/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.RubyString;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class IOOutputStream
extends OutputStream {
    private IRubyObject io;
    private CallSite writeAdapter;
    private CallSite closeAdapter = MethodIndex.getFunctionalCallSite("close");

    public IOOutputStream(IRubyObject io) {
        if (io.respondsTo("write")) {
            this.writeAdapter = MethodIndex.getFunctionalCallSite("write");
        } else if (io.respondsTo("<<")) {
            this.writeAdapter = MethodIndex.getFunctionalCallSite("<<");
        } else {
            throw new IllegalArgumentException("Object: " + io + " is not a legal argument to this wrapper, cause it doesn't respond to \"write\".");
        }
        this.io = io;
    }

    public void write(int bite) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(new byte[]{(byte)bite}, false)));
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.writeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io, RubyString.newStringLight(this.io.getRuntime(), new ByteList(b, off, len, false)));
    }

    public void close() throws IOException {
        if (this.io.respondsTo("close")) {
            this.closeAdapter.call(this.io.getRuntime().getCurrentContext(), this.io);
        }
    }
}

