/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.Arrays;

public class CodegenUtils {
    public static String c(String p) {
        return p.replace('/', '.');
    }

    public static String p(Class n) {
        return n.getName().replace('.', '/');
    }

    public static String ci(Class n) {
        if (n.isArray()) {
            if ((n = n.getComponentType()).isPrimitive()) {
                if (n == Byte.TYPE) {
                    return "[B";
                }
                if (n == Boolean.TYPE) {
                    return "[Z";
                }
                if (n == Short.TYPE) {
                    return "[S";
                }
                if (n == Character.TYPE) {
                    return "[C";
                }
                if (n == Integer.TYPE) {
                    return "[I";
                }
                if (n == Float.TYPE) {
                    return "[F";
                }
                if (n == Double.TYPE) {
                    return "[D";
                }
                if (n == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
            }
            return "[" + CodegenUtils.ci(n);
        }
        if (n.isPrimitive()) {
            if (n == Byte.TYPE) {
                return "B";
            }
            if (n == Boolean.TYPE) {
                return "Z";
            }
            if (n == Short.TYPE) {
                return "S";
            }
            if (n == Character.TYPE) {
                return "C";
            }
            if (n == Integer.TYPE) {
                return "I";
            }
            if (n == Float.TYPE) {
                return "F";
            }
            if (n == Double.TYPE) {
                return "D";
            }
            if (n == Long.TYPE) {
                return "J";
            }
            if (n == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n.getName());
        }
        return "L" + CodegenUtils.p(n) + ";";
    }

    public static String human(Class n) {
        return n.getCanonicalName();
    }

    public static String sig(Class retval, Class ... params) {
        return CodegenUtils.sigParams(params) + CodegenUtils.ci(retval);
    }

    public static String sigParams(Class ... params) {
        StringBuffer signature = new StringBuffer("(");
        for (int i = 0; i < params.length; ++i) {
            signature.append(CodegenUtils.ci(params[i]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static String pretty(Class retval, Class ... params) {
        return CodegenUtils.prettyParams(params) + CodegenUtils.human(retval);
    }

    public static String prettyParams(Class ... params) {
        StringBuffer signature = new StringBuffer("(");
        for (int i = 0; i < params.length; ++i) {
            signature.append(CodegenUtils.human(params[i]));
            if (i >= params.length - 1) continue;
            signature.append(',');
        }
        signature.append(")");
        return signature.toString();
    }

    public static Class[] params(Class ... classes) {
        return classes;
    }

    public static Class[] params(Class cls, int times) {
        Object[] classes = new Class[times];
        Arrays.fill(classes, cls);
        return classes;
    }

    public static Class[] params(Class cls1, Class clsFill, int times) {
        Object[] classes = new Class[times + 1];
        Arrays.fill(classes, clsFill);
        classes[0] = cls1;
        return classes;
    }

    public static String getAnnotatedBindingClassName(String javaMethodName, String typeName, boolean isStatic, int required, int optional, boolean multi) {
        String commonClassSuffix = multi ? "Invoker$" + javaMethodName + (isStatic ? "_s" : "") + "_method_multi" : "Invoker$" + javaMethodName + (isStatic ? "_s" : "") + "_method_" + required + "_" + optional;
        return typeName + commonClassSuffix;
    }
}

