/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.compiler.NodeCompilerFactory;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.collections.SinglyLinkedList;

public final class DefaultMethod
extends DynamicMethod {
    private StaticScope staticScope;
    private Node body;
    private ArgsNode argsNode;
    private SinglyLinkedList cref;
    private int callCount = 0;
    private Script jitCompiledScript;

    public DefaultMethod(RubyModule implementationClass, StaticScope staticScope, Node body, ArgsNode argsNode, Visibility visibility, SinglyLinkedList cref) {
        super(implementationClass, visibility);
        this.body = body;
        this.staticScope = staticScope;
        this.argsNode = argsNode;
        this.cref = cref;
        assert (argsNode != null);
    }

    public void preMethod(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        context.preDefMethodInternalCall(clazz, name, self, args, this.getArity().required(), block, noSuper, this.cref, this.staticScope, this);
    }

    public void postMethod(ThreadContext context) {
        context.postDefMethodInternalCall();
    }

    public IRubyObject internalCall(ThreadContext context, RubyModule clazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        IRubyObject blockArg;
        assert (args != null);
        Ruby runtime = context.getRuntime();
        if (runtime.getInstanceConfig().isJitEnabled()) {
            this.runJIT(runtime, context, name);
        }
        if (this.argsNode.getBlockArgNode() != null && block.isGiven()) {
            if (block.getProcObject() != null) {
                blockArg = block.getProcObject();
            } else {
                blockArg = runtime.newProc(false, block);
                blockArg.getBlock().isLambda = block.isLambda;
            }
            context.getCurrentScope().setValue(this.argsNode.getBlockArgNode().getCount(), blockArg, 0);
        }
        try {
            this.prepareArguments(context, runtime, args);
            this.getArity().checkArity(runtime, args);
            if (runtime.hasEventHooks()) {
                this.traceCall(context, runtime, name);
            }
            if (this.jitCompiledScript != null && !runtime.hasEventHooks()) {
                blockArg = this.jitCompiledScript.run(context, self, args, block);
                return blockArg;
            }
            blockArg = EvaluationState.eval(runtime, context, this.body, self, block);
            return blockArg;
        }
        catch (JumpException je) {
            if (je.getJumpType() == JumpException.JumpType.ReturnJump && je.getTarget() == this) {
                IRubyObject iRubyObject = (IRubyObject)je.getValue();
                return iRubyObject;
            }
            throw je;
        }
        finally {
            if (runtime.hasEventHooks()) {
                this.traceReturn(context, runtime, name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJIT(Ruby runtime, ThreadContext context, String name) {
        if (this.callCount >= 0) {
            String className = null;
            if (runtime.getInstanceConfig().isJitLogging() && (className = this.getImplementationClass().getBaseName()) == null) {
                className = "<anon class>";
            }
            try {
                NodeCompilerFactory.confirmNodeIsSafe(this.argsNode);
                ++this.callCount;
                if (this.callCount >= runtime.getInstanceConfig().getJitThreshold()) {
                    final ArrayCallback evalOptionalValue = new ArrayCallback(){

                        public void nextValue(Compiler context, Object object, int index) {
                            ListNode optArgs = (ListNode)object;
                            Node node = optArgs.get(index);
                            NodeCompilerFactory.getCompiler(node).compile(node, context);
                        }
                    };
                    ClosureCallback args = new ClosureCallback(){

                        public void compile(Compiler context) {
                            int expectedArgsCount = DefaultMethod.this.argsNode.getArgsCount();
                            int restArg = DefaultMethod.this.argsNode.getRestArg();
                            boolean hasOptArgs = DefaultMethod.this.argsNode.getOptArgs() != null;
                            Arity arity = DefaultMethod.this.argsNode.getArity();
                            if (hasOptArgs) {
                                if (restArg > -1) {
                                    DefaultMethod.this.callCount = -1;
                                    return;
                                }
                                int opt = expectedArgsCount + DefaultMethod.this.argsNode.getOptArgs().size();
                                context.processRequiredArgs(arity, opt);
                                ListNode optArgs = DefaultMethod.this.argsNode.getOptArgs();
                                context.assignOptionalArgs(optArgs, expectedArgsCount, optArgs.size(), evalOptionalValue);
                            } else {
                                if (restArg > -1) {
                                    DefaultMethod.this.callCount = -1;
                                    return;
                                }
                                context.processRequiredArgs(arity, expectedArgsCount);
                            }
                        }
                    };
                    String cleanName = CodegenUtils.cg.cleanJavaIdentifier(name);
                    StandardASMCompiler compiler = new StandardASMCompiler(cleanName + this.hashCode() + "_" + context.hashCode(), this.body.getPosition().getFile());
                    compiler.startScript();
                    Object methodToken = compiler.beginMethod("__file__", args);
                    NodeCompilerFactory.getCompiler(this.body).compile(this.body, compiler);
                    compiler.endMethod(methodToken);
                    compiler.endScript();
                    Class sourceClass = compiler.loadClass(new JRubyClassLoader(runtime.getJRubyClassLoader()));
                    this.jitCompiledScript = (Script)sourceClass.newInstance();
                    if (runtime.getInstanceConfig().isJitLogging()) {
                        System.err.println("compiled: " + className + "." + name);
                    }
                }
            }
            catch (Exception e) {
                if (runtime.getInstanceConfig().isJitLoggingVerbose()) {
                    System.err.println("could not compile: " + className + "." + name + " because of: \"" + e.getMessage() + '\"');
                }
            }
            finally {
                this.callCount = -1;
            }
        }
    }

    private void prepareArguments(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        boolean hasOptArgs;
        int expectedArgsCount = this.argsNode.getArgsCount();
        int restArg = this.argsNode.getRestArg();
        boolean bl = hasOptArgs = this.argsNode.getOptArgs() != null;
        if (expectedArgsCount > args.length) {
            throw runtime.newArgumentError("Wrong # of arguments(" + args.length + " for " + expectedArgsCount + ")");
        }
        if (expectedArgsCount > 0) {
            context.getCurrentScope().setArgValues(args, expectedArgsCount);
        }
        if (hasOptArgs || restArg != -1) {
            args = this.prepareOptOrRestArgs(context, runtime, args, expectedArgsCount, restArg, hasOptArgs);
        }
        context.setFrameArgs(args);
    }

    private IRubyObject[] prepareOptOrRestArgs(ThreadContext context, Ruby runtime, IRubyObject[] args, int expectedArgsCount, int restArg, boolean hasOptArgs) {
        int i;
        int opt;
        if (restArg == -1 && hasOptArgs && (opt = expectedArgsCount + this.argsNode.getOptArgs().size()) < args.length) {
            throw runtime.newArgumentError("wrong # of arguments(" + args.length + " for " + opt + ")");
        }
        int count = expectedArgsCount;
        if (this.argsNode.getOptArgs() != null) {
            count += this.argsNode.getOptArgs().size();
        }
        ArrayList<IRubyObject> allArgs = new ArrayList<IRubyObject>();
        for (i = 0; i < count && i < args.length; ++i) {
            allArgs.add(args[i]);
        }
        if (hasOptArgs) {
            ListNode optArgs = this.argsNode.getOptArgs();
            int j = 0;
            for (int i2 = expectedArgsCount; i2 < args.length && j < optArgs.size(); ++i2, ++j) {
                AssignmentVisitor.assign(runtime, context, context.getFrameSelf(), optArgs.get(j), args[i2], Block.NULL_BLOCK, true);
                ++expectedArgsCount;
            }
            while (j < optArgs.size()) {
                allArgs.add(EvaluationState.eval(runtime, context, optArgs.get(j++), context.getFrameSelf(), Block.NULL_BLOCK));
            }
        }
        if (restArg != -1) {
            for (i = expectedArgsCount; i < args.length; ++i) {
                allArgs.add(args[i]);
            }
            if (restArg >= 0) {
                RubyArray array = runtime.newArray(args.length - expectedArgsCount);
                for (int i3 = expectedArgsCount; i3 < args.length; ++i3) {
                    array.append(args[i3]);
                }
                context.getCurrentScope().setValue(restArg, array, 0);
            }
        }
        args = allArgs.toArray(new IRubyObject[allArgs.size()]);
        return args;
    }

    private void traceReturn(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        ISourcePosition position = context.getPreviousFramePosition();
        runtime.callEventHooks(context, 4, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
    }

    private void traceCall(ThreadContext context, Ruby runtime, String name) {
        if (!runtime.hasEventHooks()) {
            return;
        }
        ISourcePosition position = this.body != null ? this.body.getPosition() : context.getPosition();
        runtime.callEventHooks(context, 3, position.getFile(), position.getStartLine(), name, this.getImplementationClass());
    }

    public Arity getArity() {
        return this.argsNode.getArity();
    }

    public DynamicMethod dup() {
        return new DefaultMethod(this.getImplementationClass(), this.staticScope, this.body, this.argsNode, this.getVisibility(), this.cref);
    }
}

