/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.environment;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.environment.IOSEnvironmentReader;
import org.jruby.environment.OSEnvironmentReaderExcepton;
import org.jruby.environment.OSEnvironmentReaderFromJava5SystemGetenv;
import org.jruby.environment.OSEnvironmentReaderFromRuntimeExec;

public class OSEnvironment {
    void handleException(Exception e) {
        throw (OSEnvironmentReaderExcepton)new OSEnvironmentReaderExcepton().initCause(e);
    }

    public Map getEnvironmentVariableMap(Ruby runtime) {
        Map envs = null;
        if (runtime.getInstanceConfig().getEnvironment() != null) {
            return OSEnvironment.getAsMapOfRubyStrings(runtime, runtime.getInstanceConfig().getEnvironment().entrySet());
        }
        if (Ruby.isSecurityRestricted()) {
            envs = new HashMap();
        } else {
            IOSEnvironmentReader reader;
            String jrubyEnvMethod = System.getProperty("jruby.env.method");
            if (jrubyEnvMethod == null || jrubyEnvMethod.length() < 1) {
                reader = OSEnvironment.getAccessibleOSEnvironment(runtime, OSEnvironmentReaderFromJava5SystemGetenv.class.getName());
                if (reader == null) {
                    reader = OSEnvironment.getAccessibleOSEnvironment(runtime, OSEnvironmentReaderFromRuntimeExec.class.getName());
                }
            } else {
                runtime.getWarnings().warn("Getting environment variables using command line defined method: " + jrubyEnvMethod);
                reader = OSEnvironment.getAccessibleOSEnvironment(runtime, jrubyEnvMethod);
            }
            envs = null;
            if (reader != null) {
                Map variables = null;
                variables = reader.getVariables(runtime);
                envs = OSEnvironment.getAsMapOfRubyStrings(runtime, variables.entrySet());
            }
        }
        return envs;
    }

    public Map getSystemPropertiesMap(Ruby runtime) {
        if (Ruby.isSecurityRestricted()) {
            return new HashMap();
        }
        return OSEnvironment.getAsMapOfRubyStrings(runtime, System.getProperties().entrySet());
    }

    private static IOSEnvironmentReader getAccessibleOSEnvironment(Ruby runtime, String classname) {
        IOSEnvironmentReader osenvironment = null;
        try {
            osenvironment = (IOSEnvironmentReader)Class.forName(classname).newInstance();
        }
        catch (Exception e) {
            runtime.getWarnings().warn(e.getMessage());
        }
        if (osenvironment != null && osenvironment.isAccessible(runtime)) {
            return osenvironment;
        }
        return null;
    }

    private static Map getAsMapOfRubyStrings(Ruby runtime, Set entrySet) {
        HashMap<RubyString, RubyString> envs = new HashMap<RubyString, RubyString>();
        for (Map.Entry entry : entrySet) {
            envs.put(runtime.newString(entry.getKey().toString()), runtime.newString(entry.getValue().toString()));
        }
        return envs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map getVariablesFrom(BufferedReader reader) {
        HashMap<String, String> envs = new HashMap<String, String>();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                int equalsPos = line.indexOf(61);
                if (equalsPos < 1) continue;
                String envVarName = line.substring(0, equalsPos);
                String envVarValue = line.substring(equalsPos + 1);
                envs.put(envVarName, envVarValue);
            }
        }
        catch (IOException e) {
            envs = null;
            this.handleException(e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                envs = null;
                this.handleException(e);
            }
        }
        return envs;
    }
}

