/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import jregex.Matcher;
import jregex.Pattern;
import jregex.PatternSyntaxException;
import org.jruby.RegexpTranslator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.parser.ReOptions;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.Sprintf;

public class RubyRegexp
extends RubyObject
implements ReOptions {
    private static final RegexpTranslator REGEXP_TRANSLATOR = new RegexpTranslator();
    private static final Pattern SPECIAL_CHARS = new Pattern("([\\\t\\\n\\\f\\\r\\ \\#\\\u000b\\+\\-\\[\\]\\.\\?\\*\\(\\)\\{\\}\\|\\\\\\^\\$])");
    private String source;
    private Pattern pattern;
    private KCode code;
    private int flags;
    private String lastTarget = null;
    private Matcher matcher = null;
    private static ObjectAllocator REGEXP_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyRegexp instance = new RubyRegexp(runtime, klass);
            return instance;
        }
    };
    public static final byte NIL_P_SWITCHVALUE = 1;
    public static final byte EQUALEQUAL_SWITCHVALUE = 2;
    public static final byte TO_S_SWITCHVALUE = 3;
    public static final byte HASH_SWITCHVALUE = 4;
    public static final byte MATCH_SWITCHVALUE = 5;
    public static final byte EQQ_SWITCHVALUE = 6;

    KCode getCode() {
        return this.code;
    }

    public RubyRegexp(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    private RubyRegexp(Ruby runtime) {
        super(runtime, runtime.getClass("Regexp"));
    }

    public static RubyClass createRegexpClass(Ruby runtime) {
        RubyClass regexpClass = runtime.defineClass("Regexp", runtime.getObject(), REGEXP_ALLOCATOR);
        regexpClass.index = 9;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyRegexp.class);
        regexpClass.defineConstant("IGNORECASE", runtime.newFixnum(1L));
        regexpClass.defineConstant("EXTENDED", runtime.newFixnum(2L));
        regexpClass.defineConstant("MULTILINE", runtime.newFixnum(4L));
        regexpClass.defineFastMethod("initialize", callbackFactory.getFastOptMethod("initialize"));
        regexpClass.defineFastMethod("initialize_copy", callbackFactory.getFastMethod("initialize_copy", RubyKernel.IRUBY_OBJECT));
        regexpClass.defineFastMethod("==", callbackFactory.getFastMethod("equal", RubyKernel.IRUBY_OBJECT));
        regexpClass.defineFastMethod("eql?", callbackFactory.getFastMethod("equal", RubyKernel.IRUBY_OBJECT));
        regexpClass.defineFastMethod("===", callbackFactory.getFastMethod("eqq", RubyKernel.IRUBY_OBJECT));
        regexpClass.defineFastMethod("=~", callbackFactory.getFastMethod("match", RubyKernel.IRUBY_OBJECT));
        regexpClass.defineFastMethod("~", callbackFactory.getFastMethod("match2"));
        regexpClass.defineFastMethod("match", callbackFactory.getFastMethod("match_m", RubyKernel.IRUBY_OBJECT));
        regexpClass.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        regexpClass.defineFastMethod("source", callbackFactory.getFastMethod("source"));
        regexpClass.defineFastMethod("casefold?", callbackFactory.getFastMethod("casefold"));
        regexpClass.defineFastMethod("kcode", callbackFactory.getFastMethod("kcode"));
        regexpClass.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        regexpClass.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        regexpClass.getMetaClass().defineFastMethod("new", callbackFactory.getFastOptSingletonMethod("newInstance"));
        regexpClass.getMetaClass().defineFastMethod("compile", callbackFactory.getFastOptSingletonMethod("newInstance"));
        regexpClass.getMetaClass().defineFastMethod("quote", callbackFactory.getFastOptSingletonMethod("quote"));
        regexpClass.getMetaClass().defineFastMethod("escape", callbackFactory.getFastSingletonMethod("quote", RubyString.class));
        regexpClass.getMetaClass().defineFastMethod("last_match", callbackFactory.getFastOptSingletonMethod("last_match_s"));
        regexpClass.getMetaClass().defineFastMethod("union", callbackFactory.getFastOptSingletonMethod("union"));
        return regexpClass;
    }

    public int getNativeTypeIndex() {
        return 9;
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        if (context.getRuntime().getTraceFunction() != null) {
            return super.callMethod(context, rubyclass, name, args, callType, block);
        }
        switch (this.getRuntime().getSelectorTable().table[rubyclass.index][methodIndex]) {
            case 1: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.nil_p();
            }
            case 2: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.equal(args[0]);
            }
            case 3: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_s();
            }
            case 4: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.hash();
            }
            case 5: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.match(args[0]);
            }
            case 6: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.eqq(args[0]);
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    public void initialize(String regex, int options) {
        try {
            if (this.getCode() == KCode.UTF8) {
                try {
                    regex = new String(ByteList.plain(regex), "UTF8");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.source = regex;
            this.pattern = REGEXP_TRANSLATOR.translate(regex, options, this.code.flags());
            this.flags = REGEXP_TRANSLATOR.flagsFor(options, this.code.flags());
        }
        catch (PatternSyntaxException e) {
            throw this.getRuntime().newRegexpError(e.getMessage());
        }
    }

    public static String escapeSpecialChars(String original) {
        return SPECIAL_CHARS.replacer("\\\\$1").replace(original);
    }

    private void recompileIfNeeded() {
        this.checkInitialized();
    }

    private void checkInitialized() {
        if (this.pattern == null) {
            throw this.getRuntime().newTypeError("uninitialized Regexp");
        }
    }

    public static RubyRegexp regexpValue(IRubyObject obj) {
        if (obj instanceof RubyRegexp) {
            return (RubyRegexp)obj;
        }
        if (obj instanceof RubyString) {
            return RubyRegexp.newRegexp(obj.getRuntime().newString(RubyRegexp.escapeSpecialChars(((RubyString)obj).toString())), 0, null);
        }
        throw obj.getRuntime().newArgumentError("can't convert arg to Regexp");
    }

    public static RubyRegexp newRegexp(RubyString str, int options, String lang) {
        return RubyRegexp.newRegexp(str.getRuntime(), str.toString(), options, lang);
    }

    public static RubyRegexp newRegexp(Ruby runtime, String source, Pattern pattern, int flags, String lang) {
        RubyRegexp re = new RubyRegexp(runtime);
        re.code = KCode.create(runtime, lang);
        re.source = source;
        re.pattern = pattern;
        re.flags = flags;
        return re;
    }

    public static RubyRegexp newRegexp(Ruby runtime, String str, int options, String kcode) {
        RubyRegexp re = new RubyRegexp(runtime);
        re.code = KCode.create(runtime, kcode);
        re.initialize(str, options);
        return re;
    }

    public static RubyRegexp newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyClass klass = (RubyClass)recv;
        RubyRegexp re = (RubyRegexp)klass.allocate();
        re.callInit(args, Block.NULL_BLOCK);
        return re;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        String pat = args[0] instanceof RubyRegexp ? ((RubyRegexp)args[0]).source().toString() : RubyString.stringValue(args[0]).toString();
        int opts = 0;
        if (args.length > 1) {
            if (args[1] instanceof RubyFixnum) {
                opts = (int)((RubyFixnum)args[1]).getLongValue();
            } else if (args[1].isTrue()) {
                opts |= 1;
            }
        }
        this.code = args.length > 2 ? KCode.create(this.getRuntime(), RubyString.stringValue(args[2]).toString()) : KCode.create(this.getRuntime(), null);
        this.initialize(pat, opts);
        return this.getRuntime().getNil();
    }

    public static RubyString quote(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0 || args.length > 2) {
            throw recv.getRuntime().newArgumentError(0, args.length);
        }
        KCode kcode = recv.getRuntime().getKCode();
        if (args.length > 1) {
            kcode = KCode.create(recv.getRuntime(), args[1].toString());
        }
        RubyString str = args[0].convertToString();
        if (kcode == KCode.NONE) {
            return RubyRegexp.quote(recv, str);
        }
        try {
            ByteList bytes = str.getByteList();
            CharBuffer decoded = kcode.decoder().decode(ByteBuffer.wrap(bytes.unsafeBytes(), bytes.begin(), bytes.length()));
            String escaped = RubyRegexp.escapeSpecialChars(decoded.toString());
            ByteBuffer encoded = kcode.encoder().encode(CharBuffer.wrap(escaped));
            return (RubyString)RubyString.newString(recv.getRuntime(), encoded.array()).infectBy(str);
        }
        catch (CharacterCodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static RubyString quote(IRubyObject recv, RubyString str) {
        return (RubyString)recv.getRuntime().newString(RubyRegexp.escapeSpecialChars(str.toString())).infectBy(str);
    }

    public static IRubyObject last_match_s(IRubyObject recv, IRubyObject[] args) {
        if (args.length == 0) {
            return recv.getRuntime().getCurrentContext().getBackref();
        }
        return ((RubyMatchData)recv.getRuntime().getCurrentContext().getBackref()).aref(args);
    }

    public IRubyObject equal(IRubyObject other) {
        if (other == this) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyRegexp)) {
            return this.getRuntime().getFalse();
        }
        RubyRegexp re = (RubyRegexp)other;
        this.checkInitialized();
        if (!re.pattern.toString().equals(this.pattern.toString()) || re.flags != this.flags) {
            return this.getRuntime().getFalse();
        }
        if (this.code != re.code) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public IRubyObject match2() {
        IRubyObject target = this.getRuntime().getCurrentContext().getLastline();
        return target instanceof RubyString ? this.match(target) : this.getRuntime().getNil();
    }

    public IRubyObject eqq(IRubyObject target) {
        int result;
        if (!(target instanceof RubyString) && (target = target.checkStringType()).isNil()) {
            this.getRuntime().getCurrentContext().setBackref(this.getRuntime().getNil());
            return this.getRuntime().getFalse();
        }
        RubyString ss = RubyString.stringValue(target);
        String string = ss.toString();
        if (string.length() == 0 && "^$".equals(this.pattern.toString())) {
            string = "\n";
        }
        return (result = this.search(string, ss, 0)) < 0 ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    public IRubyObject match(IRubyObject target) {
        int result;
        if (target.isNil()) {
            return this.getRuntime().getFalse();
        }
        if (target instanceof RubySymbol || target instanceof RubyHash || target instanceof RubyArray) {
            return this.getRuntime().getFalse();
        }
        RubyString ss = RubyString.stringValue(target);
        String string = ss.toString();
        if (string.length() == 0 && "^$".equals(this.pattern.toString())) {
            string = "\n";
        }
        return (result = this.search(string, ss, 0)) < 0 ? this.getRuntime().getNil() : this.getRuntime().newFixnum(result);
    }

    public IRubyObject match_m(IRubyObject target) {
        if (target.isNil()) {
            return target;
        }
        IRubyObject result = this.match(target);
        return result.isNil() ? result : this.getRuntime().getCurrentContext().getBackref().rbClone(Block.NULL_BLOCK);
    }

    public RubyString source() {
        this.checkInitialized();
        return this.getRuntime().newString(this.source);
    }

    public IRubyObject kcode() {
        if (this.code == KCode.NIL) {
            return this.code.kcode(this.getRuntime());
        }
        return this.getRuntime().newString(this.code.kcode(this.getRuntime()).toString().toLowerCase());
    }

    public RubyBoolean casefold() {
        this.checkInitialized();
        return this.getRuntime().newBoolean((this.flags & 1) != 0);
    }

    public static IRubyObject nth_match(int n, IRubyObject match) {
        IRubyObject nil = match.getRuntime().getNil();
        if (match.isNil()) {
            return nil;
        }
        RubyMatchData rmd = (RubyMatchData)match;
        if ((long)n > rmd.getSize()) {
            return nil;
        }
        if (n < 0 && (n = (int)((long)n + rmd.getSize())) <= 0) {
            return nil;
        }
        return rmd.group(n);
    }

    public static IRubyObject last_match(IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).group(0L);
    }

    public static IRubyObject match_pre(IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).pre_match();
    }

    public static IRubyObject match_post(IRubyObject match) {
        return match.isNil() ? match : ((RubyMatchData)match).post_match();
    }

    public static IRubyObject match_last(IRubyObject match) {
        if (match.isNil()) {
            return match;
        }
        RubyMatchData md = (RubyMatchData)match;
        for (long i = md.getSize() - 1L; i > 0L; --i) {
            if (md.group(i).isNil()) continue;
            return md.group(i);
        }
        return md.getRuntime().getNil();
    }

    public int search(String target, RubyString rtarget, int pos) {
        if (pos > target.length()) {
            return -1;
        }
        this.recompileIfNeeded();
        IRubyObject result = this.match(target, rtarget, pos);
        this.getRuntime().getCurrentContext().setBackref(result);
        return result instanceof RubyMatchData ? ((RubyMatchData)result).matchStartPosition() : -1;
    }

    public IRubyObject search2(String str, RubyString rtarget) {
        IRubyObject result = this.match(str, rtarget, 0);
        this.getRuntime().getCurrentContext().setBackref(result);
        return result;
    }

    public int searchAgain(String target, RubyString rtarget, boolean utf) {
        if (this.matcher == null || !target.equals(this.lastTarget)) {
            this.matcher = this.pattern.matcher(target);
            this.lastTarget = target;
        }
        if (!this.matcher.find()) {
            return -1;
        }
        RubyMatchData match = utf ? new RubyMatchData.JavaString(this.getRuntime(), target, this.matcher) : new RubyMatchData.RString(this.getRuntime(), rtarget, this.matcher);
        this.getRuntime().getCurrentContext().setBackref(match);
        return match.matchStartPosition();
    }

    public IRubyObject match(String target, RubyString rtarget, int startPos) {
        boolean utf8 = this.getCode() == KCode.UTF8;
        String t = target;
        if (utf8) {
            try {
                t = new String(ByteList.plain(target), "UTF8");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Matcher aMatcher = this.pattern.matcher(t);
        aMatcher.setPosition(startPos);
        if (aMatcher.find()) {
            return utf8 ? new RubyMatchData.JavaString(this.getRuntime(), target, aMatcher) : new RubyMatchData.RString(this.getRuntime(), rtarget, aMatcher);
        }
        return this.getRuntime().getNil();
    }

    public void regsub(RubyString str, RubyMatchData match, ByteList sb) {
        ByteList repl = str.getByteList();
        int pos = 0;
        int end = repl.length();
        block8: while (pos < end) {
            char c;
            if ((c = (char)(repl.get(pos++) & 0xFF)) == '\\' && pos < end) {
                IRubyObject ins;
                c = (char)(repl.get(pos++) & 0xFF);
                switch (c) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        ins = match.group(c - 48);
                        break;
                    }
                    case '&': {
                        ins = match.group(0L);
                        break;
                    }
                    case '`': {
                        ins = match.pre_match();
                        break;
                    }
                    case '\'': {
                        ins = match.post_match();
                        break;
                    }
                    case '+': {
                        ins = RubyRegexp.match_last(match);
                        break;
                    }
                    case '\\': {
                        sb.append(c);
                        continue block8;
                    }
                    default: {
                        sb.append(92);
                        sb.append(c);
                        continue block8;
                    }
                }
                if (ins.isNil()) continue;
                sb.append(((RubyString)ins).getByteList());
                continue;
            }
            sb.append(c);
        }
    }

    public IRubyObject regsub(IRubyObject str, RubyMatchData match) {
        RubyString str2 = str.asString();
        ByteList sb = new ByteList(str2.getByteList().length() + 30);
        this.regsub(str2, match, sb);
        return RubyString.newString(this.getRuntime(), sb);
    }

    public IRubyObject initialize_copy(IRubyObject original) {
        if (this == original) {
            return this;
        }
        if (this.getMetaClass() != original.getMetaClass()) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyRegexp origRegexp = (RubyRegexp)original;
        this.source = origRegexp.source;
        this.pattern = origRegexp.pattern;
        this.code = origRegexp.code;
        return this;
    }

    public IRubyObject inspect() {
        String regex = this.source;
        int length = regex.length();
        StringBuffer sb = new StringBuffer(length + 2);
        sb.append('/');
        for (int i = 0; i < length; ++i) {
            char c = regex.charAt(i);
            if (RubyString.isAlnum(c)) {
                sb.append(c);
                continue;
            }
            if (c == '/') {
                if (i == 0 || regex.charAt(i - 1) != '\\') {
                    sb.append("\\");
                }
                sb.append(c);
                continue;
            }
            if (RubyString.isPrint(c)) {
                sb.append(c);
                continue;
            }
            if (c == '\n') {
                sb.append('\\').append('n');
                continue;
            }
            if (c == '\r') {
                sb.append('\\').append('r');
                continue;
            }
            if (c == '\t') {
                sb.append('\\').append('t');
                continue;
            }
            if (c == '\f') {
                sb.append('\\').append('f');
                continue;
            }
            if (c == '\u000b') {
                sb.append('\\').append('v');
                continue;
            }
            if (c == '\u0007') {
                sb.append('\\').append('a');
                continue;
            }
            if (c == '\u001b') {
                sb.append('\\').append('e');
                continue;
            }
            sb.append(Sprintf.sprintf(this.getRuntime(), (CharSequence)"\\%.3o", c));
        }
        sb.append('/');
        if (this.code == KCode.NONE) {
            sb.append('n');
        } else if (this.code == KCode.UTF8) {
            sb.append('u');
        } else if (this.code == KCode.SJIS) {
            sb.append('s');
        }
        if ((this.flags & 1) > 0) {
            sb.append('i');
        }
        if ((this.flags & 4) > 0) {
            sb.append('m');
        }
        if ((this.flags & 8) > 0) {
            sb.append('x');
        }
        return this.getRuntime().newString(sb.toString());
    }

    public static IRubyObject union(IRubyObject recv, IRubyObject[] args) {
        Ruby runtime = recv.getRuntime();
        if (args.length == 0) {
            return RubyRegexp.newInstance(recv, new IRubyObject[]{runtime.newString("(?!)")});
        }
        if (args.length == 1) {
            IRubyObject arg = args[0].convertToType(runtime.getClass("Regexp"), 0, "to_regexp", false);
            if (!arg.isNil()) {
                return arg;
            }
            return RubyRegexp.newInstance(recv, new IRubyObject[]{RubyRegexp.quote(recv, args[0].convertToString())});
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            IRubyObject arg;
            if (i > 0) {
                buffer.append("|");
            }
            if ((arg = args[i].convertToType(runtime.getClass("Regexp"), 0, "to_regexp", false)).isNil()) {
                arg = RubyRegexp.quote(recv, args[i].convertToString());
            }
            buffer.append(arg.toString());
        }
        return RubyRegexp.newInstance(recv, new IRubyObject[]{runtime.newString(buffer.toString())});
    }

    public IRubyObject to_s() {
        return this.getRuntime().newString(this.toString());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        StringBuffer off = new StringBuffer(3);
        buffer.append("(?");
        this.flagToString(buffer, off, 4, 'm');
        this.flagToString(buffer, off, 1, 'i');
        this.flagToString(buffer, off, 8, 'x');
        if (off.length() > 0) {
            buffer.append('-').append(off);
        }
        buffer.append(':');
        buffer.append(this.pattern.toString().replaceAll("^/|([^\\\\])/", "$1\\\\/"));
        buffer.append(')');
        return buffer.toString();
    }

    private void flagToString(StringBuffer buffer, StringBuffer off, int flag, char c) {
        if ((this.flags & flag) != 0) {
            buffer.append(c);
        } else {
            off.append(c);
        }
    }

    public static RubyRegexp unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyRegexp result = RubyRegexp.newRegexp(input.getRuntime(), RubyString.byteListToString(input.unmarshalString()), input.unmarshalInt(), null);
        input.registerLinkTarget(result);
        return result;
    }

    public static void marshalTo(RubyRegexp regexp, MarshalStream output) throws IOException {
        output.writeString(regexp.pattern.toString());
        int _flags = 0;
        if ((regexp.flags & 4) > 0) {
            _flags |= 4;
        }
        if ((regexp.flags & 1) > 0) {
            _flags |= 1;
        }
        if ((regexp.flags & 8) > 0) {
            _flags |= 2;
        }
        output.writeInt(_flags);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.pattern.toString().hashCode());
    }
}

