/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

public class RubyFileStat
extends RubyObject {
    private static final int READ = 146;
    private static final int WRITE = 292;
    private RubyFixnum blksize;
    private RubyBoolean isDirectory;
    private RubyBoolean isFile;
    private RubyString ftype;
    private RubyFixnum mode;
    private RubyTime mtime;
    private RubyTime ctime;
    private RubyBoolean isReadable;
    private RubyBoolean isWritable;
    private RubyFixnum size;
    private RubyBoolean isSymlink;
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyFileStat(runtime, klass);
        }
    };

    public static RubyClass createFileStatClass(Ruby runtime) {
        RubyClass fileStatClass = runtime.getClass("File").defineClassUnder("Stat", runtime.getObject(), ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFileStat.class);
        fileStatClass.defineFastMethod("initialize", callbackFactory.getMethod("initialize", RubyKernel.IRUBY_OBJECT));
        fileStatClass.defineFastMethod("blksize", callbackFactory.getFastMethod("blksize"));
        fileStatClass.defineFastMethod("ctime", callbackFactory.getFastMethod("ctime"));
        fileStatClass.defineFastMethod("directory?", callbackFactory.getFastMethod("directory_p"));
        fileStatClass.defineFastMethod("file?", callbackFactory.getFastMethod("file_p"));
        fileStatClass.defineFastMethod("ftype", callbackFactory.getFastMethod("ftype"));
        fileStatClass.defineFastMethod("ino", callbackFactory.getFastMethod("ino"));
        fileStatClass.defineFastMethod("mode", callbackFactory.getFastMethod("mode"));
        fileStatClass.defineFastMethod("mtime", callbackFactory.getFastMethod("mtime"));
        fileStatClass.defineFastMethod("readable?", callbackFactory.getFastMethod("readable_p"));
        fileStatClass.defineFastMethod("size", callbackFactory.getFastMethod("size"));
        fileStatClass.defineFastMethod("symlink?", callbackFactory.getFastMethod("symlink_p"));
        fileStatClass.defineFastMethod("writable?", callbackFactory.getFastMethod("writable"));
        return fileStatClass;
    }

    protected RubyFileStat(Ruby runtime, RubyClass clazz) {
        super(runtime, clazz);
    }

    public IRubyObject initialize(IRubyObject fname, Block unusedBlock) {
        JRubyFile file;
        Ruby runtime = this.getRuntime();
        String filename = fname.toString();
        if (RubyFile.IS_WINDOWS && filename.length() == 2 && filename.charAt(1) == ':' && Character.isLetter(filename.charAt(0))) {
            filename = filename + "/";
        }
        if (!(file = JRubyFile.create(runtime.getCurrentDirectory(), filename)).exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + filename);
        }
        this.blksize = runtime.newFixnum(4096L);
        this.isDirectory = runtime.newBoolean(file.isDirectory());
        this.isFile = runtime.newBoolean(file.isFile());
        this.ftype = file.isDirectory() ? runtime.newString("directory") : (file.isFile() ? runtime.newString("file") : null);
        int baseMode = 32768;
        if (file.canRead()) {
            baseMode += 146;
        }
        if (file.canWrite()) {
            baseMode += 292;
        }
        this.mode = runtime.newFixnum(baseMode);
        this.mtime = runtime.newTime(file.lastModified());
        this.ctime = runtime.newTime(file.getParentFile().lastModified());
        this.isReadable = runtime.newBoolean(file.canRead());
        this.isWritable = runtime.newBoolean(file.canWrite());
        this.size = runtime.newFixnum(file.length());
        this.isSymlink = runtime.getFalse();
        return this;
    }

    public RubyFixnum blksize() {
        return this.blksize;
    }

    public RubyBoolean directory_p() {
        return this.isDirectory;
    }

    public RubyBoolean file_p() {
        return this.isFile;
    }

    public RubyString ftype() {
        return this.ftype;
    }

    public IRubyObject ino() {
        return this.getRuntime().newFixnum(0L);
    }

    public IRubyObject mode() {
        return this.mode;
    }

    public IRubyObject mtime() {
        return this.mtime;
    }

    public IRubyObject ctime() {
        return this.ctime;
    }

    public IRubyObject readable_p() {
        return this.isReadable;
    }

    public IRubyObject size() {
        return this.size;
    }

    public IRubyObject symlink_p() {
        return this.isSymlink;
    }

    public IRubyObject writable() {
        return this.isWritable;
    }
}

