/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubySymbol;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyEnumerator
extends RubyObject {
    private IRubyObject object;
    private IRubyObject method;
    private IRubyObject[] methodArgs;
    private static ObjectAllocator ENUMERATOR_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyEnumerator(runtime, klass);
        }
    };

    public static void defineEnumerator(Ruby runtime) {
        RubyModule enumerableModule = runtime.getModule("Enumerable");
        RubyClass object = runtime.getObject();
        RubyClass enumeratorClass = enumerableModule.defineClassUnder("Enumerator", object, ENUMERATOR_ALLOCATOR);
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyEnumerator.class);
        enumeratorClass.includeModule(enumerableModule);
        enumeratorClass.getMetaClass().defineMethod("new", callbackFactory.getOptSingletonMethod("new_instance"));
        enumeratorClass.defineMethod("initialize", callbackFactory.getOptSingletonMethod("initialize"));
        enumeratorClass.defineMethod("each", callbackFactory.getOptSingletonMethod("each"));
        object.defineMethod("to_enum", callbackFactory.getOptSingletonMethod("o_to_enum"));
        object.defineMethod("enum_for", callbackFactory.getOptSingletonMethod("o_to_enum"));
        enumerableModule.defineMethod("enum_with_index", callbackFactory.getSingletonMethod("each_with_index"));
        enumerableModule.defineMethod("each_slice", callbackFactory.getSingletonMethod("each_slice", IRubyObject.class));
        enumerableModule.defineMethod("enum_slice", callbackFactory.getSingletonMethod("enum_slice", IRubyObject.class));
        enumerableModule.defineMethod("each_cons", callbackFactory.getSingletonMethod("each_cons", IRubyObject.class));
        enumerableModule.defineMethod("enum_cons", callbackFactory.getSingletonMethod("enum_cons", IRubyObject.class));
    }

    private RubyEnumerator(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static IRubyObject new_instance(IRubyObject self, IRubyObject[] args, Block block) {
        RubyClass klass = (RubyClass)self;
        RubyEnumerator result = (RubyEnumerator)klass.allocate();
        result.callInit(args, block);
        return result;
    }

    public static IRubyObject initialize(IRubyObject self, IRubyObject[] args, Block block) {
        return ((RubyEnumerator)self).initialize(self.getRuntime().getCurrentContext(), args, block);
    }

    public static IRubyObject each(IRubyObject self, IRubyObject[] args, Block block) {
        return ((RubyEnumerator)self).each(self.getRuntime().getCurrentContext(), args, block);
    }

    public static IRubyObject o_to_enum(IRubyObject self, IRubyObject[] args, Block block) {
        IRubyObject[] newArgs = new IRubyObject[args.length + 1];
        newArgs[0] = self;
        System.arraycopy(args, 0, newArgs, 1, args.length);
        return self.getRuntime().getModule("Enumerable").getConstant("Enumerator").callMethod(self.getRuntime().getCurrentContext(), "new", newArgs);
    }

    public static IRubyObject each_with_index(IRubyObject self, Block block) {
        return self.getRuntime().getModule("Enumerable").getConstant("Enumerator").callMethod(self.getRuntime().getCurrentContext(), "new", new IRubyObject[]{self, self.getRuntime().newSymbol("each_with_index")});
    }

    public static IRubyObject each_slice(IRubyObject self, IRubyObject arg, Block block) {
        long sliceSize = arg.convertToInteger().getLongValue();
        if (sliceSize <= 0L) {
            throw self.getRuntime().newArgumentError("invalid slice size");
        }
        SlicedBlockCallback sliceBlock = new SlicedBlockCallback(self.getRuntime(), block, sliceSize);
        RubyEnumerable.callEachOld(self.getRuntime().getCurrentContext(), self, self.getMetaClass(), sliceBlock);
        if (sliceBlock.hasLeftovers()) {
            sliceBlock.yieldLeftovers(self.getRuntime().getCurrentContext());
        }
        return self.getRuntime().getNil();
    }

    public static IRubyObject each_cons(IRubyObject self, IRubyObject arg, Block block) {
        long consecutiveSize = arg.convertToInteger().getLongValue();
        if (consecutiveSize <= 0L) {
            throw self.getRuntime().newArgumentError("invalid size");
        }
        RubyEnumerable.callEachOld(self.getRuntime().getCurrentContext(), self, self.getMetaClass(), new ConsecutiveBlockCallback(self.getRuntime(), block, consecutiveSize));
        return self.getRuntime().getNil();
    }

    public static IRubyObject enum_slice(IRubyObject self, IRubyObject arg, Block block) {
        return self.getRuntime().getModule("Enumerable").getConstant("Enumerator").callMethod(self.getRuntime().getCurrentContext(), "new", new IRubyObject[]{self, self.getRuntime().newSymbol("each_slice"), arg});
    }

    public static IRubyObject enum_cons(IRubyObject self, IRubyObject arg, Block block) {
        return self.getRuntime().getModule("Enumerable").getConstant("Enumerator").callMethod(self.getRuntime().getCurrentContext(), "new", new IRubyObject[]{self, self.getRuntime().newSymbol("each_cons"), arg});
    }

    private IRubyObject initialize(ThreadContext tc, IRubyObject[] args, Block block) {
        Arity.checkArgumentCount(tc.getRuntime(), args, 1, -1);
        this.object = args[0];
        this.methodArgs = new IRubyObject[Math.max(0, args.length - 2)];
        this.method = args.length >= 2 ? args[1] : RubySymbol.newSymbol(tc.getRuntime(), "each");
        if (args.length >= 3) {
            System.arraycopy(args, 2, this.methodArgs, 0, args.length - 2);
        } else {
            this.methodArgs = new IRubyObject[0];
        }
        return this;
    }

    private IRubyObject each(ThreadContext tc, IRubyObject[] args, Block block) {
        Arity.checkArgumentCount(tc.getRuntime(), args, 0, 0);
        return this.object.callMethod(tc, this.method.asSymbol(), this.methodArgs, block);
    }

    public static class ConsecutiveBlockCallback
    implements BlockCallback {
        protected final RubyArray cont;
        protected final long contSize;
        protected final Block clientBlock;
        protected final Ruby runtime;

        public ConsecutiveBlockCallback(Ruby runtime, Block clientBlock, long contSize) {
            this.runtime = runtime;
            this.clientBlock = clientBlock;
            this.contSize = contSize;
            this.cont = RubyArray.newArray(runtime, contSize);
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] args, Block block) {
            if ((long)this.cont.getLength() == this.contSize) {
                this.cont.shift();
            }
            if (args.length > 1) {
                this.cont.append(RubyArray.newArray(this.runtime, args));
            } else {
                this.cont.append(args[0]);
            }
            if ((long)this.cont.getLength() == this.contSize) {
                this.clientBlock.call(context, new IRubyObject[]{this.cont.dup()});
            }
            return this.runtime.getNil();
        }
    }

    public static class SlicedBlockCallback
    implements BlockCallback {
        protected RubyArray slice;
        protected final long sliceSize;
        protected final Block clientBlock;
        protected final Ruby runtime;

        public SlicedBlockCallback(Ruby runtime, Block clientBlock, long sliceSize) {
            this.runtime = runtime;
            this.clientBlock = clientBlock;
            this.sliceSize = sliceSize;
            this.slice = RubyArray.newArray(runtime, sliceSize);
        }

        public IRubyObject call(ThreadContext context, IRubyObject[] args, Block block) {
            if (args.length > 1) {
                this.slice.append(RubyArray.newArray(this.runtime, args));
            } else {
                this.slice.append(args[0]);
            }
            if ((long)this.slice.getLength() == this.sliceSize) {
                this.clientBlock.call(context, new IRubyObject[]{this.slice});
                this.slice = RubyArray.newArray(this.runtime, this.sliceSize);
            }
            return this.runtime.getNil();
        }

        public boolean hasLeftovers() {
            return this.slice.getLength() > 0 && (long)this.slice.getLength() < this.sliceSize;
        }

        public void yieldLeftovers(ThreadContext context) {
            this.clientBlock.call(context, new IRubyObject[]{this.slice});
        }
    }
}

