/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Pack;

public class RubyArray
extends RubyObject
implements List {
    private static ObjectAllocator ARRAY_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyArray(runtime, klass);
        }
    };
    public static final byte OP_PLUS_SWITCHVALUE = 1;
    public static final byte AREF_SWITCHVALUE = 2;
    public static final byte ASET_SWITCHVALUE = 3;
    public static final byte POP_SWITCHVALUE = 4;
    public static final byte PUSH_SWITCHVALUE = 5;
    public static final byte NIL_P_SWITCHVALUE = 6;
    public static final byte EQUALEQUAL_SWITCHVALUE = 7;
    public static final byte UNSHIFT_SWITCHVALUE = 8;
    public static final byte OP_LSHIFT_SWITCHVALUE = 9;
    public static final byte EMPTY_P_SWITCHVALUE = 10;
    public static final byte TO_S_SWITCHVALUE = 11;
    public static final byte AT_SWITCHVALUE = 12;
    public static final byte TO_ARY_SWITCHVALUE = 13;
    public static final byte TO_A_SWITCHVALUE = 14;
    public static final byte HASH_SWITCHVALUE = 15;
    public static final byte OP_TIMES_SWITCHVALUE = 16;
    public static final byte OP_SPACESHIP_SWITCHVALUE = 17;
    public static final byte LENGTH_SWITCHVALUE = 18;
    public static final byte LAST_SWITCHVALUE = 19;
    public static final byte SHIFT_SWITCHVALUE = 20;
    public static final int ARRAY_DEFAULT_SIZE = 16;
    private IRubyObject[] values;
    private boolean tmpLock = false;
    private boolean shared = false;
    private int begin = 0;
    private int realLength = 0;

    public static RubyClass createArrayClass(Ruby runtime) {
        RubyClass arrayc = runtime.defineClass("Array", runtime.getObject(), ARRAY_ALLOCATOR);
        arrayc.index = 3;
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyArray.class);
        arrayc.includeModule(runtime.getModule("Enumerable"));
        arrayc.getMetaClass().defineMethod("[]", callbackFactory.getOptSingletonMethod("create"));
        arrayc.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        arrayc.defineFastMethod("initialize_copy", callbackFactory.getFastMethod("replace", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("to_s", callbackFactory.getFastMethod("to_s"));
        arrayc.defineFastMethod("inspect", callbackFactory.getFastMethod("inspect"));
        arrayc.defineFastMethod("to_a", callbackFactory.getFastMethod("to_a"));
        arrayc.defineFastMethod("to_ary", callbackFactory.getFastMethod("to_ary"));
        arrayc.defineFastMethod("frozen?", callbackFactory.getFastMethod("frozen"));
        arrayc.defineFastMethod("==", callbackFactory.getFastMethod("op_equal", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("eql?", callbackFactory.getFastMethod("eql_p", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("hash", callbackFactory.getFastMethod("hash"));
        arrayc.defineFastMethod("[]", callbackFactory.getFastOptMethod("aref"));
        arrayc.defineFastMethod("[]=", callbackFactory.getFastOptMethod("aset"));
        arrayc.defineFastMethod("at", callbackFactory.getFastMethod("at", RubyKernel.IRUBY_OBJECT));
        arrayc.defineMethod("fetch", callbackFactory.getOptMethod("fetch"));
        arrayc.defineFastMethod("first", callbackFactory.getFastOptMethod("first"));
        arrayc.defineFastMethod("last", callbackFactory.getFastOptMethod("last"));
        arrayc.defineFastMethod("concat", callbackFactory.getFastMethod("concat", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("<<", callbackFactory.getFastMethod("append", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("push", callbackFactory.getFastOptMethod("push_m"));
        arrayc.defineFastMethod("pop", callbackFactory.getFastMethod("pop"));
        arrayc.defineFastMethod("shift", callbackFactory.getFastMethod("shift"));
        arrayc.defineFastMethod("unshift", callbackFactory.getFastOptMethod("unshift_m"));
        arrayc.defineFastMethod("insert", callbackFactory.getFastOptMethod("insert"));
        arrayc.defineMethod("each", callbackFactory.getMethod("each"));
        arrayc.defineMethod("each_index", callbackFactory.getMethod("each_index"));
        arrayc.defineMethod("reverse_each", callbackFactory.getMethod("reverse_each"));
        arrayc.defineFastMethod("length", callbackFactory.getFastMethod("length"));
        arrayc.defineAlias("size", "length");
        arrayc.defineFastMethod("empty?", callbackFactory.getFastMethod("empty_p"));
        arrayc.defineFastMethod("index", callbackFactory.getFastMethod("index", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("rindex", callbackFactory.getFastMethod("rindex", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("indexes", callbackFactory.getFastOptMethod("indexes"));
        arrayc.defineFastMethod("indices", callbackFactory.getFastOptMethod("indexes"));
        arrayc.defineFastMethod("join", callbackFactory.getFastOptMethod("join_m"));
        arrayc.defineFastMethod("reverse", callbackFactory.getFastMethod("reverse"));
        arrayc.defineFastMethod("reverse!", callbackFactory.getFastMethod("reverse_bang"));
        arrayc.defineMethod("sort", callbackFactory.getMethod("sort"));
        arrayc.defineMethod("sort!", callbackFactory.getMethod("sort_bang"));
        arrayc.defineMethod("collect", callbackFactory.getMethod("collect"));
        arrayc.defineMethod("collect!", callbackFactory.getMethod("collect_bang"));
        arrayc.defineMethod("map", callbackFactory.getMethod("collect"));
        arrayc.defineMethod("map!", callbackFactory.getMethod("collect_bang"));
        arrayc.defineMethod("select", callbackFactory.getMethod("select"));
        arrayc.defineFastMethod("values_at", callbackFactory.getFastOptMethod("values_at"));
        arrayc.defineMethod("delete", callbackFactory.getMethod("delete", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("delete_at", callbackFactory.getFastMethod("delete_at", RubyKernel.IRUBY_OBJECT));
        arrayc.defineMethod("delete_if", callbackFactory.getMethod("delete_if"));
        arrayc.defineMethod("reject", callbackFactory.getMethod("reject"));
        arrayc.defineMethod("reject!", callbackFactory.getMethod("reject_bang"));
        arrayc.defineMethod("zip", callbackFactory.getOptMethod("zip"));
        arrayc.defineFastMethod("transpose", callbackFactory.getFastMethod("transpose"));
        arrayc.defineFastMethod("replace", callbackFactory.getFastMethod("replace", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("clear", callbackFactory.getFastMethod("rb_clear"));
        arrayc.defineMethod("fill", callbackFactory.getOptMethod("fill"));
        arrayc.defineFastMethod("include?", callbackFactory.getFastMethod("include_p", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("<=>", callbackFactory.getFastMethod("op_cmp", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("slice", callbackFactory.getFastOptMethod("aref"));
        arrayc.defineFastMethod("slice!", callbackFactory.getFastOptMethod("slice_bang"));
        arrayc.defineFastMethod("assoc", callbackFactory.getFastMethod("assoc", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("rassoc", callbackFactory.getFastMethod("rassoc", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("+", callbackFactory.getFastMethod("op_plus", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("*", callbackFactory.getFastMethod("op_times", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("-", callbackFactory.getFastMethod("op_diff", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("&", callbackFactory.getFastMethod("op_and", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("|", callbackFactory.getFastMethod("op_or", RubyKernel.IRUBY_OBJECT));
        arrayc.defineFastMethod("uniq", callbackFactory.getFastMethod("uniq"));
        arrayc.defineFastMethod("uniq!", callbackFactory.getFastMethod("uniq_bang"));
        arrayc.defineFastMethod("compact", callbackFactory.getFastMethod("compact"));
        arrayc.defineFastMethod("compact!", callbackFactory.getFastMethod("compact_bang"));
        arrayc.defineFastMethod("flatten", callbackFactory.getFastMethod("flatten"));
        arrayc.defineFastMethod("flatten!", callbackFactory.getFastMethod("flatten_bang"));
        arrayc.defineFastMethod("nitems", callbackFactory.getFastMethod("nitems"));
        arrayc.defineFastMethod("pack", callbackFactory.getFastMethod("pack", RubyKernel.IRUBY_OBJECT));
        return arrayc;
    }

    public IRubyObject callMethod(ThreadContext context, RubyModule rubyclass, int methodIndex, String name, IRubyObject[] args, CallType callType, Block block) {
        if (context.getRuntime().getTraceFunction() != null) {
            return super.callMethod(context, rubyclass, name, args, callType, block);
        }
        switch (this.getRuntime().getSelectorTable().table[rubyclass.index][methodIndex]) {
            case 1: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_plus(args[0]);
            }
            case 2: {
                return this.aref(args);
            }
            case 3: {
                return this.aset(args);
            }
            case 4: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.pop();
            }
            case 5: {
                return this.push_m(args);
            }
            case 6: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.nil_p();
            }
            case 7: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_equal(args[0]);
            }
            case 8: {
                return this.unshift_m(args);
            }
            case 9: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.append(args[0]);
            }
            case 10: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.empty_p();
            }
            case 11: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_s();
            }
            case 12: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.at(args[0]);
            }
            case 13: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_ary();
            }
            case 14: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.to_a();
            }
            case 15: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.hash();
            }
            case 16: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_times(args[0]);
            }
            case 17: {
                if (args.length != 1) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 1 + ")");
                }
                return this.op_cmp(args[0]);
            }
            case 18: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.length();
            }
            case 19: {
                return this.last(args);
            }
            case 20: {
                if (args.length != 0) {
                    throw context.getRuntime().newArgumentError("wrong number of arguments(" + args.length + " for " + 0 + ")");
                }
                return this.shift();
            }
        }
        return super.callMethod(context, rubyclass, name, args, callType, block);
    }

    public int getNativeTypeIndex() {
        return 3;
    }

    public static IRubyObject create(IRubyObject klass, IRubyObject[] args, Block block) {
        RubyArray arr = (RubyArray)((RubyClass)klass).allocate();
        arr.callInit(IRubyObject.NULL_ARRAY, block);
        if (args.length > 0) {
            arr.alloc(args.length);
            System.arraycopy(args, 0, arr.values, 0, args.length);
            arr.realLength = args.length;
        }
        return arr;
    }

    public static final RubyArray newArray(Ruby runtime, long len) {
        return new RubyArray(runtime, len);
    }

    public static final RubyArray newArrayLight(Ruby runtime, long len) {
        return new RubyArray(runtime, len, false);
    }

    public static final RubyArray newArray(Ruby runtime) {
        return new RubyArray(runtime, 16L);
    }

    public static final RubyArray newArrayLight(Ruby runtime) {
        RubyArray arr = new RubyArray(runtime, false);
        arr.alloc(16);
        return arr;
    }

    public static RubyArray newArray(Ruby runtime, IRubyObject obj) {
        return new RubyArray(runtime, new IRubyObject[]{obj});
    }

    public static RubyArray newArray(Ruby runtime, IRubyObject car, IRubyObject cdr) {
        return new RubyArray(runtime, new IRubyObject[]{car, cdr});
    }

    public static RubyArray newArray(Ruby runtime, IRubyObject[] args) {
        RubyArray arr = new RubyArray(runtime, args.length);
        System.arraycopy(args, 0, arr.values, 0, args.length);
        arr.realLength = args.length;
        return arr;
    }

    public static RubyArray newArrayNoCopy(Ruby runtime, IRubyObject[] args) {
        return new RubyArray(runtime, args);
    }

    public static RubyArray newArrayNoCopyLight(Ruby runtime, IRubyObject[] args) {
        RubyArray arr = new RubyArray(runtime, false);
        arr.values = args;
        arr.realLength = args.length;
        return arr;
    }

    public static RubyArray newArray(Ruby runtime, Collection collection) {
        RubyArray arr = new RubyArray(runtime, collection.size());
        collection.toArray(arr.values);
        arr.realLength = arr.values.length;
        return arr;
    }

    private RubyArray(Ruby runtime, IRubyObject[] vals) {
        super(runtime, runtime.getArray());
        this.values = vals;
        this.realLength = vals.length;
    }

    private RubyArray(Ruby runtime, long length) {
        super(runtime, runtime.getArray());
        this.checkLength(length);
        this.alloc((int)length);
    }

    private RubyArray(Ruby runtime, long length, boolean objectspace) {
        super(runtime, runtime.getArray(), objectspace);
        this.checkLength(length);
        this.alloc((int)length);
    }

    public RubyArray(Ruby runtime, long length, IRubyObject[] vals) {
        super(runtime, runtime.getArray());
        this.checkLength(length);
        int ilength = (int)length;
        this.alloc(ilength);
        if (ilength > 0 && vals.length > 0) {
            System.arraycopy(vals, 0, this.values, 0, ilength);
        }
        this.realLength = ilength;
    }

    private RubyArray(Ruby runtime, boolean objectSpace) {
        super(runtime, runtime.getArray(), objectSpace);
    }

    private RubyArray(Ruby runtime) {
        super(runtime, runtime.getArray());
        this.alloc(16);
    }

    public RubyArray(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.alloc(16);
    }

    private RubyArray(Ruby runtime, RubyClass klass, int length) {
        super(runtime, klass);
        this.alloc(length);
    }

    private RubyArray(Ruby runtime, RubyClass klass, long length) {
        super(runtime, klass);
        this.checkLength(length);
        this.alloc((int)length);
    }

    private RubyArray(Ruby runtime, RubyClass klass, long length, boolean objectspace) {
        super(runtime, klass, objectspace);
        this.checkLength(length);
        this.alloc((int)length);
    }

    private RubyArray(Ruby runtime, RubyClass klass, boolean objectSpace) {
        super(runtime, klass, objectSpace);
    }

    private RubyArray(Ruby runtime, RubyClass klass, RubyArray original) {
        super(runtime, klass);
        this.realLength = original.realLength;
        this.alloc(this.realLength);
        System.arraycopy(original.values, original.begin, this.values, 0, this.realLength);
    }

    private final IRubyObject[] reserve(int length) {
        return new IRubyObject[length];
    }

    private final void alloc(int length) {
        this.values = new IRubyObject[length];
    }

    private final void realloc(int newLength) {
        IRubyObject[] reallocated = new IRubyObject[newLength];
        System.arraycopy(this.values, 0, reallocated, 0, newLength > this.realLength ? this.realLength : newLength);
        this.values = reallocated;
    }

    private final void checkLength(long length) {
        if (length < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        if (length >= Integer.MAX_VALUE) {
            throw this.getRuntime().newArgumentError("array size too big");
        }
    }

    public List getList() {
        return Arrays.asList(this.toJavaArray());
    }

    public int getLength() {
        return this.realLength;
    }

    public IRubyObject[] toJavaArray() {
        IRubyObject[] copy = this.reserve(this.realLength);
        System.arraycopy(this.values, this.begin, copy, 0, this.realLength);
        return copy;
    }

    public IRubyObject[] toJavaArrayUnsafe() {
        return !this.shared ? this.values : this.toJavaArray();
    }

    public IRubyObject[] toJavaArrayMaybeUnsafe() {
        return !this.shared && this.begin == 0 && this.values.length == this.realLength ? this.values : this.toJavaArray();
    }

    private final RubyArray makeShared(int beg, int len, RubyClass klass, boolean objectSpace) {
        RubyArray sharedArray = new RubyArray(this.getRuntime(), klass, objectSpace);
        this.shared = true;
        sharedArray.values = this.values;
        sharedArray.shared = true;
        sharedArray.begin = beg;
        sharedArray.realLength = len;
        return sharedArray;
    }

    private final void modifyCheck() {
        this.testFrozen("array");
        if (this.tmpLock) {
            throw this.getRuntime().newTypeError("can't modify array during iteration");
        }
        if (!this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify array");
        }
    }

    private final void modify() {
        this.modifyCheck();
        if (this.shared) {
            IRubyObject[] vals = this.reserve(this.realLength);
            this.shared = false;
            System.arraycopy(this.values, this.begin, vals, 0, this.realLength);
            this.begin = 0;
            this.values = vals;
        }
    }

    public IRubyObject initialize(IRubyObject[] args, Block block) {
        IRubyObject val;
        int argc = Arity.checkArgumentCount(this.getRuntime(), args, 0, 2);
        Ruby runtime = this.getRuntime();
        if (argc == 0) {
            this.realLength = 0;
            if (block.isGiven()) {
                runtime.getWarnings().warn("given block not used");
            }
            return this;
        }
        if (argc == 1 && !(args[0] instanceof RubyFixnum) && !(val = args[0].checkArrayType()).isNil()) {
            this.replace(val);
            return this;
        }
        long len = RubyNumeric.num2long(args[0]);
        if (len < 0L) {
            throw runtime.newArgumentError("negative array size");
        }
        if (len >= Integer.MAX_VALUE) {
            throw runtime.newArgumentError("array size too big");
        }
        int ilen = (int)len;
        this.modify();
        if (ilen > this.values.length) {
            this.values = this.reserve(ilen);
        }
        if (block.isGiven()) {
            if (argc == 2) {
                runtime.getWarnings().warn("block supersedes default value argument");
            }
            ThreadContext context = runtime.getCurrentContext();
            for (int i = 0; i < ilen; ++i) {
                this.store(i, block.yield(context, new RubyFixnum(runtime, i)));
                this.realLength = i + 1;
            }
        } else {
            Arrays.fill(this.values, 0, ilen, argc == 2 ? args[1] : runtime.getNil());
            this.realLength = ilen;
        }
        return this;
    }

    public IRubyObject replace(IRubyObject orig) {
        this.modifyCheck();
        RubyArray origArr = orig.convertToArray();
        if (this == orig) {
            return this;
        }
        origArr.shared = true;
        this.values = origArr.values;
        this.realLength = origArr.realLength;
        this.begin = origArr.begin;
        this.shared = true;
        return this;
    }

    public IRubyObject to_s() {
        if (this.realLength == 0) {
            return this.getRuntime().newString("");
        }
        return this.join(this.getRuntime().getGlobalVariables().get("$,"));
    }

    public boolean includes(IRubyObject item) {
        int begin;
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = begin = this.begin; i < begin + this.realLength; ++i) {
            if (!this.values[i].equalInternal(context, item).isTrue()) continue;
            return true;
        }
        return false;
    }

    public RubyFixnum hash() {
        int begin;
        int h = this.realLength;
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (int i = begin = this.begin; i < begin + this.realLength; ++i) {
            h = h << 1 | (h < 0 ? 1 : 0);
            h = (int)((long)h ^ RubyNumeric.num2long(this.values[i].callMethod(context, 23, "hash")));
        }
        return runtime.newFixnum(h);
    }

    public final IRubyObject store(long index, IRubyObject value) {
        if (index < 0L && (index += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (index - (long)this.realLength) + " out of array");
        }
        this.modify();
        if (index >= (long)this.realLength) {
            if (index >= (long)this.values.length) {
                long newLength = this.values.length >> 1;
                if (newLength < 16L) {
                    newLength = 16L;
                }
                if ((newLength += index) >= Integer.MAX_VALUE) {
                    throw this.getRuntime().newArgumentError("index too big");
                }
                this.realloc((int)newLength);
            }
            if (index != (long)this.realLength) {
                Arrays.fill(this.values, this.realLength, (int)index + 1, this.getRuntime().getNil());
            }
            this.realLength = (int)index + 1;
        }
        this.values[(int)index] = value;
        return value;
    }

    private final IRubyObject elt(long offset) {
        if (this.realLength == 0 || offset < 0L || offset >= (long)this.realLength) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + (int)offset];
    }

    private final IRubyObject elt(int offset) {
        if (this.realLength == 0 || offset < 0 || offset >= this.realLength) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + offset];
    }

    private final IRubyObject elt_f(long offset) {
        if (this.realLength == 0 || offset >= (long)this.realLength) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + (int)offset];
    }

    private final IRubyObject elt_f(int offset) {
        if (this.realLength == 0 || offset >= this.realLength) {
            return this.getRuntime().getNil();
        }
        return this.values[this.begin + offset];
    }

    public final IRubyObject entry(long offset) {
        return offset < 0L ? this.elt(offset + (long)this.realLength) : this.elt_f(offset);
    }

    public final IRubyObject entry(int offset) {
        return offset < 0 ? this.elt(offset + this.realLength) : this.elt_f(offset);
    }

    public final IRubyObject eltInternal(int offset) {
        return this.values[this.begin + offset];
    }

    public final IRubyObject eltInternalSet(int offset, IRubyObject item) {
        IRubyObject iRubyObject = item;
        this.values[this.begin + offset] = iRubyObject;
        return iRubyObject;
    }

    public IRubyObject fetch(IRubyObject[] args, Block block) {
        long index;
        if (Arity.checkArgumentCount(this.getRuntime(), args, 1, 2) == 2 && block.isGiven()) {
            this.getRuntime().getWarnings().warn("block supersedes default value argument");
        }
        if ((index = RubyNumeric.num2long(args[0])) < 0L) {
            index += (long)this.realLength;
        }
        if (index < 0L || index >= (long)this.realLength) {
            if (block.isGiven()) {
                return block.yield(this.getRuntime().getCurrentContext(), args[0]);
            }
            if (args.length == 1) {
                throw this.getRuntime().newIndexError("index " + index + " out of array");
            }
            return args[1];
        }
        return this.values[this.begin + (int)index];
    }

    private static RubyArray aryToAry(IRubyObject obj) {
        if (obj instanceof RubyArray) {
            return (RubyArray)obj;
        }
        if (obj.respondsTo("to_ary")) {
            return obj.convertToArray();
        }
        RubyArray arr = new RubyArray(obj.getRuntime(), false);
        arr.alloc(1);
        arr.values[0] = obj;
        arr.realLength = 1;
        return arr;
    }

    private final void splice(long beg, long len, IRubyObject rpl) {
        int rlen;
        RubyArray rplArr;
        if (len < 0L) {
            throw this.getRuntime().newIndexError("negative length (" + len + ")");
        }
        if (beg < 0L && (beg += (long)this.realLength) < 0L) {
            throw this.getRuntime().newIndexError("index " + (beg -= (long)this.realLength) + " out of array");
        }
        if (beg + len > (long)this.realLength) {
            len = (long)this.realLength - beg;
        }
        if (rpl == null || rpl.isNil()) {
            rplArr = null;
            rlen = 0;
        } else {
            rplArr = RubyArray.aryToAry(rpl);
            rlen = rplArr.realLength;
        }
        this.modify();
        if (beg >= (long)this.realLength) {
            len = beg + (long)rlen;
            if (len >= (long)this.values.length) {
                int tryNewLength = this.values.length + (this.values.length >> 1);
                this.realloc(len > (long)tryNewLength ? (int)len : tryNewLength);
            }
            Arrays.fill(this.values, this.realLength, (int)beg, this.getRuntime().getNil());
            if (rlen > 0) {
                System.arraycopy(rplArr.values, rplArr.begin, this.values, (int)beg, rlen);
            }
            this.realLength = (int)len;
        } else {
            long alen;
            if (beg + len > (long)this.realLength) {
                len = (long)this.realLength - beg;
            }
            if ((alen = (long)(this.realLength + rlen) - len) >= (long)this.values.length) {
                int tryNewLength = this.values.length + (this.values.length >> 1);
                this.realloc(alen > (long)tryNewLength ? (int)alen : tryNewLength);
            }
            if (len != (long)rlen) {
                System.arraycopy(this.values, (int)(beg + len), this.values, (int)beg + rlen, this.realLength - (int)(beg + len));
                this.realLength = (int)alen;
            }
            if (rlen > 0) {
                System.arraycopy(rplArr.values, rplArr.begin, this.values, (int)beg, rlen);
            }
        }
    }

    public IRubyObject insert(IRubyObject[] args) {
        if (args.length == 1) {
            return this;
        }
        if (args.length < 1) {
            throw this.getRuntime().newArgumentError("wrong number of arguments (at least 1)");
        }
        long pos = RubyNumeric.num2long(args[0]);
        if (pos == -1L) {
            pos = this.realLength;
        }
        if (pos < 0L) {
            ++pos;
        }
        RubyArray inserted = new RubyArray(this.getRuntime(), false);
        inserted.values = args;
        inserted.begin = 1;
        inserted.realLength = args.length - 1;
        this.splice(pos, 0L, inserted);
        return this;
    }

    private final RubyArray aryDup() {
        RubyArray dup = new RubyArray(this.getRuntime(), this.getMetaClass(), this);
        dup.setTaint(this.isTaint());
        return dup;
    }

    public RubyArray transpose() {
        RubyArray result = null;
        int alen = this.realLength;
        if (alen == 0) {
            return this.aryDup();
        }
        Ruby runtime = this.getRuntime();
        int elen = -1;
        int end = this.begin + alen;
        for (int i = this.begin; i < end; ++i) {
            int j;
            RubyArray tmp = this.elt(i).convertToArray();
            if (elen < 0) {
                elen = tmp.realLength;
                result = new RubyArray(runtime, elen);
                for (j = 0; j < elen; ++j) {
                    result.store(j, new RubyArray(runtime, alen));
                }
            } else if (elen != tmp.realLength) {
                throw runtime.newIndexError("element size differs (" + tmp.realLength + " should be " + elen + ")");
            }
            for (j = 0; j < elen; ++j) {
                ((RubyArray)result.elt(j)).store(i - this.begin, tmp.elt(j));
            }
        }
        return result;
    }

    private final IRubyObject values_at(long olen, IRubyObject[] args) {
        RubyArray result = new RubyArray(this.getRuntime(), args.length);
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof RubyFixnum) {
                result.append(this.entry(((RubyFixnum)args[i]).getLongValue()));
                continue;
            }
            if (args[i] instanceof RubyRange) {
                long[] beglen = ((RubyRange)args[i]).begLen(olen, 0);
                if (beglen == null) continue;
                int beg = (int)beglen[0];
                int len = (int)beglen[1];
                int end = this.begin + len;
                for (int j = this.begin; j < end; ++j) {
                    result.append(this.entry(j + beg));
                }
                continue;
            }
            result.append(this.entry(RubyNumeric.num2long(args[i])));
        }
        return result;
    }

    public IRubyObject values_at(IRubyObject[] args) {
        return this.values_at(this.realLength, args);
    }

    public IRubyObject subseq(long beg, long len) {
        if (beg > (long)this.realLength || beg < 0L || len < 0L) {
            return this.getRuntime().getNil();
        }
        if (beg + len > (long)this.realLength && (len = (long)this.realLength - beg) < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), 0);
        }
        return this.makeShared(this.begin + (int)beg, (int)len, this.getMetaClass(), true);
    }

    public IRubyObject subseqLight(long beg, long len) {
        if (beg > (long)this.realLength || beg < 0L || len < 0L) {
            return this.getRuntime().getNil();
        }
        if (beg + len > (long)this.realLength && (len = (long)this.realLength - beg) < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), 0L, false);
        }
        return this.makeShared(this.begin + (int)beg, (int)len, this.getMetaClass(), false);
    }

    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.realLength);
    }

    public RubyArray append(IRubyObject item) {
        this.modify();
        if (this.realLength == this.values.length) {
            if (this.realLength == Integer.MAX_VALUE) {
                throw this.getRuntime().newArgumentError("index too big");
            }
            long newLength = this.values.length + (this.values.length >> 1);
            if (newLength > Integer.MAX_VALUE) {
                newLength = Integer.MAX_VALUE;
            } else if (newLength < 16L) {
                newLength = 16L;
            }
            this.realloc((int)newLength);
        }
        this.values[this.realLength++] = item;
        return this;
    }

    public RubyArray push_m(IRubyObject[] items) {
        for (int i = 0; i < items.length; ++i) {
            this.append(items[i]);
        }
        return this;
    }

    public IRubyObject pop() {
        this.modifyCheck();
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        if (!this.shared) {
            int index = this.begin + --this.realLength;
            IRubyObject obj = this.values[index];
            this.values[index] = null;
            return obj;
        }
        return this.values[this.begin + --this.realLength];
    }

    public IRubyObject shift() {
        this.modifyCheck();
        if (this.realLength == 0) {
            return this.getRuntime().getNil();
        }
        IRubyObject obj = this.values[this.begin];
        if (!this.shared) {
            this.shared = true;
        }
        ++this.begin;
        --this.realLength;
        return obj;
    }

    public RubyArray unshift(IRubyObject item) {
        this.modify();
        if (this.realLength == this.values.length) {
            int newLength = this.values.length >> 1;
            if (newLength < 16) {
                newLength = 16;
            }
            this.realloc(newLength += this.values.length);
        }
        System.arraycopy(this.values, 0, this.values, 1, this.realLength);
        ++this.realLength;
        this.values[0] = item;
        return this;
    }

    public RubyArray unshift_m(IRubyObject[] items) {
        long len = this.realLength;
        if (items.length == 0) {
            return this;
        }
        this.store(len + (long)items.length - 1L, this.getRuntime().getNil());
        System.arraycopy(this.values, 0, this.values, items.length, (int)len);
        System.arraycopy(items, 0, this.values, 0, items.length);
        return this;
    }

    public RubyBoolean include_p(IRubyObject item) {
        return this.getRuntime().newBoolean(this.includes(item));
    }

    public RubyBoolean frozen() {
        return this.getRuntime().newBoolean(this.isFrozen() || this.tmpLock);
    }

    public IRubyObject aref(IRubyObject[] args) {
        if (args.length == 1) {
            if (args[0] instanceof RubyFixnum) {
                return this.entry(((RubyFixnum)args[0]).getLongValue());
            }
            if (args[0] instanceof RubySymbol) {
                throw this.getRuntime().newTypeError("Symbol as array index");
            }
            if (args[0] instanceof RubyRange) {
                long[] beglen = ((RubyRange)args[0]).begLen(this.realLength, 0);
                if (beglen == null) {
                    return this.getRuntime().getNil();
                }
                long beg = beglen[0];
                long len = beglen[1];
                return this.subseq(beg, len);
            }
            return this.entry(RubyNumeric.num2long(args[0]));
        }
        if (args.length == 2) {
            if (args[0] instanceof RubySymbol) {
                throw this.getRuntime().newTypeError("Symbol as array index");
            }
            long beg = RubyNumeric.num2long(args[0]);
            long len = RubyNumeric.num2long(args[1]);
            if (beg < 0L) {
                beg += (long)this.realLength;
            }
            return this.subseq(beg, len);
        }
        Arity.checkArgumentCount(this.getRuntime(), args, 1, 2);
        return null;
    }

    public IRubyObject aset(IRubyObject[] args) {
        if (args.length == 2) {
            if (args[0] instanceof RubyFixnum) {
                this.store(((RubyFixnum)args[0]).getLongValue(), args[1]);
                return args[1];
            }
            if (args[0] instanceof RubyRange) {
                long[] beglen = ((RubyRange)args[0]).begLen(this.realLength, 1);
                this.splice(beglen[0], beglen[1], args[1]);
                return args[1];
            }
            if (args[0] instanceof RubySymbol) {
                throw this.getRuntime().newTypeError("Symbol as array index");
            }
            this.store(RubyNumeric.num2long(args[0]), args[1]);
            return args[1];
        }
        if (args.length == 3) {
            if (args[0] instanceof RubySymbol) {
                throw this.getRuntime().newTypeError("Symbol as array index");
            }
            if (args[1] instanceof RubySymbol) {
                throw this.getRuntime().newTypeError("Symbol as subarray length");
            }
            this.splice(RubyNumeric.num2long(args[0]), RubyNumeric.num2long(args[1]), args[2]);
            return args[2];
        }
        throw this.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for 2)");
    }

    public IRubyObject at(IRubyObject pos) {
        return this.entry(RubyNumeric.num2long(pos));
    }

    public RubyArray concat(IRubyObject obj) {
        RubyArray ary = obj.convertToArray();
        if (ary.realLength > 0) {
            this.splice(this.realLength, 0L, ary);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject inspect() {
        if (this.realLength == 0) {
            return this.getRuntime().newString("[]");
        }
        if (!this.getRuntime().registerInspecting(this)) {
            return this.getRuntime().newString("[...]");
        }
        try {
            StringBuffer buffer = new StringBuffer("[");
            Ruby runtime = this.getRuntime();
            ThreadContext context = runtime.getCurrentContext();
            boolean tainted = this.isTaint();
            for (int i = 0; i < this.realLength; ++i) {
                RubyString s = RubyString.objAsString(this.values[this.begin + i].callMethod(context, "inspect"));
                if (s.isTaint()) {
                    tainted = true;
                }
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(s.toString());
            }
            buffer.append("]");
            if (tainted) {
                this.setTaint(true);
            }
            RubyString rubyString = runtime.newString(buffer.toString());
            return rubyString;
        }
        finally {
            this.getRuntime().unregisterInspecting(this);
        }
    }

    public IRubyObject first(IRubyObject[] args) {
        if (args.length == 0) {
            if (this.realLength == 0) {
                return this.getRuntime().getNil();
            }
            return this.values[this.begin];
        }
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        long n = RubyNumeric.num2long(args[0]);
        if (n > (long)this.realLength) {
            n = this.realLength;
        } else if (n < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        return this.makeShared(this.begin, (int)n, this.getRuntime().getArray(), true);
    }

    public IRubyObject last(IRubyObject[] args) {
        if (args.length == 0) {
            if (this.realLength == 0) {
                return this.getRuntime().getNil();
            }
            return this.values[this.begin + this.realLength - 1];
        }
        Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        long n = RubyNumeric.num2long(args[0]);
        if (n > (long)this.realLength) {
            n = this.realLength;
        } else if (n < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        return this.makeShared(this.begin + this.realLength - (int)n, (int)n, this.getRuntime().getArray(), true);
    }

    public IRubyObject each(Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        if (this.shared) {
            for (int i = this.begin; i < this.begin + this.realLength; ++i) {
                block.yield(context, this.values[i]);
            }
        } else {
            for (int i = 0; i < this.realLength; ++i) {
                block.yield(context, this.values[i]);
            }
        }
        return this;
    }

    public IRubyObject each_index(Block block) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (int i = 0; i < this.realLength; ++i) {
            block.yield(context, runtime.newFixnum(i));
        }
        return this;
    }

    public IRubyObject reverse_each(Block block) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int len = this.realLength;
        while (len-- > 0) {
            block.yield(context, this.values[this.begin + len]);
            if (this.realLength >= len) continue;
            len = this.realLength;
        }
        return this;
    }

    private final IRubyObject inspectJoin(IRubyObject sep) {
        RubyString result = this.join(sep);
        this.getRuntime().unregisterInspecting(this);
        return result;
    }

    public RubyString join(IRubyObject sep) {
        if (this.realLength == 0) {
            return this.getRuntime().newString("");
        }
        boolean taint = this.isTaint() || sep.isTaint();
        long len = 1L;
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject tmp = this.values[i].checkStringType();
            len += tmp.isNil() ? 10L : (long)((RubyString)tmp).getByteList().length();
        }
        if (!sep.isNil()) {
            len += (long)(sep.convertToString().getByteList().length() * (this.realLength - 1));
        }
        StringBuffer buf = new StringBuffer((int)len);
        Ruby runtime = this.getRuntime();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject tmp = this.values[i];
            if (!(tmp instanceof RubyString)) {
                tmp = tmp instanceof RubyArray ? (!runtime.registerInspecting(tmp) ? runtime.newString("[...]") : ((RubyArray)tmp).inspectJoin(sep)) : RubyString.objAsString(tmp);
            }
            if (i > this.begin && !sep.isNil()) {
                buf.append(sep.toString());
            }
            buf.append(((RubyString)tmp).toString());
            taint |= tmp.isTaint();
        }
        RubyString result = RubyString.newString(runtime, buf.toString());
        if (taint) {
            result.setTaint(taint);
        }
        return result;
    }

    public RubyString join_m(IRubyObject[] args) {
        int argc = Arity.checkArgumentCount(this.getRuntime(), args, 0, 1);
        IRubyObject sep = argc == 1 ? args[0] : this.getRuntime().getGlobalVariables().get("$,");
        return this.join(sep);
    }

    public RubyArray to_a() {
        if (this.getMetaClass() != this.getRuntime().getArray()) {
            RubyArray dup = new RubyArray(this.getRuntime(), true);
            this.shared = true;
            dup.values = this.values;
            dup.realLength = this.realLength;
            dup.begin = this.begin;
            dup.shared = true;
            return dup;
        }
        return this;
    }

    public IRubyObject to_ary() {
        return this;
    }

    public RubyArray convertToArray() {
        return this;
    }

    public IRubyObject checkArrayType() {
        return this;
    }

    public IRubyObject op_equal(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().getTrue();
        }
        if (!(obj instanceof RubyArray)) {
            if (!obj.respondsTo("to_ary")) {
                return this.getRuntime().getFalse();
            }
            return obj.equalInternal(this.getRuntime().getCurrentContext(), this);
        }
        RubyArray ary = (RubyArray)obj;
        if (this.realLength != ary.realLength) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (long i = 0L; i < (long)this.realLength; ++i) {
            if (this.elt(i).equalInternal(context, ary.elt(i)).isTrue()) continue;
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    public RubyBoolean eql_p(IRubyObject obj) {
        if (this == obj) {
            return this.getRuntime().getTrue();
        }
        if (!(obj instanceof RubyArray)) {
            return this.getRuntime().getFalse();
        }
        RubyArray ary = (RubyArray)obj;
        if (this.realLength != ary.realLength) {
            return this.getRuntime().getFalse();
        }
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (int i = 0; i < this.realLength; ++i) {
            if (this.elt(i).eqlInternal(context, ary.elt(i))) continue;
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    public IRubyObject compact_bang() {
        this.modify();
        int p = 0;
        int t = 0;
        int end = p + this.realLength;
        while (t < end) {
            if (this.values[t].isNil()) {
                ++t;
                continue;
            }
            this.values[p++] = this.values[t++];
        }
        if (this.realLength == p) {
            return this.getRuntime().getNil();
        }
        this.realloc(p);
        this.realLength = p;
        return this;
    }

    public IRubyObject compact() {
        RubyArray ary = this.aryDup();
        ary.compact_bang();
        return ary;
    }

    public IRubyObject empty_p() {
        return this.realLength == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject rb_clear() {
        this.modifyCheck();
        if (this.shared) {
            this.alloc(16);
            this.shared = false;
        } else if (this.values.length > 32) {
            this.alloc(32);
        }
        this.begin = 0;
        this.realLength = 0;
        return this;
    }

    public IRubyObject fill(IRubyObject[] args, Block block) {
        IRubyObject item = null;
        IRubyObject begObj = null;
        IRubyObject lenObj = null;
        int argc = args.length;
        if (block.isGiven()) {
            Arity.checkArgumentCount(this.getRuntime(), args, 0, 2);
            item = null;
            begObj = argc > 0 ? args[0] : null;
            lenObj = argc > 1 ? args[1] : null;
            ++argc;
        } else {
            Arity.checkArgumentCount(this.getRuntime(), args, 1, 3);
            item = args[0];
            begObj = argc > 1 ? args[1] : null;
            lenObj = argc > 2 ? args[2] : null;
        }
        long beg = 0L;
        long end = 0L;
        long len = 0L;
        switch (argc) {
            case 1: {
                beg = 0L;
                len = this.realLength;
                break;
            }
            case 2: {
                if (begObj instanceof RubyRange) {
                    long[] beglen = ((RubyRange)begObj).begLen(this.realLength, 1);
                    beg = (int)beglen[0];
                    len = (int)beglen[1];
                    break;
                }
            }
            case 3: {
                long l = beg = begObj.isNil() ? 0L : RubyNumeric.num2long(begObj);
                if (beg < 0L && (beg = (long)this.realLength + beg) < 0L) {
                    beg = 0L;
                }
                len = lenObj == null || lenObj.isNil() ? (long)this.realLength - beg : RubyNumeric.num2long(lenObj);
            }
        }
        this.modify();
        end = beg + len;
        if (end > (long)this.realLength) {
            if (end >= (long)this.values.length) {
                this.realloc((int)end);
            }
            Arrays.fill(this.values, this.realLength, (int)end, this.getRuntime().getNil());
            this.realLength = (int)end;
        }
        if (block.isGiven()) {
            Ruby runtime = this.getRuntime();
            ThreadContext context = runtime.getCurrentContext();
            for (int i = (int)beg; i < (int)end; ++i) {
                IRubyObject v = block.yield(context, runtime.newFixnum(i));
                if (i < this.realLength) {
                    this.values[i] = v;
                    continue;
                }
                break;
            }
        } else if (len > 0L) {
            Arrays.fill(this.values, (int)beg, (int)(beg + len), item);
        }
        return this;
    }

    public IRubyObject index(IRubyObject obj) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (!this.values[i].equalInternal(context, obj).isTrue()) continue;
            return runtime.newFixnum(i - this.begin);
        }
        return runtime.getNil();
    }

    public IRubyObject rindex(IRubyObject obj) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        int i = this.realLength;
        while (i-- > 0) {
            if (i > this.realLength) {
                i = this.realLength;
                continue;
            }
            if (!this.values[this.begin + i].equalInternal(context, obj).isTrue()) continue;
            return this.getRuntime().newFixnum(i);
        }
        return runtime.getNil();
    }

    public IRubyObject indexes(IRubyObject[] args) {
        this.getRuntime().getWarnings().warn("Array#indexes is deprecated; use Array#values_at");
        RubyArray ary = new RubyArray(this.getRuntime(), args.length);
        IRubyObject[] arefArgs = new IRubyObject[1];
        for (int i = 0; i < args.length; ++i) {
            arefArgs[0] = args[i];
            ary.append(this.aref(arefArgs));
        }
        return ary;
    }

    public IRubyObject reverse_bang() {
        this.modify();
        if (this.realLength > 1) {
            int p1 = 0;
            int p2 = p1 + this.realLength - 1;
            while (p1 < p2) {
                IRubyObject tmp = this.values[p1];
                this.values[p1++] = this.values[p2];
                this.values[p2--] = tmp;
            }
        }
        return this;
    }

    public IRubyObject reverse() {
        return this.aryDup().reverse_bang();
    }

    public RubyArray collect(Block block) {
        Ruby runtime = this.getRuntime();
        if (!block.isGiven()) {
            return new RubyArray(this.getRuntime(), runtime.getArray(), this);
        }
        ThreadContext context = runtime.getCurrentContext();
        RubyArray collect = new RubyArray(runtime, this.realLength);
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            collect.append(block.yield(context, this.values[i]));
        }
        return collect;
    }

    public RubyArray collect_bang(Block block) {
        this.modify();
        ThreadContext context = this.getRuntime().getCurrentContext();
        int len = this.realLength;
        for (int i = 0; i < len; ++i) {
            this.store(i, block.yield(context, this.values[this.begin + i]));
        }
        return this;
    }

    public RubyArray select(Block block) {
        Ruby runtime = this.getRuntime();
        RubyArray result = new RubyArray(runtime, this.realLength);
        ThreadContext context = runtime.getCurrentContext();
        if (this.shared) {
            for (int i = this.begin; i < this.begin + this.realLength; ++i) {
                if (!block.yield(context, this.values[i]).isTrue()) continue;
                result.append(this.elt(i - this.begin));
            }
        } else {
            for (int i = 0; i < this.realLength; ++i) {
                if (!block.yield(context, this.values[i]).isTrue()) continue;
                result.append(this.elt(i));
            }
        }
        return result;
    }

    public IRubyObject delete(IRubyObject item, Block block) {
        int i2 = 0;
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject e = this.values[this.begin + i1];
            if (e.equalInternal(context, item).isTrue()) continue;
            if (i1 != i2) {
                this.store(i2, e);
            }
            ++i2;
        }
        if (this.realLength == i2) {
            if (block.isGiven()) {
                return block.yield(context, item);
            }
            return runtime.getNil();
        }
        this.modify();
        if (this.realLength > i2) {
            this.realLength = i2;
            if (i2 << 1 < this.values.length && this.values.length > 16) {
                this.realloc(i2 << 1);
            }
        }
        return item;
    }

    private final IRubyObject delete_at(int pos) {
        int len = this.realLength;
        if (pos >= len) {
            return this.getRuntime().getNil();
        }
        if (pos < 0) {
            pos += len;
        }
        if (pos < 0) {
            return this.getRuntime().getNil();
        }
        this.modify();
        IRubyObject obj = this.values[pos];
        System.arraycopy(this.values, pos + 1, this.values, pos, len - (pos + 1));
        --this.realLength;
        return obj;
    }

    public IRubyObject delete_at(IRubyObject obj) {
        return this.delete_at((int)RubyNumeric.num2long(obj));
    }

    public IRubyObject reject(Block block) {
        RubyArray ary = this.aryDup();
        ary.reject_bang(block);
        return ary;
    }

    public IRubyObject reject_bang(Block block) {
        int i2 = 0;
        this.modify();
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i1 = 0; i1 < this.realLength; ++i1) {
            IRubyObject v = this.values[i1];
            if (block.yield(context, v).isTrue()) continue;
            if (i1 != i2) {
                this.store(i2, v);
            }
            ++i2;
        }
        if (this.realLength == i2) {
            return this.getRuntime().getNil();
        }
        if (i2 < this.realLength) {
            this.realLength = i2;
        }
        return this;
    }

    public IRubyObject delete_if(Block block) {
        this.reject_bang(block);
        return this;
    }

    public IRubyObject zip(IRubyObject[] args, Block block) {
        for (int i = 0; i < args.length; ++i) {
            args[i] = args[i].convertToArray();
        }
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (block.isGiven()) {
            for (int i = 0; i < this.realLength; ++i) {
                RubyArray tmp = new RubyArray(runtime, args.length + 1);
                tmp.append(this.elt(i));
                for (int j = 0; j < args.length; ++j) {
                    tmp.append(((RubyArray)args[j]).elt(i));
                }
                block.yield(context, tmp);
            }
            return runtime.getNil();
        }
        int len = this.realLength;
        RubyArray result = new RubyArray(runtime, len);
        for (int i = 0; i < len; ++i) {
            RubyArray tmp = new RubyArray(runtime, args.length + 1);
            tmp.append(this.elt(i));
            for (int j = 0; j < args.length; ++j) {
                tmp.append(((RubyArray)args[j]).elt(i));
            }
            result.append(tmp);
        }
        return result;
    }

    public IRubyObject op_cmp(IRubyObject obj) {
        RubyArray ary2 = obj.convertToArray();
        int len = this.realLength;
        if (len > ary2.realLength) {
            len = ary2.realLength;
        }
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (int i = 0; i < len; ++i) {
            IRubyObject v = this.elt(i).callMethod(context, 27, "<=>", ary2.elt(i));
            if (v instanceof RubyFixnum && ((RubyFixnum)v).getLongValue() == 0L) continue;
            return v;
        }
        len = this.realLength - ary2.realLength;
        if (len == 0) {
            return RubyFixnum.zero(runtime);
        }
        if (len > 0) {
            return RubyFixnum.one(runtime);
        }
        return RubyFixnum.minus_one(runtime);
    }

    public IRubyObject slice_bang(IRubyObject[] args) {
        if (Arity.checkArgumentCount(this.getRuntime(), args, 1, 2) == 2) {
            long pos = RubyNumeric.num2long(args[0]);
            long len = RubyNumeric.num2long(args[1]);
            if (pos < 0L) {
                pos = (long)this.realLength + pos;
            }
            args[1] = this.subseq(pos, len);
            this.splice(pos, len, null);
            return args[1];
        }
        IRubyObject arg = args[0];
        if (arg instanceof RubyRange) {
            long[] beglen = ((RubyRange)arg).begLen(this.realLength, 1);
            long pos = beglen[0];
            long len = beglen[1];
            if (pos < 0L) {
                pos = (long)this.realLength + pos;
            }
            arg = this.subseq(pos, len);
            this.splice(pos, len, null);
            return arg;
        }
        return this.delete_at((int)RubyNumeric.num2long(args[0]));
    }

    public IRubyObject assoc(IRubyObject key) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject v = this.values[i];
            if (!(v instanceof RubyArray) || ((RubyArray)v).realLength <= 0 || !((RubyArray)v).values[0].equalInternal(context, key).isTrue()) continue;
            return v;
        }
        return runtime.getNil();
    }

    public IRubyObject rassoc(IRubyObject value) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            IRubyObject v = this.values[i];
            if (!(v instanceof RubyArray) || ((RubyArray)v).realLength <= 1 || !((RubyArray)v).values[1].equalInternal(context, value).isTrue()) continue;
            return v;
        }
        return runtime.getNil();
    }

    private final int flatten(int index, RubyArray ary2, RubyArray memo) {
        int lim = index + ary2.realLength;
        RubyFixnum id = ary2.id();
        if (memo.includes(id)) {
            throw this.getRuntime().newArgumentError("tried to flatten recursive array");
        }
        memo.append(id);
        this.splice(index, 1L, ary2);
        for (int i = index; i < lim; ++i) {
            IRubyObject tmp = this.elt(i).checkArrayType();
            if (tmp.isNil()) continue;
            int n = this.flatten(i, (RubyArray)tmp, memo);
            i += n;
            lim += n;
        }
        memo.pop();
        return lim - index - 1;
    }

    public IRubyObject flatten_bang() {
        RubyArray memo = null;
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject ary2 = this.values[this.begin + i];
            IRubyObject tmp = ary2.checkArrayType();
            if (tmp.isNil()) continue;
            if (memo == null) {
                memo = new RubyArray(this.getRuntime(), false);
                memo.values = this.reserve(16);
            }
            i += this.flatten(i, (RubyArray)tmp, memo);
        }
        if (memo == null) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    public IRubyObject flatten() {
        RubyArray ary = this.aryDup();
        ary.flatten_bang();
        return ary;
    }

    public IRubyObject nitems() {
        int n = 0;
        for (int i = this.begin; i < this.begin + this.realLength; ++i) {
            if (this.values[i].isNil()) continue;
            ++n;
        }
        return this.getRuntime().newFixnum(n);
    }

    public IRubyObject op_plus(IRubyObject obj) {
        RubyArray y = obj.convertToArray();
        int len = this.realLength + y.realLength;
        RubyArray z = new RubyArray(this.getRuntime(), len);
        System.arraycopy(this.values, this.begin, z.values, 0, this.realLength);
        System.arraycopy(y.values, y.begin, z.values, this.realLength, y.realLength);
        z.realLength = len;
        return z;
    }

    public IRubyObject op_times(IRubyObject times) {
        IRubyObject tmp = times.checkStringType();
        if (!tmp.isNil()) {
            return this.join(tmp);
        }
        long len = RubyNumeric.num2long(times);
        if (len == 0L) {
            return new RubyArray(this.getRuntime(), this.getMetaClass(), 0);
        }
        if (len < 0L) {
            throw this.getRuntime().newArgumentError("negative argument");
        }
        if (Long.MAX_VALUE / len < (long)this.realLength) {
            throw this.getRuntime().newArgumentError("argument too big");
        }
        RubyArray ary2 = new RubyArray(this.getRuntime(), this.getMetaClass(), len *= (long)this.realLength);
        ary2.realLength = (int)len;
        int i = 0;
        while ((long)i < len) {
            System.arraycopy(this.values, this.begin, ary2.values, i, this.realLength);
            i += this.realLength;
        }
        ary2.infectBy(this);
        return ary2;
    }

    private final Set makeSet(RubyArray ary2) {
        int begin;
        int i;
        HashSet<IRubyObject> set = new HashSet<IRubyObject>();
        for (i = begin = this.begin; i < begin + this.realLength; ++i) {
            set.add(this.values[i]);
        }
        if (ary2 != null) {
            for (i = begin = ary2.begin; i < begin + ary2.realLength; ++i) {
                set.add(ary2.values[i]);
            }
        }
        return set;
    }

    public IRubyObject uniq_bang() {
        Set set = this.makeSet(null);
        if (this.realLength == set.size()) {
            return this.getRuntime().getNil();
        }
        int j = 0;
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject v = this.elt(i);
            if (!set.remove(v)) continue;
            this.store(j++, v);
        }
        this.realLength = j;
        return this;
    }

    public IRubyObject uniq() {
        RubyArray ary = this.aryDup();
        ary.uniq_bang();
        return ary;
    }

    public IRubyObject op_diff(IRubyObject other) {
        int begin;
        Set set = other.convertToArray().makeSet(null);
        RubyArray ary3 = new RubyArray(this.getRuntime());
        for (int i = begin = this.begin; i < begin + this.realLength; ++i) {
            if (set.contains(this.values[i])) continue;
            ary3.append(this.elt(i - begin));
        }
        return ary3;
    }

    public IRubyObject op_and(IRubyObject other) {
        RubyArray ary2 = other.convertToArray();
        Set set = ary2.makeSet(null);
        RubyArray ary3 = new RubyArray(this.getRuntime(), this.realLength < ary2.realLength ? (long)this.realLength : (long)ary2.realLength);
        for (int i = 0; i < this.realLength; ++i) {
            IRubyObject v = this.elt(i);
            if (!set.remove(v)) continue;
            ary3.append(v);
        }
        return ary3;
    }

    public IRubyObject op_or(IRubyObject other) {
        IRubyObject v;
        int i;
        RubyArray ary2 = other.convertToArray();
        Set set = this.makeSet(ary2);
        RubyArray ary3 = new RubyArray(this.getRuntime(), this.realLength + ary2.realLength);
        for (i = 0; i < this.realLength; ++i) {
            v = this.elt(i);
            if (!set.remove(v)) continue;
            ary3.append(v);
        }
        for (i = 0; i < ary2.realLength; ++i) {
            v = ary2.elt(i);
            if (!set.remove(v)) continue;
            ary3.append(v);
        }
        return ary3;
    }

    public RubyArray sort(Block block) {
        RubyArray ary = this.aryDup();
        ary.sort_bang(block);
        return ary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyArray sort_bang(Block block) {
        this.modify();
        if (this.realLength > 1) {
            this.tmpLock = true;
            try {
                if (block.isGiven()) {
                    Arrays.sort(this.values, 0, this.realLength, new BlockComparator(block));
                } else {
                    Arrays.sort(this.values, 0, this.realLength, new DefaultComparator());
                }
            }
            finally {
                this.tmpLock = false;
            }
        }
        return this;
    }

    public static void marshalTo(RubyArray array, MarshalStream output) throws IOException {
        output.writeInt(array.getList().size());
        Iterator iter = array.getList().iterator();
        while (iter.hasNext()) {
            output.dumpObject((IRubyObject)iter.next());
        }
    }

    public static RubyArray unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyArray result = input.getRuntime().newArray();
        input.registerLinkTarget(result);
        int size = input.unmarshalInt();
        for (int i = 0; i < size; ++i) {
            result.append(input.unmarshalObject());
        }
        return result;
    }

    public RubyString pack(IRubyObject obj) {
        RubyString iFmt = RubyString.objAsString(obj);
        return Pack.pack(this.getRuntime(), this, iFmt.getByteList());
    }

    public Class getJavaClass() {
        return List.class;
    }

    public int size() {
        return this.realLength;
    }

    public boolean isEmpty() {
        return this.realLength == 0;
    }

    public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    public Object[] toArray() {
        Object[] array = new Object[this.realLength];
        for (int i = this.begin; i < this.realLength; ++i) {
            array[i - this.begin] = JavaUtil.convertRubyToJava(this.values[i]);
        }
        return array;
    }

    public Object[] toArray(Object[] arg) {
        Object[] array = arg;
        if (array.length < this.realLength) {
            Class<?> type = array.getClass().getComponentType();
            array = (Object[])Array.newInstance(type, this.realLength);
        }
        int length = this.realLength - this.begin;
        for (int i = 0; i < length; ++i) {
            array[i] = JavaUtil.convertRubyToJava(this.values[i + this.begin]);
        }
        return array;
    }

    public boolean add(Object element) {
        this.append(JavaUtil.convertJavaToRuby(this.getRuntime(), element));
        return true;
    }

    public boolean remove(Object element) {
        IRubyObject deleted = this.delete(JavaUtil.convertJavaToRuby(this.getRuntime(), element), Block.NULL_BLOCK);
        return !deleted.isNil();
    }

    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.indexOf(iter.next()) != -1) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return !c.isEmpty();
    }

    public boolean addAll(int index, Collection c) {
        Iterator iter = c.iterator();
        int i = index;
        while (iter.hasNext()) {
            this.add(i, iter.next());
            ++i;
        }
        return !c.isEmpty();
    }

    public boolean removeAll(Collection c) {
        boolean listChanged = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            listChanged = true;
        }
        return listChanged;
    }

    public boolean retainAll(Collection c) {
        boolean listChanged = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (c.contains(element)) continue;
            this.remove(element);
            listChanged = true;
        }
        return listChanged;
    }

    public Object get(int index) {
        return JavaUtil.convertRubyToJava(this.elt(index), Object.class);
    }

    public Object set(int index, Object element) {
        return this.store(index, JavaUtil.convertJavaToRuby(this.getRuntime(), element));
    }

    public void add(int index, Object element) {
        this.insert(new IRubyObject[]{RubyFixnum.newFixnum(this.getRuntime(), index), JavaUtil.convertJavaToRuby(this.getRuntime(), element)});
    }

    public Object remove(int index) {
        return JavaUtil.convertRubyToJava(this.delete_at(index), Object.class);
    }

    public int indexOf(Object element) {
        int begin = this.begin;
        if (element == null) {
            for (int i = begin; i < begin + this.realLength; ++i) {
                if (this.values[i] != null) continue;
                return i;
            }
        } else {
            IRubyObject convertedElement = JavaUtil.convertJavaToRuby(this.getRuntime(), element);
            for (int i = begin; i < begin + this.realLength; ++i) {
                if (!convertedElement.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int lastIndexOf(Object element) {
        int begin = this.begin;
        if (element == null) {
            for (int i = begin + this.realLength - 1; i >= begin; --i) {
                if (this.values[i] != null) continue;
                return i;
            }
        } else {
            IRubyObject convertedElement = JavaUtil.convertJavaToRuby(this.getRuntime(), element);
            for (int i = begin + this.realLength - 1; i >= begin; --i) {
                if (!convertedElement.equals(this.values[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public Iterator iterator() {
        return new RubyArrayConversionIterator();
    }

    public ListIterator listIterator() {
        return new RubyArrayConversionListIterator();
    }

    public ListIterator listIterator(int index) {
        return new RubyArrayConversionListIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        IRubyObject subList = this.subseq(fromIndex, toIndex - fromIndex + 1);
        return subList.isNil() ? null : (List)((Object)subList);
    }

    public void clear() {
        this.rb_clear();
    }

    final class RubyArrayConversionListIterator
    extends RubyArrayConversionIterator
    implements ListIterator {
        public RubyArrayConversionListIterator() {
        }

        public RubyArrayConversionListIterator(int index) {
            this.index = index;
        }

        public boolean hasPrevious() {
            return this.index >= 0;
        }

        public Object previous() {
            this.last = --this.index;
            return JavaUtil.convertRubyToJava(RubyArray.this.elt(this.index), class$java$lang$Object == null ? (class$java$lang$Object = RubyArray.class$("java.lang.Object")) : class$java$lang$Object);
        }

        public int nextIndex() {
            return this.index;
        }

        public int previousIndex() {
            return this.index - 1;
        }

        public void set(Object obj) {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.store(this.last, JavaUtil.convertJavaToRuby(RubyArray.this.getRuntime(), obj));
        }

        public void add(Object obj) {
            RubyArray.this.insert(new IRubyObject[]{RubyFixnum.newFixnum(RubyArray.this.getRuntime(), this.index++), JavaUtil.convertJavaToRuby(RubyArray.this.getRuntime(), obj)});
            this.last = -1;
        }
    }

    public class RubyArrayConversionIterator
    implements Iterator {
        protected int index = 0;
        protected int last = -1;

        public boolean hasNext() {
            return this.index < RubyArray.this.realLength;
        }

        public Object next() {
            IRubyObject element = RubyArray.this.elt(this.index);
            this.last = this.index++;
            return JavaUtil.convertRubyToJava(element, class$java$lang$Object == null ? (class$java$lang$Object = RubyArray.class$("java.lang.Object")) : class$java$lang$Object);
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            RubyArray.this.delete_at(this.last);
            if (this.last < this.index) {
                --this.index;
            }
            this.last = -1;
        }
    }

    final class DefaultComparator
    implements Comparator {
        DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof RubyFixnum && o2 instanceof RubyFixnum) {
                long b;
                long a = ((RubyFixnum)o1).getLongValue();
                if (a > (b = ((RubyFixnum)o2).getLongValue())) {
                    return 1;
                }
                if (a < b) {
                    return -1;
                }
                return 0;
            }
            if (o1 instanceof RubyString && o2 instanceof RubyString) {
                return ((RubyString)o1).cmp((RubyString)o2);
            }
            IRubyObject obj1 = (IRubyObject)o1;
            IRubyObject obj2 = (IRubyObject)o2;
            IRubyObject ret = obj1.callMethod(obj1.getRuntime().getCurrentContext(), 27, "<=>", obj2);
            int n = RubyComparable.cmpint(ret, obj1, obj2);
            return n;
        }
    }

    final class BlockComparator
    implements Comparator {
        private Block block;

        public BlockComparator(Block block) {
            this.block = block;
        }

        public int compare(Object o1, Object o2) {
            ThreadContext context = RubyArray.this.getRuntime().getCurrentContext();
            IRubyObject obj1 = (IRubyObject)o1;
            IRubyObject obj2 = (IRubyObject)o2;
            IRubyObject ret = this.block.yield(context, RubyArray.this.getRuntime().newArray(obj1, obj2), null, null, true);
            int n = RubyComparable.cmpint(ret, obj1, obj2);
            return n;
        }
    }
}

