/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class ObjectMetaClass
extends AbstractMetaClass {
    public static ObjectAllocator OBJECT_ALLOCATOR;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ObjectMetaClass(Ruby runtime) {
        super(runtime, null, null, OBJECT_ALLOCATOR, null, "Object");
        this.builtinClass = RubyObject.class;
        this.index = 14;
    }

    protected ObjectMetaClass(Ruby runtime, RubyClass metaClass, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef, String name, Class builtinClass) {
        super(runtime, metaClass, superClass, allocator, parentCRef, name);
        this.builtinClass = builtinClass;
    }

    protected ObjectMetaClass(String name, Class builtinClass, RubyClass superClass, ObjectAllocator allocator) {
        this(name, builtinClass, superClass, allocator, superClass.getRuntime().getClass("Object").getCRef());
    }

    protected ObjectMetaClass(String name, Class builtinClass, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef) {
        super(superClass.getRuntime(), superClass.getRuntime().getClass("Class"), superClass, allocator, parentCRef, name);
        if (!$assertionsDisabled && builtinClass == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && superClass == null) {
            throw new AssertionError();
        }
        this.builtinClass = builtinClass;
        this.makeMetaClass(superClass.getMetaClass(), this.getCRef());
        this.inheritedBy(superClass);
        if (name != null) {
            ((RubyModule)parentCRef.getValue()).setConstant(name, this);
        }
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new ObjectMeta();
    }

    public void initializeClass() {
        this.getMeta().initializeClass();
    }

    static {
        $assertionsDisabled = !ObjectMetaClass.class.desiredAssertionStatus();
        OBJECT_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                RubyObject instance = new RubyObject(runtime, klass);
                instance.setMetaClass(klass);
                return instance;
            }
        };
    }

    protected class ObjectMeta
    extends AbstractMetaClass.Meta {
        protected ObjectMeta() {
        }

        protected void initializeClass() {
            ObjectMetaClass.this.definePrivateMethod("initialize", Arity.optional());
            ObjectMetaClass.this.definePrivateMethod("inherited", Arity.singleArgument());
            ObjectMetaClass.this.defineFastMethod("initialize_copy", Arity.singleArgument());
        }
    }
}

