/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class ModuleMetaClass
extends ObjectMetaClass {
    private static ObjectAllocator MODULE_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return RubyModule.newModule(runtime, klass, null);
        }
    };

    public ModuleMetaClass(Ruby runtime, RubyClass superClass) {
        super(runtime, null, superClass, MODULE_ALLOCATOR, runtime.getObject().getCRef(), "Module", RubyModule.class);
        this.index = 12;
    }

    private ModuleMetaClass(String name, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef) {
        super(name, RubyModule.class, superClass, allocator, parentCRef);
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new ModuleMeta();
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new ModuleMetaClass(name, (RubyClass)this, MODULE_ALLOCATOR, parentCRef);
    }

    protected void defineModuleFunction(String name, Arity arity) {
        this.definePrivateMethod(name, arity);
        this.defineSingletonMethod(name, arity);
    }

    protected void defineModuleFunction(String name, Arity arity, String javaName) {
        this.definePrivateMethod(name, arity, javaName);
        this.defineSingletonMethod(name, arity, javaName);
    }

    public RubyArray nesting(Block block) {
        Ruby runtime = this.getRuntime();
        RubyClass object = runtime.getObject();
        SinglyLinkedList base = runtime.getCurrentContext().peekCRef();
        RubyArray result = runtime.newArray();
        SinglyLinkedList current = base;
        while (current.getValue() != object) {
            result.append((RubyModule)current.getValue());
            current = current.getNext();
        }
        return result;
    }

    protected class ModuleMeta
    extends AbstractMetaClass.Meta {
        protected ModuleMeta() {
        }

        public void initializeClass() {
            ModuleMetaClass.this.defineFastMethod("===", Arity.singleArgument(), "op_eqq");
            ModuleMetaClass.this.defineFastMethod("<=>", Arity.singleArgument(), "op_cmp");
            ModuleMetaClass.this.defineFastMethod("<", Arity.singleArgument(), "op_lt");
            ModuleMetaClass.this.defineFastMethod("<=", Arity.singleArgument(), "op_le");
            ModuleMetaClass.this.defineFastMethod(">", Arity.singleArgument(), "op_gt");
            ModuleMetaClass.this.defineFastMethod(">=", Arity.singleArgument(), "op_ge");
            ModuleMetaClass.this.defineFastMethod("ancestors", Arity.noArguments());
            ModuleMetaClass.this.defineFastMethod("class_variables", Arity.noArguments());
            ModuleMetaClass.this.defineFastMethod("const_defined?", Arity.singleArgument(), "const_defined");
            ModuleMetaClass.this.defineFastMethod("const_get", Arity.singleArgument(), "const_get");
            ModuleMetaClass.this.defineMethod("const_missing", Arity.singleArgument());
            ModuleMetaClass.this.defineFastMethod("const_set", Arity.twoArguments());
            ModuleMetaClass.this.defineFastMethod("constants", Arity.noArguments());
            ModuleMetaClass.this.defineMethod("extended", Arity.singleArgument());
            ModuleMetaClass.this.defineFastMethod("included", Arity.singleArgument());
            ModuleMetaClass.this.defineFastMethod("included_modules", Arity.noArguments());
            ModuleMetaClass.this.defineMethod("initialize", Arity.optional());
            ModuleMetaClass.this.defineFastMethod("initialize_copy", Arity.singleArgument());
            ModuleMetaClass.this.defineFastMethod("instance_method", Arity.singleArgument());
            ModuleMetaClass.this.defineFastMethod("instance_methods", Arity.optional());
            ModuleMetaClass.this.defineFastMethod("method_defined?", Arity.singleArgument(), "method_defined");
            ModuleMetaClass.this.defineMethod("module_eval", Arity.optional());
            ModuleMetaClass.this.defineFastMethod("name", Arity.noArguments());
            ModuleMetaClass.this.defineFastMethod("private_class_method", Arity.optional());
            ModuleMetaClass.this.defineFastMethod("private_instance_methods", Arity.optional());
            ModuleMetaClass.this.defineFastMethod("protected_instance_methods", Arity.optional());
            ModuleMetaClass.this.defineFastMethod("public_class_method", Arity.optional());
            ModuleMetaClass.this.defineFastMethod("public_instance_methods", Arity.optional());
            ModuleMetaClass.this.defineFastMethod("to_s", Arity.noArguments());
            ModuleMetaClass.this.defineAlias("class_eval", "module_eval");
            ModuleMetaClass.this.defineFastPrivateMethod("alias_method", Arity.twoArguments());
            ModuleMetaClass.this.defineFastPrivateMethod("append_features", Arity.singleArgument());
            ModuleMetaClass.this.defineFastPrivateMethod("attr", Arity.optional());
            ModuleMetaClass.this.defineFastPrivateMethod("attr_reader", Arity.optional());
            ModuleMetaClass.this.defineFastPrivateMethod("attr_writer", Arity.optional());
            ModuleMetaClass.this.defineFastPrivateMethod("attr_accessor", Arity.optional());
            ModuleMetaClass.this.definePrivateMethod("define_method", Arity.optional());
            ModuleMetaClass.this.defineFastPrivateMethod("extend_object", Arity.singleArgument());
            ModuleMetaClass.this.defineFastPrivateMethod("include", Arity.optional());
            ModuleMetaClass.this.definePrivateMethod("method_added", Arity.singleArgument());
            ModuleMetaClass.this.definePrivateMethod("method_removed", Arity.singleArgument());
            ModuleMetaClass.this.definePrivateMethod("method_undefined", Arity.singleArgument());
            ModuleMetaClass.this.defineFastPrivateMethod("module_function", Arity.optional());
            ModuleMetaClass.this.defineFastPrivateMethod("public", Arity.optional(), "rbPublic");
            ModuleMetaClass.this.defineFastPrivateMethod("protected", Arity.optional(), "rbProtected");
            ModuleMetaClass.this.defineFastPrivateMethod("private", Arity.optional(), "rbPrivate");
            ModuleMetaClass.this.defineFastPrivateMethod("remove_class_variable", Arity.singleArgument());
            ModuleMetaClass.this.defineFastPrivateMethod("remove_const", Arity.singleArgument());
            ModuleMetaClass.this.defineFastPrivateMethod("remove_method", Arity.optional());
            ModuleMetaClass.this.defineFastPrivateMethod("undef_method", Arity.singleArgument());
            ModuleMetaClass.this.defineSingletonMethod("nesting", Arity.noArguments());
        }
    }
}

