/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class FullInvocationMethod
extends DynamicMethod
implements Cloneable {
    private Arity arity;

    public FullInvocationMethod(RubyModule implementationClass, Arity arity, Visibility visibility) {
        super(implementationClass, visibility);
        this.arity = arity;
    }

    public void preMethod(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        context.preReflectedMethodInternalCall(this.implementationClass, klazz, self, name, args, noSuper, block);
    }

    public void postMethod(ThreadContext context) {
        context.postReflectedMethodInternalCall();
    }

    private IRubyObject wrap(Ruby runtime, IRubyObject self, IRubyObject[] args, Block block) {
        try {
            return this.call(self, args, block);
        }
        catch (RaiseException e) {
            throw e;
        }
        catch (JumpException e) {
            throw e;
        }
        catch (ThreadKill e) {
            throw e;
        }
        catch (MainExitException e) {
            throw e;
        }
        catch (Exception e) {
            runtime.getJavaSupport().handleNativeException(e);
            return runtime.getNil();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject internalCall(ThreadContext context, RubyModule klazz, IRubyObject self, String name, IRubyObject[] args, boolean noSuper, Block block) {
        Ruby runtime = context.getRuntime();
        this.arity.checkArity(runtime, args);
        if (runtime.getTraceFunction() != null) {
            ISourcePosition position = context.getPosition();
            runtime.callTraceFunction(context, "c-call", position, self, name, this.getImplementationClass());
            try {
                IRubyObject iRubyObject = this.wrap(runtime, self, args, block);
                return iRubyObject;
            }
            finally {
                runtime.callTraceFunction(context, "c-return", position, self, name, this.getImplementationClass());
            }
        }
        return this.wrap(runtime, self, args, block);
    }

    public abstract IRubyObject call(IRubyObject var1, IRubyObject[] var2, Block var3);

    public DynamicMethod dup() {
        try {
            return (FullInvocationMethod)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Arity getArity() {
        return this.arity;
    }
}

