/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

public class AtomicSpinlock {
    private volatile int counter;

    public AtomicSpinlock() {
        this.counter = 0;
    }

    public AtomicSpinlock(int start) {
        this.counter = start;
    }

    public synchronized void increment() {
        ++this.counter;
        this.notify();
    }

    public synchronized void decrement() {
        --this.counter;
        this.notify();
    }

    public synchronized void waitForZero(long timeout) throws InterruptedException {
        while (this.counter > 0) {
            this.timeWait(timeout);
        }
    }

    public synchronized void waitForValue(long timeout, int value) throws InterruptedException {
        while (this.counter != value) {
            this.timeWait(timeout);
        }
    }

    private void timeWait(long timeout) throws InterruptedException {
        if (timeout > 0L) {
            this.wait(timeout);
        } else {
            this.wait();
        }
    }
}

