/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.FileMetaClass;
import org.jruby.util.IOHandler;
import org.jruby.util.IOHandlerNull;
import org.jruby.util.IOHandlerSeekable;
import org.jruby.util.IOHandlerUnseekable;
import org.jruby.util.IOModes;
import org.jruby.util.JRubyFile;

public class RubyFile
extends RubyIO {
    public static final int LOCK_SH = 1;
    public static final int LOCK_EX = 2;
    public static final int LOCK_NB = 4;
    public static final int LOCK_UN = 8;
    protected String path;
    private FileLock currentLock;

    public RubyFile(Ruby runtime, RubyClass type) {
        super(runtime, type);
    }

    public RubyFile(Ruby runtime, String path) {
        this(runtime, path, RubyFile.open(runtime, path));
    }

    private static InputStream open(Ruby runtime, String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    public RubyFile(Ruby runtime, String path, final Reader reader) {
        this(runtime, path, new InputStream(){

            public int read() throws IOException {
                return reader.read();
            }
        });
    }

    private RubyFile(Ruby runtime, String path, InputStream in) {
        super(runtime, runtime.getClass("File"));
        this.path = path;
        try {
            this.handler = new IOHandlerUnseekable(runtime, in, null);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
        this.modes = this.handler.getModes();
        this.registerIOHandler(this.handler);
    }

    public void openInternal(String newPath, IOModes newModes) {
        this.path = newPath;
        this.modes = newModes;
        try {
            this.handler = newPath.equals("/dev/null") ? new IOHandlerNull(this.getRuntime(), newModes) : new IOHandlerSeekable(this.getRuntime(), newPath, newModes);
            this.registerIOHandler(this.handler);
        }
        catch (IOHandler.InvalidValueException e) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        catch (FileNotFoundException e) {
            throw this.getRuntime().newErrnoENOENTError();
        }
        catch (IOException e) {
            throw this.getRuntime().newIOError(e.getMessage());
        }
    }

    public IRubyObject close() {
        if (this.currentLock != null) {
            try {
                this.currentLock.release();
            }
            catch (IOException e) {
                throw this.getRuntime().newIOError(e.getMessage());
            }
        }
        return super.close();
    }

    public IRubyObject flock(IRubyObject lockingConstant) {
        FileChannel fileChannel = this.handler.getFileChannel();
        int lockMode = (int)((RubyFixnum)lockingConstant.convertToType("Fixnum", "to_int", true)).getLongValue();
        try {
            switch (lockMode) {
                case 8: {
                    if (this.currentLock == null) break;
                    this.currentLock.release();
                    this.currentLock = null;
                    return this.getRuntime().newFixnum(0L);
                }
                case 2: 
                case 6: {
                    if (this.currentLock != null) {
                        this.currentLock.release();
                        this.currentLock = null;
                    }
                    this.currentLock = fileChannel.tryLock();
                    if (this.currentLock == null) break;
                    return this.getRuntime().newFixnum(0L);
                }
                case 1: 
                case 5: {
                    if (this.currentLock != null) {
                        this.currentLock.release();
                        this.currentLock = null;
                    }
                    this.currentLock = fileChannel.tryLock(0L, Long.MAX_VALUE, true);
                    if (this.currentLock == null) break;
                    return this.getRuntime().newFixnum(0L);
                }
            }
        }
        catch (IOException ioe) {
            throw new RaiseException(new NativeException(this.getRuntime(), this.getRuntime().getClass("IOError"), ioe));
        }
        return this.getRuntime().getFalse();
    }

    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (args.length == 0) {
            throw this.getRuntime().newArgumentError(0, 1);
        }
        args[0].checkSafeString();
        this.path = args[0].toString();
        IOModes iOModes = this.modes = args.length > 1 ? this.getModes(args[1]) : new IOModes(this.getRuntime(), 0L);
        if (this.handler != null) {
            this.close();
        }
        this.openInternal(this.path, this.modes);
        if (block.isGiven()) {
            // empty if block
        }
        return this;
    }

    public IRubyObject chmod(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, 1);
        RubyInteger mode = args[0].convertToInteger();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        try {
            Process chown = Runtime.getRuntime().exec("chmod " + FileMetaClass.OCTAL_FORMATTER.sprintf(mode.getLongValue()) + " " + this.path);
            chown.waitFor();
        }
        catch (IOException ioe) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getRuntime().newFixnum(0L);
    }

    public IRubyObject chown(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, 1);
        RubyInteger owner = args[0].convertToInteger();
        if (!new File(this.path).exists()) {
            throw this.getRuntime().newErrnoENOENTError("No such file or directory - " + this.path);
        }
        try {
            Process chown = Runtime.getRuntime().exec("chown " + owner + " " + this.path);
            chown.waitFor();
        }
        catch (IOException ioe) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.getRuntime().newFixnum(0L);
    }

    public IRubyObject ctime() {
        return this.getRuntime().newTime(JRubyFile.create(this.getRuntime().getCurrentDirectory(), this.path).getParentFile().lastModified());
    }

    public RubyString path() {
        return this.getRuntime().newString(this.path);
    }

    public IRubyObject stat() {
        return this.getRuntime().newRubyFileStat(this.path);
    }

    public IRubyObject truncate(IRubyObject arg) {
        RubyFixnum newLength = (RubyFixnum)arg.convertToType("Fixnum", "to_int", true);
        try {
            this.handler.truncate(newLength.getLongValue());
        }
        catch (IOHandler.PipeException e) {
            throw this.getRuntime().newErrnoESPIPEError();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    public String toString() {
        return "RubyFile(" + this.path + ", " + this.modes + ", " + fileno + ")";
    }

    private IOModes getModes(IRubyObject object) {
        if (object instanceof RubyString) {
            return new IOModes(this.getRuntime(), ((RubyString)object).toString());
        }
        if (object instanceof RubyFixnum) {
            return new IOModes(this.getRuntime(), ((RubyFixnum)object).getLongValue());
        }
        throw this.getRuntime().newTypeError("Invalid type for modes");
    }

    public IRubyObject inspect() {
        StringBuffer val = new StringBuffer();
        val.append("#<File:").append(this.path);
        if (!this.isOpen()) {
            val.append(" (closed)");
        }
        val.append(">");
        return this.getRuntime().newString(val.toString());
    }
}

