/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.cli;

import com.headius.options.Option;
import java.io.Console;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.RubyInstanceConfig;
import org.jruby.compiler.ClassLoaderMode;
import org.jruby.util.KCode;
import org.jruby.util.SafePropertyAccessor;
import org.jruby.util.cli.Category;
import org.jruby.util.collections.ClassValue;

public class Options {
    private static final List<Option> _loadedOptions;
    private static final boolean COLOR;
    public static final String IR_PRINT_PATTERN_NO_PATTERN_STRING = "<NO_PATTERN>";
    public static final Option<Boolean> PARSER_WARN_USELESSS_USE_OF;
    public static final Option<Boolean> PARSER_WARN_NOT_REACHED;
    public static final Option<Boolean> PARSER_WARN_LOCAL_SHADOWING;
    public static final Option<Boolean> PARSER_WARN_REGEX_CONDITION;
    public static final Option<Boolean> PARSER_WARN_ARGUMENT_PREFIX;
    public static final Option<Boolean> PARSER_WARN_AMBIGUOUS_ARGUMENTS;
    public static final Option<Boolean> PARSER_WARN_FLAGS_IGNORED;
    public static final Option<Boolean> PARSER_SUMMARY;
    public static final Option<RubyInstanceConfig.CompileMode> COMPILE_MODE;
    public static final Option<Boolean> COMPILE_DUMP;
    public static final Option<Boolean> COMPILE_INVOKEDYNAMIC;
    public static final Option<Boolean> COMPILE_CACHE_CLASSES;
    public static final Option<Boolean> COMPILE_CACHE_CLASSES_LOGGING;
    public static final Option<Integer> INVOKEDYNAMIC_MAXFAIL;
    public static final Option<Integer> INVOKEDYNAMIC_MAXPOLY;
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_BINDING;
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_CONSTANTS;
    public static final Option<Boolean> INVOKEDYNAMIC_LOG_GLOBALS;
    public static final Option<Boolean> INVOKEDYNAMIC_CLASS_VALUES;
    public static final Option<Integer> INVOKEDYNAMIC_GLOBAL_MAXFAIL;
    public static final Option<Boolean> INVOKEDYNAMIC_HANDLES;
    public static final Option<Boolean> INVOKEDYNAMIC_YIELD;
    public static final Option<Integer> JIT_THRESHOLD;
    public static final Option<Integer> JIT_MAX;
    public static final Option<Integer> JIT_MAXSIZE;
    public static final Option<Boolean> JIT_LOGGING;
    public static final Option<Boolean> JIT_LOGGING_VERBOSE;
    public static final Option<Integer> JIT_LOGEVERY;
    public static final Option<String> JIT_EXCLUDE;
    public static final Option<Boolean> JIT_BACKGROUND;
    public static final Option<Boolean> JIT_KERNEL;
    public static final Option<ClassLoaderMode> JIT_LOADER_MODE;
    public static final Option<Boolean> JIT_DEBUG;
    public static final Option<String> IR_DEBUG_IGV;
    public static final Option<Boolean> IR_DEBUG_IGV_STDOUT;
    public static final Option<Boolean> IR_DEBUG;
    public static final Option<Boolean> IR_PROFILE;
    public static final Option<Boolean> IR_COMPILER_DEBUG;
    public static final Option<Boolean> IR_VISUALIZER;
    public static final Option<Boolean> IR_UNBOXING;
    public static final Option<String> IR_COMPILER_PASSES;
    public static final Option<String> IR_JIT_PASSES;
    public static final Option<Boolean> IR_READING;
    public static final Option<Boolean> IR_READING_DEBUG;
    public static final Option<Boolean> IR_WRITING;
    public static final Option<Boolean> IR_INLINER;
    public static final Option<Integer> IR_INLINER_THRESHOLD;
    public static final Option<Boolean> IR_INLINER_VERBOSE;
    public static final Option<Boolean> IR_WRITING_DEBUG;
    public static final Option<Boolean> IR_PRINT_OPT;
    public static final Option<Boolean> IR_PRINT_ALL;
    public static final Option<Boolean> IR_PRINT;
    public static final Option<Boolean> IR_PRINT_COLOR;
    public static final Option<Boolean> IR_STRING_FREEZE;
    public static final Option<String> IR_PRINT_PATTERN;
    public static final Option<Boolean> NATIVE_ENABLED;
    public static final Option<Boolean> NATIVE_VERBOSE;
    public static final Option<Boolean> FFI_COMPILE_DUMP;
    public static final Option<Integer> FFI_COMPILE_THRESHOLD;
    public static final Option<Boolean> FFI_COMPILE_REIFY;
    public static final Option<Boolean> NATIVE_STDIO;
    public static final Option<Boolean> NATIVE_PTHREAD_KILL;
    public static final Option<Boolean> NATIVE_POPEN;
    public static final Option<Integer> THREADPOOL_MIN;
    public static final Option<Integer> THREADPOOL_MAX;
    public static final Option<Integer> THREADPOOL_TTL;
    public static final Option<Integer> FIBER_THREADPOOL_TTL;
    public static final Option<Boolean> FIBER_VTHREADS;
    public static final Option<Boolean> CLASSLOADER_DELEGATE;
    public static final Option<Boolean> OBJECTSPACE_ENABLED;
    public static final Option<Boolean> SIPHASH_ENABLED;
    public static final Option<Boolean> LAUNCH_INPROC;
    public static final Option<String> BYTECODE_VERSION;
    public static final Option<Boolean> MANAGEMENT_ENABLED;
    public static final Option<Boolean> JUMP_BACKTRACE;
    public static final Option<Boolean> PROCESS_NOUNWRAP;
    public static final Option<Boolean> REIFY_CLASSES;
    public static final Option<Boolean> REIFY_FFI;
    public static final Option<Boolean> REIFY_LOGERRORS;
    public static final Option<Boolean> BACKTRACE_COLOR;
    public static final Option<String> BACKTRACE_STYLE;
    public static final Option<Boolean> BACKTRACE_MASK;
    public static final Option<Boolean> NATIVE_EXEC;
    public static final Option<Boolean> CONSISTENT_HASHING;
    public static final Option<Boolean> VOLATILE_VARIABLES;
    public static final Option<Boolean> REIFY_VARIABLES;
    public static final Option<Integer> REIFY_VARIABLES_MAX;
    public static final Option<Boolean> REIFY_VARIABLES_NAME;
    public static final Option<String> PREFERRED_PRNG;
    public static final Option<Boolean> USE_FIXNUM_CACHE;
    public static final Option<Integer> FIXNUM_CACHE_RANGE;
    public static final Option<Boolean> PACKED_ARRAYS;
    public static final Option<Boolean> REGEXP_INTERRUPTIBLE;
    public static final Option<Integer> JAR_CACHE_EXPIRATION;
    public static final Option<String> WINDOWS_FILESYSTEM_ENCODING;
    public static final Option<String> GEM_HOME;
    public static final Option<String> GEM_PATH;
    public static final Option<Boolean> DEBUG_LOADSERVICE;
    public static final Option<Boolean> DEBUG_LOADSERVICE_TIMING;
    public static final Option<Boolean> DEBUG_LAUNCH;
    public static final Option<Boolean> DEBUG_FULLTRACE;
    public static final Option<Boolean> DEBUG_SCRIPTRESOLUTION;
    public static final Option<Boolean> DEBUG_PARSER;
    public static final Option<Boolean> ERRNO_BACKTRACE;
    public static final Option<Boolean> STOPITERATION_BACKTRACE;
    public static final Option<Boolean> LOG_EXCEPTIONS;
    public static final Option<Boolean> LOG_BACKTRACES;
    public static final Option<Boolean> LOG_CALLERS;
    public static final Option<Boolean> LOG_WARNINGS;
    public static final Option<Boolean> LOG_SINGLETONS;
    public static final Option<Boolean> LOG_SINGLETONS_VERBOSE;
    public static final Option<String> LOGGER_CLASS;
    public static final Option<Boolean> DUMP_INSTANCE_VARS;
    public static final Option<Boolean> REWRITE_JAVA_TRACE;
    public static final Option<Boolean> PARSER_PRISM;
    public static final Option<Boolean> PARSER_WASM;
    public static final Option<Boolean> JI_SETACCESSIBLE;
    public static final Option<Boolean> JI_UPPER_CASE_PACKAGE_NAME_ALLOWED;
    public static final Option<Boolean> INTERFACES_USEPROXY;
    public static final Option<Boolean> JI_NEWSTYLEEXTENSION;
    public static final Option<Boolean> JI_OBJECTPROXYCACHE;
    public static final Option<String> JI_PROXYCLASSFACTORY;
    public static final Option<Boolean> JI_AMBIGUOUS_CALLS_DEBUG;
    public static final Option<Boolean> AOT_LOADCLASSES;
    public static final Option<Boolean> JI_LOAD_LAZY;
    public static final Option<Boolean> JI_CLOSE_CLASSLOADER;
    public static final Option<String> JI_NESTED_JAR_TMPDIR;
    public static final Option<ClassValue.Type> JI_CLASS_VALUES;
    public static final Option<Integer> PROFILE_MAX_METHODS;
    public static final Option<Boolean> FIBER_SCHEDULER;
    public static final Option<Boolean> CLI_AUTOSPLIT;
    public static final Option<Boolean> CLI_DEBUG;
    public static final Option<Boolean> CLI_PROCESS_LINE_ENDS;
    public static final Option<Boolean> CLI_ASSUME_LOOP;
    public static final Option<Boolean> CLI_ASSUME_PRINT;
    public static final Option<Boolean> CLI_VERBOSE;
    public static final Option<RubyInstanceConfig.Verbosity> CLI_WARNING_LEVEL;
    public static final Option<Boolean> CLI_PARSER_DEBUG;
    public static final Option<Boolean> CLI_VERSION;
    public static final Option<Boolean> CLI_BYTECODE;
    public static final Option<Boolean> CLI_COPYRIGHT;
    public static final Option<Integer> CLI_BACKTRACE_LIMIT;
    public static final Option<Boolean> CLI_CHECK_SYNTAX;
    public static final Option<String> CLI_AUTOSPLIT_SEPARATOR;
    public static final Option<KCode> CLI_KCODE;
    public static final Option<Boolean> CLI_HELP;
    public static final Option<Boolean> CLI_PROPERTIES;
    public static final Option<String> CLI_ENCODING_INTERNAL;
    public static final Option<String> CLI_ENCODING_EXTERNAL;
    public static final Option<String> CLI_ENCODING_SOURCE;
    public static final Option<String> CLI_RECORD_SEPARATOR;
    public static final Option<String> CLI_BACKUP_EXTENSION;
    public static final Option<RubyInstanceConfig.ProfilingMode> CLI_PROFILING_MODE;
    public static final Option<String> CLI_PROFILING_SERVICE;
    public static final Option<Boolean> CLI_RUBYGEMS_ENABLE;
    public static final Option<Boolean> CLI_DID_YOU_MEAN_ENABLE;
    public static final Option<Boolean> CLI_ERROR_HIGHLIGHT_ENABLE;
    public static final Option<Boolean> CLI_SYNTAX_SUGGEST_ENABLE;
    public static final Option<Boolean> CLI_RUBYOPT_ENABLE;
    public static final Option<Boolean> CLI_STRIP_HEADER;
    public static final Option<Boolean> CLI_LOAD_GEMFILE;
    public static final Collection<Option> PROPERTIES;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> PARSER_WARN_GROUPED_EXPRESSIONS;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> COMPILE_FASTOPS;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> COMPILE_THREADLESS;
    @Deprecated(since="9.3.0.0")
    public static final Option<Integer> COMPILE_CHAINSIZE;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> COMPILE_PEEPHOLE;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> COMPILE_NOGUARDS;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> COMPILE_FASTEST;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> COMPILE_FASTSEND;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> COMPILE_FASTMASGN;
    @Deprecated(since="9.3.0.0")
    public static final Option<Integer> COMPILE_OUTLINE_CASECOUNT;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_SAFE;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_INDIRECT;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_JAVA;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_ATTR;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_FFI;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_INVOCATION_FASTOPS;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_CONSTANTS;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_LITERALS;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> INVOKEDYNAMIC_CACHE_IVARS;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> JIT_CACHE;
    public static final Option<Boolean> INVOKEDYNAMIC_ALL;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> JIT_DUMPING;
    @Deprecated(since="9.3.0.0")
    public static final Option<String> IR_INLINE_COMPILER_PASSES;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> FFI_COMPILE_INVOKEDYNAMIC;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> NATIVE_NET_PROTOCOL;
    @Deprecated(since="9.3.0.0")
    public static final Option<String> THREAD_DUMP_SIGNAL;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> FIBER_COROUTINES;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> GLOBAL_REQUIRE_LOCK;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> REFLECTED_HANDLES;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> ENUMERATOR_LIGHTWEIGHT;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> FCNTL_LOCKING;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> RECORD_LEXICAL_HIERARCHY;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> JI_LOGCANSETACCESSIBLE;
    @Deprecated(since="9.3.0.0")
    public static final Option<Boolean> JAVA_HANDLES;
    @Deprecated(since="10.0.0.0")
    public static final Option<Boolean> NAME_ERROR_INSPECT_OBJECT;

    public static String dump() {
        return "# JRuby configuration options with current values\n" + Option.formatValues(_loadedOptions);
    }

    private static Option<String> string(Category category, String name2, String[] options2, String defval, String description) {
        Option option = Option.string((String)"jruby", (String)name2, (Enum)category, (String[])options2, (String)defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String defval, String description) {
        Option option = Option.string((String)"jruby", (String)name2, (Enum)category, (String)defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String[] options2, String description) {
        Option option = Option.string((String)"jruby", (String)name2, (Enum)category, (String[])options2, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<String> string(Category category, String name2, String description) {
        Option option = Option.string((String)"jruby", (String)name2, (Enum)category, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Boolean> bool(Category category, String name2, Boolean defval, String description) {
        Option option = Option.bool((String)"jruby", (String)name2, (Enum)category, (Boolean)defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static Option<Integer> integer(Category category, String name2, Integer defval, String description) {
        Option option = Option.integer((String)"jruby", (String)name2, (Enum)category, (Integer)defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static <T extends Enum<T>> Option<T> enumeration(Category category, String name2, Class<T> enumClass, T defval, String description) {
        Option option = defval == null ? Option.enumeration((String)"jruby", (String)name2, (Enum)category, enumClass, (String)description) : Option.enumeration((String)"jruby", (String)name2, (Enum)category, defval, (String)description);
        _loadedOptions.add(option);
        return option;
    }

    private static RubyInstanceConfig.Verbosity calculateVerbosityDefault() {
        Boolean verbose = (Boolean)CLI_VERBOSE.load();
        if (verbose == null) {
            return RubyInstanceConfig.Verbosity.NIL;
        }
        return verbose != false ? RubyInstanceConfig.Verbosity.TRUE : RubyInstanceConfig.Verbosity.FALSE;
    }

    public static void listPrefix(String prefix) {
        Options.list(SearchMode.PREFIX, prefix);
    }

    public static void listContains(String substring) {
        Options.list(SearchMode.CONTAINS, substring);
    }

    private static void list(SearchMode mode2, String string2) {
        for (Option option : PROPERTIES) {
            boolean include2 = false;
            switch (mode2.ordinal()) {
                case 0: {
                    include2 = option.shortName().startsWith(string2);
                    break;
                }
                case 1: {
                    include2 = option.shortName().contains(string2);
                }
            }
            if (!include2) continue;
            System.out.printf("%s=%s\n", option.shortName(), option.load());
        }
    }

    public static Set<String> getPropertyNames() {
        HashSet<String> propertyNames = new HashSet<String>(PROPERTIES.size() + 1, 1.0f);
        Options.addPropertyNames(propertyNames);
        return Collections.unmodifiableSet(propertyNames);
    }

    static void addPropertyNames(Set<String> propertyNames) {
        for (Option option : PROPERTIES) {
            propertyNames.add(option.propertyName());
        }
    }

    static {
        boolean isatty;
        _loadedOptions = new ArrayList<Option>(240);
        Console console = System.console();
        if (console == null) {
            isatty = false;
        } else if (Integer.parseInt(SafePropertyAccessor.getProperty("java.specification.version", "21")) <= 21) {
            isatty = true;
        } else {
            try {
                isatty = (Boolean)Console.class.getMethod("isTerminal", new Class[0]).invoke((Object)console, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                isatty = false;
            }
        }
        COLOR = isatty;
        PARSER_WARN_USELESSS_USE_OF = Options.bool(Category.PARSER, "parser.warn.useless_use_of", true, "Warn about potentially useless expressions in void contents.");
        PARSER_WARN_NOT_REACHED = Options.bool(Category.PARSER, "parser.warn.not_reached", true, "Warn about statements that can never be reached.");
        PARSER_WARN_LOCAL_SHADOWING = Options.bool(Category.PARSER, "parser.warn.shadowing_local", false, "Warn about shadowing local variables.");
        PARSER_WARN_REGEX_CONDITION = Options.bool(Category.PARSER, "parser.warn.regex_condition", true, "Warn about regex literals in conditions.");
        PARSER_WARN_ARGUMENT_PREFIX = Options.bool(Category.PARSER, "parser.warn.argument_prefix", true, "Warn about splat operators being interpreted as argument prefixes.");
        PARSER_WARN_AMBIGUOUS_ARGUMENTS = Options.bool(Category.PARSER, "parser.warn.ambiguous_argument", true, "Warn about ambiguous arguments.");
        PARSER_WARN_FLAGS_IGNORED = Options.bool(Category.PARSER, "parser.warn.flags_ignored", true, "Warn about ignored regex flags being ignored.");
        PARSER_SUMMARY = Options.bool(Category.PARSER, "parser.summary", false, "print out summary of parsing activities");
        COMPILE_MODE = Options.enumeration(Category.COMPILER, "compile.mode", RubyInstanceConfig.CompileMode.class, RubyInstanceConfig.CompileMode.JIT, "Set compilation mode. JIT = at runtime; FORCE = before execution.");
        COMPILE_DUMP = Options.bool(Category.COMPILER, "compile.dump", false, "Dump to console all bytecode generated at runtime.");
        COMPILE_INVOKEDYNAMIC = Options.bool(Category.COMPILER, "compile.invokedynamic", true, "Use invokedynamic for optimizing Ruby code.");
        COMPILE_CACHE_CLASSES = Options.bool(Category.COMPILER, "compile.cache.classes", false, "Use cache of compiled script classes");
        COMPILE_CACHE_CLASSES_LOGGING = Options.bool(Category.COMPILER, "compile.cache.classes.logging", false, "Log whether cached script classes are being saved or used");
        INVOKEDYNAMIC_MAXFAIL = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxfail", 1000, "Maximum call site failures after which to inline cache.");
        INVOKEDYNAMIC_MAXPOLY = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.maxpoly", 6, "Maximum polymorphism of PIC binding.");
        INVOKEDYNAMIC_LOG_BINDING = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.binding", false, "Log binding of invokedynamic call sites.");
        INVOKEDYNAMIC_LOG_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.constants", false, "Log invokedynamic-based constant lookups.");
        INVOKEDYNAMIC_LOG_GLOBALS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.log.globals", false, "Log invokedynamic-based global lookups.");
        INVOKEDYNAMIC_CLASS_VALUES = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.class.values", false, "Use ClassValue to store class-specific data.");
        INVOKEDYNAMIC_GLOBAL_MAXFAIL = Options.integer(Category.INVOKEDYNAMIC, "invokedynamic.global.maxfail", 100, "Maximum global cache failures after which to use slow path.");
        INVOKEDYNAMIC_HANDLES = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.handles", false, "Use MethodHandles rather than generated code to bind Ruby methods.");
        INVOKEDYNAMIC_YIELD = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.yield", true, "Bind yields directly using invokedynamic.");
        JIT_THRESHOLD = Options.integer(Category.JIT, "jit.threshold", 50, "Set the JIT threshold to the specified method invocation count.");
        JIT_MAX = Options.integer(Category.JIT, "jit.max", 10000, "Set the max count of active methods eligible for JIT-compilation.");
        JIT_MAXSIZE = Options.integer(Category.JIT, "jit.maxsize", 3000, "Set the max size (in IR instructions) for a method to be eligible to JIT.");
        JIT_LOGGING = Options.bool(Category.JIT, "jit.logging", false, "Enable JIT logging (reports successful compilation).");
        JIT_LOGGING_VERBOSE = Options.bool(Category.JIT, "jit.logging.verbose", false, "Enable verbose JIT logging (reports failed compilation).");
        JIT_LOGEVERY = Options.integer(Category.JIT, "jit.logEvery", 0, "Log a message every n methods JIT compiled.");
        JIT_EXCLUDE = Options.string(Category.JIT, "jit.exclude", "", "Exclude methods from JIT. <ModClsName or '-'>::<method_name>, comma-delimited.");
        JIT_BACKGROUND = Options.bool(Category.JIT, "jit.background", (Integer)JIT_THRESHOLD.load() != 0, "Run the JIT compiler in a background thread. Off if jit.threshold=0.");
        JIT_KERNEL = Options.bool(Category.JIT, "jit.kernel", false, "Run the JIT compiler while the pure-Ruby kernel is booting.");
        JIT_LOADER_MODE = Options.enumeration(Category.JIT, "jit.loader.mode", ClassLoaderMode.class, ClassLoaderMode.UNIQUE, "Set JIT class loader to use. UNIQUE class loader per class; SHARED loader for all classes");
        JIT_DEBUG = Options.bool(Category.JIT, "jit.debug", false, "Emit extra JIT information for debugging in JVM.");
        IR_DEBUG_IGV = Options.string(Category.IR, "ir.debug.igv", (String)null, "Specify file:line of scope to jump to IGV");
        IR_DEBUG_IGV_STDOUT = Options.bool(Category.IR, "ir.debug.igv.stdout", false, "Save IGV generated XML to stdout");
        IR_DEBUG = Options.bool(Category.IR, "ir.debug", false, "Debug generation of JRuby IR.");
        IR_PROFILE = Options.bool(Category.IR, "ir.profile", false, "[EXPT]: Profile IR code during interpretation.");
        IR_COMPILER_DEBUG = Options.bool(Category.IR, "ir.compiler.debug", false, "Debug compilation of JRuby IR.");
        IR_VISUALIZER = Options.bool(Category.IR, "ir.visualizer", false, "Visualization of JRuby IR.");
        IR_UNBOXING = Options.bool(Category.IR, "ir.unboxing", false, "Implement unboxing opts.");
        IR_COMPILER_PASSES = Options.string(Category.IR, "ir.passes", "Specify comma delimeted list of passes to run.");
        IR_JIT_PASSES = Options.string(Category.IR, "ir.jit.passes", "Specify comma delimeted list of passes to run before JIT.");
        IR_READING = Options.bool(Category.IR, "ir.reading", false, "Read JRuby IR file.");
        IR_READING_DEBUG = Options.bool(Category.IR, "ir.reading.debug", false, "Debug reading JRuby IR file.");
        IR_WRITING = Options.bool(Category.IR, "ir.writing", false, "Write JRuby IR file.");
        IR_INLINER = Options.bool(Category.IR, "ir.inliner", false, "Enable the inliner.");
        IR_INLINER_THRESHOLD = Options.integer(Category.IR, "ir.inliner.threshold", 20, "Enable the inliner.");
        IR_INLINER_VERBOSE = Options.bool(Category.IR, "ir.inliner.verbose", false, "Report inlining activity.");
        IR_WRITING_DEBUG = Options.bool(Category.IR, "ir.writing.debug", false, "Debug writing JRuby IR file.");
        IR_PRINT_OPT = Options.bool(Category.IR, "ir.print.opt", false, "Print the IR CFG before and after each optimization pass.");
        IR_PRINT_ALL = Options.bool(Category.IR, "ir.print.all", false, "Enable ir.print and include IR executed during JRuby's boot phase.");
        IR_PRINT = Options.bool(Category.IR, "ir.print", (Boolean)IR_PRINT_ALL.load(), "Print the final IR to be run before starting to execute each body of code.");
        IR_PRINT_COLOR = Options.bool(Category.IR, "ir.print.color", COLOR, "Print the final IR with color highlighting.");
        IR_STRING_FREEZE = Options.bool(Category.IR, "ir.string.freeze", true, "Compile \"foo\".freeze as a constant frozen string value instead of a call.");
        IR_PRINT_PATTERN = Options.string(Category.IR, "ir.print.pattern", IR_PRINT_PATTERN_NO_PATTERN_STRING, "A pattern to limit IR print output to specific scopes.");
        NATIVE_ENABLED = Options.bool(Category.NATIVE, "native.enabled", true, "Enable/disable native code, including POSIX features and C exts.");
        NATIVE_VERBOSE = Options.bool(Category.NATIVE, "native.verbose", false, "Enable verbose logging of native extension loading.");
        FFI_COMPILE_DUMP = Options.bool(Category.NATIVE, "ffi.compile.dump", false, "Dump bytecode-generated FFI stubs to console.");
        FFI_COMPILE_THRESHOLD = Options.integer(Category.NATIVE, "ffi.compile.threshold", 100, "Number of FFI invocations before generating a bytecode stub.");
        FFI_COMPILE_REIFY = Options.bool(Category.NATIVE, "ffi.compile.reify", false, "Reify FFI compiled classes.");
        NATIVE_STDIO = Options.bool(Category.NATIVE, "native.stdio", true, "Use native wrappers around the default stdio descriptors.");
        NATIVE_PTHREAD_KILL = Options.bool(Category.NATIVE, "native.pthread_kill", true, "Use pthread_kill to interrupt blocking kernel calls.");
        NATIVE_POPEN = Options.bool(Category.NATIVE, "native.popen", true, "Use native calls to posix_spawn for subprocess execution.");
        THREADPOOL_MIN = Options.integer(Category.THREADPOOL, "thread.pool.min", 0, "The minimum number of threads to keep alive in the pool.");
        THREADPOOL_MAX = Options.integer(Category.THREADPOOL, "thread.pool.max", Integer.MAX_VALUE, "The maximum number of threads to allow in the pool.");
        THREADPOOL_TTL = Options.integer(Category.THREADPOOL, "thread.pool.ttl", 60, "The maximum number of seconds to keep alive an idle thread.");
        FIBER_THREADPOOL_TTL = Options.integer(Category.THREADPOOL, "fiber.thread.pool.ttl", 60, "The maximum number of seconds to keep alive a pooled fiber thread.");
        FIBER_VTHREADS = Options.bool(Category.THREADPOOL, "fiber.vthread", true, "Use JDK virtual threads for Ruby Fibers.");
        CLASSLOADER_DELEGATE = Options.bool(Category.MISCELLANEOUS, "classloader.delegate", true, "In some cases of classloader conflicts it might help not to delegate first to the parent classloader but to load first from the jruby-classloader.");
        OBJECTSPACE_ENABLED = Options.bool(Category.MISCELLANEOUS, "objectspace.enabled", false, "Enable or disable ObjectSpace.each_object.");
        SIPHASH_ENABLED = Options.bool(Category.MISCELLANEOUS, "siphash.enabled", false, "Enable or disable SipHash for String hash function.");
        LAUNCH_INPROC = Options.bool(Category.MISCELLANEOUS, "launch.inproc", false, "Set in-process launching of e.g. system('ruby ...').");
        BYTECODE_VERSION = Options.string(Category.MISCELLANEOUS, "bytecode.version", SafePropertyAccessor.getProperty("java.specification.version", "21"), "Specify the major Java bytecode version.");
        MANAGEMENT_ENABLED = Options.bool(Category.MISCELLANEOUS, "management.enabled", false, "Set whether JMX management is enabled.");
        JUMP_BACKTRACE = Options.bool(Category.MISCELLANEOUS, "jump.backtrace", false, "Make non-local flow jumps generate backtraces.");
        PROCESS_NOUNWRAP = Options.bool(Category.MISCELLANEOUS, "process.noUnwrap", false, "Do not unwrap process streams (issue on some recent JVMs).");
        REIFY_CLASSES = Options.bool(Category.MISCELLANEOUS, "reify.classes", false, "Generate a real Java class and methods for every Ruby class.");
        REIFY_FFI = Options.bool(Category.MISCELLANEOUS, "reify.ffi", false, "Reify FFI memory structures.");
        REIFY_LOGERRORS = Options.bool(Category.MISCELLANEOUS, "reify.logErrors", false, "Log errors during reification (reify.classes=true).");
        BACKTRACE_COLOR = Options.bool(Category.MISCELLANEOUS, "backtrace.color", COLOR, "Enable colorized backtraces.");
        BACKTRACE_STYLE = Options.string(Category.MISCELLANEOUS, "backtrace.style", new String[]{"normal", "raw", "full", "mri"}, "normal", "Set the style of exception backtraces.");
        BACKTRACE_MASK = Options.bool(Category.MISCELLANEOUS, "backtrace.mask", false, "Mask .java lines in Ruby backtraces.");
        NATIVE_EXEC = Options.bool(Category.MISCELLANEOUS, "native.exec", true, "Do a true process-obliterating native exec for Kernel#exec.");
        CONSISTENT_HASHING = Options.bool(Category.MISCELLANEOUS, "consistent.hashing", false, "Generate consistent object hashes across JVMs");
        VOLATILE_VARIABLES = Options.bool(Category.MISCELLANEOUS, "volatile.variables", false, "Always ensure volatile semantics for instance variables.");
        REIFY_VARIABLES = Options.bool(Category.MISCELLANEOUS, "reify.variables", (Boolean)REIFY_CLASSES.load() == false && (Boolean)VOLATILE_VARIABLES.load() == false, "Expand instance vars into Java fields");
        REIFY_VARIABLES_MAX = Options.integer(Category.MISCELLANEOUS, "reify.variables.max", 50, "Maximum number of reified instance variable fields");
        REIFY_VARIABLES_NAME = Options.bool(Category.MISCELLANEOUS, "reify.variables.name", false, "Reify variables into a class named after the Ruby class");
        PREFERRED_PRNG = Options.string(Category.MISCELLANEOUS, "preferred.prng", "NativePRNGNonBlocking", "Set the preferred JDK-supported random number generator to use.");
        USE_FIXNUM_CACHE = Options.bool(Category.MISCELLANEOUS, "fixnum.cache", true, "Use a cache of low-valued Fixnum objects.");
        FIXNUM_CACHE_RANGE = Options.integer(Category.MISCELLANEOUS, "fixnum.cache.size", 256, "Values to retrieve from Fixnum cache, in the range -X..(X-1).");
        PACKED_ARRAYS = Options.bool(Category.MISCELLANEOUS, "packed.arrays", true, "Toggle whether to use \"packed\" arrays for small tuples.");
        REGEXP_INTERRUPTIBLE = Options.bool(Category.MISCELLANEOUS, "regexp.interruptible", true, "Allow regexp operations to be interruptible from Ruby.");
        JAR_CACHE_EXPIRATION = Options.integer(Category.MISCELLANEOUS, "jar.cache.expiration", 750, "The time (ms) between checks if a JAR file containing resources has been updated.");
        WINDOWS_FILESYSTEM_ENCODING = Options.string(Category.MISCELLANEOUS, "windows.filesystem.encoding", "UTF-8", "The encoding to use for filesystem names and paths on Windows.");
        GEM_HOME = Options.string(Category.MISCELLANEOUS, "gem.home", "The home dir where Ruby gems will be installed.");
        GEM_PATH = Options.string(Category.MISCELLANEOUS, "gem.path", "The path containing all dirs to search for installed Ruby gems.");
        DEBUG_LOADSERVICE = Options.bool(Category.DEBUG, "debug.loadService", false, "Log require/load file searches.");
        DEBUG_LOADSERVICE_TIMING = Options.bool(Category.DEBUG, "debug.loadService.timing", false, "Log require/load parse+evaluate times.");
        DEBUG_LAUNCH = Options.bool(Category.DEBUG, "debug.launch", false, "Log externally-launched processes.");
        DEBUG_FULLTRACE = Options.bool(Category.DEBUG, "debug.fullTrace", false, "Set whether full traces are enabled (c-call/c-return).");
        DEBUG_SCRIPTRESOLUTION = Options.bool(Category.DEBUG, "debug.scriptResolution", false, "Print which script is executed by '-S' flag.");
        DEBUG_PARSER = Options.bool(Category.DEBUG, "debug.parser", false, "disables JRuby impl script loads and prints parse exceptions");
        ERRNO_BACKTRACE = Options.bool(Category.DEBUG, "errno.backtrace", false, "Generate backtraces for heavily-used Errno exceptions (EAGAIN).");
        STOPITERATION_BACKTRACE = Options.bool(Category.DEBUG, "stop_iteration.backtrace", false, "Generate backtraces for heavily-used Errno exceptions (EAGAIN).");
        LOG_EXCEPTIONS = Options.bool(Category.DEBUG, "log.exceptions", false, "Log every time an exception is constructed.");
        LOG_BACKTRACES = Options.bool(Category.DEBUG, "log.backtraces", false, "Log every time an exception backtrace is generated.");
        LOG_CALLERS = Options.bool(Category.DEBUG, "log.callers", false, "Log every time a Kernel#caller backtrace is generated.");
        LOG_WARNINGS = Options.bool(Category.DEBUG, "log.warnings", false, "Log every time a built-in warning backtrace is generated.");
        LOG_SINGLETONS = Options.bool(Category.DEBUG, "log.singletons", false, "Log every time a singleton class is created.");
        LOG_SINGLETONS_VERBOSE = Options.bool(Category.DEBUG, "log.singletons.verbose", false, "Log a stack trace every time a singleton class is created.");
        LOGGER_CLASS = Options.string(Category.DEBUG, "logger.class", new String[]{"class name"}, "org.jruby.util.log.StandardErrorLogger", "Use specified class for logging.");
        DUMP_INSTANCE_VARS = Options.bool(Category.DEBUG, "dump.variables", false, "Dump class + instance var names on first new of Object subclasses.");
        REWRITE_JAVA_TRACE = Options.bool(Category.DEBUG, "rewrite.java.trace", true, "Rewrite stack traces from exceptions raised in Java calls.");
        PARSER_PRISM = Options.bool(Category.DEBUG, "parser.prism", false, "Parse and build Ruby using the prism parser.");
        PARSER_WASM = Options.bool(Category.DEBUG, "parser.prism.wasm", false, "Parse and build Ruby using the wasm prism parser.");
        JI_SETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.setAccessible", true, "Try to set inaccessible Java methods to be accessible.");
        JI_UPPER_CASE_PACKAGE_NAME_ALLOWED = Options.bool(Category.JAVA_INTEGRATION, "ji.upper.case.package.name.allowed", false, "Allow Capitalized Java package names.");
        INTERFACES_USEPROXY = Options.bool(Category.JAVA_INTEGRATION, "interfaces.useProxy", false, "Use java.lang.reflect.Proxy for interface impl.");
        JI_NEWSTYLEEXTENSION = Options.bool(Category.JAVA_INTEGRATION, "ji.newStyleExtension", false, "Extend Java classes without using a proxy object.");
        JI_OBJECTPROXYCACHE = Options.bool(Category.JAVA_INTEGRATION, "ji.objectProxyCache", false, "Cache Java object wrappers between calls.");
        JI_PROXYCLASSFACTORY = Options.string(Category.JAVA_INTEGRATION, "ji.proxyClassFactory", "Allow external envs to replace JI proxy class factory");
        JI_AMBIGUOUS_CALLS_DEBUG = Options.bool(Category.JAVA_INTEGRATION, "ji.ambiguous.calls.debug", false, "Toggle verbose reporting of all ambiguous calls to Java objects");
        AOT_LOADCLASSES = Options.bool(Category.JAVA_INTEGRATION, "aot.loadClasses", false, "Look for .class before .rb to load AOT-compiled code");
        JI_LOAD_LAZY = Options.bool(Category.JAVA_INTEGRATION, "ji.load.lazy", true, "Load Java support (class extensions) lazily on demand or ahead of time.");
        JI_CLOSE_CLASSLOADER = Options.bool(Category.JAVA_INTEGRATION, "ji.close.classloader", false, "Close the JRubyClassLoader used by each runtime");
        JI_NESTED_JAR_TMPDIR = Options.string(Category.JAVA_INTEGRATION, "ji.nested.jar.tmpdir", "Use specified dir as a base for unpacking nested jar files.");
        JI_CLASS_VALUES = Options.enumeration(Category.JAVA_INTEGRATION, "ji.class.values", ClassValue.Type.class, ClassValue.Type.STABLE, "use the specified type of class-to-value holder for JI proxy structures");
        PROFILE_MAX_METHODS = Options.integer(Category.PROFILING, "profile.max.methods", 100000, "Maximum number of methods to consider for profiling.");
        FIBER_SCHEDULER = Options.bool(Category.EXPERIMENTAL, "experimental.fiber.scheduler", true, "Enable experimental Fiber::Scheduler support.");
        CLI_AUTOSPLIT = Options.bool(Category.CLI, "cli.autosplit", false, "Split $_ into $F for -p or -n. Same as -a.");
        CLI_DEBUG = Options.bool(Category.CLI, "cli.debug", false, "Enable debug mode logging. Same as -d.");
        CLI_PROCESS_LINE_ENDS = Options.bool(Category.CLI, "cli.process.line.ends", false, "Enable line ending processing. Same as -l.");
        CLI_ASSUME_LOOP = Options.bool(Category.CLI, "cli.assume.loop", false, "Wrap execution with a gets() loop. Same as -n.");
        CLI_ASSUME_PRINT = Options.bool(Category.CLI, "cli.assume.print", false, "Print $_ after each execution of script. Same as -p.");
        CLI_VERBOSE = Options.bool(Category.CLI, "cli.verbose", false, "Verbose mode, as -w or -W2. Sets default for cli.warning.level.");
        CLI_WARNING_LEVEL = Options.enumeration(Category.CLI, "cli.warning.level", RubyInstanceConfig.Verbosity.class, Options.calculateVerbosityDefault(), "Warning level (off=0,normal=1,on=2). Same as -W.");
        CLI_PARSER_DEBUG = Options.bool(Category.CLI, "cli.parser.debug", false, "Enable parser debug logging. Same as -y.");
        CLI_VERSION = Options.bool(Category.CLI, "cli.version", false, "Print version to stderr. Same as --version.");
        CLI_BYTECODE = Options.bool(Category.CLI, "cli.bytecode", false, "Print target script bytecode to stderr. Same as --bytecode.");
        CLI_COPYRIGHT = Options.bool(Category.CLI, "cli.copyright", false, "Print copyright to stderr. Same as --copyright but runs script.");
        CLI_BACKTRACE_LIMIT = Options.integer(Category.CLI, "cli.backtracelimit", -1, "Backtrace limit");
        CLI_CHECK_SYNTAX = Options.bool(Category.CLI, "cli.check.syntax", false, "Check syntax of target script. Same as -c but runs script.");
        CLI_AUTOSPLIT_SEPARATOR = Options.string(Category.CLI, "cli.autosplit.separator", "Set autosplit separator. Same as -F.");
        CLI_KCODE = Options.enumeration(Category.CLI, "cli.kcode", KCode.class, KCode.NONE, "Set kcode character set. Same as -K (1.8).");
        CLI_HELP = Options.bool(Category.CLI, "cli.help", false, "Print command-line usage. Same as --help but runs script.");
        CLI_PROPERTIES = Options.bool(Category.CLI, "cli.properties", false, "Print config properties. Same as --properties but runs script.");
        CLI_ENCODING_INTERNAL = Options.string(Category.CLI, "cli.encoding.internal", "Encoding name to use internally.");
        CLI_ENCODING_EXTERNAL = Options.string(Category.CLI, "cli.encoding.external", "Encoding name to treat external data.");
        CLI_ENCODING_SOURCE = Options.string(Category.CLI, "cli.encoding.source", "Encoding name to treat source code.");
        CLI_RECORD_SEPARATOR = Options.string(Category.CLI, "cli.record.separator", "\n", "Default record separator.");
        CLI_BACKUP_EXTENSION = Options.string(Category.CLI, "cli.backup.extension", "Backup extension for in-place ARGV files. Same as -i.");
        CLI_PROFILING_MODE = Options.enumeration(Category.CLI, "cli.profiling.mode", RubyInstanceConfig.ProfilingMode.class, RubyInstanceConfig.ProfilingMode.OFF, "Enable instrumented profiling modes.");
        CLI_PROFILING_SERVICE = Options.string(Category.CLI, "cli.profiling.service", "Profiling service class to use.");
        CLI_RUBYGEMS_ENABLE = Options.bool(Category.CLI, "cli.rubygems.enable", true, "Enable/disable RubyGems.");
        CLI_DID_YOU_MEAN_ENABLE = Options.bool(Category.CLI, "cli.did_you_mean.enable", true, "Enable/disable did_you_mean.");
        CLI_ERROR_HIGHLIGHT_ENABLE = Options.bool(Category.CLI, "cli.error_highlight.enable", false, "Ignored. ErrorHighlight does not currently support JRuby.");
        CLI_SYNTAX_SUGGEST_ENABLE = Options.bool(Category.CLI, "cli.syntax_suggest.enable", true, "Enable/disable syntax_suggest.");
        CLI_RUBYOPT_ENABLE = Options.bool(Category.CLI, "cli.rubyopt.enable", true, "Enable/disable RUBYOPT processing at start.");
        CLI_STRIP_HEADER = Options.bool(Category.CLI, "cli.strip.header", false, "Strip text before shebang in script. Same as -x.");
        CLI_LOAD_GEMFILE = Options.bool(Category.CLI, "cli.load.gemfile", false, "Load a bundler Gemfile in cwd before running. Same as -G.");
        PROPERTIES = Collections.unmodifiableCollection(_loadedOptions);
        PARSER_WARN_GROUPED_EXPRESSIONS = Options.bool(Category.PARSER, "parser.warn.grouped_expressions", true, "Warn about interpreting (...) as a grouped expression.");
        COMPILE_FASTOPS = Options.bool(Category.COMPILER, "compile.fastops", true, "Turn on fast operators for Fixnum and Float.");
        COMPILE_THREADLESS = Options.bool(Category.COMPILER, "compile.threadless", false, "(EXPERIMENTAL) Turn on compilation without polling for \"unsafe\" thread events.");
        COMPILE_CHAINSIZE = Options.integer(Category.COMPILER, "compile.chainsize", 500, "Set the number of lines at which compiled bodies are \"chained\".");
        COMPILE_PEEPHOLE = Options.bool(Category.COMPILER, "compile.peephole", true, "Enable or disable peephole optimizations.");
        COMPILE_NOGUARDS = Options.bool(Category.COMPILER, "compile.noguards", false, "Compile calls without guards, for experimentation.");
        COMPILE_FASTEST = Options.bool(Category.COMPILER, "compile.fastest", false, "Compile with all \"mostly harmless\" compiler optimizations.");
        COMPILE_FASTSEND = Options.bool(Category.COMPILER, "compile.fastsend", false, "Compile obj.__send__(<literal>, ...) as obj.<literal>(...).");
        COMPILE_FASTMASGN = Options.bool(Category.COMPILER, "compile.fastMasgn", false, "Return true from multiple assignment instead of a new array.");
        COMPILE_OUTLINE_CASECOUNT = Options.integer(Category.COMPILER, "compile.outline.casecount", 50, "Outline when bodies when number of cases exceeds this value.");
        INVOKEDYNAMIC_SAFE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.safe", false, "Enable all safe (but maybe not fast) uses of invokedynamic.");
        INVOKEDYNAMIC_INVOCATION = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation", true, "Enable invokedynamic for method invocations.");
        INVOKEDYNAMIC_INVOCATION_INDIRECT = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.indirect", true, "Also bind indirect method invokers to invokedynamic.");
        INVOKEDYNAMIC_INVOCATION_JAVA = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.java", true, "Bind Ruby to Java invocations with invokedynamic.");
        INVOKEDYNAMIC_INVOCATION_ATTR = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.attr", true, "Bind Ruby attribute invocations directly to invokedynamic.");
        INVOKEDYNAMIC_INVOCATION_FFI = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.ffi", true, "Bind Ruby FFI invocations directly to invokedynamic.");
        INVOKEDYNAMIC_INVOCATION_FASTOPS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.invocation.fastops", true, "Bind Fixnum and Float math using optimized logic.");
        INVOKEDYNAMIC_CACHE = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache", true, "Use invokedynamic to load cached values like literals and constants.");
        INVOKEDYNAMIC_CACHE_CONSTANTS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.constants", true, "Use invokedynamic to load constants.");
        INVOKEDYNAMIC_CACHE_LITERALS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.literals", true, "Use invokedynamic to load literals.");
        INVOKEDYNAMIC_CACHE_IVARS = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.cache.ivars", true, "Use invokedynamic to get/set instance variables.");
        JIT_CACHE = Options.bool(Category.JIT, "jit.cache", (Boolean)COMPILE_INVOKEDYNAMIC.load() == false, "(DEPRECATED) Cache jitted method in-memory bodies across runtimes and loads.");
        INVOKEDYNAMIC_ALL = Options.bool(Category.INVOKEDYNAMIC, "invokedynamic.all", false, "Enable all possible uses of invokedynamic.");
        JIT_DUMPING = Options.bool(Category.JIT, "jit.dumping", false, "Enable stdout dumping of JITed bytecode.");
        IR_INLINE_COMPILER_PASSES = Options.string(Category.IR, "ir.inline_passes", "Specify comma delimeted list of passes to run after inlining a method.");
        FFI_COMPILE_INVOKEDYNAMIC = Options.bool(Category.NATIVE, "ffi.compile.invokedynamic", false, "Use invokedynamic to bind FFI invocations.");
        NATIVE_NET_PROTOCOL = Options.bool(Category.MISCELLANEOUS, "native.net.protocol", false, "Use native impls for parts of net/protocol.");
        THREAD_DUMP_SIGNAL = Options.string(Category.MISCELLANEOUS, "thread.dump.signal", new String[]{"USR1", "USR2", "etc"}, "USR2", "Set the signal used for dumping thread stacks.");
        FIBER_COROUTINES = Options.bool(Category.MISCELLANEOUS, "fiber.coroutines", false, "Use JVM coroutines for Fiber.");
        GLOBAL_REQUIRE_LOCK = Options.bool(Category.MISCELLANEOUS, "global.require.lock", false, "Use a single global lock for requires.");
        REFLECTED_HANDLES = Options.bool(Category.MISCELLANEOUS, "reflected.handles", false, "Use reflection for binding methods, not generated bytecode.");
        ENUMERATOR_LIGHTWEIGHT = Options.bool(Category.MISCELLANEOUS, "enumerator.lightweight", true, "Use lightweight Enumerator#next logic when possible.");
        FCNTL_LOCKING = Options.bool(Category.MISCELLANEOUS, "file.flock.fcntl", true, "Use fcntl rather than flock for File#flock");
        RECORD_LEXICAL_HIERARCHY = Options.bool(Category.MISCELLANEOUS, "record.lexical.hierarchy", false, "Maintain children static scopes to support scope dumping.");
        JI_LOGCANSETACCESSIBLE = Options.bool(Category.JAVA_INTEGRATION, "ji.logCanSetAccessible", false, "Log whether setAccessible is working.");
        JAVA_HANDLES = Options.bool(Category.JAVA_INTEGRATION, "java.handles", false, "Use generated handles instead of reflection for calling Java.");
        NAME_ERROR_INSPECT_OBJECT = Options.bool(Category.MISCELLANEOUS, "nameError.inspect.object", true, "Inspect the target object for display in NameError messages.");
    }

    private static enum SearchMode {
        PREFIX,
        CONTAINS;

    }
}

