/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import jnr.constants.platform.Errno;
import org.jruby.Ruby;
import org.jruby.exceptions.RaiseException;

public abstract class ResourceException
extends IOException {
    public ResourceException() {
    }

    public ResourceException(String message2) {
        super(message2);
    }

    public ResourceException(Throwable t) {
        super(t);
    }

    public ResourceException(String message2, Throwable cause2) {
        super(message2, cause2);
    }

    public abstract RaiseException newRaiseException(Ruby var1);

    @Deprecated(since="9.2.1.0")
    public static class IOError
    extends ResourceException {
        private final IOException ioe;

        IOError(IOException ioe) {
            super(ioe);
            this.ioe = ioe;
        }

        @Override
        public RaiseException newRaiseException(Ruby runtime2) {
            return runtime2.newIOErrorFromException(this.ioe);
        }
    }

    public static class TooManySymlinks
    extends ErrnoException {
        public TooManySymlinks(String path2) {
            super("ELOOP", path2);
        }
    }

    public static class InvalidArguments
    extends ErrnoException {
        public InvalidArguments(String path2) {
            super("EINVAL", path2);
        }
    }

    public static class PermissionDenied
    extends ErrnoException {
        public PermissionDenied(String path2) {
            super("EACCES", path2);
        }
    }

    public static class NotFound
    extends ErrnoException {
        public NotFound(String path2) {
            super("ENOENT", path2);
        }
    }

    public static class FileExists
    extends ErrnoException {
        public FileExists(String path2) {
            super("EEXIST", path2);
        }
    }

    public static class FileIsNotDirectory
    extends ErrnoException {
        public FileIsNotDirectory(String path2) {
            super("ENOTDIR", path2);
        }
    }

    public static class FileIsDirectory
    extends ErrnoException {
        public FileIsDirectory(String path2) {
            super("EISDIR", path2);
        }
    }

    public static class ErrnoException
    extends ResourceException {
        private final String path;
        private final String errnoClass;
        private final Errno errno;

        protected ErrnoException(String errnoClass, String path2) {
            super(errnoClass + ": " + path2);
            this.errno = Errno.valueOf((String)errnoClass);
            this.errnoClass = errnoClass;
            this.path = path2;
        }

        protected ErrnoException(Errno errno2, String path2) {
            super(errno2.name() + ": " + path2);
            this.errno = errno2;
            this.errnoClass = errno2.name();
            this.path = path2;
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        @Override
        public RaiseException newRaiseException(Ruby runtime2) {
            return runtime2.newRaiseException(runtime2.getErrno().getClass(runtime2.getCurrentContext(), this.errnoClass), this.path);
        }

        public String getPath() {
            return this.path;
        }

        public Errno getErrno() {
            return this.errno;
        }
    }
}

