/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import com.headius.invokebinder.Binder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.NullBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class BlockBody {
    protected final Signature signature;
    protected MethodHandle testBlockBody;
    private static final MethodHandle TEST_BLOCK_BODY = Binder.from(Boolean.TYPE, Block.class, (Class[])new Class[]{BlockBody.class}).invokeStaticQuiet(MethodHandles.lookup(), BlockBody.class, "testBlockBody");
    public static final BlockBody NULL_BODY = new NullBlockBody();

    public BlockBody(Signature signature) {
        this.signature = signature;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public boolean canCallDirect() {
        return false;
    }

    public MethodHandle getTestBlockBody() {
        MethodHandle testBlockBody = this.testBlockBody;
        if (testBlockBody != null) {
            return testBlockBody;
        }
        this.testBlockBody = Binder.from(Boolean.TYPE, ThreadContext.class, (Class[])new Class[]{Block.class}).drop(0).append(new Object[]{this}).invoke(TEST_BLOCK_BODY);
        return this.testBlockBody;
    }

    public static boolean testBlockBody(Block block, BlockBody body) {
        return block.getBody() == body;
    }

    protected IRubyObject callDirect(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        throw new RuntimeException("callDirect not implemented in base class. We should never get here.");
    }

    protected IRubyObject yieldDirect(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        throw new RuntimeException("yieldDirect not implemented in base class. We should never get here.");
    }

    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2) {
        if (this.canCallDirect()) {
            return this.callDirect(context, block, args2, Block.NULL_BLOCK);
        }
        return this.yield(context, block, this.prepareArgumentsForCall(context, args2, block.type), null);
    }

    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        if (this.canCallDirect()) {
            return this.callDirect(context, block, args2, blockArg);
        }
        return this.yield(context, block, this.prepareArgumentsForCall(context, args2, block.type), null, blockArg);
    }

    public final IRubyObject yield(ThreadContext context, Block block, IRubyObject value2) {
        if (this.canCallDirect()) {
            return this.yieldDirect(context, block, new IRubyObject[]{value2}, null);
        }
        return this.doYield(context, block, value2);
    }

    public final IRubyObject yield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        if (this.canCallDirect()) {
            return this.yieldDirect(context, block, args2, self2);
        }
        return this.doYield(context, block, args2, self2);
    }

    protected abstract IRubyObject doYield(ThreadContext var1, Block var2, IRubyObject var3);

    protected abstract IRubyObject doYield(ThreadContext var1, Block var2, IRubyObject[] var3, IRubyObject var4);

    public IRubyObject yield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2, Block blockArg) {
        return this.yield(context, block, args2, self2);
    }

    public IRubyObject yield(ThreadContext context, Block block, IRubyObject value2, Block blockArg) {
        return this.yield(context, block, value2);
    }

    public IRubyObject call(ThreadContext context, Block block) {
        IRubyObject[] args2 = IRubyObject.NULL_ARRAY;
        if (this.canCallDirect()) {
            return this.callDirect(context, block, args2, Block.NULL_BLOCK);
        }
        return this.yield(context, block, this.prepareArgumentsForCall(context, args2, block.type), null);
    }

    public IRubyObject call(ThreadContext context, Block block, Block unusedBlock) {
        return this.call(context, block);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Block block) {
        if (this.canCallDirect()) {
            return this.yieldDirect(context, block, null, null);
        }
        return this.yield(context, block, null);
    }

    public IRubyObject call(ThreadContext context, Block block, IRubyObject arg0) {
        IRubyObject[] args2 = new IRubyObject[]{arg0};
        if (this.canCallDirect()) {
            return this.callDirect(context, block, args2, Block.NULL_BLOCK);
        }
        return this.yield(context, block, this.prepareArgumentsForCall(context, args2, block.type), null);
    }

    public IRubyObject call(ThreadContext context, Block block, IRubyObject arg0, Block unusedBlock) {
        return this.call(context, block, arg0);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0) {
        if (this.canCallDirect()) {
            return this.yieldDirect(context, block, new IRubyObject[]{arg0}, null);
        }
        return this.yield(context, block, arg0);
    }

    public IRubyObject call(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1) {
        IRubyObject[] args2 = new IRubyObject[]{arg0, arg1};
        if (this.canCallDirect()) {
            return this.callDirect(context, block, args2, Block.NULL_BLOCK);
        }
        return this.yield(context, block, this.prepareArgumentsForCall(context, args2, block.type), null);
    }

    public IRubyObject call(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1, Block unusedBlock) {
        return this.call(context, block, arg0, arg1);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1) {
        if (this.canCallDirect()) {
            return this.yieldDirect(context, block, new IRubyObject[]{arg0, arg1}, null);
        }
        return this.yield(context, block, new IRubyObject[]{arg0, arg1}, null);
    }

    public IRubyObject call(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject[] args2 = new IRubyObject[]{arg0, arg1, arg2};
        if (this.canCallDirect()) {
            return this.callDirect(context, block, args2, Block.NULL_BLOCK);
        }
        return this.yield(context, block, this.prepareArgumentsForCall(context, args2, block.type), null);
    }

    public IRubyObject call(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block unusedBlock) {
        return this.call(context, block, arg0, arg1, arg2);
    }

    public IRubyObject yieldSpecific(ThreadContext context, Block block, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (this.canCallDirect()) {
            return this.yieldDirect(context, block, new IRubyObject[]{arg0, arg1, arg2}, null);
        }
        return this.yield(context, block, new IRubyObject[]{arg0, arg1, arg2}, null);
    }

    public abstract StaticScope getStaticScope();

    public abstract void setStaticScope(StaticScope var1);

    @Deprecated(since="9.0.0.0")
    public Arity arity() {
        return this.signature.arity();
    }

    public boolean isGiven() {
        return true;
    }

    public abstract String getFile();

    public abstract int getLine();

    public boolean isRubyBlock() {
        return false;
    }

    public IRubyObject[] prepareArgumentsForCall(ThreadContext context, IRubyObject[] args2, Block.Type type2) {
        if (type2 == Block.Type.LAMBDA) {
            this.signature.checkArity(context, args2);
        } else if (args2.length == 1) {
            args2 = IRRuntimeHelpers.convertValueIntoArgArray(context, args2[0], this.signature);
        }
        return args2;
    }

    public ArgumentDescriptor[] getArgumentDescriptors() {
        return ArgumentDescriptor.EMPTY_ARRAY;
    }
}

