/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.Enumeration;
import java.util.regex.Pattern;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.AddressInfo;
import jnr.constants.platform.Errno;
import jnr.constants.platform.INAddr;
import jnr.constants.platform.IP;
import jnr.constants.platform.IPProto;
import jnr.constants.platform.InterfaceInfo;
import jnr.constants.platform.NameInfo;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Shutdown;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketMessage;
import jnr.constants.platform.SocketOption;
import jnr.constants.platform.TCP;
import jnr.netdb.Protocol;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.Ifaddr;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyUDPSocket;
import org.jruby.ext.socket.SocketType;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelFD;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"Socket"}, parent="BasicSocket", include={"Socket::Constants"})
public class RubySocket
extends RubyBasicSocket {
    private static final Pattern ALREADY_BOUND_PATTERN = Pattern.compile("[Aa]lready.*bound");
    private static final Pattern ADDR_NOT_AVAIL_PATTERN = Pattern.compile("assign.*address");
    protected AddressFamily soDomain;
    protected ProtocolFamily soProtocolFamily;
    protected Sock soType;
    protected Protocol soProtocol = Protocol.getProtocolByNumber((int)0);
    private static final String JRUBY_SERVER_SOCKET_ERROR = "use ServerSocket for servers (https://github.com/jruby/jruby/wiki/ServerSocket)";

    static RubyClass createSocket(ThreadContext context, RubyClass BasicSocket) {
        RubyClass Socket2 = (RubyClass)Define.defineClass(context, "Socket", BasicSocket, RubySocket::new).defineMethods(context, RubySocket.class);
        Socket2.setInternalVariable("tcp_fast_fallback", RubySocket.getFastFallbackDefault(context));
        Object SocketConstants = ((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)Socket2.defineModuleUnder(context, "Constants").defineConstantsFrom(context, Sock.class)).defineConstantsFrom(context, SocketOption.class)).defineConstantsFrom(context, SocketLevel.class)).defineConstantsFrom(context, ProtocolFamily.class)).defineConstantsFrom(context, AddressFamily.class)).defineConstantsFrom(context, INAddr.class)).defineConstantsFrom(context, IPProto.class)).defineConstantsFrom(context, Shutdown.class)).defineConstantsFrom(context, TCP.class)).defineConstantsFrom(context, IP.class)).defineConstantsFrom(context, InterfaceInfo.class)).defineConstantsFrom(context, NameInfo.class)).defineConstantsFrom(context, SocketMessage.class);
        ((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyModule)SocketConstants).defineConstant(context, "SOMAXCONN", Convert.asFixnum(context, 128))).defineConstant(context, "IPPORT_RESERVED", Convert.asFixnum(context, 1024))).defineConstant(context, "IPPORT_USERRESERVED", Convert.asFixnum(context, 5000))).defineConstant(context, "AI_PASSIVE", Convert.asFixnum(context, AddressInfo.AI_PASSIVE.longValue()))).defineConstant(context, "AI_CANONNAME", Convert.asFixnum(context, AddressInfo.AI_CANONNAME.longValue()))).defineConstant(context, "AI_NUMERICHOST", Convert.asFixnum(context, AddressInfo.AI_NUMERICHOST.longValue()))).defineConstant(context, "AI_ALL", Convert.asFixnum(context, AddressInfo.AI_ALL.longValue()))).defineConstant(context, "AI_V4MAPPED_CFG", Convert.asFixnum(context, AddressInfo.AI_V4MAPPED_CFG.longValue()))).defineConstant(context, "AI_ADDRCONFIG", Convert.asFixnum(context, AddressInfo.AI_ADDRCONFIG.longValue()))).defineConstant(context, "AI_V4MAPPED", Convert.asFixnum(context, AddressInfo.AI_V4MAPPED.longValue()))).defineConstant(context, "AI_NUMERICSERV", Convert.asFixnum(context, AddressInfo.AI_NUMERICSERV.longValue()))).defineConstant(context, "AI_DEFAULT", Convert.asFixnum(context, AddressInfo.AI_DEFAULT.longValue()))).defineConstant(context, "AI_MASK", Convert.asFixnum(context, AddressInfo.AI_MASK.longValue()));
        Socket2.include(context, (RubyModule)SocketConstants);
        return Socket2;
    }

    public RubySocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject socketClass, IRubyObject _fd) {
        int intFD = Convert.castAsFixnum(context, _fd).asInt(context);
        ChannelFD fd = context.runtime.getFilenoUtil().getWrapperFromFileno(intFD);
        if (fd == null) {
            throw context.runtime.newErrnoEBADFError();
        }
        RubySocket socket2 = (RubySocket)((RubyClass)socketClass).allocate(context);
        socket2.initFieldsFromDescriptor(context.runtime, fd);
        socket2.initSocket(fd);
        return socket2;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2) {
        this.initFromArgs(context, domain, type2);
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        this.initFromArgs(context, domain, type2, protocol2);
        return this;
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context, IRubyObject arg2) {
        return this.connect_nonblock(context, arg2, context.nil);
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context, IRubyObject arg2, IRubyObject opts) {
        SocketAddress addr2 = this.addressForChannel(context, arg2);
        return this.doConnectNonblock(context, addr2, RubySocket.extractExceptionArg(context, opts));
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context, IRubyObject arg2) {
        SocketAddress addr2 = this.addressForChannel(context, arg2);
        return this.doConnect(context, addr2, true);
    }

    @JRubyMethod
    public IRubyObject bind(ThreadContext context, IRubyObject arg2) {
        SocketAddress sockaddr;
        if (arg2 instanceof Addrinfo) {
            Addrinfo addr2 = (Addrinfo)arg2;
            sockaddr = addr2.getSocketAddress();
        } else {
            sockaddr = Sockaddr.addressFromSockaddr(context, arg2);
        }
        this.doBind(context, sockaddr);
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length) {
        return RubyUDPSocket.recvfrom(this, context, _length);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject _length, IRubyObject _flags) {
        return this.recvfrom(context, _length);
    }

    @JRubyMethod(required=1, optional=3, checkArity=false)
    public IRubyObject recvfrom_nonblock(ThreadContext context, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 4);
        if (this.getOpenFile() == null) {
            throw context.runtime.newErrnoENOTCONNError("socket is not connected");
        }
        return RubyUDPSocket.recvfrom_nonblock(this, context, args2);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject accept(ThreadContext context) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(notImplemented=true, optional=1, checkArity=false)
    public IRubyObject accept_nonblock(ThreadContext context, IRubyObject[] args2) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostname(ThreadContext context, IRubyObject recv2) {
        return SocketUtils.gethostname(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject getifaddrs(ThreadContext context, IRubyObject recv2) {
        RubyArray<?> list2 = Create.newArray(context);
        RubyClass Ifaddr2 = (RubyClass)context.runtime.getClassFromPath("Socket::Ifaddr");
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface iface = en.nextElement();
                list2.append(context, new Ifaddr(context.runtime, Ifaddr2, iface));
                for (InterfaceAddress iaddr : iface.getInterfaceAddresses()) {
                    list2.append(context, new Ifaddr(context.runtime, Ifaddr2, iface, iaddr));
                }
            }
        }
        catch (RuntimeException | SocketException ex) {
            if (ex instanceof RaiseException) {
                throw (RaiseException)ex;
            }
            throw SocketUtils.sockerr_with_trace(context.runtime, "getifaddrs: " + ex.toString(), ex.getStackTrace());
        }
        return list2;
    }

    @JRubyMethod(required=1, rest=true, checkArity=false, meta=true)
    public static IRubyObject gethostbyaddr(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, -1);
        return SocketUtils.gethostbyaddr(context, args2);
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, meta=true)
    public static IRubyObject getservbyname(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 2);
        return SocketUtils.getservbyname(context, args2);
    }

    @JRubyMethod(name={"pack_sockaddr_in", "sockaddr_in"}, meta=true)
    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject port, IRubyObject host) {
        return Sockaddr.pack_sockaddr_in(context, port, host);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        return Sockaddr.unpack_sockaddr_in(context, addr2);
    }

    @JRubyMethod(name={"pack_sockaddr_un", "sockaddr_un"}, meta=true)
    public static IRubyObject pack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        String path2 = filename2.convertToString().asJavaString();
        return Sockaddr.pack_sockaddr_un(context, path2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        return Sockaddr.unpack_sockaddr_un(context, addr2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        return SocketUtils.gethostbyname(context, hostname);
    }

    @JRubyMethod(required=2, optional=5, checkArity=false, meta=true)
    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 2, 7);
        return SocketUtils.getaddrinfo(context, args2);
    }

    @JRubyMethod(required=1, optional=1, checkArity=false, meta=true)
    public static IRubyObject getnameinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        Arity.checkArgumentCount(context, args2, 1, 2);
        return SocketUtils.getnameinfo(context, args2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject ip_address_list(ThreadContext context, IRubyObject self2) {
        return SocketUtils.ip_address_list(context);
    }

    @JRubyMethod(name={"socketpair", "pair"}, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        ProtocolFamily pf = SocketUtils.protocolFamilyFromArg(context, protocol2);
        if (pf == null) {
            pf = ProtocolFamily.PF_UNIX;
        }
        if (pf != ProtocolFamily.PF_UNIX && pf.ordinal() != 0) {
            throw context.runtime.newErrnoEOPNOTSUPPError("Socket.socketpair only supports streaming UNIX sockets");
        }
        return RubySocket.socketpair(context, recv2, domain, type2);
    }

    @JRubyMethod(name={"socketpair", "pair"}, meta=true)
    public static IRubyObject socketpair(ThreadContext context, IRubyObject recv2, IRubyObject domain, IRubyObject type2) {
        Sock s2;
        AddressFamily af = SocketUtils.addressFamilyFromArg(context, domain);
        if (af == null) {
            af = AddressFamily.AF_UNIX;
        }
        if ((s2 = SocketUtils.sockFromArg(context, type2)) == null) {
            s2 = Sock.SOCK_STREAM;
        }
        if (af != AddressFamily.AF_UNIX || s2 != Sock.SOCK_STREAM) {
            throw context.runtime.newErrnoEOPNOTSUPPError("Socket.socketpair only supports streaming UNIX sockets");
        }
        Ruby runtime2 = context.runtime;
        try {
            UnixSocketChannel[] sp = UnixSocketChannel.pair();
            RubyClass socketClass = Access.getClass(context, "Socket");
            RubySocket sock0 = new RubySocket(runtime2, socketClass);
            ChannelFD fd0 = RubySocket.newChannelFD(runtime2, (Channel)sp[0]);
            sock0.initFieldsFromDescriptor(runtime2, fd0);
            sock0.initSocket(fd0);
            RubySocket sock1 = new RubySocket(runtime2, socketClass);
            ChannelFD fd1 = RubySocket.newChannelFD(runtime2, (Channel)sp[1]);
            sock1.initFieldsFromDescriptor(runtime2, fd1);
            sock1.initSocket(fd1);
            return Create.newArray(context, (IRubyObject)sock0, (IRubyObject)sock1);
        }
        catch (IOException ioe) {
            throw runtime2.newIOErrorFromException(ioe);
        }
    }

    private void initFieldsFromDescriptor(Ruby runtime2, ChannelFD fd) {
        Channel mainChannel = fd.ch;
        if (mainChannel instanceof SocketChannel) {
            this.soDomain = AddressFamily.AF_INET;
            this.soType = Sock.SOCK_STREAM;
            this.soProtocolFamily = ProtocolFamily.PF_INET;
            this.soProtocol = Protocol.getProtocolByName((String)"tcp");
        } else if (mainChannel instanceof UnixSocketChannel) {
            this.soDomain = AddressFamily.AF_UNIX;
            this.soType = Sock.SOCK_STREAM;
            this.soProtocolFamily = ProtocolFamily.PF_UNIX;
        } else if (mainChannel instanceof DatagramChannel) {
            this.soDomain = AddressFamily.AF_INET;
            this.soType = Sock.SOCK_DGRAM;
            this.soProtocolFamily = ProtocolFamily.PF_INET;
        } else {
            throw runtime2.newErrnoENOTSOCKError("can't Socket.new/for_fd against a non-socket");
        }
    }

    private void initFromArgs(ThreadContext context, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        this.setProtocol(context, protocol2);
        this.initFromArgs(context, domain, type2);
    }

    private void initFromArgs(ThreadContext context, IRubyObject domain, IRubyObject type2) {
        this.setDomain(context, domain);
        this.setType(context, type2);
        ChannelFD fd = this.initChannelFD(context.runtime);
        this.initSocket(fd);
    }

    protected void initFromServer(Ruby runtime2, RubySocket serverSocket, SocketChannel socketChannel) {
        this.soDomain = serverSocket.soDomain;
        this.soType = serverSocket.soType;
        this.soProtocol = serverSocket.soProtocol;
        this.initSocket(RubySocket.newChannelFD(runtime2, socketChannel));
    }

    protected ChannelFD initChannelFD(Ruby runtime2) {
        try {
            return RubySocket.newChannelFD(runtime2, switch (this.soType) {
                case Sock.SOCK_STREAM -> {
                    if (this.soProtocolFamily == ProtocolFamily.PF_UNIX || this.soProtocolFamily == ProtocolFamily.PF_LOCAL) {
                        yield UnixSocketChannel.open();
                    }
                    if (this.soProtocolFamily == ProtocolFamily.PF_INET || this.soProtocolFamily == ProtocolFamily.PF_INET6 || this.soProtocolFamily == ProtocolFamily.PF_UNSPEC) {
                        yield SocketChannel.open();
                    }
                    throw Error.argumentError(runtime2.getCurrentContext(), "unsupported protocol family '" + String.valueOf(this.soProtocolFamily) + "'");
                }
                case Sock.SOCK_DGRAM -> DatagramChannel.open();
                default -> throw Error.argumentError(runtime2.getCurrentContext(), "unsupported socket type '" + String.valueOf(this.soType) + "'");
            });
        }
        catch (IOException e) {
            throw RubySocket.sockerr(runtime2, "initialize: " + e.toString(), e);
        }
    }

    private void setProtocol(ThreadContext context, IRubyObject protocol2) {
        this.soProtocol = SocketUtils.protocolFromArg(context, protocol2);
    }

    private void setType(ThreadContext context, IRubyObject type2) {
        Sock sockType = SocketUtils.sockFromArg(context, type2);
        if (sockType == null) {
            throw SocketUtils.sockerr(context.runtime, "unknown socket type " + String.valueOf(type2));
        }
        this.soType = sockType;
    }

    private void setDomain(ThreadContext context, IRubyObject domain) {
        AddressFamily family2 = SocketUtils.addressFamilyFromArg(context, domain);
        if (family2 == null) {
            throw SocketUtils.sockerr(context.runtime, "unknown socket domain " + String.valueOf(domain));
        }
        this.soDomain = family2;
        String name2 = this.soDomain.name();
        if (name2.startsWith("pseudo_")) {
            name2 = name2.substring(7);
        }
        this.soProtocolFamily = ProtocolFamily.valueOf((String)("PF" + name2.substring(2)));
    }

    private IRubyObject doConnectNonblock(ThreadContext context, SocketAddress addr2, boolean ex) {
        Channel channel = this.getChannel();
        if (!(channel instanceof SelectableChannel)) {
            throw context.runtime.newErrnoENOPROTOOPTError();
        }
        boolean result2 = this.tryConnect(context, channel, addr2, ex, false);
        if (!result2) {
            if (!ex) {
                return Convert.asSymbol(context, "wait_writable");
            }
            throw context.runtime.newErrnoEINPROGRESSWritableError();
        }
        return Convert.asFixnum(context, 0);
    }

    protected IRubyObject doConnect(ThreadContext context, SocketAddress addr2, boolean ex) {
        this.tryConnect(context, this.getChannel(), addr2, ex, true);
        return Convert.asFixnum(context, 0);
    }

    /*
     * Exception decompiling
     */
    private boolean tryConnect(ThreadContext context, Channel channel, SocketAddress addr, boolean ex, boolean blocking) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 20[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doBind(ThreadContext context, SocketAddress iaddr) {
        block7: {
            Ruby runtime2 = context.runtime;
            Channel channel = this.getChannel();
            try {
                if (channel instanceof SocketChannel) {
                    Socket socket2 = ((SocketChannel)channel).socket();
                    socket2.bind(iaddr);
                    break block7;
                }
                if (channel instanceof UnixSocketChannel) break block7;
                if (channel instanceof DatagramChannel) {
                    DatagramSocket socket3 = ((DatagramChannel)channel).socket();
                    socket3.bind(iaddr);
                    break block7;
                }
                throw runtime2.newErrnoENOPROTOOPTError();
            }
            catch (UnknownHostException e) {
                throw SocketUtils.sockerr(runtime2, "bind(2): unknown host");
            }
            catch (SocketException e) {
                throw RubySocket.buildSocketException(runtime2, e, "bind(2)", iaddr);
            }
            catch (IOException e) {
                throw RubySocket.sockerr(runtime2, "bind(2): name or service not known", e);
            }
            catch (IllegalArgumentException e) {
                throw RubySocket.sockerr(runtime2, e.getMessage(), e);
            }
        }
    }

    static RaiseException buildSocketException(Ruby runtime2, SocketException ex, String caller2, SocketAddress addr2) {
        Errno errno2 = Helpers.errnoFromException(ex);
        String callerWithAddr = caller2 + " for " + String.valueOf(RubySocket.formatAddress(addr2));
        if (errno2 != null) {
            return runtime2.newErrnoFromErrno(errno2, callerWithAddr);
        }
        String message2 = ex.getMessage();
        if (message2 != null) {
            if (ALREADY_BOUND_PATTERN.matcher(message2).find()) {
                return runtime2.newErrnoEINVALError(callerWithAddr);
            }
            if (ADDR_NOT_AVAIL_PATTERN.matcher(message2).find()) {
                return runtime2.newErrnoEADDRNOTAVAILError(callerWithAddr);
            }
        }
        return runtime2.newIOError(callerWithAddr);
    }

    private static CharSequence formatAddress(SocketAddress addr2) {
        if (addr2 == null) {
            return null;
        }
        String str = addr2.toString();
        if (str.length() > 0 && str.charAt(0) == '/') {
            return str.substring(1);
        }
        return str;
    }

    private SocketAddress addressForChannel(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof Addrinfo) {
            return ((Addrinfo)arg2).getSocketAddress();
        }
        switch (this.soProtocolFamily) {
            case PF_UNIX: 
            case PF_LOCAL: {
                return Sockaddr.addressFromSockaddr_un(context, arg2);
            }
            case PF_INET: 
            case PF_INET6: 
            case PF_UNSPEC: {
                return Sockaddr.addressFromSockaddr_in(context, arg2);
            }
        }
        throw Error.argumentError(context, "unsupported protocol family '" + String.valueOf(this.soProtocolFamily) + "'");
    }

    @Override
    protected IRubyObject addrFor(ThreadContext context, InetSocketAddress addr2, boolean reverse2) {
        return new Addrinfo(context.runtime, Access.getClass(context, "Addrinfo"), addr2.getAddress(), addr2.getPort(), Sock.SOCK_DGRAM);
    }

    @Override
    @JRubyMethod
    public IRubyObject close(ThreadContext context) {
        if (this.getOpenFile() != null) {
            if (this.isClosed()) {
                return context.nil;
            }
            this.openFile.checkClosed();
            return this.rbIoClose(context);
        }
        return context.nil;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject tcp_fast_fallback(ThreadContext context, IRubyObject self2) {
        return (IRubyObject)Access.getClass(context, "Socket").getInternalVariable("tcp_fast_fallback");
    }

    @JRubyMethod(name={"tcp_fast_fallback="}, meta=true)
    public static IRubyObject tcp_fast_fallback_set(ThreadContext context, IRubyObject self2, IRubyObject value2) {
        Access.getClass(context, "Socket").setInternalVariable("tcp_fast_fallback", value2);
        return value2;
    }

    private static RubyBoolean getFastFallbackDefault(ThreadContext context) {
        IRubyObject tcpNoFastFallbackConfig = context.runtime.getENV().fastARef(Create.newString(context, "RUBY_TCP_NO_FAST_FALLBACK"));
        if (tcpNoFastFallbackConfig == null || tcpNoFastFallbackConfig.isNil() || tcpNoFastFallbackConfig.toString().equals("0")) {
            return context.tru;
        }
        return context.fals;
    }

    @Override
    public RubyBoolean closed_p(ThreadContext context) {
        if (this.getOpenFile() == null) {
            return context.fals;
        }
        return super.closed_p(context);
    }

    @Override
    protected SocketAddress getSocketAddress() {
        Channel channel = this.getChannel();
        return SocketType.forChannel(channel).getLocalSocketAddress(channel);
    }

    @Deprecated(since="1.7.0")
    public static RuntimeException sockerr(Ruby runtime2, String msg) {
        return SocketUtils.sockerr(runtime2, msg);
    }
}

