/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.Invoker;
import com.kenai.jffi.ObjectParameterInfo;
import com.kenai.jffi.ObjectParameterStrategy;
import com.kenai.jffi.Platform;
import java.util.Arrays;
import org.jruby.RubyModule;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.jffi.AsmClassBuilder;
import org.jruby.ext.ffi.jffi.JITMethodGenerator;
import org.jruby.ext.ffi.jffi.JITNativeInvoker;
import org.jruby.ext.ffi.jffi.JITRuntime;
import org.jruby.ext.ffi.jffi.JITSignature;
import org.jruby.ext.ffi.jffi.NativeDataConverter;
import org.jruby.ext.ffi.jffi.PointerParameterStrategy;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CachingCallSite;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Label;

abstract class AbstractNumericMethodGenerator
implements JITMethodGenerator {
    AbstractNumericMethodGenerator() {
    }

    @Override
    public void generate(AsmClassBuilder builder, String functionName, JITSignature signature) {
        Object[] params2 = new Class[4 + signature.getParameterCount()];
        params2[0] = ThreadContext.class;
        params2[1] = IRubyObject.class;
        params2[2] = RubyModule.class;
        params2[3] = String.class;
        Arrays.fill(params2, 4, params2.length, IRubyObject.class);
        SkinnyMethodAdapter mv = new SkinnyMethodAdapter(builder.getClassVisitor(), 17, functionName, CodegenUtils.sig(IRubyObject.class, (Class[])params2), null, null);
        mv.start();
        this.generate(builder, mv, signature, 5);
        mv.visitMaxs(30, 30);
        mv.visitEnd();
    }

    public void generate(AsmClassBuilder builder, SkinnyMethodAdapter mv, JITSignature signature, int firstParam) {
        int i2;
        Class nativeIntType = this.getInvokerIntType();
        int pointerCount = 0;
        mv.aload(1);
        mv.getstatic(CodegenUtils.p(JITNativeInvoker.class), "invoker", CodegenUtils.ci(Invoker.class));
        mv.aload(0);
        mv.getfield(CodegenUtils.p(JITNativeInvoker.class), "callContext", CodegenUtils.ci(CallContext.class));
        mv.aload(0);
        mv.getfield(CodegenUtils.p(JITNativeInvoker.class), "functionAddress", CodegenUtils.ci(Long.TYPE));
        int nextLocalVar = firstParam + signature.getParameterCount();
        int heapPointerCountVar = nextLocalVar++;
        int firstMemoryVar = nextLocalVar;
        nextLocalVar += signature.getParameterCount();
        int nextMemoryVar = firstMemoryVar;
        for (i2 = 0; i2 < signature.getParameterCount(); ++i2) {
            if (!signature.hasParameterConverter(i2)) continue;
            mv.aload(0);
            mv.getfield(builder.getClassName(), builder.getParameterConverterFieldName(i2), CodegenUtils.ci(NativeDataConverter.class));
            mv.aload(1);
            mv.aload(firstParam + i2);
            mv.invokevirtual(CodegenUtils.p(NativeDataConverter.class), "toNative", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
            mv.astore(firstParam + i2);
        }
        block23: for (i2 = 0; i2 < signature.getParameterCount(); ++i2) {
            NativeType parameterType = signature.getParameterType(i2);
            int paramVar = i2 + firstParam;
            mv.aload(paramVar);
            switch (parameterType) {
                case BOOL: {
                    this.unbox(mv, "boolValue");
                    continue block23;
                }
                case CHAR: {
                    this.unbox(mv, "s8Value");
                    continue block23;
                }
                case UCHAR: {
                    this.unbox(mv, "u8Value");
                    continue block23;
                }
                case SHORT: {
                    this.unbox(mv, "s16Value");
                    continue block23;
                }
                case USHORT: {
                    this.unbox(mv, "u16Value");
                    continue block23;
                }
                case INT: {
                    this.unbox(mv, "s32Value");
                    continue block23;
                }
                case UINT: {
                    this.unbox(mv, "u32Value");
                    continue block23;
                }
                case LONG: {
                    if (Platform.getPlatform().longSize() == 32) {
                        this.unbox(mv, "s32Value");
                        continue block23;
                    }
                    this.unbox(mv, "s64Value");
                    continue block23;
                }
                case ULONG: {
                    if (Platform.getPlatform().longSize() == 32) {
                        this.unbox(mv, "u32Value");
                        continue block23;
                    }
                    this.unbox(mv, "u64Value");
                    continue block23;
                }
                case LONG_LONG: {
                    this.unbox(mv, "s64Value");
                    continue block23;
                }
                case ULONG_LONG: {
                    this.unbox(mv, "u64Value");
                    continue block23;
                }
                case STRING: 
                case TRANSIENT_STRING: 
                case POINTER: 
                case BUFFER_IN: 
                case BUFFER_OUT: 
                case BUFFER_INOUT: {
                    Label direct = new Label();
                    Label next2 = new Label();
                    if (pointerCount++ < 1) {
                        mv.pushInt(0);
                        mv.istore(heapPointerCountVar);
                    }
                    Label haveMemoryIO = new Label();
                    switch (parameterType) {
                        case STRING: 
                        case TRANSIENT_STRING: {
                            mv.aload(1);
                            mv.aload(0);
                            mv.getfield(CodegenUtils.p(JITNativeInvoker.class), builder.getParameterCallSiteName(i2), CodegenUtils.ci(CachingCallSite.class));
                            mv.invokestatic(CodegenUtils.p(JITRuntime.class), parameterType == NativeType.STRING ? "convertToStringMemoryIO" : "convertToTransientStringMemoryIO", CodegenUtils.sig(MemoryIO.class, IRubyObject.class, ThreadContext.class, CachingCallSite.class));
                            break;
                        }
                        default: {
                            mv.invokestatic(CodegenUtils.p(JITRuntime.class), "lookupPointerMemoryIO", CodegenUtils.sig(MemoryIO.class, IRubyObject.class));
                            mv.astore(nextMemoryVar);
                            mv.aload(nextMemoryVar);
                            mv.ifnonnull(haveMemoryIO);
                            mv.aload(1);
                            mv.aload(paramVar);
                            mv.aload(0);
                            mv.getfield(CodegenUtils.p(JITNativeInvoker.class), builder.getParameterCallSiteName(i2), CodegenUtils.ci(CachingCallSite.class));
                            mv.invokestatic(CodegenUtils.p(JITRuntime.class), "convertToPointerMemoryIO", CodegenUtils.sig(MemoryIO.class, ThreadContext.class, IRubyObject.class, CachingCallSite.class));
                        }
                    }
                    mv.astore(nextMemoryVar);
                    mv.label(haveMemoryIO);
                    mv.aload(nextMemoryVar);
                    mv.invokevirtual(CodegenUtils.p(MemoryIO.class), "isDirect", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
                    mv.iftrue(direct);
                    mv.iinc(heapPointerCountVar, 1);
                    if (Integer.TYPE == nativeIntType) {
                        mv.iconst_0();
                    } else {
                        mv.lconst_0();
                    }
                    mv.go_to(next2);
                    mv.label(direct);
                    mv.aload(nextMemoryVar);
                    mv.invokevirtual(CodegenUtils.p(MemoryIO.class), "address", CodegenUtils.sig(Long.TYPE, new Class[0]));
                    AbstractNumericMethodGenerator.narrow(mv, Long.TYPE, nativeIntType);
                    ++nextMemoryVar;
                    mv.label(next2);
                    continue block23;
                }
                case FLOAT: {
                    this.unbox(mv, "f32Value");
                    continue block23;
                }
                case DOUBLE: {
                    this.unbox(mv, "f64Value");
                    continue block23;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported parameter type " + String.valueOf((Object)parameterType));
                }
            }
        }
        Label indirect = new Label();
        if (pointerCount > 0) {
            mv.iload(heapPointerCountVar);
            mv.ifne(indirect);
        }
        mv.invokevirtual(CodegenUtils.p(Invoker.class), this.getInvokerMethodName(signature), this.getInvokerSignature(signature.getParameterCount()));
        Label boxResult = new Label();
        if (pointerCount > 0) {
            mv.label(boxResult);
        }
        this.boxResult(mv, signature.getResultType());
        Label resultConversion = new Label();
        if (pointerCount > 0) {
            mv.label(resultConversion);
        }
        this.emitResultConversion(mv, builder, signature);
        mv.areturn();
        if (pointerCount > 0) {
            mv.label(indirect);
            if (Integer.TYPE == nativeIntType) {
                int i3;
                int firstIntParam = nextLocalVar;
                for (i3 = 0; i3 < signature.getParameterCount() - 1; ++i3) {
                    mv.istore(firstIntParam + i3);
                }
                mv.i2l();
                for (i3 = signature.getParameterCount() - 2; i3 >= 0; --i3) {
                    mv.iload(firstIntParam + i3);
                    mv.i2l();
                }
            }
            mv.iload(heapPointerCountVar);
            int ptrIdx = 0;
            for (int i4 = 0; i4 < signature.getParameterCount(); ++i4) {
                switch (signature.getParameterType(i4)) {
                    case STRING: 
                    case TRANSIENT_STRING: 
                    case POINTER: 
                    case BUFFER_IN: 
                    case BUFFER_OUT: 
                    case BUFFER_INOUT: {
                        mv.aload(firstMemoryVar + ptrIdx);
                        mv.dup();
                        mv.invokestatic(CodegenUtils.p(JITRuntime.class), "getMemoryIOStrategy", CodegenUtils.sig(PointerParameterStrategy.class, MemoryIO.class));
                        mv.aload(0);
                        mv.getfield(CodegenUtils.p(JITNativeInvoker.class), "parameterInfo" + i4, CodegenUtils.ci(ObjectParameterInfo.class));
                        ++ptrIdx;
                    }
                }
            }
            mv.invokevirtual(CodegenUtils.p(Invoker.class), "invokeN" + signature.getParameterCount(), CodegenUtils.sig(Long.TYPE, AbstractNumericMethodGenerator.makeObjectParamSignature(signature, pointerCount)));
            AbstractNumericMethodGenerator.narrow(mv, Long.TYPE, nativeIntType);
            mv.go_to(boxResult);
        }
    }

    private void emitResultConversion(SkinnyMethodAdapter mv, AsmClassBuilder builder, JITSignature signature) {
        if (signature.hasResultConverter()) {
            mv.aload(0);
            mv.getfield(builder.getClassName(), builder.getResultConverterFieldName(), CodegenUtils.ci(NativeDataConverter.class));
            mv.swap();
            mv.aload(1);
            mv.swap();
            mv.invokevirtual(CodegenUtils.p(NativeDataConverter.class), "fromNative", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        }
    }

    private static Class[] makeObjectParamSignature(JITSignature signature, int pointerCount) {
        int i2;
        Class[] paramTypes = new Class[3 + signature.getParameterCount() + pointerCount * 3];
        int idx = 0;
        paramTypes[idx++] = CallContext.class;
        paramTypes[idx++] = Long.TYPE;
        for (i2 = 0; i2 < signature.getParameterCount(); ++i2) {
            paramTypes[idx++] = Long.TYPE;
        }
        paramTypes[idx++] = Integer.TYPE;
        for (i2 = 0; i2 < pointerCount; ++i2) {
            paramTypes[idx++] = Object.class;
            paramTypes[idx++] = ObjectParameterStrategy.class;
            paramTypes[idx++] = ObjectParameterInfo.class;
        }
        return paramTypes;
    }

    private void unbox(SkinnyMethodAdapter mv, String method2) {
        mv.invokestatic(CodegenUtils.p(JITRuntime.class), this.getRuntimeMethod(method2), CodegenUtils.sig(this.getInvokerIntType(), IRubyObject.class));
    }

    private String getRuntimeMethod(String method2) {
        return method2 + (Integer.TYPE == this.getInvokerIntType() ? "32" : "64");
    }

    private void boxResult(SkinnyMethodAdapter mv, String boxMethodName) {
        mv.invokestatic(CodegenUtils.p(JITRuntime.class), boxMethodName, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, this.getInvokerIntType()));
    }

    private void boxResult(SkinnyMethodAdapter mv, NativeType type2) {
        switch (type2) {
            case BOOL: {
                this.boxResult(mv, "newBoolean");
                break;
            }
            case CHAR: {
                this.boxResult(mv, "newSigned8");
                break;
            }
            case UCHAR: {
                this.boxResult(mv, "newUnsigned8");
                break;
            }
            case SHORT: {
                this.boxResult(mv, "newSigned16");
                break;
            }
            case USHORT: {
                this.boxResult(mv, "newUnsigned16");
                break;
            }
            case INT: {
                this.boxResult(mv, "newSigned32");
                break;
            }
            case UINT: {
                this.boxResult(mv, "newUnsigned32");
                break;
            }
            case LONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    this.boxResult(mv, "newSigned32");
                    break;
                }
                this.boxResult(mv, "newSigned64");
                break;
            }
            case ULONG: {
                if (Platform.getPlatform().longSize() == 32) {
                    this.boxResult(mv, "newUnsigned32");
                    break;
                }
                this.boxResult(mv, "newUnsigned64");
                break;
            }
            case LONG_LONG: {
                this.boxResult(mv, "newSigned64");
                break;
            }
            case ULONG_LONG: {
                this.boxResult(mv, "newUnsigned64");
                break;
            }
            case FLOAT: {
                this.boxResult(mv, "newFloat32");
                break;
            }
            case DOUBLE: {
                this.boxResult(mv, "newFloat64");
                break;
            }
            case VOID: {
                if (Integer.TYPE == this.getInvokerIntType()) {
                    mv.pop();
                } else {
                    mv.pop2();
                }
                mv.getfield(CodegenUtils.p(ThreadContext.class), "nil", CodegenUtils.ci(IRubyObject.class));
                break;
            }
            case POINTER: {
                this.boxResult(mv, "newPointer" + Platform.getPlatform().addressSize());
                break;
            }
            case STRING: 
            case TRANSIENT_STRING: {
                this.boxResult(mv, "newString");
                break;
            }
            default: {
                throw new UnsupportedOperationException("native return type not supported: " + String.valueOf((Object)type2));
            }
        }
    }

    abstract String getInvokerMethodName(JITSignature var1);

    abstract String getInvokerSignature(int var1);

    abstract Class getInvokerIntType();

    public static boolean isPrimitiveInt(Class c) {
        return Byte.TYPE == c || Character.TYPE == c || Short.TYPE == c || Integer.TYPE == c || Boolean.TYPE == c;
    }

    public static final void widen(SkinnyMethodAdapter mv, Class from, Class to) {
        if (Long.TYPE == to && Long.TYPE != from && AbstractNumericMethodGenerator.isPrimitiveInt(from)) {
            mv.i2l();
        }
    }

    public static final void narrow(SkinnyMethodAdapter mv, Class from, Class to) {
        if (!from.equals(to) && AbstractNumericMethodGenerator.isPrimitiveInt(to)) {
            if (Long.TYPE == from) {
                mv.l2i();
            }
            if (Byte.TYPE == to) {
                mv.i2b();
            } else if (Short.TYPE == to) {
                mv.i2s();
            } else if (Character.TYPE == to) {
                mv.i2c();
            } else if (Boolean.TYPE == to) {
                mv.iconst_1();
                mv.iand();
            }
        }
    }

    protected static String[] buildSignatures(Class nativeIntClass, int maxParameters) {
        char sigChar = Integer.TYPE == nativeIntClass ? (char)'I' : 'J';
        String[] signatures = new String[maxParameters + 1];
        for (int i2 = 0; i2 < signatures.length; ++i2) {
            StringBuilder sb = new StringBuilder();
            sb.append('(').append(CodegenUtils.ci(CallContext.class)).append(CodegenUtils.ci(Long.TYPE));
            for (int n = 0; n < i2; ++n) {
                sb.append(sigChar);
            }
            signatures[i2] = sb.append(")").append(sigChar).toString();
        }
        return signatures;
    }
}

