/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import com.headius.backport9.buffer.Buffers;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class Util {
    private static final BigInteger UINT64_BASE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);

    private Util() {
    }

    public static final byte int8Value(IRubyObject parameter) {
        return (byte)Util.longValue(parameter);
    }

    public static final short uint8Value(IRubyObject parameter) {
        return (short)Util.longValue(parameter);
    }

    public static final short int16Value(IRubyObject parameter) {
        return (short)Util.longValue(parameter);
    }

    public static final int uint16Value(IRubyObject parameter) {
        return (int)Util.longValue(parameter);
    }

    public static final int int32Value(IRubyObject parameter) {
        return (int)Util.longValue(parameter);
    }

    public static final long uint32Value(IRubyObject parameter) {
        return Util.longValue(parameter);
    }

    public static final long int64Value(IRubyObject parameter) {
        return Util.longValue(parameter);
    }

    public static final long uint64Value(IRubyObject parameter) {
        long value2 = parameter instanceof RubyBignum ? ((RubyBignum)parameter).getValue().longValue() : Util.ulongValue(parameter);
        return value2;
    }

    @Deprecated(since="10.0.0.0")
    public static final float floatValue(IRubyObject parameter) {
        return Util.floatValue(((RubyBasicObject)parameter).getCurrentContext(), parameter);
    }

    public static final float floatValue(ThreadContext context, IRubyObject parameter) {
        return (float)Convert.toDouble(context, parameter);
    }

    @Deprecated(since="10.0.0.0")
    public static final double doubleValue(IRubyObject parameter) {
        return Util.doubleValue(((RubyBasicObject)parameter).getCurrentContext(), parameter);
    }

    public static final double doubleValue(ThreadContext context, IRubyObject parameter) {
        return Convert.toDouble(context, parameter);
    }

    public static final long longValue(IRubyObject parameter) {
        return RubyNumeric.num2long(parameter);
    }

    @Deprecated(since="10.0.0.0")
    public static int intValue(IRubyObject obj, RubyHash enums) {
        ThreadContext context = ((RubyBasicObject)obj).getCurrentContext();
        if (obj instanceof RubyInteger) {
            RubyInteger obji = (RubyInteger)obj;
            return obji.asInt(context);
        }
        if (obj instanceof RubySymbol) {
            IRubyObject value2 = enums.fastARef(obj);
            if (value2.isNil()) {
                throw Error.argumentError(context, "invalid enum value, " + String.valueOf(obj.inspect(context)));
            }
            return (int)Util.longValue(value2);
        }
        return (int)Util.longValue(obj);
    }

    public static final long ulongValue(IRubyObject parameter) {
        return RubyNumeric.num2ulong(parameter);
    }

    public static final IRubyObject newSigned8(Ruby runtime2, byte value2) {
        return RubyFixnum.newFixnum(runtime2, value2);
    }

    public static final IRubyObject newUnsigned8(Ruby runtime2, byte value2) {
        return RubyFixnum.newFixnum(runtime2, value2 < 0 ? ((long)value2 & 0x7FL) + 128L : (long)value2);
    }

    public static final IRubyObject newSigned16(Ruby runtime2, short value2) {
        return RubyFixnum.newFixnum(runtime2, value2);
    }

    public static final IRubyObject newUnsigned16(Ruby runtime2, short value2) {
        return RubyFixnum.newFixnum(runtime2, value2 < 0 ? ((long)value2 & 0x7FFFL) + 32768L : (long)value2);
    }

    public static final IRubyObject newSigned32(Ruby runtime2, int value2) {
        return RubyFixnum.newFixnum(runtime2, value2);
    }

    public static final IRubyObject newUnsigned32(Ruby runtime2, int value2) {
        return RubyFixnum.newFixnum(runtime2, value2 < 0 ? ((long)value2 & Integer.MAX_VALUE) + 0x80000000L : (long)value2);
    }

    public static final IRubyObject newSigned64(Ruby runtime2, long value2) {
        return RubyFixnum.newFixnum(runtime2, value2);
    }

    public static final IRubyObject newUnsigned64(Ruby runtime2, long value2) {
        return value2 < 0L ? RubyBignum.newBignum(runtime2, BigInteger.valueOf(value2 & Long.MAX_VALUE).add(UINT64_BASE)) : RubyFixnum.newFixnum(runtime2, value2);
    }

    @Deprecated(since="1.4.0")
    public static final <T> T convertParameter(IRubyObject parameter, Class<T> paramClass) {
        return paramClass.cast(parameter.toJava(paramClass));
    }

    public static final ByteBuffer slice(ByteBuffer buf, int offset2) {
        ByteBuffer tmp = buf.duplicate();
        Buffers.positionBuffer((Buffer)tmp, (int)offset2);
        return tmp.slice();
    }

    public static final void checkBounds(Ruby runtime2, long size2, long off, long len) {
        if ((off | len | off + len | size2 - (off + len)) < 0L) {
            throw runtime2.newIndexError("Memory access offset=" + off + " size=" + len + " is out of bounds");
        }
    }

    public static Type findType(ThreadContext context, IRubyObject name2) {
        return context.runtime.getFFI().getTypeResolver().findType(context.runtime, name2);
    }

    public static Type findType(ThreadContext context, IRubyObject name2, IRubyObject typeMap) {
        return context.runtime.getFFI().getTypeResolver().findType(context.runtime, name2, typeMap);
    }

    public static ByteOrder parseByteOrder(Ruby runtime2, IRubyObject byte_order) {
        if (!(byte_order instanceof RubySymbol) && !(byte_order instanceof RubyString)) {
            throw Error.typeError(runtime2.getCurrentContext(), byte_order, "Symbol or String");
        }
        switch (byte_order.asJavaString()) {
            case "network": 
            case "big": {
                return ByteOrder.BIG_ENDIAN;
            }
            case "little": {
                return ByteOrder.LITTLE_ENDIAN;
            }
        }
        throw Error.argumentError(runtime2.getCurrentContext(), "unknown byte order");
    }

    public static int roundUpToPowerOfTwo(int v) {
        if (v <= 1) {
            return 1;
        }
        return Integer.MIN_VALUE >>> Integer.numberOfLeadingZeros(v - 1) << 1;
    }
}

