/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.BiFunction;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.api.Warn;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectMarshal;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.runtime.marshal.MarshalDumper;
import org.jruby.runtime.marshal.MarshalLoader;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.RubyInputStream;
import org.jruby.util.io.RubyOutputStream;

@JRubyClass(name={"Complex"}, parent="Numeric")
public class RubyComplex
extends RubyNumeric {
    private static final int[][] DIRS = new int[][]{{1, 0}, {1, 1}, {0, 1}, {-1, 1}, {-1, 0}, {-1, -1}, {0, -1}, {1, -1}};
    private IRubyObject real;
    private IRubyObject image;
    private static boolean canonicalization = false;
    private static final ObjectMarshal COMPLEX_MARSHAL = new ObjectMarshal(){

        @Deprecated(since="10.0.0.0", forRemoval=true)
        public void marshalTo(Ruby runtime2, Object obj, RubyClass type2, MarshalStream marshalStream) {
        }

        public void marshalTo(ThreadContext context, RubyOutputStream out, Object obj, RubyClass type2, MarshalDumper marshalStream) {
        }

        @Deprecated(since="10.0.0.0", forRemoval=true)
        public Object unmarshalFrom(Ruby runtime2, RubyClass type2, UnmarshalStream unmarshalStream) throws IOException {
            RubyComplex c = (RubyComplex)RubyClass.DEFAULT_OBJECT_MARSHAL.unmarshalFrom(runtime2, type2, unmarshalStream);
            c.real = c.removeInstanceVariable("@real");
            c.image = c.removeInstanceVariable("@image");
            c.setFrozen(true);
            return c;
        }

        public Object unmarshalFrom(ThreadContext context, RubyInputStream in, RubyClass type2, MarshalLoader loader) {
            RubyComplex c = (RubyComplex)RubyClass.DEFAULT_OBJECT_MARSHAL.unmarshalFrom(context, in, type2, loader);
            c.real = c.removeInstanceVariable("@real");
            c.image = c.removeInstanceVariable("@image");
            c.setFrozen(true);
            return c;
        }
    };
    private static final ByteList SEP = RubyFile.SLASH;
    private static final ByteList _eE = new ByteList(new byte[]{46, 101, 69}, false);

    public static RubyClass createComplexClass(ThreadContext context, RubyClass Numeric2) {
        return ((RubyModule)((RubyModule)((RubyModule)((RubyModule)((RubyClass)Define.defineClass(context, "Complex", Numeric2, RubyComplex::new).reifiedClass(RubyComplex.class)).marshalWith(COMPLEX_MARSHAL)).kindOf(new RubyModule.JavaClassKindOf(RubyComplex.class))).classIndex(ClassIndex.COMPLEX)).defineMethods(context, RubyComplex.class)).undefMethods(context, "<", "<=", ">", ">=", "between?", "clamp", "%", "div", "divmod", "floor", "ceil", "modulo", "remainder", "round", "step", "truncate", "positive?", "negative?").tap(c -> c.singletonClass(context).undefMethods(context, "allocate", "new")).tap(c -> c.defineConstant(context, "I", RubyComplex.convert(context, c, Convert.asFixnum(context, 0), Convert.asFixnum(context, 1))));
    }

    private RubyComplex(Ruby runtime2, RubyClass clazz, IRubyObject real2, IRubyObject image2) {
        super(runtime2, clazz);
        this.real = real2;
        this.image = image2;
    }

    private RubyComplex(Ruby runtime2, RubyClass clazz) {
        super(runtime2, clazz);
        RubyFixnum zero = RubyFixnum.zero(runtime2);
        this.real = zero;
        this.image = zero;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.COMPLEX;
    }

    private static RubyComplex newComplexInternal(Ruby runtime2, RubyClass clazz, IRubyObject x, IRubyObject y) {
        RubyComplex ret = new RubyComplex(runtime2, clazz, x, y);
        ret.setFrozen(true);
        return ret;
    }

    public static RubyComplex newComplexRaw(Ruby runtime2, IRubyObject x, IRubyObject y) {
        return RubyComplex.newComplexInternal(runtime2, runtime2.getComplex(), x, y);
    }

    public static RubyComplex newComplexRaw(Ruby runtime2, IRubyObject x) {
        return RubyComplex.newComplexRaw(runtime2, x, RubyFixnum.zero(runtime2));
    }

    public static RubyComplex newComplexRawImage(Ruby runtime2, IRubyObject image2) {
        return RubyComplex.newComplexRaw(runtime2, RubyFixnum.zero(runtime2), image2);
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext context, IRubyObject x) {
        return RubyComplex.newComplexCanonicalize(context, x, RubyFixnum.zero(context.runtime));
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.canonicalizeInternal(context, context.runtime.getComplex(), x, y);
    }

    static IRubyObject newComplexPolar(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.f_complex_polar(context, context.runtime.getComplex(), x, y);
    }

    static RubyNumeric newComplex(ThreadContext context, RubyClass clazz, IRubyObject x) {
        return RubyComplex.newComplex(context, clazz, x, RubyFixnum.zero(context.runtime));
    }

    static RubyNumeric newComplex(ThreadContext context, RubyClass clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyComplex));
        RubyNumeric ret = RubyComplex.canonicalizeInternal(context, clazz, x, y);
        ret.setFrozen(true);
        return ret;
    }

    static RubyComplex newComplexBang(ThreadContext context, RubyClass clazz, RubyNumeric x, RubyNumeric y) {
        return RubyComplex.newComplexInternal(context.runtime, clazz, x, y);
    }

    static RubyComplex newComplexBang(ThreadContext context, RubyClass clazz, RubyNumeric x) {
        return RubyComplex.newComplexBang(context, clazz, x, RubyFixnum.zero(context.runtime));
    }

    @Deprecated(since="9.2.0.0")
    public static RubyComplex newComplexBang(ThreadContext context, RubyClass clazz, IRubyObject x) {
        return RubyComplex.newComplexBang(context, clazz, (RubyNumeric)x);
    }

    IRubyObject getImage() {
        return this.image;
    }

    IRubyObject getReal() {
        return this.real;
    }

    private static IRubyObject m_cos(ThreadContext context, IRubyObject x) {
        if (!(x instanceof RubyComplex)) {
            return RubyMath.cos(context, x, x);
        }
        RubyComplex complex = (RubyComplex)x;
        return RubyComplex.newComplex(context, context.runtime.getComplex(), Numeric.f_mul(context, RubyMath.cos(context, x, complex.real), RubyMath.cosh(context, x, complex.image)), Numeric.f_mul(context, Numeric.f_negate(context, RubyMath.sin(context, x, complex.real)), RubyMath.sinh(context, x, complex.image)));
    }

    private static IRubyObject m_sin(ThreadContext context, IRubyObject x) {
        if (!(x instanceof RubyComplex)) {
            return RubyMath.sin(context, x, x);
        }
        RubyComplex complex = (RubyComplex)x;
        return RubyComplex.newComplex(context, context.runtime.getComplex(), Numeric.f_mul(context, RubyMath.sin(context, x, complex.real), RubyMath.cosh(context, x, complex.image)), Numeric.f_mul(context, RubyMath.cos(context, x, complex.real), RubyMath.sinh(context, x, complex.image)));
    }

    private static IRubyObject m_sqrt(ThreadContext context, IRubyObject x) {
        if (Numeric.f_real_p(context, x)) {
            if (!Numeric.f_negative_p(context, x)) {
                return RubyMath.sqrt(context, x, x);
            }
            return RubyComplex.newComplex(context, context.runtime.getComplex(), RubyFixnum.zero(context.runtime), RubyMath.sqrt(context, x, Numeric.f_negate(context, x)));
        }
        RubyComplex complex = (RubyComplex)x;
        if (Numeric.f_negative_p(context, complex.image)) {
            return Numeric.f_conjugate(context, RubyComplex.m_sqrt(context, Numeric.f_conjugate(context, x)));
        }
        IRubyObject a = Numeric.f_abs(context, x);
        RubyFixnum two = RubyFixnum.two(context.runtime);
        return RubyComplex.newComplex(context, context.runtime.getComplex(), RubyMath.sqrt(context, x, Numeric.f_div(context, Numeric.f_add(context, a, complex.real), two)), RubyMath.sqrt(context, x, Numeric.f_div(context, Numeric.f_sub(context, a, complex.real), two)));
    }

    @Deprecated(since="1.1.4")
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyComplex.newInstanceBang(context, recv2, args2[0]);
            }
            case 2: {
                return RubyComplex.newInstanceBang(context, recv2, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject real2) {
        if (!(real2 instanceof RubyNumeric)) {
            real2 = Numeric.f_to_i(context, real2);
        }
        return RubyComplex.newComplexInternal(context.runtime, (RubyClass)recv2, real2, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2) {
        if (!(real2 instanceof RubyNumeric)) {
            real2 = Numeric.f_to_i(context, real2);
        }
        if (!(image2 instanceof RubyNumeric)) {
            image2 = Numeric.f_to_i(context, image2);
        }
        return RubyComplex.newComplexInternal(context.runtime, (RubyClass)recv2, real2, image2);
    }

    public static void setCanonicalization(boolean canonical) {
        canonicalization = canonical;
    }

    private static boolean realCheck(ThreadContext context, IRubyObject num, boolean raise2) {
        switch (num.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: 
            case RATIONAL: {
                break;
            }
            default: {
                if (num instanceof RubyNumeric && Numeric.f_real_p(context, num)) break;
                if (raise2) {
                    throw Error.typeError(context, "not a real");
                }
                return false;
            }
        }
        return true;
    }

    private static RubyNumeric canonicalizeInternal(ThreadContext context, RubyClass clazz, IRubyObject real2, IRubyObject image2) {
        if (Numeric.f_zero_p(context, image2) && Numeric.k_exact_p(image2) && canonicalization) {
            return (RubyNumeric)real2;
        }
        boolean realComplex = real2 instanceof RubyComplex;
        boolean imageComplex = image2 instanceof RubyComplex;
        if (!realComplex && !imageComplex) {
            return RubyComplex.newComplexInternal(context.runtime, clazz, real2, image2);
        }
        if (!realComplex) {
            RubyComplex complex = (RubyComplex)image2;
            return RubyComplex.newComplexInternal(context.runtime, clazz, Numeric.f_sub(context, real2, complex.image), Numeric.f_add(context, (IRubyObject)RubyFixnum.zero(context.runtime), complex.real));
        }
        if (!imageComplex) {
            RubyComplex complex = (RubyComplex)real2;
            return RubyComplex.newComplexInternal(context.runtime, clazz, complex.real, Numeric.f_add(context, complex.image, image2));
        }
        RubyComplex complex1 = (RubyComplex)real2;
        RubyComplex complex2 = (RubyComplex)image2;
        return RubyComplex.newComplexInternal(context.runtime, clazz, Numeric.f_sub(context, complex1.real, complex2.image), Numeric.f_add(context, complex1.image, complex2.real));
    }

    @Deprecated(since="1.1.4")
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyComplex.newInstance(context, recv2, args2[0]);
            }
            case 2: {
                return RubyComplex.newInstance(context, recv2, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 1, 2);
        return null;
    }

    @Deprecated(since="9.2.0.0")
    public static IRubyObject newInstanceNew(ThreadContext context, IRubyObject recv2, IRubyObject real2) {
        return RubyComplex.newInstance(context, recv2, real2);
    }

    @JRubyMethod(name={"rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject real2) {
        return RubyComplex.newInstance(context, recv2, real2, true);
    }

    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject real2, boolean raise2) {
        if (!RubyComplex.realCheck(context, real2, raise2)) {
            return context.nil;
        }
        return RubyComplex.canonicalizeInternal(context, (RubyClass)recv2, real2, RubyFixnum.zero(context.runtime));
    }

    @Deprecated(since="9.2.0.0")
    public static IRubyObject newInstanceNew(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2) {
        return RubyComplex.newInstance(context, recv2, real2, image2);
    }

    @JRubyMethod(name={"rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2) {
        return RubyComplex.newInstance(context, recv2, real2, image2, true);
    }

    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2, boolean raise2) {
        if (!RubyComplex.realCheck(context, real2, raise2) || !RubyComplex.realCheck(context, image2, raise2)) {
            return context.nil;
        }
        return RubyComplex.canonicalizeInternal(context, (RubyClass)recv2, real2, image2);
    }

    private static IRubyObject f_complex_polar(ThreadContext context, RubyClass clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyComplex) && !(y instanceof RubyComplex));
        return RubyComplex.canonicalizeInternal(context, clazz, Numeric.f_mul(context, x, RubyComplex.m_cos(context, y)), Numeric.f_mul(context, x, RubyComplex.m_sin(context, y)));
    }

    @JRubyMethod(name={"polar"}, meta=true, required=1, optional=1, checkArity=false)
    public static IRubyObject polar(ThreadContext context, IRubyObject clazz, IRubyObject ... args2) {
        int argc = Arity.checkArgumentCount(context, args2, 1, 2);
        IRubyObject abs3 = args2[0];
        IRubyObject arg2 = argc < 2 ? RubyFixnum.zero(context.runtime) : args2[1];
        RubyComplex.realCheck(context, abs3, true);
        RubyComplex.realCheck(context, arg2, true);
        if (abs3 instanceof RubyComplex) {
            abs3 = ((RubyComplex)abs3).getReal();
        }
        if (arg2 instanceof RubyComplex) {
            arg2 = ((RubyComplex)arg2).getReal();
        }
        return RubyComplex.f_complex_polar(context, (RubyClass)clazz, abs3, arg2);
    }

    public static IRubyObject newComplexConvert(ThreadContext context, IRubyObject x) {
        return RubyComplex.newComplexConvert(context, x, RubyFixnum.zero(context.runtime));
    }

    public static IRubyObject newComplexConvert(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.convert(context, context.runtime.getComplex(), x, y);
    }

    @Deprecated(since="1.1.4")
    public static IRubyObject convert(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyComplex.convert(context, clazz, args2[0]);
            }
            case 2: {
                return RubyComplex.convert(context, clazz, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context, args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        if (arg2 instanceof RubyComplex) {
            return arg2;
        }
        return RubyComplex.convertCommon(context, recv2, arg2, null, true);
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2) {
        IRubyObject maybeKwargs = ArgsUtil.getOptionsArg(context.runtime, a2, false);
        if (maybeKwargs.isNil()) {
            return RubyComplex.convertCommon(context, recv2, a1, a2, true);
        }
        IRubyObject exception2 = ArgsUtil.extractKeywordArg(context, "exception", (RubyHash)maybeKwargs);
        if (exception2 instanceof RubyBoolean) {
            return a1 instanceof RubyComplex ? a1 : RubyComplex.convertCommon(context, recv2, a1, null, exception2.isTrue());
        }
        throw Error.argumentError(context, "'Complex': expected true or false as exception: " + String.valueOf(exception2));
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2, IRubyObject kwargs) {
        Ruby runtime2 = context.runtime;
        IRubyObject maybeKwargs = ArgsUtil.getOptionsArg(runtime2, kwargs, false);
        if (maybeKwargs.isNil()) {
            throw Error.argumentError(context, 3, 1, 2);
        }
        IRubyObject exception2 = ArgsUtil.extractKeywordArg(context, "exception", (RubyHash)maybeKwargs);
        if (exception2 instanceof RubyBoolean) {
            return RubyComplex.convertCommon(context, recv2, a1, a2, exception2.isTrue());
        }
        throw Error.argumentError(context, "'Complex': expected true or false as exception: " + String.valueOf(exception2));
    }

    public static IRubyObject convertCommon(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2, boolean raise2) {
        boolean singleArg;
        boolean bl = singleArg = a2 == null;
        if (a1 == context.nil || a2 == context.nil) {
            if (!raise2) {
                return context.nil;
            }
            throw Error.typeError(context, "can't convert nil into Complex");
        }
        if (a1 instanceof RubyString && (a1 = RubyComplex.str_to_c_strict(context, (RubyString)a1, raise2)).isNil()) {
            return a1;
        }
        if (a2 instanceof RubyString && (a2 = RubyComplex.str_to_c_strict(context, (RubyString)a2, raise2)).isNil()) {
            return a2;
        }
        if (a1 instanceof RubyComplex) {
            RubyComplex a1c = (RubyComplex)a1;
            if (Numeric.k_exact_zero_p(context, a1c.image)) {
                a1 = a1c.real;
            }
        }
        if (a2 instanceof RubyComplex) {
            RubyComplex a2c = (RubyComplex)a2;
            if (Numeric.k_exact_zero_p(context, a2c.image)) {
                a2 = a2c.real;
            }
        }
        if (a1 instanceof RubyComplex && (singleArg || Numeric.k_exact_zero_p(context, a2))) {
            return a1;
        }
        if (singleArg) {
            if (a1 instanceof RubyNumeric) {
                if (!Numeric.f_real_p(context, a1)) {
                    return a1;
                }
            } else {
                try {
                    return TypeConverter.convertToType(context, a1, context.runtime.getComplex(), RubyComplex.sites((ThreadContext)context).to_c_checked, raise2);
                }
                catch (RaiseException re) {
                    if (raise2) {
                        throw re;
                    }
                    context.clearErrorInfo();
                    return context.nil;
                }
            }
            return RubyComplex.newInstance(context, recv2, a1, raise2);
        }
        if (a1 instanceof RubyNumeric && a2 instanceof RubyNumeric && (!Numeric.f_real_p(context, a1) || !Numeric.f_real_p(context, a2))) {
            Ruby runtime2 = context.runtime;
            return Numeric.f_add(context, a1, Numeric.f_mul(context, a2, RubyComplex.newComplexBang(context, runtime2.getComplex(), RubyFixnum.zero(runtime2), RubyFixnum.one(runtime2))));
        }
        if (a2.isNil()) {
            return RubyComplex.newInstance(context, recv2, a1);
        }
        if (!(raise2 || a2 instanceof RubyInteger || a2 instanceof RubyFloat || a2 instanceof RubyRational)) {
            return context.nil;
        }
        return RubyComplex.newInstance(context, recv2, a1, a2, true);
    }

    private boolean nucomp_real_p(ThreadContext context) {
        return Numeric.f_zero_p(context, this.image);
    }

    @Override
    @JRubyMethod(name={"<=>"})
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        if (!Numeric.k_numeric_p(other)) {
            return this.coerceCmp(context, RubyComplex.sites((ThreadContext)context).op_cmp, other);
        }
        if (!this.nucomp_real_p(context)) {
            return context.nil;
        }
        if (other instanceof RubyComplex) {
            if (((RubyComplex)other).nucomp_real_p(context)) {
                return this.real.callMethod(context, "<=>", ((RubyComplex)other).real);
            }
        } else {
            if (Numeric.f_real_p(context, other)) {
                return this.real.callMethod(context, "<=>", other);
            }
            return this.coerceCmp(context, RubyComplex.sites((ThreadContext)context).op_cmp, other);
        }
        return context.nil;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject real() {
        return this.real(this.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"real"})
    public IRubyObject real(ThreadContext context) {
        return this.real;
    }

    @Deprecated(since="10.0.0.0")
    public IRubyObject image() {
        return this.image(this.getCurrentContext());
    }

    @Override
    @JRubyMethod(name={"imaginary", "imag"})
    public IRubyObject image(ThreadContext context) {
        return this.image;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject negate(ThreadContext context) {
        return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_negate(context, this.real), Numeric.f_negate(context, this.image));
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_add(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_add(context, this.real, otherComplex.real), Numeric.f_add(context, this.image, otherComplex.image));
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, (RubyNumeric)other)) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_add(context, this.real, other), this.image);
        }
        return this.coerceBin(context, RubyComplex.sites((ThreadContext)context).op_plus, other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_sub(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, this.real, otherComplex.real), Numeric.f_sub(context, this.image, otherComplex.image));
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, (RubyNumeric)other)) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, this.real, other), this.image);
        }
        return this.coerceBin(context, RubyComplex.sites((ThreadContext)context).op_minus, other);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            boolean arzero = Numeric.f_zero_p(context, this.real);
            boolean aizero = Numeric.f_zero_p(context, this.image);
            boolean brzero = Numeric.f_zero_p(context, otherComplex.real);
            boolean bizero = Numeric.f_zero_p(context, otherComplex.image);
            IRubyObject realp = Numeric.f_sub(context, Numeric.safe_mul(context, this.real, otherComplex.real, arzero, brzero), Numeric.safe_mul(context, this.image, otherComplex.image, aizero, bizero));
            IRubyObject imagep = Numeric.f_add(context, Numeric.safe_mul(context, this.real, otherComplex.image, arzero, bizero), Numeric.safe_mul(context, this.image, otherComplex.real, aizero, brzero));
            return RubyComplex.newComplex(context, this.getMetaClass(), realp, imagep);
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, (RubyNumeric)other)) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_mul(context, this.real, other), Numeric.f_mul(context, this.image, other));
        }
        return this.coerceBin(context, RubyComplex.sites((ThreadContext)context).op_times, other);
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        return RubyComplex.f_divide(context, this, other, (a, b2) -> Numeric.f_quo(context, a, b2), RubyComplex.sites((ThreadContext)context).op_quo);
    }

    public static IRubyObject f_divide(ThreadContext context, RubyComplex self2, IRubyObject other, BiFunction<IRubyObject, IRubyObject, IRubyObject> func, CallSite id) {
        Ruby runtime2 = context.runtime;
        IRubyObject selfReal = self2.real;
        IRubyObject selfImage = self2.image;
        if (other instanceof RubyComplex) {
            IRubyObject y;
            IRubyObject x;
            boolean flo;
            RubyComplex otherComplex = (RubyComplex)other;
            IRubyObject otherReal = otherComplex.real;
            IRubyObject otherImage = otherComplex.image;
            boolean bl = flo = selfReal instanceof RubyFloat || selfImage instanceof RubyFloat || otherReal instanceof RubyFloat || otherImage instanceof RubyFloat;
            if (Numeric.f_gt_p(context, Numeric.f_abs(context, otherReal), Numeric.f_abs(context, otherImage))) {
                IRubyObject r = func.apply(otherImage, otherReal);
                IRubyObject n = Numeric.f_mul(context, otherReal, Numeric.f_add(context, (IRubyObject)RubyFixnum.one(runtime2), Numeric.f_mul(context, r, r)));
                x = func.apply(Numeric.f_add(context, selfReal, Numeric.f_mul(context, selfImage, r)), n);
                y = func.apply(Numeric.f_sub(context, selfImage, Numeric.f_mul(context, selfReal, r)), n);
            } else {
                IRubyObject r = func.apply(otherReal, otherImage);
                IRubyObject n = Numeric.f_mul(context, otherImage, Numeric.f_add(context, (IRubyObject)RubyFixnum.one(runtime2), Numeric.f_mul(context, r, r)));
                x = func.apply(Numeric.f_add(context, Numeric.f_mul(context, selfReal, r), selfImage), n);
                y = func.apply(Numeric.f_sub(context, Numeric.f_mul(context, selfImage, r), selfReal), n);
            }
            if (!flo) {
                x = RubyRational.rationalCanonicalize(context, x);
                y = RubyRational.rationalCanonicalize(context, y);
            }
            return RubyComplex.newComplex(context, self2.getMetaClass(), x, y);
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other)) {
            IRubyObject x = RubyRational.rationalCanonicalize(context, func.apply(selfReal, other));
            IRubyObject y = RubyRational.rationalCanonicalize(context, func.apply(selfImage, other));
            return RubyComplex.newComplex(context, self2.getMetaClass(), x, y);
        }
        return self2.coerceBin(context, id, other);
    }

    @Override
    @JRubyMethod(name={"fdiv"})
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        CallSite fdiv2 = RubyComplex.sites((ThreadContext)context).fdiv;
        return RubyComplex.f_divide(context, this, other, (a, b2) -> fdiv2.call(context, (IRubyObject)a, (IRubyObject)a, (IRubyObject)b2), fdiv2);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext context, IRubyObject other) {
        RubyRational otherRational;
        if (other instanceof RubyNumeric && Numeric.k_exact_zero_p(context, other)) {
            return RubyComplex.newComplexBang(context, this.getMetaClass(), Convert.asFixnum(context, 1));
        }
        if (other instanceof RubyRational && Numeric.f_one_p(context, (otherRational = (RubyRational)other).getDenominator())) {
            other = Numeric.f_numerator(context, other);
        }
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (Numeric.k_exact_zero_p(context, otherComplex.image)) {
                other = otherComplex.real;
            }
        }
        if (other == RubyFixnum.one(context.runtime)) {
            return RubyComplex.newComplex(context, this.metaClass, this.real, this.image);
        }
        IRubyObject result2 = this.complexPowForSpecialAngle(context, other);
        if (result2 != UNDEF) {
            return result2;
        }
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            IRubyObject otherReal = otherComplex.real;
            IRubyObject otherImage = otherComplex.image;
            IRubyObject r = Numeric.f_abs(context, this);
            IRubyObject theta = Numeric.f_arg(context, this);
            RubyFloat nr = RubyMath.exp(context, Numeric.f_sub(context, Numeric.f_mul(context, otherReal, RubyMath.log(context, r)), Numeric.f_mul(context, otherImage, theta)));
            IRubyObject ntheta = Numeric.f_add(context, Numeric.f_mul(context, theta, otherReal), Numeric.f_mul(context, otherImage, RubyMath.log(context, r)));
            return RubyComplex.f_complex_polar(context, this.getMetaClass(), nr, ntheta);
        }
        if (other instanceof RubyFixnum) {
            RubyFixnum otherFixnum = (RubyFixnum)other;
            long n = otherFixnum.getValue();
            if (n == 0L) {
                return RubyComplex.newInstance(context, (IRubyObject)this.getMetaClass(), (IRubyObject)Convert.asFixnum(context, 1), Convert.asFixnum(context, 0));
            }
            RubyComplex self2 = this;
            if (n < 0L) {
                self2 = (RubyComplex)Numeric.f_reciprocal(context, self2);
                other = otherFixnum.op_uminus(context);
                n = -n;
            }
            IRubyObject selfReal = self2.real;
            IRubyObject selfImage = self2.image;
            IRubyObject xr = selfReal;
            IRubyObject xi = selfImage;
            IRubyObject zr = xr;
            IRubyObject zi = xi;
            if (Numeric.f_zero_p(context, xi)) {
                zr = Numeric.num_pow(context, zr, other);
            } else if (Numeric.f_zero_p(context, xr)) {
                zi = Numeric.num_pow(context, zi, other);
                if ((n & 2L) != 0L) {
                    zi = Numeric.f_negate(context, zi);
                }
                if ((n & 1L) == 0L) {
                    IRubyObject tmp = zr;
                    zr = zi;
                    zi = tmp;
                }
            } else {
                while (--n != 0L) {
                    long r = n % 2L;
                    while (r == 0L) {
                        IRubyObject tmp = Numeric.f_sub(context, Numeric.f_mul(context, xr, xr), Numeric.f_mul(context, xi, xi));
                        xi = Numeric.f_mul(context, Numeric.f_mul(context, (IRubyObject)Convert.asFixnum(context, 2), xr), xi);
                        xr = tmp;
                        long q = n / 2L;
                        r = n % 2L;
                        n = q;
                    }
                    IRubyObject areal = zr;
                    IRubyObject aimag = zi;
                    IRubyObject breal = xr;
                    IRubyObject bimag = xi;
                    boolean arzero = Numeric.f_zero_p(context, areal);
                    boolean aizero = Numeric.f_zero_p(context, aimag);
                    boolean brzero = Numeric.f_zero_p(context, breal);
                    boolean bizero = Numeric.f_zero_p(context, bimag);
                    zr = Numeric.f_sub(context, Numeric.safe_mul(context, areal, breal, arzero, brzero), Numeric.safe_mul(context, aimag, bimag, aizero, bizero));
                    zi = Numeric.f_add(context, Numeric.safe_mul(context, areal, bimag, arzero, bizero), Numeric.safe_mul(context, aimag, breal, aizero, brzero));
                }
            }
            return RubyComplex.newInstance(context, (IRubyObject)this.getMetaClass(), zr, zi);
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other)) {
            if (other instanceof RubyBignum) {
                Warn.warn(context, "in a**b, b may be too big");
            }
            IRubyObject r = Numeric.f_abs(context, this);
            IRubyObject theta = Numeric.f_arg(context, this);
            return RubyComplex.f_complex_polar(context, this.getMetaClass(), Numeric.f_expt(context, r, other), Numeric.f_mul(context, theta, other));
        }
        return this.coerceBin(context, RubyComplex.sites((ThreadContext)context).op_exp, other);
    }

    private IRubyObject complexPowForSpecialAngle(ThreadContext context, IRubyObject other) {
        IRubyObject zx;
        int dir;
        if (!(other instanceof RubyInteger)) {
            return UNDEF;
        }
        RubyInteger integer = (RubyInteger)other;
        IRubyObject x = UNDEF;
        if (Numeric.f_zero_p(context, this.image)) {
            x = this.real;
            dir = 0;
        } else if (Numeric.f_zero_p(context, this.real)) {
            x = this.image;
            dir = 2;
        } else if (Numeric.f_eqeq_p(context, this.real, this.image)) {
            x = this.real;
            dir = 1;
        } else if (Numeric.f_eqeq_p(context, this.real, Numeric.f_negate(context, this.image))) {
            x = this.image;
            dir = 3;
        } else {
            dir = 0;
        }
        if (x == UNDEF) {
            return x;
        }
        if (Numeric.f_negative_p(context, x)) {
            x = Numeric.f_negate(context, x);
            dir += 4;
        }
        if (dir % 2 == 0) {
            zx = Numeric.num_pow(context, x, other);
        } else {
            RubyFixnum two = RubyFixnum.two(context.runtime);
            zx = Numeric.num_pow(context, RubyComplex.sites((ThreadContext)context).op_times.call(context, (IRubyObject)this, two.op_mul(context, x), x), integer.op_div(context, two));
            if (Numeric.f_odd_p(context, other)) {
                zx = RubyComplex.sites((ThreadContext)context).op_times.call(context, (IRubyObject)this, zx, x);
            }
        }
        int z_dir = Convert.toInt(context, ((RubyInteger)Convert.asFixnum(context, dir).op_mul(context, other)).modulo(context, 8L));
        IRubyObject zr = context.fals;
        IRubyObject zi = context.fals;
        switch (DIRS[z_dir][0]) {
            case 0: {
                zr = RubyComplex.zero_for(context, zx);
                break;
            }
            case 1: {
                zr = zx;
                break;
            }
            case -1: {
                zr = Numeric.f_negate(context, zx);
            }
        }
        switch (DIRS[z_dir][1]) {
            case 0: {
                zi = RubyComplex.zero_for(context, zx);
                break;
            }
            case 1: {
                zi = zx;
                break;
            }
            case -1: {
                zi = Numeric.f_negate(context, zx);
            }
        }
        return RubyComplex.newComplex(context, this.metaClass, zr, zi);
    }

    private static IRubyObject zero_for(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFloat) {
            return Convert.asFloat(context, 0L);
        }
        if (x instanceof RubyRational) {
            return Create.newRational(context, 0L, 1L);
        }
        return Convert.asFixnum(context, 0);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        RubyNumeric num;
        if (other instanceof RubyComplex) {
            RubyComplex comp = (RubyComplex)other;
            return Convert.asBoolean(context, Numeric.f_equal(context, this.real, comp.real).isTrue() && Numeric.f_equal(context, this.image, comp.image).isTrue());
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, num = (RubyNumeric)other)) {
            return Convert.asBoolean(context, Numeric.f_equal(context, this.real, num).isTrue() && Numeric.f_zero_p(context, this.image));
        }
        return Numeric.f_equal(context, other, this);
    }

    @Override
    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            return Create.newArray(context, other, (IRubyObject)this);
        }
        if (other instanceof RubyNumeric) {
            RubyNumeric numeric = (RubyNumeric)other;
            if (Numeric.f_real_p(context, other)) {
                return Create.newArray(context, (IRubyObject)RubyComplex.newComplexBang(context, this.getMetaClass(), numeric), (IRubyObject)this);
            }
        }
        Ruby runtime2 = context.runtime;
        throw Error.typeError(context, RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, (RubyModule)other.getMetaClass()), " can't be coerced into ", RubyStringBuilder.types(runtime2, (RubyModule)this.getMetaClass())));
    }

    @Override
    @JRubyMethod(name={"abs", "magnitude"})
    public IRubyObject abs(ThreadContext context) {
        return RubyMath.hypot(context, this, this.real, this.image);
    }

    @Override
    @JRubyMethod(name={"abs2"})
    public IRubyObject abs2(ThreadContext context) {
        return Numeric.f_add(context, Numeric.f_mul(context, this.real, this.real), Numeric.f_mul(context, this.image, this.image));
    }

    @Override
    @JRubyMethod(name={"arg", "angle", "phase"})
    public IRubyObject arg(ThreadContext context) {
        return RubyMath.atan2(context, this, this.image, this.real);
    }

    @Override
    @JRubyMethod(name={"rectangular", "rect"})
    public IRubyObject rect(ThreadContext context) {
        return Create.newArray(context, this.real, this.image);
    }

    @Override
    @JRubyMethod(name={"polar"})
    public IRubyObject polar(ThreadContext context) {
        return Create.newArray(context, Numeric.f_abs(context, this), Numeric.f_arg(context, this));
    }

    @Override
    @JRubyMethod(name={"conjugate", "conj", "~"})
    public IRubyObject conjugate(ThreadContext context) {
        return RubyComplex.newComplex(context, this.getMetaClass(), this.real, Numeric.f_negate(context, this.image));
    }

    @Override
    @JRubyMethod(name={"real?"})
    public IRubyObject real_p(ThreadContext context) {
        return context.fals;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    public IRubyObject complex_p(ThreadContext context) {
        return context.tru;
    }

    public IRubyObject exact_p(ThreadContext context) {
        return Numeric.f_exact_p(context, this.real) && Numeric.f_exact_p(context, this.image) ? context.tru : context.fals;
    }

    public IRubyObject inexact_p(ThreadContext context) {
        return this.exact_p(context) == context.tru ? context.fals : context.tru;
    }

    @JRubyMethod(name={"denominator"})
    public IRubyObject demoninator(ThreadContext context) {
        return Numeric.f_lcm(context, Numeric.f_denominator(context, this.real), Numeric.f_denominator(context, this.image));
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        IRubyObject cd = this.callMethod(context, "denominator");
        return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_mul(context, Numeric.f_numerator(context, this.real), Numeric.f_div(context, cd, Numeric.f_denominator(context, this.real))), Numeric.f_mul(context, Numeric.f_numerator(context, this.image), Numeric.f_div(context, cd, Numeric.f_denominator(context, this.image))));
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        long realHash = Convert.toLong(context, Helpers.invokedynamic(context, this.real, MethodNames.HASH));
        long imageHash = Convert.toLong(context, Helpers.invokedynamic(context, this.image, MethodNames.HASH));
        byte[] bytes2 = ByteBuffer.allocate(16).putLong(realHash).putLong(imageHash).array();
        return Convert.asFixnum(context, Helpers.multAndMix(context.runtime.getHashSeedK0(), Arrays.hashCode(bytes2)));
    }

    @Override
    public int hashCode() {
        int n;
        ThreadContext context = this.getRuntime().getCurrentContext();
        RubyFixnum hash2 = this.hash(context);
        if (hash2 instanceof RubyFixnum) {
            RubyFixnum fixnum = hash2;
            n = (int)fixnum.getValue();
        } else {
            n = RubyComplex.nonFixnumHashCode(context, hash2);
        }
        return n;
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        return Convert.asBoolean(context, this.equals(context, other));
    }

    private boolean equals(ThreadContext context, Object other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (this.real.getMetaClass() == otherComplex.real.getMetaClass() && this.image.getMetaClass() == otherComplex.image.getMetaClass() && Numeric.f_equal(context, this, otherComplex).isTrue()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        return this.equals(this.getRuntime().getCurrentContext(), other);
    }

    private static boolean signbit(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFloat) {
            double value2 = ((RubyFloat)x).value;
            return !Double.isNaN(value2) && Double.doubleToLongBits(value2) < 0L;
        }
        return Numeric.f_negative_p(context, x);
    }

    private static boolean tpositive_p(ThreadContext context, IRubyObject x) {
        return !RubyComplex.signbit(context, x);
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        boolean impos = RubyComplex.tpositive_p(context, this.image);
        RubyString str = Numeric.f_to_s(context, this.real).convertToString();
        str.cat(impos ? (byte)43 : 45);
        str.cat(Numeric.f_to_s(context, Numeric.f_abs(context, this.image)).convertToString().getByteList());
        if (!RubyComplex.lastCharDigit(str)) {
            str.cat((byte)42);
        }
        str.cat((byte)105);
        return str;
    }

    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        boolean impos = RubyComplex.tpositive_p(context, this.image);
        RubyString str = context.runtime.newString();
        str.cat((byte)40);
        str.cat(Numeric.f_inspect(context, this.real).convertToString().getByteList());
        str.cat(impos ? (byte)43 : 45);
        str.cat(Numeric.f_inspect(context, Numeric.f_abs(context, this.image)).convertToString().getByteList());
        if (!RubyComplex.lastCharDigit(str)) {
            str.cat((byte)42);
        }
        str.cat((byte)105);
        str.cat((byte)41);
        return str;
    }

    private static boolean lastCharDigit(RubyString str) {
        ByteList bytes2 = str.getByteList();
        return ASCIIEncoding.INSTANCE.isDigit((int)bytes2.getUnsafeBytes()[bytes2.getBegin() + bytes2.getRealSize() - 1]);
    }

    @JRubyMethod(name={"marshal_dump"}, visibility=Visibility.PRIVATE)
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyArray<?> dump2 = Create.newArray(context, this.real, this.image);
        if (this.hasVariables()) {
            dump2.syncVariables(this);
        }
        return dump2;
    }

    @JRubyMethod(name={"marshal_load"}, visibility=Visibility.PRIVATE)
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        this.real = load2.size() > 0 ? load2.eltInternal(0) : context.nil;
        IRubyObject iRubyObject = this.image = load2.size() > 1 ? load2.eltInternal(1) : context.nil;
        if (load2.hasVariables()) {
            this.syncVariables(load2);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"to_c"})
    public IRubyObject to_c(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(ThreadContext context) {
        this.checkValidRational(context, "Integer");
        return Numeric.f_to_i(context, this.real);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        this.checkValidRational(context, "Float");
        return Numeric.f_to_f(context, this.real);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        IRubyObject imag;
        RubyFloat imageFloat;
        IRubyObject iRubyObject = this.image;
        if (!(iRubyObject instanceof RubyFloat && (imageFloat = (RubyFloat)iRubyObject).isZero(context) || Numeric.k_exact_zero_p(context, this.image) || !(imag = Convert.checkToRational(context, this.image)).isNil() && Numeric.k_exact_zero_p(context, imag))) {
            throw Error.rangeError(context, "can't convert " + String.valueOf(this) + " into Rational");
        }
        return Numeric.f_to_r(context, this.real);
    }

    @JRubyMethod(name={"rationalize"}, optional=1, checkArity=false)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        this.checkValidRational(context, "Rational");
        return this.real.callMethod(context, "rationalize", args2);
    }

    private void checkValidRational(ThreadContext context, String type2) {
        if (!Numeric.k_exact_zero_p(context, this.image)) {
            throw Error.rangeError(context, "can't convert " + String.valueOf(Numeric.f_to_s(context, this).convertToString()) + " into " + type2);
        }
    }

    @Override
    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p(ThreadContext context) {
        return this.checkFinite(context, this.real) && this.checkFinite(context, this.image) ? context.tru : context.fals;
    }

    public boolean checkFinite(ThreadContext context, IRubyObject value2) {
        boolean bl;
        if (value2 instanceof RubyInteger || value2 instanceof RubyRational) {
            return true;
        }
        if (value2 instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)value2;
            bl = flote.finite_p(context).isTrue();
        } else {
            bl = RubyComplex.sites((ThreadContext)context).finite.call(context, value2, value2).isTrue();
        }
        return bl;
    }

    @Override
    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p(ThreadContext context) {
        return this.checkInfinite(context, this.real).isNil() && this.checkInfinite(context, this.image).isNil() ? context.nil : Convert.asFixnum(context, 1);
    }

    public IRubyObject checkInfinite(ThreadContext context, IRubyObject value2) {
        IRubyObject iRubyObject;
        if (value2 instanceof RubyInteger || value2 instanceof RubyRational) {
            return context.nil;
        }
        if (value2 instanceof RubyFloat) {
            RubyFloat flote = (RubyFloat)value2;
            iRubyObject = flote.infinite_p(context);
        } else {
            iRubyObject = RubyComplex.sites((ThreadContext)context).infinite.call(context, value2, value2);
        }
        return iRubyObject;
    }

    static IRubyObject[] str_to_c_internal(ThreadContext context, RubyString str) {
        IRubyObject t;
        RubyMatchData match2;
        IRubyObject re;
        Ruby runtime2 = context.runtime;
        IRubyObject nil = context.nil;
        ByteList bytes2 = str.getByteList();
        if (bytes2.getRealSize() == 0) {
            return new IRubyObject[]{nil, str};
        }
        IRubyObject si = re = nil;
        IRubyObject sr = re;
        boolean po = false;
        IRubyObject m = RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.comp_pat0).match_m(context, (IRubyObject)str, false);
        if (m != nil) {
            match2 = (RubyMatchData)m;
            sr = match2.at(context, 1);
            si = match2.at(context, 2);
            re = match2.post_match(context);
            po = true;
        }
        if (m == nil && (m = RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.comp_pat1).match_m(context, (IRubyObject)str, false)) != nil) {
            match2 = (RubyMatchData)m;
            sr = nil;
            si = match2.at(context, 1);
            if (si == nil) {
                si = runtime2.newString();
            }
            if ((t = match2.at(context, 2)) == nil) {
                t = runtime2.newString(RubyInteger.singleCharByteList((byte)49));
            }
            si = si.convertToString();
            ((RubyString)si).cat(t.convertToString());
            re = match2.post_match(context);
            po = false;
        }
        if (m == nil) {
            m = RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.comp_pat2).match_m(context, (IRubyObject)str, false);
            if (m == nil) {
                return new IRubyObject[]{context.nil, str};
            }
            match2 = (RubyMatchData)m;
            sr = match2.at(context, 1);
            if (match2.at(context, 2) == nil) {
                si = context.nil;
            } else {
                si = match2.at(context, 3);
                t = match2.at(context, 4);
                if (t == nil) {
                    t = runtime2.newString(RubyInteger.singleCharByteList((byte)49));
                }
                si = si.convertToString();
                ((RubyString)si).cat(t.convertToString());
            }
            re = match2.post_match(context);
            po = false;
        }
        RubyFixnum zero = RubyFixnum.zero(runtime2);
        try {
            RubyNumeric r = RubyComplex.convertString(context, sr, zero);
            RubyNumeric i2 = RubyComplex.convertString(context, si, zero);
            return new IRubyObject[]{po ? RubyComplex.newComplexPolar(context, r, i2) : RubyComplex.newComplexCanonicalize(context, r, i2), re};
        }
        catch (RaiseException exception2) {
            context.setErrorInfo(context.nil);
            return new IRubyObject[]{context.nil, str};
        }
    }

    private static RubyNumeric convertString(ThreadContext context, IRubyObject s2, RubyFixnum zero) {
        if (s2 == context.nil) {
            return zero;
        }
        if (s2.callMethod(context, "include?", Create.newSharedString(context, SEP)).isTrue()) {
            return (RubyNumeric)Numeric.f_to_r(context, s2);
        }
        if (Numeric.f_gt_p(context, s2.callMethod(context, "count", Create.newSharedString(context, _eE)), (IRubyObject)zero)) {
            return (RubyNumeric)Numeric.f_to_f(context, s2);
        }
        return (RubyNumeric)((RubyString)s2).stringToInum(10, true);
    }

    private static IRubyObject str_to_c_strict(ThreadContext context, RubyString str, boolean raise2) {
        str.verifyAsciiCompatible();
        if (str.hasNul()) {
            if (!raise2) {
                return context.nil;
            }
            throw Error.argumentError(context, "string contains null byte");
        }
        IRubyObject[] ary = RubyComplex.str_to_c_internal(context, str);
        if (ary[0] == context.nil || ary[1].convertToString().getByteList().length() > 0) {
            if (raise2) {
                throw Error.argumentError(context, RubyStringBuilder.str(context.runtime, "invalid value for convert(): ", str.callMethod(context, "inspect")));
            }
            return context.nil;
        }
        return ary[0];
    }

    private static JavaSites.ComplexSites sites(ThreadContext context) {
        return context.sites.Complex;
    }
}

