/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.text.DateFormatSymbols;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.JulianChronology;
import org.jruby.Ruby;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.api.Convert;
import org.jruby.api.Error;
import org.jruby.lexer.StrftimeLexer;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;
import org.jruby.util.RubyTimeOutputFormatter;

public class RubyDateFormatter {
    private static final ByteList AM = new ByteList(new byte[]{97, 109});
    private static final ByteList PM = new ByteList(new byte[]{112, 109});
    private static final ByteList CAPITAL_AM = new ByteList(new byte[]{65, 77});
    private static final ByteList CAPITAL_PM = new ByteList(new byte[]{80, 77});
    private static final String[] FORMAT_MONTHS;
    private static final String[] FORMAT_SHORT_MONTHS;
    private static final String[] FORMAT_WEEKDAYS;
    private static final String[] FORMAT_SHORT_WEEKDAYS;
    private static final Token[] CONVERSION2TOKEN;
    private final Ruby runtime;
    private final StrftimeLexer lexer;
    public static Token COLON_TOKEN;
    public static Token DASH_TOKEN;
    public static Token DOT_TOKEN;
    public static Token SLASH_TOKEN;
    private Token[] compiledPattern = new Token[256];
    private int compiledPatternLength = 0;
    private Encoding patternEncoding;

    public RubyDateFormatter(ThreadContext context) {
        this.runtime = context.runtime;
        this.lexer = new StrftimeLexer();
    }

    private void addToPattern(String str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            char c = str.charAt(i2);
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z') {
                this.addToken(Token.format(c));
                continue;
            }
            this.addToken(Token.str(new ByteList(new byte[]{(byte)c})));
        }
    }

    private void addToken(Token token2) {
        if (this.compiledPatternLength >= this.compiledPattern.length) {
            this.growTokens();
        }
        this.compiledPattern[this.compiledPatternLength] = token2;
        ++this.compiledPatternLength;
    }

    private void growTokens() {
        Token[] newCompiledPattern = new Token[this.compiledPattern.length * 2];
        System.arraycopy(this.compiledPattern, 0, newCompiledPattern, 0, this.compiledPattern.length);
        this.compiledPattern = newCompiledPattern;
    }

    public void compilePattern(ByteList pattern, boolean dateLibrary) {
        Token token2;
        this.compiledPatternLength = 0;
        this.patternEncoding = pattern.getEncoding();
        if (!this.patternEncoding.isAsciiCompatible()) {
            throw Error.argumentError(this.runtime.getCurrentContext(), "format should have ASCII compatible encoding");
        }
        this.lexer.reset(pattern);
        RubyTimeOutputFormatter formatter = null;
        block17: while ((token2 = this.lexer.yylex()) != null) {
            if (token2.format == Format.FORMAT_OUTPUT) {
                formatter = (RubyTimeOutputFormatter)token2.data;
                continue;
            }
            if (token2.format != Format.FORMAT_SPECIAL) {
                if (formatter != null) {
                    this.addToken(formatter);
                    formatter = null;
                }
                this.addToken(token2);
                continue;
            }
            char c = ((Character)token2.data).charValue();
            if (formatter != null) {
                switch (c) {
                    default: {
                        if (formatter.flags == ByteList.EMPTY_BYTELIST || formatter.flags == null) {
                            this.addToken(new RubyTimeOutputFormatter(CommonByteLists.UNDERSCORE, formatter.width));
                            break;
                        }
                    }
                    case '+': 
                    case 'Q': {
                        this.addToken(formatter);
                    }
                }
                formatter = null;
            }
            switch (c) {
                case 'c': {
                    this.addToPattern("a b e H:M:S Y");
                    continue block17;
                }
                case 'D': 
                case 'x': {
                    this.addToPattern("m/d/y");
                    continue block17;
                }
                case 'F': {
                    this.addToPattern("Y-m-d");
                    continue block17;
                }
                case 'n': {
                    this.addToken(Token.str(CommonByteLists.NEWLINE));
                    continue block17;
                }
                case 'Q': {
                    if (dateLibrary) {
                        this.addToken(new Token(Format.FORMAT_MICROSEC_EPOCH));
                        continue block17;
                    }
                    this.addToken(Token.str(CommonByteLists.PERCENT_Q));
                    continue block17;
                }
                case 'R': {
                    this.addToPattern("H:M");
                    continue block17;
                }
                case 'r': {
                    this.addToPattern("I:M:S p");
                    continue block17;
                }
                case 'T': 
                case 'X': {
                    this.addToPattern("H:M:S");
                    continue block17;
                }
                case 't': {
                    this.addToken(Token.str(CommonByteLists.TAB));
                    continue block17;
                }
                case 'v': {
                    this.addToPattern("e-");
                    if (!dateLibrary) {
                        this.addToken(Token.formatter(new RubyTimeOutputFormatter(CommonByteLists.CARET, 0)));
                    }
                    this.addToPattern("^b-Y");
                    continue block17;
                }
                case 'Z': {
                    if (dateLibrary) {
                        this.addToken(Token.zoneOffsetColons(1));
                        continue block17;
                    }
                    this.addToken(new Token(Format.FORMAT_ZONE_ID));
                    continue block17;
                }
                case '+': {
                    if (!dateLibrary) {
                        this.addToken(Token.str(CommonByteLists.PERCENT_PLUS));
                        continue block17;
                    }
                    this.addToPattern("a b e H:M:S ");
                    this.addToken(Token.zoneOffsetColons(1));
                    this.addToPattern(" Y");
                    continue block17;
                }
            }
            throw new AssertionError((Object)("Unknown special char: " + c));
        }
        if (formatter != null) {
            this.addToken(formatter);
        }
    }

    public RubyString compileAndFormat(ByteList pattern, boolean dateLibrary, DateTime dt, long nsec2, RubyNumeric sub_millis) {
        this.compilePattern(pattern, dateLibrary);
        RubyString out = this.format(this.compiledPattern, dt, nsec2, sub_millis);
        return out;
    }

    public RubyString format(Token[] compiledPattern, DateTime dt, long nsec2, RubyNumeric sub_millis) {
        return this.runtime.newString(this.formatToByteList(compiledPattern, dt, nsec2, sub_millis));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ByteList formatToByteList(Token[] compiledPattern, DateTime dt, long nsec2, RubyNumeric sub_millis) {
        RubyTimeOutputFormatter formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
        ByteList output = new ByteList(27, this.patternEncoding);
        ByteList tmp = new ByteList(48);
        boolean toUpper = false;
        int ti = 0;
        while (true) {
            block52: {
                block51: {
                    if (ti >= this.compiledPatternLength) {
                        return output;
                    }
                    Token token2 = compiledPattern[ti];
                    CharSequence data2 = null;
                    long value2 = 0L;
                    FieldType type2 = FieldType.TEXT;
                    Format format = token2.getFormat();
                    switch (format.ordinal()) {
                        case 1: {
                            formatter = (RubyTimeOutputFormatter)token2.getData();
                            break block52;
                        }
                        case 0: {
                            data2 = (ByteList)token2.getData();
                            if (!"^".equals(data2.toString())) break;
                            toUpper = true;
                            break block52;
                        }
                        case 3: {
                            int v = (dt.getDayOfWeek() + 1) % 8;
                            data2 = FORMAT_WEEKDAYS[v == 0 ? 1 : v];
                            break;
                        }
                        case 4: {
                            int v = (dt.getDayOfWeek() + 1) % 8;
                            data2 = FORMAT_SHORT_WEEKDAYS[v == 0 ? 1 : v];
                            break;
                        }
                        case 5: {
                            data2 = FORMAT_MONTHS[dt.getMonthOfYear() - 1];
                            break;
                        }
                        case 6: {
                            data2 = FORMAT_SHORT_MONTHS[dt.getMonthOfYear() - 1];
                            break;
                        }
                        case 8: {
                            type2 = FieldType.NUMERIC2;
                            value2 = dt.getDayOfMonth();
                            break;
                        }
                        case 9: {
                            type2 = FieldType.NUMERIC2BLANK;
                            value2 = dt.getDayOfMonth();
                            break;
                        }
                        case 12: {
                            type2 = FieldType.NUMERIC2;
                            value2 = dt.getHourOfDay();
                            break;
                        }
                        case 15: {
                            type2 = FieldType.NUMERIC2BLANK;
                            value2 = dt.getHourOfDay();
                            break;
                        }
                        case 13: 
                        case 17: {
                            value2 = dt.getHourOfDay();
                            if (value2 == 0L) {
                                value2 = 12L;
                            } else if (value2 > 12L) {
                                value2 -= 12L;
                            }
                            type2 = format == Format.FORMAT_HOUR_M ? FieldType.NUMERIC2 : FieldType.NUMERIC2BLANK;
                            break;
                        }
                        case 14: {
                            type2 = FieldType.NUMERIC3;
                            value2 = dt.getDayOfYear();
                            break;
                        }
                        case 18: {
                            type2 = FieldType.NUMERIC2;
                            value2 = dt.getMinuteOfHour();
                            break;
                        }
                        case 19: {
                            type2 = FieldType.NUMERIC2;
                            value2 = dt.getMonthOfYear();
                            break;
                        }
                        case 22: {
                            data2 = dt.getHourOfDay() < 12 ? CAPITAL_AM : CAPITAL_PM;
                            break;
                        }
                        case 21: {
                            data2 = dt.getHourOfDay() < 12 ? AM : PM;
                            break;
                        }
                        case 23: {
                            type2 = FieldType.NUMERIC2;
                            value2 = dt.getSecondOfMinute();
                            break;
                        }
                        case 28: {
                            type2 = FieldType.NUMERIC2;
                            value2 = RubyDateFormatter.formatWeekYear(dt, 2);
                            break;
                        }
                        case 25: {
                            type2 = FieldType.NUMERIC2;
                            value2 = RubyDateFormatter.formatWeekYear(dt, 1);
                            break;
                        }
                        case 29: {
                            type2 = FieldType.NUMERIC;
                            value2 = dt.getDayOfWeek() % 7;
                            break;
                        }
                        case 26: {
                            type2 = FieldType.NUMERIC;
                            value2 = dt.getDayOfWeek();
                            break;
                        }
                        case 30: {
                            value2 = RubyDateFormatter.year(dt, dt.getYear());
                            type2 = value2 >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                            break;
                        }
                        case 31: {
                            type2 = FieldType.NUMERIC2;
                            value2 = RubyDateFormatter.year(dt, dt.getYear()) % 100;
                            break;
                        }
                        case 32: {
                            value2 = dt.getZone().getOffset(dt.getMillis()) / 1000;
                            int colons = (Integer)token2.getData();
                            data2 = RubyDateFormatter.formatZone(colons, (int)value2, formatter);
                            break;
                        }
                        case 33: {
                            data2 = RubyTime.getRubyTimeZoneName(this.runtime.getCurrentContext(), dt);
                            break;
                        }
                        case 7: {
                            type2 = FieldType.NUMERIC;
                            value2 = RubyDateFormatter.year(dt, dt.getYear()) / 100;
                            break;
                        }
                        case 24: {
                            type2 = FieldType.NUMERIC;
                            value2 = dt.getMillis() / 1000L;
                            break;
                        }
                        case 27: {
                            type2 = FieldType.NUMERIC2;
                            value2 = dt.getWeekOfWeekyear();
                            break;
                        }
                        case 16: 
                        case 20: {
                            int defaultWidth = format == Format.FORMAT_NANOSEC ? 9 : 3;
                            int width = formatter.getWidth(defaultWidth);
                            tmp.setRealSize(0);
                            data2 = tmp;
                            RubyTimeOutputFormatter.formatNumber((ByteList)data2, dt.getMillisOfSecond(), 3, '0');
                            if (width > 3) {
                                if (sub_millis == null) {
                                    RubyTimeOutputFormatter.formatNumber((ByteList)data2, nsec2, 6, '0');
                                } else {
                                    RubyDateFormatter.formatSubMillisGt3(this.runtime.getCurrentContext(), (ByteList)data2, width, sub_millis);
                                }
                            }
                            if (width < data2.length()) {
                                ((ByteList)data2).setRealSize(width);
                            } else {
                                int padLength = width - data2.length();
                                for (int i2 = 0; i2 < padLength; ++i2) {
                                    ((ByteList)data2).append(48);
                                }
                            }
                            formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
                            break;
                        }
                        case 10: {
                            value2 = RubyDateFormatter.year(dt, dt.getWeekyear());
                            type2 = value2 >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                            break;
                        }
                        case 11: {
                            type2 = FieldType.NUMERIC2;
                            value2 = RubyDateFormatter.year(dt, dt.getWeekyear()) % 100;
                            break;
                        }
                        case 34: {
                            type2 = FieldType.NUMERIC;
                            value2 = dt.getMillis();
                            break;
                        }
                        case 2: {
                            throw new java.lang.Error("FORMAT_SPECIAL is a special token only for the lexer.");
                        }
                    }
                    try {
                        if (data2 == null) {
                            formatter.format(output, value2, type2);
                            break block51;
                        }
                        if (toUpper) {
                            formatter.format(output, data2.toString().toUpperCase());
                            toUpper = false;
                        } else {
                            formatter.format(output, data2);
                        }
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        throw this.runtime.newErrnoFromErrno(Errno.ERANGE, "strftime");
                    }
                }
                formatter = RubyTimeOutputFormatter.DEFAULT_FORMATTER;
            }
            ++ti;
        }
    }

    private static void formatSubMillisGt3(ThreadContext context, ByteList buff, int width, RubyNumeric sub_millis) {
        int prec = width - 3;
        RubyNumeric power = (RubyNumeric)Convert.asFixnum(context, 10).op_pow(context, prec);
        RubyNumeric truncated = (RubyNumeric)sub_millis.numerator(context).convertToInteger().op_mul(context, power);
        truncated = (RubyNumeric)truncated.idiv(context, sub_millis.denominator(context));
        long decimals = truncated.asLong(context);
        RubyTimeOutputFormatter.formatNumber(buff, decimals, prec, '0');
    }

    private static int year(DateTime dt, int year2) {
        Chronology c;
        if (year2 < 0 && ((c = dt.getChronology()) instanceof JulianChronology || c instanceof GJChronology && ((GJChronology)c).getGregorianCutover().isAfter((ReadableInstant)dt))) {
            return year2 + 1;
        }
        return year2;
    }

    private static int formatWeekYear(DateTime dt, int firstDayOfWeek) {
        GregorianCalendar dtCalendar = dt.toGregorianCalendar();
        dtCalendar.setFirstDayOfWeek(firstDayOfWeek);
        dtCalendar.setMinimalDaysInFirstWeek(7);
        int value2 = dtCalendar.get(3);
        if ((value2 == 52 || value2 == 53) && dtCalendar.get(2) == 0) {
            value2 = 0;
        }
        return value2;
    }

    private static ByteList formatZone(int colons, int value2, RubyTimeOutputFormatter formatter) {
        int seconds = Math.abs(value2);
        int hours = seconds / 3600;
        int minutes = (seconds %= 3600) / 60;
        seconds %= 60;
        if (value2 < 0 && hours != 0) {
            hours = -hours;
        }
        char padder = formatter.getPadder('0');
        int defaultWidth = -1;
        ByteList after = new ByteList(12);
        switch (colons) {
            case 0: {
                defaultWidth = 5;
                RubyTimeOutputFormatter.formatNumber(after, minutes, 2, '0');
                break;
            }
            case 1: {
                defaultWidth = 6;
                after.append(58);
                RubyTimeOutputFormatter.formatNumber(after, minutes, 2, '0');
                break;
            }
            case 2: {
                defaultWidth = 9;
                after.append(58);
                RubyTimeOutputFormatter.formatNumber(after, minutes, 2, '0');
                after.append(58);
                RubyTimeOutputFormatter.formatNumber(after, seconds, 2, '0');
                break;
            }
            case 3: {
                if (minutes != 0 || seconds != 0) {
                    after.append(58);
                    RubyTimeOutputFormatter.formatNumber(after, minutes, 2, '0');
                }
                if (seconds != 0) {
                    after.append(58);
                    RubyTimeOutputFormatter.formatNumber(after, seconds, 2, '0');
                }
                defaultWidth = after.length() + 3;
            }
        }
        int minWidth = defaultWidth - 1;
        int width = formatter.getWidth(defaultWidth);
        if (width < minWidth) {
            width = minWidth;
        }
        ByteList result2 = new ByteList(width);
        RubyTimeOutputFormatter.formatSignedNumber(result2, hours, value2, width -= after.length(), padder);
        result2.append(after);
        return result2;
    }

    public Date parse(String source2, ParsePosition pos2) {
        throw new UnsupportedOperationException();
    }

    static {
        DateFormatSymbols FORMAT_SYMBOLS = new DateFormatSymbols(Locale.US);
        FORMAT_MONTHS = FORMAT_SYMBOLS.getMonths();
        FORMAT_SHORT_MONTHS = FORMAT_SYMBOLS.getShortMonths();
        FORMAT_WEEKDAYS = FORMAT_SYMBOLS.getWeekdays();
        FORMAT_SHORT_WEEKDAYS = FORMAT_SYMBOLS.getShortWeekdays();
        CONVERSION2TOKEN = new Token[256];
        COLON_TOKEN = new Token(Format.FORMAT_STRING, CommonByteLists.COLON);
        DASH_TOKEN = new Token(Format.FORMAT_STRING, CommonByteLists.DASH);
        DOT_TOKEN = new Token(Format.FORMAT_STRING, CommonByteLists.DOT);
        SLASH_TOKEN = new Token(Format.FORMAT_STRING, CommonByteLists.SLASH);
    }

    public static class Token {
        private final Format format;
        protected Object data;

        protected Token(Format format) {
            this(format, null);
        }

        public Token(Format formatString, Object data2) {
            this.format = formatString;
            this.data = data2;
        }

        public static Token str(ByteList str) {
            if (str.length() == 1) {
                switch (str.charAt(0)) {
                    case ':': {
                        return COLON_TOKEN;
                    }
                    case '.': {
                        return DOT_TOKEN;
                    }
                    case '-': {
                        return DASH_TOKEN;
                    }
                    case '/': {
                        return SLASH_TOKEN;
                    }
                }
            }
            return new Token(Format.FORMAT_STRING, str);
        }

        public static Token format(char c) {
            return Format.conversionToToken(c);
        }

        public static Token zoneOffsetColons(int colons) {
            return new Token(Format.FORMAT_COLON_ZONE_OFF, colons);
        }

        public static Token special(char c) {
            return new Token(Format.FORMAT_SPECIAL, Character.valueOf(c));
        }

        public static Token formatter(RubyTimeOutputFormatter formatter) {
            return formatter;
        }

        public Object getData() {
            return this.data;
        }

        public Format getFormat() {
            return this.format;
        }

        public String toString() {
            return "<Token " + String.valueOf((Object)this.format) + " " + String.valueOf(this.data) + ">";
        }
    }

    public static enum Format {
        FORMAT_STRING,
        FORMAT_OUTPUT,
        FORMAT_SPECIAL,
        FORMAT_WEEK_LONG('A'),
        FORMAT_WEEK_SHORT('a'),
        FORMAT_MONTH_LONG('B'),
        FORMAT_MONTH_SHORT('b', 'h'),
        FORMAT_CENTURY('C'),
        FORMAT_DAY('d'),
        FORMAT_DAY_S('e'),
        FORMAT_WEEKYEAR('G'),
        FORMAT_WEEKYEAR_SHORT('g'),
        FORMAT_HOUR('H'),
        FORMAT_HOUR_M('I'),
        FORMAT_DAY_YEAR('j'),
        FORMAT_HOUR_BLANK('k'),
        FORMAT_MILLISEC('L'),
        FORMAT_HOUR_S('l'),
        FORMAT_MINUTES('M'),
        FORMAT_MONTH('m'),
        FORMAT_NANOSEC('N'),
        FORMAT_MERIDIAN_LOWER_CASE('P'),
        FORMAT_MERIDIAN('p'),
        FORMAT_SECONDS('S'),
        FORMAT_EPOCH('s'),
        FORMAT_WEEK_YEAR_S('U'),
        FORMAT_DAY_WEEK2('u'),
        FORMAT_WEEK_WEEKYEAR('V'),
        FORMAT_WEEK_YEAR_M('W'),
        FORMAT_DAY_WEEK('w'),
        FORMAT_YEAR_LONG('Y'),
        FORMAT_YEAR_SHORT('y'),
        FORMAT_COLON_ZONE_OFF,
        FORMAT_ZONE_ID,
        FORMAT_MICROSEC_EPOCH;


        private Format() {
        }

        private Format(char conversion) {
            Format.addToConversions(conversion, new Token(this));
        }

        private Format(char conversion, char alias) {
            this(conversion);
            Format.addToConversions(alias, Format.conversionToToken(conversion));
        }

        private static void addToConversions(char conversion, Token token2) {
            RubyDateFormatter.CONVERSION2TOKEN[conversion] = token2;
        }

        private static Token conversionToToken(int conversion) {
            return CONVERSION2TOKEN[conversion];
        }
    }

    static enum FieldType {
        NUMERIC('0', 0),
        NUMERIC2('0', 2),
        NUMERIC2BLANK(' ', 2),
        NUMERIC3('0', 3),
        NUMERIC4('0', 4),
        NUMERIC5('0', 5),
        TEXT(' ', 0);

        final char defaultPadder;
        final int defaultWidth;

        private FieldType(char padder, int width) {
            this.defaultPadder = padder;
            this.defaultWidth = width;
        }
    }
}

