/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jcodings.Encoding;
import org.joni.Matcher;
import org.joni.NameEntry;
import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.JOniException;
import org.joni.exception.ValueException;
import org.jruby.ObjectFlags;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Convert;
import org.jruby.api.Create;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;

@JRubyClass(name={"MatchData"})
public class RubyMatchData
extends RubyObject {
    Region regs;
    int begin;
    int end;
    RubyString str;
    private Object pattern;
    transient RubyRegexp regexp;
    private boolean charOffsetUpdated;
    private Region charOffsets;
    private static final int MATCH_BUSY = ObjectFlags.MATCH_BUSY;

    public static RubyClass createMatchDataClass(ThreadContext context, RubyClass Object2) {
        return ((RubyModule)((RubyModule)((RubyModule)Define.defineClass(context, "MatchData", Object2, RubyMatchData::new).reifiedClass(RubyMatchData.class)).kindOf(new RubyModule.JavaClassKindOf(RubyMatchData.class))).classIndex(ClassIndex.MATCHDATA)).defineMethods(context, RubyMatchData.class).tap(c -> c.singletonClass(context).undefMethods(context, "new", "allocate"));
    }

    public RubyMatchData(Ruby runtime2) {
        super(runtime2, runtime2.getMatchData());
    }

    public RubyMatchData(Ruby runtime2, RubyClass metaClass) {
        super(runtime2, metaClass);
    }

    final void initMatchData(RubyString str, Matcher matcher, Regex pattern) {
        Region region = matcher.getRegion();
        this.regs = region == null ? null : region.clone();
        this.begin = matcher.getBegin();
        this.end = matcher.getEnd();
        this.pattern = pattern;
        this.regexp = null;
        this.charOffsets = null;
        this.charOffsetUpdated = false;
        this.str = str.newFrozen();
    }

    final void initMatchData(RubyString str, int beg, RubyString pattern) {
        this.regs = null;
        this.begin = beg;
        this.end = beg + pattern.size();
        this.pattern = pattern.newFrozen();
        this.regexp = null;
        this.charOffsets = null;
        this.charOffsetUpdated = false;
        this.str = str.newFrozen();
    }

    @Override
    public void copySpecialInstanceVariables(IRubyObject clone2) {
        RubyMatchData match2 = (RubyMatchData)clone2;
        match2.regs = this.regs;
        match2.begin = this.begin;
        match2.end = this.end;
        match2.pattern = this.pattern;
        match2.regexp = this.regexp;
        match2.charOffsetUpdated = this.charOffsetUpdated;
        match2.charOffsets = this.charOffsets;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.MATCHDATA;
    }

    private static void updatePairs(ByteList value2, Encoding encoding2, Pair[] pairs) {
        int p2;
        Arrays.sort(pairs);
        byte[] bytes2 = value2.getUnsafeBytes();
        int s2 = p2 = value2.getBegin();
        int c = 0;
        for (Pair pair : pairs) {
            int q = s2 + pair.bytePos;
            pair.charPos = c += StringSupport.strLength(encoding2, bytes2, p2, q);
            p2 = q;
        }
    }

    private void updateCharOffsetOnlyOneReg(ByteList value2, Encoding encoding2) {
        if (this.charOffsetUpdated) {
            return;
        }
        if (this.charOffsets == null || this.charOffsets.getNumRegs() < 1) {
            this.charOffsets = Region.newRegion((int)1);
        }
        if (encoding2.maxLength() == 1) {
            this.charOffsets.setBeg(0, this.begin);
            this.charOffsets.setEnd(0, this.end);
            this.charOffsetUpdated = true;
            return;
        }
        Object[] pairs = new Pair[2];
        if (this.begin >= 0) {
            pairs[0] = new Pair();
            pairs[0].bytePos = this.begin;
            pairs[1] = new Pair();
            pairs[1].bytePos = this.end;
        }
        RubyMatchData.updatePairs(value2, encoding2, (Pair[])pairs);
        if (this.begin < 0) {
            this.charOffsets.setBeg(0, this.charOffsets.setEnd(0, -1));
            return;
        }
        Pair key2 = new Pair();
        key2.bytePos = this.begin;
        this.charOffsets.setBeg(0, ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos);
        key2.bytePos = this.end;
        this.charOffsets.setEnd(0, ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos);
        this.charOffsetUpdated = true;
    }

    private void updateCharOffsetManyRegs(ByteList value2, Encoding encoding2) {
        if (this.charOffsetUpdated) {
            return;
        }
        Region regs = this.regs;
        int numRegs = regs.getNumRegs();
        if (this.charOffsets == null || this.charOffsets.getNumRegs() < numRegs) {
            this.charOffsets = Region.newRegion((int)numRegs);
        }
        if (encoding2.maxLength() == 1) {
            for (int i2 = 0; i2 < numRegs; ++i2) {
                this.charOffsets.setBeg(i2, regs.getBeg(i2));
                this.charOffsets.setEnd(i2, regs.getEnd(i2));
            }
            this.charOffsetUpdated = true;
            return;
        }
        Object[] pairs = new Pair[numRegs * 2];
        for (int i3 = 0; i3 < pairs.length; ++i3) {
            pairs[i3] = new Pair();
        }
        int numPos = 0;
        for (int i4 = 0; i4 < numRegs; ++i4) {
            if (regs.getBeg(i4) < 0) continue;
            pairs[numPos++].bytePos = regs.getBeg(i4);
            pairs[numPos++].bytePos = regs.getEnd(i4);
        }
        RubyMatchData.updatePairs(value2, encoding2, (Pair[])pairs);
        Pair key2 = new Pair();
        for (int i5 = 0; i5 < regs.getNumRegs(); ++i5) {
            if (regs.getBeg(i5) < 0) {
                this.charOffsets.setBeg(i5, this.charOffsets.setEnd(i5, -1));
                continue;
            }
            key2.bytePos = regs.getBeg(i5);
            this.charOffsets.setBeg(i5, ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos);
            key2.bytePos = regs.getEnd(i5);
            this.charOffsets.setEnd(i5, ((Pair)pairs[Arrays.binarySearch((Object[])pairs, (Object)key2)]).charPos);
        }
        this.charOffsetUpdated = true;
    }

    private void updateCharOffset() {
        if (this.charOffsetUpdated) {
            return;
        }
        ByteList value2 = this.str.getByteList();
        Encoding enc = value2.getEncoding();
        if (this.regs == null) {
            this.updateCharOffsetOnlyOneReg(value2, enc);
        } else {
            this.updateCharOffsetManyRegs(value2, enc);
        }
        this.charOffsetUpdated = true;
    }

    public final void use() {
        this.flags |= MATCH_BUSY;
    }

    public final boolean used() {
        return (this.flags & MATCH_BUSY) != 0;
    }

    final void check(ThreadContext context) {
        if (this.str == null) {
            throw Error.typeError(context, "uninitialized Match");
        }
    }

    final Regex getPattern(ThreadContext context) {
        Object pattern = this.pattern;
        if (pattern instanceof Regex) {
            Regex regex = (Regex)pattern;
            return regex;
        }
        if (pattern == null) {
            throw Error.typeError(context, "uninitialized Match (missing pattern)");
        }
        Regex regexPattern = RubyRegexp.getQuotedRegexpFromCache(context, (RubyString)pattern, RegexpOptions.NULL_OPTIONS);
        this.pattern = regexPattern;
        return regexPattern;
    }

    private RubyRegexp getRegexp(ThreadContext context) {
        RubyRegexp regexp2 = this.regexp;
        if (regexp2 != null) {
            return regexp2;
        }
        Regex pattern = this.getPattern(context);
        this.regexp = RubyRegexp.newRegexp(context.runtime, (ByteList)pattern.getUserObject(), pattern);
        return this.regexp;
    }

    private RubyArray<?> match_array(ThreadContext context, int start2) {
        this.check(context);
        if (this.regs == null) {
            if (start2 != 0) {
                return Create.newEmptyArray(context);
            }
            return this.begin == -1 ? Create.newArray(context, context.nil) : Create.newArray(context, (IRubyObject)this.str.makeSharedString(context.runtime, this.begin, this.end - this.begin));
        }
        int count2 = this.regs.getNumRegs() - start2;
        RubyArray<?> arr = Create.allocArray(context, count2);
        for (int i2 = 0; i2 < count2; ++i2) {
            int beg = this.regs.getBeg(i2 + start2);
            arr.storeInternal(context, i2, beg == -1 ? context.nil : this.str.makeSharedString(context.runtime, beg, this.regs.getEnd(i2 + start2) - beg));
        }
        return arr;
    }

    @Deprecated(since="10.0")
    public IRubyObject group(long n) {
        return this.group(this.getCurrentContext(), (int)n);
    }

    @Deprecated(since="10.0")
    public IRubyObject group(int n) {
        return this.group(this.getCurrentContext(), n);
    }

    public IRubyObject group(ThreadContext context, int n) {
        return RubyRegexp.nth_match(context, n, this);
    }

    @Deprecated(since="10.0")
    public int getNameToBackrefNumber(String name2) {
        return this.getNameToBackrefNumber(this.getCurrentContext(), name2);
    }

    public int getNameToBackrefNumber(ThreadContext context, String name2) {
        try {
            byte[] bytes2 = name2.getBytes();
            return this.getPattern(context).nameToBackrefNumber(bytes2, 0, bytes2.length, this.regs);
        }
        catch (JOniException je) {
            throw Error.indexError(context, je.getMessage());
        }
    }

    @Deprecated(since="10.0")
    public IRubyObject[] getNamedBackrefValues(Ruby runtime2) {
        ThreadContext context = runtime2.getCurrentContext();
        Regex pattern = this.getPattern(context);
        if (pattern.numberOfNames() == 0) {
            return NULL_ARRAY;
        }
        IRubyObject[] values2 = new IRubyObject[pattern.numberOfNames()];
        int j = 0;
        Iterator i2 = pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            NameEntry e = (NameEntry)i2.next();
            int nth = pattern.nameToBackrefNumber(e.name, e.nameP, e.nameEnd, this.regs);
            values2[j++] = RubyRegexp.nth_match(context, nth, this);
        }
        return values2;
    }

    @JRubyMethod
    public IRubyObject byteoffset(ThreadContext context, IRubyObject group2) {
        int index2 = this.backrefNumber(context, group2);
        Region regs = this.regs;
        this.backrefNumberCheck(context, index2);
        int start2 = regs.getBeg(index2);
        return start2 < 0 ? Create.newArray(context, context.nil, context.nil) : Create.newArray(context, (IRubyObject)Convert.asFixnum(context, start2), (IRubyObject)Convert.asFixnum(context, regs.getEnd(index2)));
    }

    @JRubyMethod
    public IRubyObject bytebegin(ThreadContext context, IRubyObject group2) {
        int index2 = this.backrefNumber(context, group2);
        Region regs = this.regs;
        this.backrefNumberCheck(context, index2);
        int start2 = regs.getBeg(index2);
        return start2 < 0 ? context.nil : Convert.asFixnum(context, start2);
    }

    @JRubyMethod
    public IRubyObject byteend(ThreadContext context, IRubyObject group2) {
        int index2 = this.backrefNumber(context, group2);
        Region regs = this.regs;
        this.backrefNumberCheck(context, index2);
        int start2 = regs.getBeg(index2);
        return start2 < 0 ? context.nil : Convert.asFixnum(context, regs.getEnd(index2));
    }

    @Override
    @Deprecated(since="10.0")
    public RubyString inspect() {
        return this.inspect(this.getCurrentContext());
    }

    @Override
    @JRubyMethod
    public RubyString inspect(ThreadContext context) {
        NameEntry e;
        if (this.str == null) {
            return (RubyString)this.anyToString();
        }
        RubyString result2 = Create.newString(context, "#<");
        result2.append(this.getMetaClass().getRealClass().to_s(context));
        NameEntry[] names2 = new NameEntry[this.regs == null ? 1 : this.regs.getNumRegs()];
        Regex pattern = this.getPattern(context);
        Iterator i2 = pattern.namedBackrefIterator();
        while (i2.hasNext()) {
            e = (NameEntry)i2.next();
            for (int num : e.getBackRefs()) {
                names2[num] = e;
            }
        }
        for (int i3 = 0; i3 < names2.length; ++i3) {
            IRubyObject v;
            result2.cat((byte)32);
            if (i3 > 0) {
                e = names2[i3];
                if (e != null) {
                    result2.cat(e.name, e.nameP, e.nameEnd - e.nameP);
                } else {
                    result2.cat((byte)(48 + i3));
                }
                result2.cat((byte)58);
            }
            if ((v = RubyRegexp.nth_match(context, i3, this)).isNil()) {
                result2.cat(RubyNil.nilBytes);
                continue;
            }
            result2.append(v.inspect(context));
        }
        return result2.cat((byte)62);
    }

    @JRubyMethod
    public RubyRegexp regexp(ThreadContext context, Block block) {
        this.check(context);
        return this.getRegexp(context);
    }

    @JRubyMethod
    public IRubyObject names(ThreadContext context, Block block) {
        this.check(context);
        return this.getRegexp(context).names(context);
    }

    @Override
    @JRubyMethod
    public RubyArray to_a(ThreadContext context) {
        return this.match_array(context, 0);
    }

    @JRubyMethod(rest=true)
    public IRubyObject values_at(ThreadContext context, IRubyObject[] args2) {
        this.check(context);
        RubyArray<?> result2 = Create.allocArray(context, args2.length);
        for (IRubyObject arg2 : args2) {
            if (arg2 instanceof RubyFixnum) {
                RubyFixnum fix2 = (RubyFixnum)arg2;
                result2.append(context, RubyRegexp.nth_match(context, fix2.asInt(context), this));
                continue;
            }
            int num = this.namevToBackrefNumber(context, arg2);
            if (num >= 0) {
                result2.append(context, RubyRegexp.nth_match(context, num, this));
                continue;
            }
            this.matchAryAref(context, arg2, result2);
        }
        return result2;
    }

    @Deprecated(since="10.0")
    public IRubyObject values_at(IRubyObject[] args2) {
        return this.values_at(this.getCurrentContext(), args2);
    }

    @JRubyMethod
    public IRubyObject captures(ThreadContext context) {
        return this.match_array(context, 1);
    }

    private int nameToBackrefNumber(ThreadContext context, RubyString str) {
        this.check(context);
        return RubyMatchData.nameToBackrefNumber(context, this.getPattern(context), this.regs, str);
    }

    private static int nameToBackrefNumber(ThreadContext context, Regex pattern, Region regs, ByteListHolder str) {
        assert (pattern != null);
        ByteList value2 = str.getByteList();
        try {
            return pattern.nameToBackrefNumber(value2.getUnsafeBytes(), value2.getBegin(), value2.getBegin() + value2.getRealSize(), regs);
        }
        catch (JOniException je) {
            if (je instanceof ValueException) {
                throw Error.indexError(context, RubyStringBuilder.str(context.runtime, "undefined group name reference: ", Create.newString(context, value2)));
            }
            throw Error.indexError(context, je.getMessage());
        }
    }

    private static int nameToBackrefNumber(Regex pattern, Region regs, ByteList name2) {
        try {
            return pattern.nameToBackrefNumber(name2.getUnsafeBytes(), name2.getBegin(), name2.getBegin() + name2.getRealSize(), regs);
        }
        catch (JOniException je) {
            return -1;
        }
    }

    @Deprecated(since="10.0")
    public final int backrefNumber(Ruby runtime2, IRubyObject obj) {
        return this.backrefNumber(runtime2.getCurrentContext(), obj);
    }

    public final int backrefNumber(ThreadContext context, IRubyObject obj) {
        this.check(context);
        return RubyMatchData.backrefNumber(context, this.getPattern(context), this.regs, obj);
    }

    @Deprecated(since="10.0")
    public static int backrefNumber(Ruby runtime2, Regex pattern, Region regs, IRubyObject obj) {
        return RubyMatchData.backrefNumber(runtime2.getCurrentContext(), pattern, regs, obj);
    }

    public static int backrefNumber(ThreadContext context, Regex pattern, Region regs, IRubyObject obj) {
        if (obj instanceof RubySymbol) {
            RubySymbol sym = (RubySymbol)obj;
            return RubyMatchData.nameToBackrefNumber(context, pattern, regs, (RubyString)sym.to_s(context));
        }
        if (obj instanceof RubyString) {
            RubyString str = (RubyString)obj;
            return RubyMatchData.nameToBackrefNumber(context, pattern, regs, str);
        }
        return Convert.toInt(context, obj);
    }

    private int namevToBackrefNumber(ThreadContext context, IRubyObject name2) {
        int num = -1;
        switch (name2.getType().getClassIndex()) {
            case SYMBOL: {
                name2 = name2.asString();
            }
            case STRING: {
                Ruby runtime2 = context.runtime;
                if (this.regexp.isNil() || RubyEncoding.areCompatible(this.regexp, name2) == null || (num = RubyMatchData.nameToBackrefNumber(context, this.regexp.getPattern(context), this.regs, name2.convertToString())) < 1) {
                    this.nameToBackrefError(context, name2.toString());
                }
                return num;
            }
        }
        return -1;
    }

    private int nameToBackrefError(ThreadContext context, String name2) {
        throw Error.indexError(context, "undefined group name reference " + name2);
    }

    private IRubyObject matchArySubseq(ThreadContext context, int beg, int len, RubyArray result2) {
        int j;
        assert (result2 != null);
        int olen = this.regs.getNumRegs();
        int wantedEnd = beg + len;
        int end2 = Math.min(olen, wantedEnd);
        if (len == 0) {
            return result2;
        }
        for (j = beg; j < end2; ++j) {
            result2.append(context, RubyRegexp.nth_match(context, j, this));
        }
        if (wantedEnd > j) {
            int newLength = result2.size() + wantedEnd - j;
            result2.storeInternal(context, newLength - 1, context.nil);
        }
        return result2;
    }

    private IRubyObject matchAryAref(ThreadContext context, IRubyObject index2, RubyArray result2) {
        int[] begLen = new int[2];
        int numRegs = this.regs.getNumRegs();
        IRubyObject isRange = RubyRange.rangeBeginLength(context, index2, numRegs, begLen, 1);
        if (isRange.isNil()) {
            return context.nil;
        }
        if (!isRange.isTrue()) {
            IRubyObject nthMatch = RubyRegexp.nth_match(context, Convert.toInt(context, index2), this);
            return result2.push(context, nthMatch);
        }
        return this.matchArySubseq(context, begLen[0], begLen[1], result2);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject idx) {
        this.check(context);
        IRubyObject result2 = this.op_arefCommon(context, idx);
        return result2 == null ? this.to_a(context).aref(context, idx) : result2;
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject op_aref(ThreadContext context, IRubyObject idx, IRubyObject rest) {
        IRubyObject result2;
        return !rest.isNil() || (result2 = this.op_arefCommon(context, idx)) == null ? this.to_a(context).aref(context, idx, rest) : result2;
    }

    private IRubyObject op_arefCommon(ThreadContext context, IRubyObject idx) {
        if (idx instanceof RubyFixnum) {
            RubyFixnum fixnum = (RubyFixnum)idx;
            int num = Convert.toInt(context, fixnum);
            if (num >= 0) {
                return RubyRegexp.nth_match(context, num, this);
            }
        } else {
            if (idx instanceof RubySymbol) {
                RubySymbol index2 = (RubySymbol)idx;
                return RubyRegexp.nth_match(context, this.nameToBackrefNumber(context, (RubyString)index2.to_s(context)), this);
            }
            if (idx instanceof RubyString) {
                RubyString index3 = (RubyString)idx;
                return RubyRegexp.nth_match(context, this.nameToBackrefNumber(context, index3), this);
            }
        }
        return null;
    }

    @Deprecated(since="10.0")
    public final IRubyObject at(int nth) {
        return this.at(this.getCurrentContext(), nth);
    }

    public final IRubyObject at(ThreadContext context, int nth) {
        return RubyRegexp.nth_match(context, nth, this);
    }

    @JRubyMethod(name={"size", "length"})
    public IRubyObject size(ThreadContext context) {
        this.check(context);
        return this.regs == null ? RubyFixnum.one(context.runtime) : Convert.asFixnum(context, this.regs.getNumRegs());
    }

    @JRubyMethod
    public IRubyObject begin(ThreadContext context, IRubyObject index2) {
        int b2;
        this.check(context);
        int i2 = this.backrefNumber(context, index2);
        this.backrefNumberCheck(context, i2);
        int n = b2 = this.regs == null ? this.begin : this.regs.getBeg(i2);
        if (b2 < 0) {
            return context.nil;
        }
        this.updateCharOffset();
        return Convert.asFixnum(context, this.charOffsets.getBeg(i2));
    }

    @JRubyMethod
    public IRubyObject end(ThreadContext context, IRubyObject index2) {
        int e;
        this.check(context);
        int i2 = this.backrefNumber(context, index2);
        this.backrefNumberCheck(context, i2);
        int n = e = this.regs == null ? this.end : this.regs.getEnd(i2);
        if (e < 0) {
            return context.nil;
        }
        if (!this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            e = this.charOffsets.getEnd(i2);
        }
        return Convert.asFixnum(context, e);
    }

    @Deprecated
    public IRubyObject offset19(ThreadContext context, IRubyObject index2) {
        return this.offset(context, index2);
    }

    @JRubyMethod(name={"offset"})
    public IRubyObject offset(ThreadContext context, IRubyObject index2) {
        int e;
        int b2;
        this.check(context);
        int i2 = this.backrefNumber(context, index2);
        this.backrefNumberCheck(context, i2);
        if (this.regs == null) {
            b2 = this.begin;
            e = this.end;
        } else {
            b2 = this.regs.getBeg(i2);
            e = this.regs.getEnd(i2);
        }
        if (b2 < 0) {
            return Create.newArray(context, context.nil, context.nil);
        }
        if (!this.str.singleByteOptimizable()) {
            this.updateCharOffset();
            b2 = this.charOffsets.getBeg(i2);
            e = this.charOffsets.getEnd(i2);
        }
        return Create.newArray(context, (IRubyObject)Convert.asFixnum(context, b2), (IRubyObject)Convert.asFixnum(context, e));
    }

    @JRubyMethod
    public IRubyObject pre_match(ThreadContext context) {
        this.check(context);
        return this.begin == -1 ? context.nil : this.str.makeSharedString(context.runtime, 0, this.begin);
    }

    @JRubyMethod
    public IRubyObject match(ThreadContext context, IRubyObject nth) {
        int index2 = this.nthToIndex(context, nth);
        Region regs = this.regs;
        this.backrefNumberCheck(context, index2);
        int start2 = regs.getBeg(index2);
        if (start2 < 0) {
            return context.nil;
        }
        int end2 = regs.getEnd(index2);
        return this.str.makeSharedString(context.runtime, start2, end2 - start2);
    }

    @JRubyMethod
    public IRubyObject match_length(ThreadContext context, IRubyObject nth) {
        int index2 = this.nthToIndex(context, nth);
        Region regs = this.regs;
        this.backrefNumberCheck(context, index2);
        int start2 = regs.getBeg(index2);
        if (start2 < 0) {
            return context.nil;
        }
        int end2 = regs.getEnd(index2);
        ByteList strBytes = this.str.getByteList();
        int length2 = StringSupport.strLength(strBytes.getEncoding(), strBytes.unsafeBytes(), start2, end2, this.str.getCodeRange());
        return Convert.asFixnum(context, length2);
    }

    private int nthToIndex(ThreadContext context, IRubyObject id2) {
        int index2 = this.namevToBackrefNumber(context, id2);
        if (index2 == -1 && id2 instanceof RubyInteger) {
            index2 = Convert.toInt(context, id2);
        }
        return index2;
    }

    private void backrefNumberCheck(ThreadContext context, int i2) {
        if (i2 < 0 || (this.regs == null ? 1 : this.regs.getNumRegs()) <= i2) {
            throw Error.indexError(context, "index " + i2 + " out of matches");
        }
    }

    @JRubyMethod
    public IRubyObject post_match(ThreadContext context) {
        this.check(context);
        return this.begin == -1 ? context.nil : this.str.makeSharedString(context.runtime, this.end, this.str.getByteList().length() - this.end);
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s(ThreadContext context) {
        this.check(context);
        IRubyObject ss = RubyRegexp.last_match(context, this);
        return ss.isNil() ? Create.newEmptyString(context) : ss;
    }

    @Deprecated(since="10.0")
    public IRubyObject string() {
        return this.string(this.getCurrentContext());
    }

    @JRubyMethod
    public IRubyObject string(ThreadContext context) {
        this.check(context);
        return this.str;
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject original) {
        if (this == original) {
            return this;
        }
        this.checkFrozen();
        if (!(original instanceof RubyMatchData)) {
            throw Error.typeError(context, "wrong argument class");
        }
        RubyMatchData orig = (RubyMatchData)original;
        this.str = orig.str;
        this.regs = orig.regs;
        return this;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RubyMatchData)) {
            return false;
        }
        RubyMatchData that = (RubyMatchData)other;
        ThreadContext context = this.getRuntime().getCurrentContext();
        return (this.str == that.str || this.str != null && this.str.equals(that.str)) && (this.regexp == that.regexp || this.getRegexp(context).equals(that.getRegexp(context))) && (this.charOffsets == that.charOffsets || this.charOffsets != null && this.charOffsets.equals(that.charOffsets)) && this.charOffsetUpdated == that.charOffsetUpdated && this.begin == that.begin && this.end == that.end;
    }

    @Override
    @JRubyMethod(name={"eql?", "=="})
    public IRubyObject eql_p(ThreadContext context, IRubyObject obj) {
        return this.equals(obj) ? context.tru : context.fals;
    }

    @Override
    public int hashCode() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        this.check(context);
        return this.getPattern(context).hashCode() ^ this.str.hashCode();
    }

    @Override
    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return Convert.asFixnum(context, this.hashCode());
    }

    @Deprecated(since="10.0")
    public RubyHash named_captures(ThreadContext context) {
        return this.named_captures(context, NULL_ARRAY);
    }

    @JRubyMethod(keywords=true, optional=1)
    public RubyHash named_captures(ThreadContext context, IRubyObject[] args2) {
        boolean symbolizeNames;
        this.check(context);
        int argc = Arity.checkArgumentCount(context, args2.length, 0, 0, true);
        RubyHash hash2 = Create.newSmallHash(context);
        if (this.regexp == context.nil) {
            return hash2;
        }
        if (argc == 1) {
            IRubyObject iRubyObject = args2[0];
            if (!(iRubyObject instanceof RubyHash)) {
                throw Error.argumentError(context, 1, 0);
            }
            RubyHash opts = (RubyHash)iRubyObject;
            IRubyObject value2 = ArgsUtil.extractKeywordArg(context, opts, "symbolize_names");
            symbolizeNames = value2 != null && value2.isTrue();
        } else {
            symbolizeNames = false;
        }
        this.getNamedBackrefKeys(context).forEach(entry -> {
            RubyObject key2 = symbolizeNames ? this.symbolFromNameEntry(context, (NameEntry)entry) : this.stringFromNameEntry(context, (NameEntry)entry);
            boolean found = false;
            for (int b2 : entry.getBackRefs()) {
                IRubyObject value2 = RubyRegexp.nth_match(context, b2, this);
                if (!value2.isTrue()) continue;
                hash2.op_aset(context, key2, value2);
                found = true;
            }
            if (!found) {
                hash2.op_aset(context, key2, context.nil);
            }
        });
        return hash2;
    }

    @JRubyMethod
    public IRubyObject deconstruct(ThreadContext context) {
        return this.match_array(context, 1);
    }

    @JRubyMethod
    public IRubyObject deconstruct_keys(ThreadContext context, IRubyObject what) {
        RubyHash hash2 = Create.newSmallHash(context);
        if (what.isNil()) {
            this.getNamedBackrefKeys(context).forEach(entry -> {
                RubySymbol key2 = this.symbolFromNameEntry(context, (NameEntry)entry);
                for (int b2 : entry.getBackRefs()) {
                    IRubyObject value2 = RubyRegexp.nth_match(context, b2, this);
                    if (!value2.isTrue()) continue;
                    hash2.op_aset(context, key2, value2);
                }
            });
        } else if (what instanceof RubyArray) {
            RubyArray arr = (RubyArray)what;
            if (this.getPattern(context).numberOfNames() < arr.size()) {
                return hash2;
            }
            Iterable iterable = () -> arr.rubyStream().iterator();
            for (IRubyObject obj : iterable) {
                IRubyObject value2;
                if (!(obj instanceof RubySymbol)) {
                    throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "wrong argument type ", obj.getMetaClass(), " (expected Symbol)"));
                }
                RubySymbol requestedKey = (RubySymbol)obj;
                int index2 = RubyMatchData.nameToBackrefNumber(this.getPattern(context), this.regs, requestedKey.getBytes());
                if (index2 != -1 && (value2 = RubyRegexp.nth_match(context, index2, this)).isTrue()) {
                    hash2.op_aset(context, requestedKey, value2);
                    continue;
                }
                break;
            }
        } else {
            throw Error.typeError(context, RubyStringBuilder.str(context.runtime, "wrong argument type ", what.getMetaClass(), " (expected Array)"));
        }
        return hash2;
    }

    private Stream<NameEntry> getNamedBackrefKeys(ThreadContext context) {
        Iterable iterable = () -> this.getPattern(context).namedBackrefIterator();
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static ByteList byteListFromNameEntry(ThreadContext context, NameEntry entry, Encoding encoding2) {
        return new ByteList(entry.name, entry.nameP, entry.nameEnd - entry.nameP, encoding2, false);
    }

    private RubySymbol symbolFromNameEntry(ThreadContext context, NameEntry entry) {
        return Convert.asSymbol(context, RubyMatchData.byteListFromNameEntry(context, entry, this.regexp.getEncoding()));
    }

    private RubyString stringFromNameEntry(ThreadContext context, NameEntry entry) {
        return Create.newSharedString(context, RubyMatchData.byteListFromNameEntry(context, entry, this.regexp.getEncoding()));
    }

    public int begin(int i2) {
        if (this.regs == null) {
            if (i2 > 1) {
                return -1;
            }
            return this.begin;
        }
        if (i2 > this.regs.getNumRegs()) {
            return -1;
        }
        return this.regs.getBeg(i2);
    }

    public int end(int i2) {
        if (this.regs == null) {
            if (i2 > 1) {
                return -1;
            }
            return this.end;
        }
        if (i2 > this.regs.getNumRegs()) {
            return -1;
        }
        return this.regs.getEnd(i2);
    }

    public int numRegs() {
        return this.regs == null ? 1 : this.regs.getNumRegs();
    }

    @Override
    @Deprecated
    public RubyArray to_a() {
        return this.match_array(this.getCurrentContext(), 0);
    }

    @Deprecated
    public IRubyObject op_aref(IRubyObject idx) {
        return this.op_aref(this.getCurrentContext(), idx);
    }

    @Deprecated
    public IRubyObject op_aref(IRubyObject idx, IRubyObject rest) {
        return this.op_aref(this.getCurrentContext(), idx, rest);
    }

    private static final class Pair
    implements Comparable<Pair> {
        int bytePos;
        int charPos;

        private Pair() {
        }

        @Override
        public int compareTo(Pair pair) {
            return this.bytePos - pair.bytePos;
        }
    }
}

