/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.targets.indy;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.jruby.RubyRange;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.targets.indy.LazyObjectSite;
import org.jruby.ir.targets.indy.StringBootstrap;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.objectweb.asm.Handle;

public class RangeObjectSite
extends LazyObjectSite {
    public static final String RANGE_BEGINLESS = "rangeBeginless";
    public static final String RANGE_ENDLESS = "rangeEndless";
    protected final boolean exclusive;
    public static final Handle BOOTSTRAP = new Handle(6, CodegenUtils.p(RangeObjectSite.class), "bootstrap", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE), false);
    public static final Handle BOOTSTRAP_LONG_LONG = new Handle(6, CodegenUtils.p(RangeObjectSite.class), "bootstrapFixnums", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE, Long.TYPE, Integer.TYPE), false);
    public static final Handle BOOTSTRAP_LONG = new Handle(6, CodegenUtils.p(RangeObjectSite.class), "bootstrapFixnums", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE, Integer.TYPE), false);
    public static final Handle BOOTSTRAP_STRING_STRING = new Handle(6, CodegenUtils.p(RangeObjectSite.class), "bootstrapStrings", CodegenUtils.sig(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class, Integer.TYPE, String.class, String.class, Integer.TYPE, Integer.TYPE), false);

    public RangeObjectSite(MethodType type2, boolean exclusive) {
        super(type2);
        this.exclusive = exclusive;
    }

    public static CallSite bootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, int exclusive) {
        return new RangeObjectSite(type2, exclusive == 1).bootstrap(lookup);
    }

    public IRubyObject construct(ThreadContext context, IRubyObject begin2, IRubyObject end2) throws Throwable {
        return RubyRange.newRange(context, begin2, end2, this.exclusive);
    }

    public static CallSite bootstrapFixnums(MethodHandles.Lookup lookup, String name2, MethodType type2, long begin2, long end2, int exclusive) {
        return new FixnumRangeObjectSite(type2, begin2, end2, false, false, exclusive != 0).bootstrap(lookup);
    }

    public static CallSite bootstrapFixnums(MethodHandles.Lookup lookup, String name2, MethodType type2, long beginOrEnd, int exclusive) {
        return new FixnumRangeObjectSite(type2, beginOrEnd, 0L, name2.equals(RANGE_BEGINLESS), name2.equals(RANGE_ENDLESS), exclusive != 0).bootstrap(lookup);
    }

    public static CallSite bootstrapStrings(MethodHandles.Lookup lookup, String name2, MethodType type2, String begin2, String beginEnc, int beginCR, String end2, String endEnc, int endCR, int exclusive) {
        return new StringRangeObjectSite(type2, StringBootstrap.bytelist(begin2, beginEnc), beginCR, StringBootstrap.bytelist(end2, endEnc), endCR, exclusive != 0).bootstrap(lookup);
    }

    public static class FixnumRangeObjectSite
    extends RangeObjectSite {
        protected final long beginOrOnly;
        protected final long end;
        protected final boolean beginless;
        protected final boolean endless;

        public FixnumRangeObjectSite(MethodType type2, long beginOrOnly, long end2, boolean beginless, boolean endless, boolean exclusive) {
            super(type2, exclusive);
            this.beginOrOnly = beginOrOnly;
            this.end = end2;
            this.beginless = beginless;
            this.endless = endless;
        }

        public IRubyObject construct(ThreadContext context) throws Throwable {
            if (this.beginless) {
                return RubyRange.newBeginlessRange(context, this.beginOrOnly, this.exclusive);
            }
            if (this.endless) {
                return RubyRange.newEndlessRange(context, this.beginOrOnly, this.exclusive);
            }
            return RubyRange.newRange(context, this.beginOrOnly, this.end, this.exclusive);
        }
    }

    public static class StringRangeObjectSite
    extends RangeObjectSite {
        protected final ByteList begin;
        protected final int beginCR;
        protected final ByteList end;
        protected final int endCR;

        public StringRangeObjectSite(MethodType type2, ByteList begin2, int beginCR, ByteList end2, int endCR, boolean exclusive) {
            super(type2, exclusive);
            this.begin = begin2;
            this.beginCR = beginCR;
            this.end = end2;
            this.endCR = endCR;
        }

        public IRubyObject construct(ThreadContext context) throws Throwable {
            return RubyRange.newRange(context, IRRuntimeHelpers.newFrozenString(context, this.begin, this.beginCR), IRRuntimeHelpers.newFrozenString(context, this.end, this.endCR), this.exclusive);
        }
    }
}

