/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.Library;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.struct.Struct;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jnr.netdb.Service;
import jnr.netdb.ServicesDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeServicesDB
implements ServicesDB {
    private final LibServices lib;

    public NativeServicesDB(LibServices lib) {
        this.lib = lib;
    }

    static final ServicesDB load() {
        try {
            String[] stringArray;
            Platform.OS os = Platform.getPlatform().getOS();
            if (!(os.equals((Object)Platform.OS.DARWIN) || os.equals((Object)Platform.OS.LINUX) || os.equals((Object)Platform.OS.SOLARIS) || os.equals((Object)Platform.OS.FREEBSD) || os.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (os.equals((Object)Platform.OS.SOLARIS)) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "socket";
                stringArray2[1] = "nsl";
                stringArray = stringArray2;
                stringArray2[2] = "c";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "c";
            }
            String[] libnames = stringArray;
            LibServices lib = (LibServices)Library.loadLibrary(LibServices.class, (String[])libnames);
            lib.getservbyname("bootps", "udp");
            lib.getservbyport(67, "udp");
            return new NativeServicesDB(lib);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Override
    public Collection<Service> getAllServices() {
        return Collections.emptyList();
    }

    private final Service serviceFromNative(UnixServent s) {
        int port = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? (int)Short.reverseBytes((short)s.port.get()) : s.port.get();
        List<String> emptyAliases = Collections.emptyList();
        return s != null ? new Service(s.name.get(), port, s.proto.get(), emptyAliases) : null;
    }

    @Override
    public Service getServiceByName(String name, String proto) {
        return this.serviceFromNative(this.lib.getservbyname(name, proto));
    }

    @Override
    public Service getServiceByPort(Integer port, String proto) {
        short nport = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? Short.reverseBytes(port.shortValue()) : port.shortValue();
        return this.serviceFromNative(this.lib.getservbyport(Integer.valueOf(nport), proto));
    }

    public static interface LibServices {
        public UnixServent getservbyname(String var1, String var2);

        public UnixServent getservbyport(Integer var1, String var2);
    }

    public static class UnixServent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef((Struct)this);
        public final Struct.Pointer aliases = new Struct.Pointer((Struct)this);
        public final Struct.Signed32 port = new Struct.Signed32((Struct)this);
        public final Struct.String proto = new Struct.UTF8StringRef((Struct)this);
    }
}

