/*
 * Decompiled with CFR 0.152.
 */
package jnr.netdb;

import com.kenai.jaffl.Library;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.struct.Struct;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jnr.netdb.Protocol;
import jnr.netdb.ProtocolsDB;
import jnr.netdb.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NativeProtocolsDB
implements ProtocolsDB {
    private final LibProto lib;

    public static final NativeProtocolsDB getInstance() {
        return SingletonHolder.INSTANCE;
    }

    NativeProtocolsDB(LibProto lib) {
        this.lib = lib;
    }

    private static final NativeProtocolsDB load() {
        try {
            String[] stringArray;
            Platform.OS os = Platform.getPlatform().getOS();
            if (!(os.equals((Object)Platform.OS.DARWIN) || os.equals((Object)Platform.OS.LINUX) || os.equals((Object)Platform.OS.SOLARIS) || os.equals((Object)Platform.OS.FREEBSD) || os.equals((Object)Platform.OS.NETBSD))) {
                return null;
            }
            if (os.equals((Object)Platform.OS.SOLARIS)) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "socket";
                stringArray2[1] = "nsl";
                stringArray = stringArray2;
                stringArray2[2] = "c";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "c";
            }
            String[] libnames = stringArray;
            LibProto lib = (LibProto)Library.loadLibrary(LibProto.class, (String[])libnames);
            lib.getprotobyname("ip");
            lib.getprotobynumber(0);
            return new NativeProtocolsDB(lib);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public Collection<Service> getAllServices() {
        return Collections.emptyList();
    }

    private final Protocol protocolFromNative(UnixProtoent s) {
        int proto = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? (int)Short.reverseBytes((short)s.proto.get()) : s.proto.get();
        List<String> aliases = Collections.emptyList();
        return s != null ? new Protocol(s.name.get(), proto, aliases) : null;
    }

    @Override
    public Protocol getProtocolByName(String name) {
        return this.protocolFromNative(this.lib.getprotobyname(name));
    }

    @Override
    public Protocol getProtocolByNumber(Integer proto) {
        short nproto = ByteOrder.nativeOrder().equals(ByteOrder.LITTLE_ENDIAN) ? Short.reverseBytes(proto.shortValue()) : proto.shortValue();
        return this.protocolFromNative(this.lib.getprotobynumber(nproto));
    }

    @Override
    public Collection<Protocol> getAllProtocols() {
        return Collections.emptyList();
    }

    static /* synthetic */ NativeProtocolsDB access$000() {
        return NativeProtocolsDB.load();
    }

    public static interface LibProto {
        public UnixProtoent getprotobyname(String var1);

        public UnixProtoent getprotobynumber(int var1);
    }

    public static class UnixProtoent
    extends Struct {
        public final Struct.String name = new Struct.UTF8StringRef((Struct)this);
        public final Struct.Pointer aliases = new Struct.Pointer((Struct)this);
        public final Struct.Signed32 proto = new Struct.Signed32((Struct)this);
    }

    private static final class SingletonHolder {
        public static final NativeProtocolsDB INSTANCE = NativeProtocolsDB.access$000();

        private SingletonHolder() {
        }
    }
}

