/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import com.kenai.jffi.Function;
import com.kenai.jffi.InvocationBuffer;
import com.kenai.jffi.MemoryIO;
import com.kenai.jffi.ObjectBuffer;
import com.kenai.jffi.Platform;
import java.nio.Buffer;
import java.nio.ByteOrder;

public final class HeapInvocationBuffer
implements InvocationBuffer {
    private static final int PARAM_SIZE = 8;
    private static final Encoder encoder = HeapInvocationBuffer.getEncoder();
    private final Function function;
    private final byte[] buffer;
    private ObjectBuffer objectBuffer = null;
    private int paramOffset = 0;
    private int paramIndex = 0;

    public HeapInvocationBuffer(Function function) {
        this.function = function;
        this.buffer = new byte[encoder.getBufferSize(function)];
    }

    byte[] array() {
        return this.buffer;
    }

    ObjectBuffer objectBuffer() {
        return this.objectBuffer;
    }

    public final void putByte(int value) {
        this.paramOffset += encoder.putByte(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putShort(int value) {
        this.paramOffset += encoder.putShort(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putInt(int value) {
        this.paramOffset += encoder.putInt(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putLong(long value) {
        this.paramOffset += encoder.putLong(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putFloat(float value) {
        this.paramOffset += encoder.putFloat(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putDouble(double value) {
        this.paramOffset += encoder.putDouble(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    public final void putAddress(long value) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, value);
        ++this.paramIndex;
    }

    private final ObjectBuffer getObjectBuffer() {
        if (this.objectBuffer == null) {
            this.objectBuffer = new ObjectBuffer();
        }
        return this.objectBuffer;
    }

    public final void putArray(byte[] array, int offset, int length, int flags) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(short[] array, int offset, int length, int flags) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(int[] array, int offset, int length, int flags) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(long[] array, int offset, int length, int flags) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(float[] array, int offset, int length, int flags) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putArray(double[] array, int offset, int length, int flags) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putArray(this.paramIndex++, array, offset, length, flags);
    }

    public final void putDirectBuffer(Buffer value, int offset, int length) {
        this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, 0L);
        this.getObjectBuffer().putDirectBuffer(this.paramIndex++, value, offset, length);
    }

    public final void putStruct(byte[] struct, int offset) {
        int size = this.function.paramTypes[this.paramIndex].size;
        if (encoder.isRaw()) {
            System.arraycopy(struct, offset, this.buffer, this.paramOffset, size);
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset + size, 4);
        } else {
            this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, 0L);
            this.getObjectBuffer().putArray(this.paramIndex, struct, offset, size, 1);
        }
        ++this.paramIndex;
    }

    public final void putStruct(long struct) {
        int size = this.function.paramTypes[this.paramIndex].size;
        if (encoder.isRaw()) {
            MemoryIO.getInstance().getByteArray(struct, this.buffer, this.paramOffset, size);
            this.paramOffset = HeapInvocationBuffer.FFI_ALIGN(this.paramOffset + size, 4);
        } else {
            this.paramOffset += encoder.putAddress(this.buffer, this.paramOffset, struct);
        }
        ++this.paramIndex;
    }

    private static final Encoder getEncoder() {
        if (Platform.getPlatform().getCPU() == Platform.CPU.I386) {
            return Foreign.getInstance().isRawParameterPackingEnabled() ? HeapInvocationBuffer.newI386RawEncoder() : HeapInvocationBuffer.newLE32Encoder();
        }
        if (Platform.getPlatform().addressSize() == 64) {
            return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? HeapInvocationBuffer.newBE64Encoder() : HeapInvocationBuffer.newLE64Encoder();
        }
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? HeapInvocationBuffer.newBE32Encoder() : HeapInvocationBuffer.newLE32Encoder();
    }

    private static final Encoder newI386RawEncoder() {
        return new I386RawEncoder();
    }

    private static final Encoder newLE32Encoder() {
        return new DefaultEncoder(LE32ArrayIO.INSTANCE);
    }

    private static final Encoder newLE64Encoder() {
        return new DefaultEncoder(LE64ArrayIO.INSTANCE);
    }

    private static final Encoder newBE32Encoder() {
        return new DefaultEncoder(BE32ArrayIO.INSTANCE);
    }

    private static final Encoder newBE64Encoder() {
        return new DefaultEncoder(BE64ArrayIO.INSTANCE);
    }

    private static final int FFI_ALIGN(int v, int a) {
        return (v - 1 | a - 1) + 1;
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE64ArrayIO();

        private BE64ArrayIO() {
        }

        public void putAddress(byte[] buffer, int offset, long value) {
            this.putLong(buffer, offset, value);
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        static final ArrayIO INSTANCE = new BE32ArrayIO();

        private BE32ArrayIO() {
        }

        public void putAddress(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)value;
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        public final void putByte(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
        }

        public final void putShort(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 8);
            buffer[offset + 1] = (byte)value;
        }

        public final void putInt(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)value;
        }

        public final void putLong(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 56);
            buffer[offset + 1] = (byte)(value >> 48);
            buffer[offset + 2] = (byte)(value >> 40);
            buffer[offset + 3] = (byte)(value >> 32);
            buffer[offset + 4] = (byte)(value >> 24);
            buffer[offset + 5] = (byte)(value >> 16);
            buffer[offset + 6] = (byte)(value >> 8);
            buffer[offset + 7] = (byte)value;
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE64ArrayIO();

        private LE64ArrayIO() {
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putLong(buffer, offset, value);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        static final ArrayIO INSTANCE = new LE32ArrayIO();

        private LE32ArrayIO() {
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        public final void putByte(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
        }

        public final void putShort(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
        }

        public final void putInt(byte[] buffer, int offset, int value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }

        public final void putLong(byte[] buffer, int offset, long value) {
            buffer[offset] = (byte)value;
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
            buffer[offset + 4] = (byte)(value >> 32);
            buffer[offset + 5] = (byte)(value >> 40);
            buffer[offset + 6] = (byte)(value >> 48);
            buffer[offset + 7] = (byte)(value >> 56);
        }
    }

    private static abstract class ArrayIO {
        private ArrayIO() {
        }

        public abstract void putByte(byte[] var1, int var2, int var3);

        public abstract void putShort(byte[] var1, int var2, int var3);

        public abstract void putInt(byte[] var1, int var2, int var3);

        public abstract void putLong(byte[] var1, int var2, long var3);

        public final void putFloat(byte[] buffer, int offset, float value) {
            this.putInt(buffer, offset, Float.floatToRawIntBits(value));
        }

        public final void putDouble(byte[] buffer, int offset, double value) {
            this.putLong(buffer, offset, Double.doubleToRawLongBits(value));
        }

        public abstract void putAddress(byte[] var1, int var2, long var3);
    }

    private static final class DefaultEncoder
    extends Encoder {
        private final ArrayIO io;

        public DefaultEncoder(ArrayIO io) {
            this.io = io;
        }

        public final boolean isRaw() {
            return false;
        }

        public final int getBufferSize(Function function) {
            return function.getParameterCount() * 8;
        }

        public final int putByte(byte[] buffer, int offset, int value) {
            this.io.putByte(buffer, offset, value);
            return 8;
        }

        public final int putShort(byte[] buffer, int offset, int value) {
            this.io.putShort(buffer, offset, value);
            return 8;
        }

        public final int putInt(byte[] buffer, int offset, int value) {
            this.io.putInt(buffer, offset, value);
            return 8;
        }

        public final int putLong(byte[] buffer, int offset, long value) {
            this.io.putLong(buffer, offset, value);
            return 8;
        }

        public final int putFloat(byte[] buffer, int offset, float value) {
            this.io.putFloat(buffer, offset, value);
            return 8;
        }

        public final int putDouble(byte[] buffer, int offset, double value) {
            this.io.putDouble(buffer, offset, value);
            return 8;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            this.io.putAddress(buffer, offset, value);
            return 8;
        }
    }

    private static final class I386RawEncoder
    extends Encoder {
        private static final ArrayIO IO = LE32ArrayIO.INSTANCE;

        private I386RawEncoder() {
        }

        public final boolean isRaw() {
            return true;
        }

        public final int getBufferSize(Function function) {
            return function.getRawParameterSize();
        }

        public final int putByte(byte[] buffer, int offset, int value) {
            IO.putByte(buffer, offset, value);
            return 4;
        }

        public final int putShort(byte[] buffer, int offset, int value) {
            IO.putShort(buffer, offset, value);
            return 4;
        }

        public final int putInt(byte[] buffer, int offset, int value) {
            IO.putInt(buffer, offset, value);
            return 4;
        }

        public final int putLong(byte[] buffer, int offset, long value) {
            IO.putLong(buffer, offset, value);
            return 8;
        }

        public final int putFloat(byte[] buffer, int offset, float value) {
            IO.putFloat(buffer, offset, value);
            return 4;
        }

        public final int putDouble(byte[] buffer, int offset, double value) {
            IO.putDouble(buffer, offset, value);
            return 8;
        }

        public final int putAddress(byte[] buffer, int offset, long value) {
            IO.putAddress(buffer, offset, value);
            return 4;
        }
    }

    private static abstract class Encoder {
        private Encoder() {
        }

        public abstract boolean isRaw();

        public abstract int getBufferSize(Function var1);

        public abstract int putByte(byte[] var1, int var2, int var3);

        public abstract int putShort(byte[] var1, int var2, int var3);

        public abstract int putInt(byte[] var1, int var2, int var3);

        public abstract int putLong(byte[] var1, int var2, long var3);

        public abstract int putFloat(byte[] var1, int var2, float var3);

        public abstract int putDouble(byte[] var1, int var2, double var3);

        public abstract int putAddress(byte[] var1, int var2, long var3);
    }
}

