/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.Foreign;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Platform {
    private static final Platform platform;
    private static final String stubLibraryName = "jffi";
    private static final OS osType;
    public static final ARCH archType;
    private static final int javaVersionMajor;
    private final int addressSize;
    private final long addressMask;
    private final boolean isSupported;

    private Platform() {
        int dataModel = Integer.getInteger("sun.arch.data.model");
        if (dataModel != 32 && dataModel != 64) {
            throw new IllegalArgumentException("Unsupported data model");
        }
        this.addressSize = dataModel;
        this.isSupported = this.getStubLibraryStream() != null;
        this.addressMask = this.addressSize == 32 ? 0xFFFFFFFFL : -1L;
    }

    public static final Platform getPlatform() {
        return platform;
    }

    public static final OS getOS() {
        return osType;
    }

    public static final ARCH getArch() {
        return archType;
    }

    public static final boolean is64() {
        return Platform.getPlatform().addressSize() == 64;
    }

    public static final boolean isMac() {
        return osType == OS.MAC || osType == OS.DARWIN;
    }

    public static final boolean isLinux() {
        return osType == OS.LINUX;
    }

    public static final boolean isWindows() {
        return osType == OS.WINDOWS;
    }

    public static final boolean isSolaris() {
        return osType == OS.SUNOS;
    }

    public static final boolean isFreeBSD() {
        return osType == OS.FREEBSD;
    }

    public static final boolean isBSD() {
        return Platform.isMac() || Platform.isFreeBSD();
    }

    public static final boolean isUnix() {
        return !Platform.isWindows();
    }

    public final int javaVersion() {
        return javaVersionMajor;
    }

    public final int longSize() {
        return this.addressSize;
    }

    public final int addressSize() {
        return this.addressSize;
    }

    public final long addressMask() {
        return this.addressMask;
    }

    public final String getName() {
        if (Platform.isMac()) {
            return "Darwin";
        }
        String osName = System.getProperty("os.name").split(" ")[0];
        return System.getProperty("os.arch") + "-" + osName;
    }

    public String mapLibraryName(String libName) {
        if (libName.matches(this.getLibraryNamePattern())) {
            return libName;
        }
        return System.mapLibraryName(libName);
    }

    public String getLibraryNamePattern() {
        return "lib.*\\.so.*$";
    }

    public File locateLibrary(String libName, List<String> libraryPath) {
        String mappedName = this.mapLibraryName(libName);
        for (String path : libraryPath) {
            File libFile = new File(path, mappedName);
            if (!libFile.exists()) continue;
            return libFile;
        }
        return new File(mappedName);
    }

    public String getStubLibraryName() {
        return stubLibraryName;
    }

    public String getStubLibraryPath() {
        return "/jni/" + this.getName() + "/" + System.mapLibraryName(stubLibraryName);
    }

    public InputStream getStubLibraryStream() {
        return Platform.class.getResourceAsStream(this.getStubLibraryPath());
    }

    public boolean isSupported() {
        try {
            return Foreign.getInstance() != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    static {
        String osName = System.getProperty("os.name").split(" ")[0];
        OS os = OS.UNKNOWN;
        try {
            os = OS.valueOf(osName.toUpperCase());
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError("Unknown Operating System");
        }
        switch (os) {
            case MAC: 
            case DARWIN: {
                platform = new MacOSX();
                break;
            }
            case LINUX: {
                platform = new Linux();
                break;
            }
            case WINDOWS: {
                platform = new Windows();
                break;
            }
            default: {
                platform = new Platform();
            }
        }
        osType = os;
        ARCH arch = ARCH.UNKNOWN;
        try {
            arch = ARCH.valueOf(System.getProperty("os.arch").toUpperCase());
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError("Unknown CPU architecture");
        }
        archType = arch;
        int version = 5;
        try {
            String versionString = System.getProperty("java.version");
            if (versionString != null) {
                String[] v = versionString.split("\\.");
                version = Integer.valueOf(v[1]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        javaVersionMajor = version;
    }

    private static class Windows
    extends Platform {
        private Windows() {
        }

        public String getLibraryNamePattern() {
            return ".*\\.dll$";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Linux
    extends Platform {
        private Linux() {
        }

        @Override
        public File locateLibrary(final String libName, List<String> libraryPath) {
            FilenameFilter filter = new FilenameFilter(){
                Pattern p;
                String exact;
                {
                    this.p = Pattern.compile("lib" + libName + "\\.so\\.[0-9]+$");
                    this.exact = "lib" + libName + ".so";
                }

                public boolean accept(File dir, String name) {
                    return this.p.matcher(name).matches() || this.exact.equals(name);
                }
            };
            LinkedList<File> matches = new LinkedList<File>();
            for (String path : libraryPath) {
                File[] files = new File(path).listFiles(filter);
                if (files == null || files.length <= 0) continue;
                matches.addAll(Arrays.asList(files));
            }
            int version = 0;
            String bestMatch = null;
            for (File file : matches) {
                String path = file.getAbsolutePath();
                if (bestMatch == null && path.endsWith(".so")) {
                    bestMatch = path;
                    version = 0;
                    continue;
                }
                String num = path.substring(path.lastIndexOf(".so.") + 4);
                try {
                    if (Integer.parseInt(num) < version) continue;
                    bestMatch = path;
                }
                catch (NumberFormatException e) {}
            }
            return bestMatch != null ? new File(bestMatch) : new File(this.mapLibraryName(libName));
        }
    }

    private static class MacOSX
    extends Platform {
        private MacOSX() {
        }

        public String mapLibraryName(String libName) {
            if (libName.matches(this.getLibraryNamePattern())) {
                return libName;
            }
            return "lib" + libName + ".dylib";
        }

        public String getLibraryNamePattern() {
            return "lib.*\\.(dylib|jnilib)$";
        }

        public InputStream getStubLibraryStream() {
            InputStream is = super.getStubLibraryStream();
            if (is != null) {
                return is;
            }
            return Platform.class.getResourceAsStream(this.getStubLibraryPath().replaceAll("dylib", "jnilib"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ARCH {
        I386,
        X86_64,
        PPC,
        SPARC,
        SPARCV9,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        DARWIN,
        FREEBSD,
        LINUX,
        MAC,
        NETBSD,
        OPENBSD,
        SUNOS,
        WINDOWS,
        UNKNOWN;

    }
}

