/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NativeLong
extends Number
implements Comparable<NativeLong> {
    public static final int SIZE = Platform.getPlatform().longSize();
    public static final int SHIFT = SIZE == 32 ? 2 : 3;
    public static final long MASK = SIZE == 32 ? 0xFFFFFFFFL : -1L;
    private static final NativeLong ZERO = new NativeLong(0L);
    private static final NativeLong ONE = new NativeLong(1L);
    private static final NativeLong MINUS_ONE = new NativeLong(-1L);
    private final long value;

    public NativeLong(long value) {
        this.value = value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public final boolean equals(Object obj) {
        return obj instanceof NativeLong && this.value == ((NativeLong)obj).value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public final int compareTo(NativeLong other) {
        return this.value < other.value ? -1 : (this.value > other.value ? 1 : 0);
    }

    private static final NativeLong _valueOf(long value) {
        if (value >= -128L && value <= 127L) {
            return Cache.get(value);
        }
        return new NativeLong(value);
    }

    public static final NativeLong valueOf(long value) {
        return value == 0L ? ZERO : (value == 1L ? ONE : (value == -1L ? MINUS_ONE : NativeLong._valueOf(value)));
    }

    private static final class Cache {
        private final NativeLong[] cache = new NativeLong[256];
        private static final Cache INSTANCE = new Cache();

        private Cache() {
            for (int i = 0; i < this.cache.length; ++i) {
                this.cache[i] = new NativeLong(i - 128);
            }
            this.cache[128] = ZERO;
            this.cache[129] = ONE;
            this.cache[127] = MINUS_ONE;
        }

        public static final NativeLong get(long value) {
            return Cache.INSTANCE.cache[128 + (int)value];
        }
    }
}

