/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.Address;
import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.provider.DelegatingMemoryIO;
import java.nio.charset.Charset;

public class BoundedMemoryIO
extends AbstractMemoryIO
implements DelegatingMemoryIO {
    private final long base;
    private final long size;
    private final MemoryIO io;

    public BoundedMemoryIO(MemoryIO parent, long offset, long size) {
        this.io = parent;
        this.base = offset;
        this.size = size;
    }

    public boolean isDirect() {
        return this.getDelegatedMemoryIO().isDirect();
    }

    public long getAddress() {
        return this.getDelegatedMemoryIO().getAddress();
    }

    public MemoryIO getDelegatedMemoryIO() {
        return this.io;
    }

    public byte getByte(long offset) {
        BoundedMemoryIO.checkBounds(this.size, offset, 1L);
        return this.io.getByte(this.base + offset);
    }

    public short getShort(long offset) {
        BoundedMemoryIO.checkBounds(this.size, offset, 2L);
        return this.io.getShort(this.base + offset);
    }

    public int getInt(long offset) {
        BoundedMemoryIO.checkBounds(this.size, offset, 4L);
        return this.io.getInt(this.base + offset);
    }

    public long getLong(long offset) {
        BoundedMemoryIO.checkBounds(this.size, offset, 8L);
        return this.io.getLong(this.base + offset);
    }

    public float getFloat(long offset) {
        BoundedMemoryIO.checkBounds(this.size, offset, 4L);
        return this.io.getFloat(this.base + offset);
    }

    public double getDouble(long offset) {
        BoundedMemoryIO.checkBounds(this.size, offset, 8L);
        return this.io.getDouble(this.base + offset);
    }

    public Pointer getPointer(long offset) {
        BoundedMemoryIO.checkBounds(this.size, offset, Address.SIZE / 8);
        return this.io.getPointer(this.base + offset);
    }

    public MemoryIO getMemoryIO(long offset) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset, Address.SIZE / 8);
        return this.io.getMemoryIO(this.base + offset);
    }

    public MemoryIO getMemoryIO(long offset, long size) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset, Address.SIZE / 8);
        return this.io.getMemoryIO(this.base + offset, size);
    }

    public void putByte(long offset, byte value) {
        BoundedMemoryIO.checkBounds(this.size, offset, 1L);
        this.io.putByte(this.base + offset, value);
    }

    public void putShort(long offset, short value) {
        BoundedMemoryIO.checkBounds(this.size, offset, 2L);
        this.io.putShort(this.base + offset, value);
    }

    public void putInt(long offset, int value) {
        BoundedMemoryIO.checkBounds(this.size, offset, 4L);
        this.io.putInt(this.base + offset, value);
    }

    public void putLong(long offset, long value) {
        BoundedMemoryIO.checkBounds(this.size, offset, 8L);
        this.io.putLong(this.base + offset, value);
    }

    public void putFloat(long offset, float value) {
        BoundedMemoryIO.checkBounds(this.size, offset, 4L);
        this.io.putFloat(this.base + offset, value);
    }

    public void putDouble(long offset, double value) {
        BoundedMemoryIO.checkBounds(this.size, offset, 8L);
        this.io.putDouble(this.base + offset, value);
    }

    public void putPointer(long offset, Pointer value) {
        BoundedMemoryIO.checkBounds(this.size, offset, Address.SIZE / 8);
        this.io.putPointer(this.base + offset, value);
    }

    public void get(long offset, byte[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len);
        this.io.get(this.base + offset, dst, off, len);
    }

    public void put(long offset, byte[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len);
        this.io.put(this.base + offset, dst, off, len);
    }

    public void get(long offset, short[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 16 / 8);
        this.io.get(this.base + offset, dst, off, len);
    }

    public void put(long offset, short[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 16 / 8);
        this.io.put(this.base + offset, dst, off, len);
    }

    public void get(long offset, int[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 32 / 8);
        this.io.get(this.base + offset, dst, off, len);
    }

    public void put(long offset, int[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 32 / 8);
        this.io.put(this.base + offset, dst, off, len);
    }

    public void get(long offset, long[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 64 / 8);
        this.io.get(this.base + offset, dst, off, len);
    }

    public void put(long offset, long[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 64 / 8);
        this.io.put(this.base + offset, dst, off, len);
    }

    public void get(long offset, float[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 32 / 8);
        this.io.get(this.base + offset, dst, off, len);
    }

    public void put(long offset, float[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 32 / 8);
        this.io.put(this.base + offset, dst, off, len);
    }

    public void get(long offset, double[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 64 / 8);
        this.io.get(this.base + offset, dst, off, len);
    }

    public void put(long offset, double[] dst, int off, int len) {
        BoundedMemoryIO.checkBounds(this.size, offset, len * 64 / 8);
        this.io.put(this.base + offset, dst, off, len);
    }

    public long getAddress(long offset) {
        BoundedMemoryIO.checkBounds(this.size, offset, Address.SIZE >> 3);
        return this.io.getAddress(this.base + offset);
    }

    public String getString(long offset, int maxLength, Charset cs) {
        BoundedMemoryIO.checkBounds(this.size, offset, maxLength);
        return this.io.getString(this.base + offset, maxLength, cs);
    }

    public String getString(long offset) {
        return this.io.getString(this.base + offset, (int)this.size, Charset.defaultCharset());
    }

    public void putAddress(long offset, long value) {
        BoundedMemoryIO.checkBounds(this.size, offset, Address.SIZE >> 3);
        this.io.putAddress(this.base + offset, value);
    }

    public void putAddress(long offset, Address value) {
        BoundedMemoryIO.checkBounds(this.size, offset, Address.SIZE >> 3);
        this.io.putAddress(this.base + offset, value);
    }

    public void putString(long offset, String string, int maxLength, Charset cs) {
        BoundedMemoryIO.checkBounds(this.size, offset, maxLength);
        this.io.putString(this.base + offset, string, maxLength, cs);
    }

    public int indexOf(long offset, byte value) {
        return this.io.indexOf(this.base + offset, value, (int)this.size);
    }

    public int indexOf(long offset, byte value, int maxlen) {
        BoundedMemoryIO.checkBounds(this.size, offset, maxlen);
        return this.io.indexOf(this.base + offset, value, maxlen);
    }

    public void setMemory(long offset, long size, byte value) {
        BoundedMemoryIO.checkBounds(this.size, this.base + offset, size);
        this.io.setMemory(this.base + offset, size, value);
    }
}

