/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jna;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.Pointer;
import com.kenai.jaffl.provider.MemoryManager;
import com.kenai.jaffl.provider.jna.BufferMemoryIO;
import com.kenai.jaffl.provider.jna.JNAPointer;
import com.kenai.jaffl.provider.jna.PointerMemoryIO;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import java.nio.Buffer;
import java.nio.ByteBuffer;

class JNAMemoryManager
implements MemoryManager {
    JNAMemoryManager() {
    }

    public MemoryIO allocate(int size) {
        return this.allocateDirect(size, true);
    }

    public MemoryIO allocateDirect(int size) {
        return new PointerMemoryIO((com.sun.jna.Pointer)new Memory((long)size));
    }

    public MemoryIO allocateDirect(int size, boolean clear) {
        Memory m = new Memory((long)size);
        if (clear) {
            m.clear();
        }
        return new PointerMemoryIO((com.sun.jna.Pointer)m);
    }

    public MemoryIO wrap(Pointer address) {
        return new PointerMemoryIO(((JNAPointer)address).getNativePointer());
    }

    public MemoryIO wrap(Pointer address, int size) {
        return new PointerMemoryIO(((JNAPointer)address).getNativePointer());
    }

    public MemoryIO wrap(ByteBuffer buffer) {
        return new BufferMemoryIO(buffer);
    }

    public Pointer getBufferPointer(Buffer buffer) {
        return new JNAPointer(Native.getDirectBufferPointer((Buffer)buffer));
    }
}

