/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.struct;

import com.kenai.jaffl.Platform;
import com.kenai.jaffl.struct.Struct;
import java.lang.reflect.Field;

public class StructLayout {
    int size = 0;
    int minAlign = 1;
    boolean isUnion = false;
    boolean resetIndex = false;

    protected final int addField(int sizeBits, int alignBits, Struct.Offset offset) {
        this.size = Math.max(this.size, offset.intValue() + (sizeBits >> 3));
        this.minAlign = Math.max(this.minAlign, alignBits >> 3);
        return offset.intValue();
    }

    protected final int addField(int sizeBits, int alignBits, int offset) {
        this.size = Math.max(this.size, offset + (sizeBits >> 3));
        this.minAlign = Math.max(this.minAlign, alignBits >> 3);
        return offset;
    }

    protected final int addField(int sizeBits, int alignBits) {
        int off;
        int mask = (alignBits >> 3) - 1;
        int n = off = this.resetIndex ? 0 : this.size;
        if ((off & mask) != 0) {
            off = (off & ~mask) + (alignBits >> 3);
        }
        this.size = Math.max(this.size, off + (sizeBits >> 3));
        this.minAlign = Math.max(this.minAlign, alignBits >> 3);
        return off;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Field[] fields = this.getClass().getDeclaredFields();
        sb.append(this.getClass().getSimpleName() + " { \n");
        String fieldPrefix = "    ";
        for (Field field : fields) {
            try {
                sb.append("    ");
                sb.append(field.getName()).append(" = ");
                sb.append(field.get(this).toString());
                sb.append("\n");
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    protected abstract class Number
    extends Member {
        protected Number(int sizeBits, int alignBits) {
            super(sizeBits, alignBits);
        }

        protected Number(int sizeBits, int alignBits, Struct.Offset offset) {
            super(sizeBits, alignBits);
        }

        public abstract void set(Struct var1, java.lang.Number var2);

        public abstract int intValue(Struct var1);

        public double doubleValue(Struct struct) {
            return this.longValue(struct);
        }

        public float floatValue(Struct struct) {
            return this.intValue(struct);
        }

        public long longValue(Struct struct) {
            return this.intValue(struct);
        }

        public String toString(Struct struct) {
            return Integer.toString(this.intValue(struct), 10);
        }
    }

    protected abstract class Member {
        public final int size;
        public final int offset;

        public Member(int sizeBits, int alignBits, Struct.Offset offset) {
            this.size = sizeBits;
            this.offset = StructLayout.this.addField(sizeBits, alignBits, offset);
        }

        public Member(int size, int align) {
            this.size = size;
            this.offset = StructLayout.this.addField(size, align);
        }
    }

    protected static final class Constants {
        static final int LONG_SIZE = Platform.getPlatform().longSize();
        static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
        static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
        static final int LONG_ALIGN = Constants.isSparc() ? 64 : ADDRESS_SIZE;
        static final int ADDRESS_ALIGN = Constants.isSparc() ? 64 : ADDRESS_SIZE;
        static final int DOUBLE_ALIGN = Constants.isSparc() ? 64 : ADDRESS_SIZE;
        static final int FLOAT_ALIGN = Constants.isSparc() ? 64 : 32;

        protected Constants() {
        }

        private static final boolean isSparc() {
            return Platform.getPlatform().getCPU() == Platform.CPU.SPARC;
        }
    }
}

