/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jffi;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.jffi.DefaultInvokerFactory;
import com.kenai.jaffl.provider.jffi.FastIntInvokerFactory;
import com.kenai.jaffl.provider.jffi.InvokerFactory;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Library
extends com.kenai.jaffl.provider.Library {
    private static final Map<String, WeakReference<Library>> cache = new ConcurrentHashMap<String, WeakReference<Library>>();
    private static final Object cacheLock = new Object();
    private final String libraryName;
    private volatile com.kenai.jffi.Library nativeLibrary;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Library getInstance(String name) {
        Object object = cacheLock;
        synchronized (object) {
            Library lib;
            WeakReference<Library> ref = cache.get(name);
            if (ref != null && (lib = (Library)ref.get()) != null) {
                return lib;
            }
            lib = new Library(name);
            cache.put(name, new WeakReference<Library>(lib));
            return lib;
        }
    }

    Library(String name) {
        this.libraryName = name;
    }

    @Override
    public Invoker getInvoker(Method method, Map<LibraryOption, ?> options) {
        InvokerFactory factory = FastIntInvokerFactory.getInstance().isMethodSupported(method) ? FastIntInvokerFactory.getInstance() : DefaultInvokerFactory.getInstance();
        return factory.createInvoker(method, this, options);
    }

    @Override
    public Object libraryLock() {
        return this;
    }

    synchronized com.kenai.jffi.Library getNativeLibrary() {
        if (this.nativeLibrary == null) {
            String path;
            com.kenai.jffi.Library lib = com.kenai.jffi.Library.getCachedInstance((String)this.libraryName, (int)1);
            if (lib == null && this.libraryName != null && (path = Library.locateLibrary(this.libraryName)) != null && !this.libraryName.equals(path)) {
                lib = com.kenai.jffi.Library.getCachedInstance((String)path, (int)1);
            }
            if (lib == null) {
                throw new UnsatisfiedLinkError(com.kenai.jffi.Library.getLastError());
            }
            this.nativeLibrary = lib;
        }
        return this.nativeLibrary;
    }
}

