/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider;

import com.kenai.jaffl.Platform;
import com.kenai.jaffl.provider.AbstractMemoryIO;
import com.kenai.jaffl.provider.StringIO;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Arrays;

public abstract class AbstractArrayMemoryIO
extends AbstractMemoryIO {
    protected static final ArrayIO IO = AbstractArrayMemoryIO.getArrayIO();
    protected static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected final byte[] buffer;
    protected final int offset;
    protected final int length;

    public AbstractArrayMemoryIO(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public AbstractArrayMemoryIO(byte[] buffer) {
        this(buffer, 0, buffer.length);
    }

    public AbstractArrayMemoryIO(int size) {
        this(new byte[size], 0, size);
    }

    public final byte[] array() {
        return this.buffer;
    }

    public final int offset() {
        return this.offset;
    }

    public final int length() {
        return this.length;
    }

    public final boolean isDirect() {
        return false;
    }

    private static final ArrayIO getArrayIO() {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return Platform.getPlatform().addressSize() == 64 ? AbstractArrayMemoryIO.newBE64ArrayIO() : AbstractArrayMemoryIO.newBE32ArrayIO();
        }
        return Platform.getPlatform().addressSize() == 64 ? AbstractArrayMemoryIO.newLE64ArrayIO() : AbstractArrayMemoryIO.newLE32ArrayIO();
    }

    private static final ArrayIO newBE64ArrayIO() {
        return new BE64ArrayIO();
    }

    private static final ArrayIO newBE32ArrayIO() {
        return new BE32ArrayIO();
    }

    private static final ArrayIO newLE64ArrayIO() {
        return new LE64ArrayIO();
    }

    private static final ArrayIO newLE32ArrayIO() {
        return new LE32ArrayIO();
    }

    protected final int index(long off) {
        return this.offset + (int)off;
    }

    public final boolean isNull() {
        return false;
    }

    public String getString(long offset, int maxLength, Charset cs) {
        ByteBuffer tmp = ByteBuffer.wrap(this.buffer, this.index(offset), this.length - (int)offset);
        return ((Object)StringIO.getStringIO().fromNative(tmp, Math.min(maxLength, this.length - (int)offset))).toString();
    }

    public void putString(long offset, String string, int maxLength, Charset cs) {
        StringIO.getStringIO().toNative(string, ByteBuffer.wrap(this.buffer, this.index(offset), Math.min(maxLength, this.length - (int)offset)));
    }

    public final byte getByte(long offset) {
        return (byte)(this.buffer[this.index(offset)] & 0xFF);
    }

    public final short getShort(long offset) {
        return IO.getInt16(this.buffer, this.index(offset));
    }

    public final int getInt(long offset) {
        return IO.getInt32(this.buffer, this.index(offset));
    }

    public final long getLong(long offset) {
        return IO.getInt64(this.buffer, this.index(offset));
    }

    public final long getAddress(long offset) {
        return IO.getAddress(this.buffer, this.index(offset));
    }

    public final float getFloat(long offset) {
        return IO.getFloat32(this.buffer, this.index(offset));
    }

    public final double getDouble(long offset) {
        return IO.getFloat64(this.buffer, this.index(offset));
    }

    public final void putByte(long offset, byte value) {
        this.buffer[this.index((long)offset)] = value;
    }

    public final void putShort(long offset, short value) {
        IO.putInt16(this.buffer, this.index(offset), value);
    }

    public final void putInt(long offset, int value) {
        IO.putInt32(this.buffer, this.index(offset), value);
    }

    public final void putLong(long offset, long value) {
        IO.putInt64(this.buffer, this.index(offset), value);
    }

    public final void putAddress(long offset, long value) {
        IO.putAddress(this.buffer, this.index(offset), value);
    }

    public final void putFloat(long offset, float value) {
        IO.putFloat32(this.buffer, this.index(offset), value);
    }

    public final void putDouble(long offset, double value) {
        IO.putFloat64(this.buffer, this.index(offset), value);
    }

    public final void get(long offset, byte[] dst, int off, int len) {
        System.arraycopy(this.buffer, this.index(offset), dst, off, len);
    }

    public final void put(long offset, byte[] src, int off, int len) {
        System.arraycopy(src, off, this.buffer, this.index(offset), len);
    }

    public final void get(long offset, short[] dst, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getInt16(this.buffer, begin + (i << 1));
        }
    }

    public final void put(long offset, short[] src, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putInt16(this.buffer, begin + (i << 1), src[off + i]);
        }
    }

    public final void get(long offset, int[] dst, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getInt32(this.buffer, begin + (i << 2));
        }
    }

    public final void put(long offset, int[] src, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putInt32(this.buffer, begin + (i << 2), src[off + i]);
        }
    }

    public final void get(long offset, long[] dst, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getInt64(this.buffer, begin + (i << 3));
        }
    }

    public final void put(long offset, long[] src, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putInt64(this.buffer, begin + (i << 3), src[off + i]);
        }
    }

    public final void get(long offset, float[] dst, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getFloat32(this.buffer, begin + (i << 2));
        }
    }

    public final void put(long offset, float[] src, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putFloat32(this.buffer, begin + (i << 2), src[off + i]);
        }
    }

    public final void get(long offset, double[] dst, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getFloat64(this.buffer, begin + (i << 3));
        }
    }

    public final void put(long offset, double[] src, int off, int len) {
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putFloat64(this.buffer, begin + (i << 3), src[off + i]);
        }
    }

    public final int indexOf(long offset, byte value) {
        int off = this.index(offset);
        for (int i = 0; i < this.length; ++i) {
            if (this.buffer[off + i] != value) continue;
            return i;
        }
        return -1;
    }

    public final int indexOf(long offset, byte value, int maxlen) {
        int off = this.index(offset);
        for (int i = 0; i < Math.min(this.length, maxlen); ++i) {
            if (this.buffer[off + i] != value) continue;
            return i;
        }
        return -1;
    }

    public final void setMemory(long offset, long size, byte value) {
        Arrays.fill(this.buffer, this.index(offset), (int)size, value);
    }

    public final void clear() {
        Arrays.fill(this.buffer, this.offset, this.length, (byte)0);
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        private BE64ArrayIO() {
        }

        public final long getAddress(byte[] buffer, int offset) {
            return this.getInt64(buffer, offset);
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putInt64(buffer, offset, value);
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        private BE32ArrayIO() {
        }

        public final long getAddress(byte[] buffer, int offset) {
            return (long)this.getInt32(buffer, offset) & 0xFFFFFFFFL;
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putInt32(buffer, offset, (int)value);
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        private LE64ArrayIO() {
        }

        public final long getAddress(byte[] buffer, int offset) {
            return this.getInt64(buffer, offset);
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putInt64(buffer, offset, value);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        private LE32ArrayIO() {
        }

        public final long getAddress(byte[] buffer, int offset) {
            return (long)this.getInt32(buffer, offset) & 0xFFFFFFFFL;
        }

        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putInt32(buffer, offset, (int)value);
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        public short getInt16(byte[] array, int offset) {
            return (short)((array[offset + 0] & 0xFF) << 8 | array[offset + 1] & 0xFF);
        }

        public int getInt32(byte[] array, int offset) {
            return (array[offset + 0] & 0xFF) << 24 | (array[offset + 1] & 0xFF) << 16 | (array[offset + 2] & 0xFF) << 8 | (array[offset + 3] & 0xFF) << 0;
        }

        public long getInt64(byte[] array, int offset) {
            return ((long)array[offset + 0] & 0xFFL) << 56 | ((long)array[offset + 1] & 0xFFL) << 48 | ((long)array[offset + 2] & 0xFFL) << 40 | ((long)array[offset + 3] & 0xFFL) << 32 | ((long)array[offset + 4] & 0xFFL) << 24 | ((long)array[offset + 5] & 0xFFL) << 16 | ((long)array[offset + 6] & 0xFFL) << 8 | ((long)array[offset + 7] & 0xFFL) << 0;
        }

        public final void putInt16(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 8);
            buffer[offset + 1] = (byte)(value >> 0);
        }

        public final void putInt32(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)(value >> 0);
        }

        public final void putInt64(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 56);
            buffer[offset + 1] = (byte)(value >> 48);
            buffer[offset + 2] = (byte)(value >> 40);
            buffer[offset + 3] = (byte)(value >> 32);
            buffer[offset + 4] = (byte)(value >> 24);
            buffer[offset + 5] = (byte)(value >> 16);
            buffer[offset + 6] = (byte)(value >> 8);
            buffer[offset + 7] = (byte)(value >> 0);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        public final short getInt16(byte[] array, int offset) {
            return (short)(array[offset] & 0xFF | (array[offset + 1] & 0xFF) << 8);
        }

        public final int getInt32(byte[] array, int offset) {
            return (array[offset + 0] & 0xFF) << 0 | (array[offset + 1] & 0xFF) << 8 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 3] & 0xFF) << 24;
        }

        public final long getInt64(byte[] array, int offset) {
            return ((long)array[offset + 0] & 0xFFL) << 0 | ((long)array[offset + 1] & 0xFFL) << 8 | ((long)array[offset + 2] & 0xFFL) << 16 | ((long)array[offset + 3] & 0xFFL) << 24 | ((long)array[offset + 4] & 0xFFL) << 32 | ((long)array[offset + 5] & 0xFFL) << 40 | ((long)array[offset + 6] & 0xFFL) << 48 | ((long)array[offset + 7] & 0xFFL) << 56;
        }

        public final void putInt16(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 0);
            buffer[offset + 1] = (byte)(value >> 8);
        }

        public final void putInt32(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 0);
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }

        public final void putInt64(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 0);
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
            buffer[offset + 4] = (byte)(value >> 32);
            buffer[offset + 5] = (byte)(value >> 40);
            buffer[offset + 6] = (byte)(value >> 48);
            buffer[offset + 7] = (byte)(value >> 56);
        }
    }

    protected static abstract class ArrayIO {
        protected ArrayIO() {
        }

        public abstract short getInt16(byte[] var1, int var2);

        public abstract int getInt32(byte[] var1, int var2);

        public abstract long getInt64(byte[] var1, int var2);

        public abstract long getAddress(byte[] var1, int var2);

        public abstract void putInt16(byte[] var1, int var2, int var3);

        public abstract void putInt32(byte[] var1, int var2, int var3);

        public abstract void putInt64(byte[] var1, int var2, long var3);

        public abstract void putAddress(byte[] var1, int var2, long var3);

        public final float getFloat32(byte[] buffer, int offset) {
            return Float.intBitsToFloat(this.getInt32(buffer, offset));
        }

        public final void putFloat32(byte[] buffer, int offset, float value) {
            this.putInt32(buffer, offset, Float.floatToRawIntBits(value));
        }

        public final double getFloat64(byte[] buffer, int offset) {
            return Double.longBitsToDouble(this.getInt64(buffer, offset));
        }

        public final void putFloat64(byte[] buffer, int offset, double value) {
            this.putInt64(buffer, offset, Double.doubleToRawLongBits(value));
        }
    }
}

