/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.struct;

import com.kenai.jaffl.MemoryIO;
import com.kenai.jaffl.ParameterFlags;
import com.kenai.jaffl.Platform;
import com.kenai.jaffl.util.EnumMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Struct {
    final Info __info = new Info();

    protected Struct() {
    }

    Struct(boolean isUnion) {
        this.__info.resetIndex = isUnion;
    }

    public void useMemory(MemoryIO address) {
        this.__info.useMemory(address);
    }

    public void useMemory(com.kenai.jaffl.Pointer address) {
        this.__info.useMemory(MemoryIO.wrap(address));
    }

    public java.lang.String toString() {
        StringBuilder sb = new StringBuilder();
        Field[] fields = this.getClass().getDeclaredFields();
        sb.append(this.getClass().getSimpleName() + " { \n");
        java.lang.String fieldPrefix = "    ";
        for (Field field : fields) {
            try {
                sb.append("    ");
                sb.append(field.getName()).append(" = ");
                sb.append(field.get(this).toString());
                sb.append("\n");
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        sb.append("}\n");
        return sb.toString();
    }

    protected final void arrayBegin() {
        this.__info.resetIndex = false;
    }

    protected final void arrayEnd() {
        this.__info.resetIndex = this.__info.isUnion;
    }

    protected <T extends Member> T[] array(T[] array) {
        this.arrayBegin();
        try {
            Class<?> arrayClass = array.getClass().getComponentType();
            Constructor<?> ctor = arrayClass.getDeclaredConstructor(arrayClass.getEnclosingClass());
            Object[] parameters = new Object[]{this};
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Member)ctor.newInstance(parameters);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed8[] array(Signed8[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed8();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned8[] array(Unsigned8[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned8();
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed16[] array(Signed16[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed16();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned16[] array(Unsigned16[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned16();
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed32[] array(Signed32[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed32();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned32[] array(Unsigned32[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned32();
        }
        this.arrayEnd();
        return array;
    }

    protected final Signed64[] array(Signed64[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Signed64();
        }
        this.arrayEnd();
        return array;
    }

    protected final Unsigned64[] array(Unsigned64[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Unsigned64();
        }
        this.arrayEnd();
        return array;
    }

    protected final SignedLong[] array(SignedLong[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new SignedLong();
        }
        this.arrayEnd();
        return array;
    }

    protected final UnsignedLong[] array(UnsignedLong[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new UnsignedLong();
        }
        this.arrayEnd();
        return array;
    }

    protected final Float[] array(Float[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Float();
        }
        this.arrayEnd();
        return array;
    }

    protected final Double[] array(Double[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Double();
        }
        this.arrayEnd();
        return array;
    }

    protected final Address[] array(Address[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Address();
        }
        this.arrayEnd();
        return array;
    }

    protected final Pointer[] array(Pointer[] array) {
        this.arrayBegin();
        for (int i = 0; i < array.length; ++i) {
            array[i] = new Pointer();
        }
        this.arrayEnd();
        return array;
    }

    public class AsciiStringRef
    extends UTFStringRef {
        public AsciiStringRef(int size) {
            super(size, Charset.forName("ASCII"));
        }

        public AsciiStringRef() {
            super(Integer.MAX_VALUE, Charset.forName("ASCII"));
        }
    }

    public class UTF8StringRef
    extends UTFStringRef {
        public UTF8StringRef(int size) {
            super(size, Charset.forName("UTF-8"));
        }

        public UTF8StringRef() {
            super(Integer.MAX_VALUE, Charset.forName("UTF-8"));
        }
    }

    public class UTFStringRef
    extends String {
        public UTFStringRef(int length, Charset cs) {
            super(Constants.ADDRESS_SIZE, Constants.ADDRESS_SIZE, length, cs);
        }

        public UTFStringRef(Charset cs) {
            this(Integer.MAX_VALUE, cs);
        }

        protected MemoryIO getStringMemory() {
            return this.getMemoryIO().getMemoryIO(this.offset, this.length());
        }
    }

    public class AsciiString
    extends UTFString {
        public AsciiString(int size) {
            super(size, Charset.forName("ASCII"));
        }
    }

    public class UTF8String
    extends UTFString {
        public UTF8String(int size) {
            super(size, Charset.forName("UTF-8"));
        }
    }

    public class UTFString
    extends String {
        public UTFString(int length, Charset cs) {
            super(length * 8, 8, length, cs);
        }

        protected MemoryIO getStringMemory() {
            return this.getMemoryIO().slice(this.offset, this.length());
        }
    }

    public abstract class String
    extends AbstractMember {
        private final Charset charset;
        private final int length;

        protected String(int size, int align, int length, Charset cs) {
            super(size, align);
            this.length = length;
            this.charset = cs;
        }

        protected String(int size, int align, Offset offset, int length, Charset cs) {
            super(size, align, offset);
            this.length = length;
            this.charset = cs;
        }

        public final int length() {
            return this.length;
        }

        protected abstract MemoryIO getStringMemory();

        public final java.lang.String get() {
            return this.getStringMemory().getString(0L, this.length, this.charset);
        }

        public final void set(java.lang.String value) {
            this.getStringMemory().putString(0L, value, this.length, this.charset);
        }

        public final java.lang.String toString() {
            return this.get();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum<T extends java.lang.Enum<T>>
    extends Enum32<T> {
        public Enum(Class<T> enumClass) {
            super(enumClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class EnumLong<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public EnumLong(Class<E> enumClass) {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value) {
            this.getMemoryIO().putNativeLong(this.offset, EnumMapper.getInstance().intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemoryIO().putNativeLong(this.offset, value.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemoryIO().getNativeLong(this.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum64<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum64(Class<E> enumClass) {
            super(64, Constants.LONG_ALIGN, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value) {
            this.getMemoryIO().putLong(this.offset, EnumMapper.getInstance().intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemoryIO().putLong(this.offset, value.longValue());
        }

        @Override
        public final int intValue() {
            return (int)this.longValue();
        }

        @Override
        public final long longValue() {
            return this.getMemoryIO().getLong(this.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum32<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum32(Class<E> enumClass) {
            super(32, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value) {
            this.getMemoryIO().putInt(this.offset, EnumMapper.getInstance().intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemoryIO().putInt(this.offset, value.intValue());
        }

        @Override
        public final int intValue() {
            return this.getMemoryIO().getInt(this.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum16<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum16(Class<E> enumClass) {
            super(16, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value) {
            this.getMemoryIO().putShort(this.offset, (short)EnumMapper.getInstance().intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemoryIO().putShort(this.offset, value.shortValue());
        }

        @Override
        public final int intValue() {
            return this.getMemoryIO().getShort(this.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Enum8<E extends java.lang.Enum<E>>
    extends EnumField<E> {
        public Enum8(Class<E> enumClass) {
            super(8, enumClass);
        }

        @Override
        public final E get() {
            return EnumMapper.getInstance().valueOf(this.intValue(), this.enumClass);
        }

        public final void set(E value) {
            this.getMemoryIO().putByte(this.offset, (byte)EnumMapper.getInstance().intValue((java.lang.Enum)value));
        }

        @Override
        public void set(Number value) {
            this.getMemoryIO().putByte(this.offset, value.byteValue());
        }

        @Override
        public final int intValue() {
            return this.getMemoryIO().getInt(this.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class EnumField<E>
    extends NumberField {
        protected final Class<E> enumClass;

        public EnumField(int size, Class<E> enumClass) {
            this(size, size, enumClass);
        }

        public EnumField(int size, Offset offset, Class<E> enumClass) {
            this(size, size, offset, enumClass);
        }

        public EnumField(int size, int align, Class<E> enumClass) {
            super(size, align);
            this.enumClass = enumClass;
        }

        public EnumField(int size, int align, Offset offset, Class<E> enumClass) {
            super(size, align, offset);
            this.enumClass = enumClass;
        }

        public abstract E get();

        @Override
        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class Pointer
    extends NumberField {
        public Pointer() {
            super(Constants.ADDRESS_SIZE, Constants.ADDRESS_ALIGN);
        }

        public Pointer(Offset offset) {
            super(Constants.ADDRESS_SIZE, Constants.ADDRESS_ALIGN, offset);
        }

        public final com.kenai.jaffl.Pointer get() {
            return this.getMemoryIO().getPointer(this.offset);
        }

        public final int size() {
            return com.kenai.jaffl.Address.SIZE;
        }

        public final void set(com.kenai.jaffl.Pointer value) {
            this.getMemoryIO().putPointer(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putAddress((long)this.offset, value.longValue());
        }

        public final int intValue() {
            return (int)this.getMemoryIO().getAddress(this.offset);
        }

        public final long longValue() {
            return this.getMemoryIO().getAddress(this.offset);
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public class Address
    extends NumberField {
        public Address() {
            super(Constants.ADDRESS_SIZE, Constants.ADDRESS_ALIGN);
        }

        public Address(Offset offset) {
            super(Constants.ADDRESS_SIZE, Constants.ADDRESS_ALIGN, offset);
        }

        public final com.kenai.jaffl.Address get() {
            long value = this.getMemoryIO().getAddress(this.offset);
            return value != 0L ? new com.kenai.jaffl.Address(value) : null;
        }

        public final void set(com.kenai.jaffl.Address value) {
            this.getMemoryIO().putAddress((long)this.offset, value != null ? value.nativeAddress() : 0L);
        }

        public void set(Number value) {
            this.getMemoryIO().putAddress((long)this.offset, value.longValue());
        }

        public final int intValue() {
            return this.get().intValue();
        }

        public final long longValue() {
            return this.get().longValue();
        }

        public final java.lang.String toString() {
            return this.get().toString();
        }
    }

    public final class Double
    extends NumberField {
        public Double() {
            super(64, Constants.DOUBLE_ALIGN);
        }

        public Double(Offset offset) {
            super(64, Constants.DOUBLE_ALIGN, offset);
        }

        public final double get() {
            return this.getMemoryIO().getDouble(this.offset);
        }

        public final void set(double value) {
            this.getMemoryIO().putDouble(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putDouble(this.offset, value.doubleValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final float floatValue() {
            return (float)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    public class Float
    extends NumberField {
        public Float() {
            super(32, Constants.FLOAT_ALIGN);
        }

        public Float(Offset offset) {
            super(32, Constants.FLOAT_ALIGN, offset);
        }

        public final float get() {
            return this.getMemoryIO().getFloat(this.offset);
        }

        public final void set(float value) {
            this.getMemoryIO().putFloat(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putFloat(this.offset, value.floatValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final double doubleValue() {
            return this.get();
        }

        public final float floatValue() {
            return this.get();
        }

        public final long longValue() {
            return (long)this.get();
        }

        public final java.lang.String toString() {
            return java.lang.String.valueOf(this.get());
        }
    }

    public class UnsignedLong
    extends NumberField {
        public UnsignedLong() {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN);
        }

        public UnsignedLong(Offset offset) {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN, offset);
        }

        public final long get() {
            long value = this.getMemoryIO().getNativeLong(this.offset);
            return value < 0L ? (value & Constants.LONG_MASK) + Constants.LONG_MASK + 1L : value;
        }

        public final void set(long value) {
            this.getMemoryIO().putNativeLong(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putNativeLong(this.offset, value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class SignedLong
    extends NumberField {
        public SignedLong() {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN);
        }

        public SignedLong(Offset offset) {
            super(Constants.LONG_SIZE, Constants.LONG_ALIGN, offset);
        }

        public final long get() {
            return this.getMemoryIO().getNativeLong(this.offset);
        }

        public final void set(long value) {
            this.getMemoryIO().putNativeLong(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putNativeLong(this.offset, value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Unsigned64
    extends NumberField {
        public Unsigned64() {
            super(64, Constants.LONG_ALIGN);
        }

        public Unsigned64(Offset offset) {
            super(64, Constants.LONG_ALIGN, offset);
        }

        public final long get() {
            return this.getMemoryIO().getLong(this.offset);
        }

        public final void set(long value) {
            this.getMemoryIO().putLong(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putLong(this.offset, value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Signed64
    extends NumberField {
        public Signed64() {
            super(64, Constants.LONG_ALIGN);
        }

        public Signed64(Offset offset) {
            super(64, Constants.LONG_ALIGN, offset);
        }

        public final long get() {
            return this.getMemoryIO().getLong(this.offset);
        }

        public final void set(long value) {
            this.getMemoryIO().putLong(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putLong(this.offset, value.longValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }

        public final java.lang.String toString() {
            return Long.toString(this.get());
        }
    }

    public class Unsigned32
    extends NumberField {
        public Unsigned32() {
            super(32);
        }

        public Unsigned32(Offset offset) {
            super(32, offset);
        }

        public final long get() {
            long value = this.getMemoryIO().getInt(this.offset);
            return value < 0L ? (value & Integer.MAX_VALUE) + 0x80000000L : value;
        }

        public final void set(long value) {
            this.getMemoryIO().putInt(this.offset, (int)value);
        }

        public void set(Number value) {
            this.getMemoryIO().putInt(this.offset, value.intValue());
        }

        public final int intValue() {
            return (int)this.get();
        }

        public final long longValue() {
            return this.get();
        }
    }

    public class Signed32
    extends NumberField {
        public Signed32() {
            super(32);
        }

        public Signed32(Offset offset) {
            super(32, offset);
        }

        public final int get() {
            return this.getMemoryIO().getInt(this.offset);
        }

        public final void set(int value) {
            this.getMemoryIO().putInt(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putInt(this.offset, value.intValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Unsigned16
    extends NumberField {
        public Unsigned16() {
            super(16);
        }

        public Unsigned16(Offset offset) {
            super(16, offset);
        }

        public final int get() {
            int value = this.getMemoryIO().getShort(this.offset);
            return value < 0 ? (value & Short.MAX_VALUE) + 32768 : value;
        }

        public final void set(int value) {
            this.getMemoryIO().putShort(this.offset, (short)value);
        }

        public void set(Number value) {
            this.getMemoryIO().putShort(this.offset, value.shortValue());
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed16
    extends NumberField {
        public Signed16() {
            super(16);
        }

        public Signed16(Offset offset) {
            super(16, offset);
        }

        public final short get() {
            return this.getMemoryIO().getShort(this.offset);
        }

        public final void set(short value) {
            this.getMemoryIO().putShort(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putShort(this.offset, value.shortValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Unsigned8
    extends NumberField {
        public Unsigned8() {
            super(8);
        }

        public Unsigned8(Offset offset) {
            super(8, offset);
        }

        public final short get() {
            short value = this.getMemoryIO().getByte(this.offset);
            return value < 0 ? (short)((value & 0x7F) + 128) : value;
        }

        public final void set(short value) {
            this.getMemoryIO().putByte(this.offset, (byte)value);
        }

        public void set(Number value) {
            this.getMemoryIO().putByte(this.offset, value.byteValue());
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    public class Signed8
    extends NumberField {
        public Signed8() {
            super(8);
        }

        public Signed8(Offset offset) {
            super(8, offset);
        }

        public final byte get() {
            return this.getMemoryIO().getByte(this.offset);
        }

        public final void set(byte value) {
            this.getMemoryIO().putByte(this.offset, value);
        }

        public void set(Number value) {
            this.getMemoryIO().putByte(this.offset, value.byteValue());
        }

        public final byte byteValue() {
            return this.get();
        }

        public final short shortValue() {
            return this.get();
        }

        public final int intValue() {
            return this.get();
        }
    }

    protected abstract class NumberField
    extends Number
    implements Member {
        protected final int offset;

        protected NumberField(int size) {
            this(size, size);
        }

        protected NumberField(int size, Offset offset) {
            this(size, size, offset);
        }

        protected NumberField(int size, int align, Offset offset) {
            this.offset = Struct.this.__info.addField(size, align, offset);
        }

        protected NumberField(int size, int align) {
            this.offset = Struct.this.__info.addField(size, align);
        }

        public final MemoryIO getMemoryIO() {
            return Struct.this.__info.getMemoryIO();
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final long offset() {
            return this.offset;
        }

        public abstract void set(Number var1);

        public double doubleValue() {
            return this.longValue();
        }

        public float floatValue() {
            return this.intValue();
        }

        public long longValue() {
            return this.intValue();
        }

        public java.lang.String toString() {
            return Integer.toString(this.intValue(), 10);
        }
    }

    protected abstract class AbstractMember
    implements Member {
        protected final int offset;

        protected AbstractMember(int size) {
            this(size, size);
        }

        protected AbstractMember(int size, int align, Offset offset) {
            this.offset = Struct.this.__info.addField(size, align, offset);
        }

        protected AbstractMember(int size, int align) {
            this.offset = Struct.this.__info.addField(size, align);
        }

        public final MemoryIO getMemoryIO() {
            return Struct.this.__info.getMemoryIO();
        }

        public final Struct struct() {
            return Struct.this;
        }

        public final long offset() {
            return this.offset;
        }
    }

    protected static interface Member {
        public Struct struct();

        public MemoryIO getMemoryIO();

        public long offset();
    }

    public static final class Offset
    extends Number {
        private final int offset;

        public Offset(int offset) {
            this.offset = offset;
        }

        public int intValue() {
            return this.offset;
        }

        public long longValue() {
            return this.offset;
        }

        public float floatValue() {
            return this.offset;
        }

        public double doubleValue() {
            return this.offset;
        }
    }

    static final class Info {
        MemoryIO io;
        int size = 0;
        int minAlign = 1;
        boolean isUnion = false;
        boolean resetIndex = false;

        Info() {
        }

        public final MemoryIO getMemoryIO(int flags) {
            return this.io != null ? this.io : (this.io = this.allocateMemory(4));
        }

        public final MemoryIO getMemoryIO() {
            return this.getMemoryIO(4);
        }

        final int size() {
            return this.size;
        }

        final int getMinimumAlignment() {
            return this.minAlign;
        }

        private final MemoryIO allocateMemory(int flags) {
            if (ParameterFlags.isTransient(flags)) {
                return MemoryIO.allocate(this.size());
            }
            return MemoryIO.allocateDirect(this.size(), true);
        }

        public final void useMemory(MemoryIO io) {
            this.io = io;
        }

        protected final int addField(int sizeBits, int alignBits, Offset offset) {
            this.size = Math.max(this.size, offset.intValue() + (sizeBits >> 3));
            this.minAlign = Math.max(this.minAlign, alignBits >> 3);
            return offset.intValue();
        }

        protected final int addField(int sizeBits, int alignBits) {
            int off;
            int mask = (alignBits >> 3) - 1;
            int n = off = this.resetIndex ? 0 : this.size;
            if ((off & mask) != 0) {
                off = (off & ~mask) + (alignBits >> 3);
            }
            this.size = Math.max(this.size, off + (sizeBits >> 3));
            this.minAlign = Math.max(this.minAlign, alignBits >> 3);
            return off;
        }
    }

    protected static final class Constants {
        static final int LONG_SIZE = Platform.getPlatform().longSize();
        static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
        static final long LONG_MASK = LONG_SIZE == 32 ? Integer.MAX_VALUE : Long.MAX_VALUE;
        static final int LONG_ALIGN = Constants.isSparc() ? 64 : ADDRESS_SIZE;
        static final int ADDRESS_ALIGN = Constants.isSparc() ? 64 : ADDRESS_SIZE;
        static final int DOUBLE_ALIGN = Constants.isSparc() ? 64 : ADDRESS_SIZE;
        static final int FLOAT_ALIGN = Constants.isSparc() ? 64 : 32;

        protected Constants() {
        }

        private static final boolean isSparc() {
            return Platform.getPlatform().getCPU() == Platform.CPU.SPARC;
        }
    }
}

