/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jna.invokers;

import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.mapper.MethodParameterContext;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.mapper.TypeMapper;
import com.kenai.jaffl.provider.jna.InvocationSession;
import com.kenai.jaffl.provider.jna.invokers.BaseInvoker;
import com.kenai.jaffl.provider.jna.marshallers.ByRefMarshaller;
import com.kenai.jaffl.provider.jna.marshallers.CharSequenceMarshaller;
import com.kenai.jaffl.provider.jna.marshallers.MarshalContext;
import com.kenai.jaffl.provider.jna.marshallers.Marshaller;
import com.kenai.jaffl.provider.jna.marshallers.StringBufferMarshaller;
import com.kenai.jaffl.provider.jna.marshallers.StringBuilderMarshaller;
import com.kenai.jaffl.provider.jna.marshallers.ToNativeConverterMarshaller;
import com.sun.jna.NativeLibrary;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MarshallingInvoker
extends BaseInvoker {
    private final Marshaller[] marshallers;
    private final int[] marshalIndexes;

    public MarshallingInvoker(NativeLibrary library, Method method, TypeMapper typeMapper) {
        super(library, method);
        int i;
        Class<?>[] types = method.getParameterTypes();
        ArrayList<Marshaller> m = new ArrayList<Marshaller>(types.length);
        ArrayList<Integer> indexes = new ArrayList<Integer>(types.length);
        for (i = 0; i < types.length; ++i) {
            MarshalContext ctx = MarshallingInvoker.getContext(method, i);
            ToNativeConverter toNative = typeMapper.getToNativeConverter(types[i]);
            if (toNative != null) {
                m.add(new ToNativeConverterMarshaller(toNative, new MethodParameterContext(method, i)));
            } else if (ByReference.class.isAssignableFrom(types[i])) {
                m.add(new ByRefMarshaller(ctx));
            } else if (StringBuffer.class.isAssignableFrom(types[i])) {
                m.add(new StringBufferMarshaller(ctx));
            } else if (StringBuilder.class.isAssignableFrom(types[i])) {
                m.add(new StringBuilderMarshaller(ctx));
            } else {
                if (!CharSequence.class.isAssignableFrom(types[i])) continue;
                m.add(new CharSequenceMarshaller(ctx));
            }
            indexes.add(i);
        }
        this.marshallers = m.toArray(new Marshaller[m.size()]);
        this.marshalIndexes = new int[indexes.size()];
        for (i = 0; i < this.marshalIndexes.length; ++i) {
            this.marshalIndexes[i] = (Integer)indexes.get(i);
        }
    }

    protected final Object invokeFunction(Object[] parameters, Map<String, Object> options) {
        InvocationSession session = new InvocationSession(this.marshallers.length);
        for (int i = 0; i < this.marshalIndexes.length; ++i) {
            parameters[this.marshalIndexes[i]] = this.marshallers[i].marshal(session, parameters[this.marshalIndexes[i]]);
        }
        Object retVal = this.function.invoke(this.returnType, parameters, options);
        session.finish();
        return retVal;
    }
}

