/*
 * Decompiled with CFR 0.152.
 */
package org.jutils.jprocesses.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessesUtils {
    private static final String CRLF = "\r\n";

    public static String executeCommand(String ... command) {
        StringBuilder commandOutput = new StringBuilder();
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            try {
                process.waitFor();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ex);
            }
            BufferedReader processOutput = process.exitValue() == 0 ? new BufferedReader(new InputStreamReader(process.getInputStream())) : new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = processOutput.readLine()) != null) {
                if (line.isEmpty()) continue;
                commandOutput.append(line).append(CRLF);
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ex);
        }
        return commandOutput.toString();
    }

    public static int executeCommandAndGetCode(String ... command) {
        Process process;
        try {
            process = Runtime.getRuntime().exec(command);
            try {
                process.waitFor();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ex);
                return -1;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(ProcessesUtils.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
        return process.exitValue();
    }
}

