/*
 * Decompiled with CFR 0.152.
 */
package org.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.dmg.pmml.Extension;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.HasExtensions;
import org.dmg.pmml.Indexable;
import org.dmg.pmml.InvalidValueTreatmentMethod;
import org.dmg.pmml.MissingValueTreatmentMethod;
import org.dmg.pmml.OpType;
import org.dmg.pmml.OutlierTreatmentMethod;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Visitor;
import org.dmg.pmml.VisitorAction;
import org.dmg.pmml.adapters.FieldNameAdapter;
import org.jpmml.schema.Added;
import org.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions"})
@XmlRootElement(name="MiningField", namespace="http://www.dmg.org/PMML-4_3")
public class MiningField
extends PMMLObject
implements HasExtensions,
Indexable<FieldName> {
    @XmlAttribute(name="name", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName name;
    @XmlAttribute(name="usageType")
    private UsageType usageType;
    @XmlAttribute(name="optype")
    private OpType opType;
    @XmlAttribute(name="importance")
    private Double importance;
    @XmlAttribute(name="outliers")
    private OutlierTreatmentMethod outlierTreatment;
    @XmlAttribute(name="lowValue")
    private Double lowValue;
    @XmlAttribute(name="highValue")
    private Double highValue;
    @XmlAttribute(name="missingValueReplacement")
    private String missingValueReplacement;
    @XmlAttribute(name="missingValueTreatment")
    private MissingValueTreatmentMethod missingValueTreatment;
    @XmlAttribute(name="invalidValueTreatment")
    @Added(value=Version.PMML_3_1)
    private InvalidValueTreatmentMethod invalidValueTreatment;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_3")
    private List<Extension> extensions;

    public MiningField() {
    }

    public MiningField(FieldName name) {
        this.name = name;
    }

    public FieldName getName() {
        return this.name;
    }

    public MiningField setName(FieldName name) {
        this.name = name;
        return this;
    }

    public UsageType getUsageType() {
        if (this.usageType == null) {
            return UsageType.ACTIVE;
        }
        return this.usageType;
    }

    public MiningField setUsageType(UsageType usageType) {
        this.usageType = usageType;
        return this;
    }

    public OpType getOpType() {
        return this.opType;
    }

    public MiningField setOpType(OpType opType) {
        this.opType = opType;
        return this;
    }

    public Double getImportance() {
        return this.importance;
    }

    public MiningField setImportance(Double importance) {
        this.importance = importance;
        return this;
    }

    public OutlierTreatmentMethod getOutlierTreatment() {
        if (this.outlierTreatment == null) {
            return OutlierTreatmentMethod.AS_IS;
        }
        return this.outlierTreatment;
    }

    public MiningField setOutlierTreatment(OutlierTreatmentMethod outlierTreatment) {
        this.outlierTreatment = outlierTreatment;
        return this;
    }

    public Double getLowValue() {
        return this.lowValue;
    }

    public MiningField setLowValue(Double lowValue) {
        this.lowValue = lowValue;
        return this;
    }

    public Double getHighValue() {
        return this.highValue;
    }

    public MiningField setHighValue(Double highValue) {
        this.highValue = highValue;
        return this;
    }

    public String getMissingValueReplacement() {
        return this.missingValueReplacement;
    }

    public MiningField setMissingValueReplacement(String missingValueReplacement) {
        this.missingValueReplacement = missingValueReplacement;
        return this;
    }

    public MissingValueTreatmentMethod getMissingValueTreatment() {
        return this.missingValueTreatment;
    }

    public MiningField setMissingValueTreatment(MissingValueTreatmentMethod missingValueTreatment) {
        this.missingValueTreatment = missingValueTreatment;
        return this;
    }

    public InvalidValueTreatmentMethod getInvalidValueTreatment() {
        if (this.invalidValueTreatment == null) {
            return InvalidValueTreatmentMethod.RETURN_INVALID;
        }
        return this.invalidValueTreatment;
    }

    public MiningField setInvalidValueTreatment(InvalidValueTreatmentMethod invalidValueTreatment) {
        this.invalidValueTreatment = invalidValueTreatment;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    @Override
    public FieldName getKey() {
        return this.getName();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public MiningField addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum UsageType {
        ACTIVE("active"),
        PREDICTED("predicted"),
        TARGET("target"),
        SUPPLEMENTARY("supplementary"),
        GROUP("group"),
        ORDER("order"),
        FREQUENCY_WEIGHT("frequencyWeight"),
        ANALYSIS_WEIGHT("analysisWeight");

        private final String value;

        private UsageType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static UsageType fromValue(String v) {
            for (UsageType c : UsageType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

