/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Scanners;
import org.jparsec.Terminals;
import org.jparsec.Token;
import org.jparsec.examples.java.parser.JavaLexer;

public final class TerminalParser {
    private static final Terminals TERMS = Terminals.operators((String[])new String[]{"+", "-", "*", "/", "%", "&", "|", "~", "^", ">", "<", "==", ">=", "<=", "!=", "&&", "||", "!", ".", ",", "?", ":", ";", "...", "@", "=", "+=", "-=", "*=", "/=", "%=", "^=", "&=", "|=", "<<=", ">>=", ">>>=", "++", "--", "(", ")", "[", "]", "{", "}", "::", "->"}).words(JavaLexer.IDENTIFIER).keywords(new String[]{"private", "protected", "public", "final", "abstract", "native", "static", "transient", "volatile", "throws", "class", "interface", "enum", "package", "import", "if", "else", "for", "while", "do", "continue", "break", "return", "switch", "case", "default", "throw", "try", "catch", "finally", "new", "this", "super", "synchronized", "instanceof", "extends", "implements", "assert", "byte", "short", "int", "long", "char", "float", "double", "boolean", "char", "void", "true", "false", "null", "goto", "const", "strictfp"}).build();
    static final Parser<?> TOKENIZER = Parsers.or(JavaLexer.SCIENTIFIC_NUMBER_LITERAL, (Parser)Terminals.StringLiteral.DOUBLE_QUOTE_TOKENIZER, (Parser)Terminals.CharLiteral.SINGLE_QUOTE_TOKENIZER, (Parser)TERMS.tokenizer(), JavaLexer.DECIMAL_POINT_NUMBER, JavaLexer.INTEGER);

    public static Parser<Token> adjacent(Parser<List<Token>> parser, Parser<?> otherwise) {
        return parser.next(tokens -> {
            if (tokens.isEmpty()) {
                return Parsers.always();
            }
            int offset = ((Token)tokens.get(0)).index();
            for (Token token : tokens) {
                if (token.index() != offset) {
                    return otherwise;
                }
                offset += token.length();
            }
            return Parsers.always();
        }).atomic().source().token();
    }

    public static Parser<Token> adjacent(String operator) {
        ArrayList<Parser> parsers = new ArrayList<Parser>(operator.length());
        for (int i = 0; i < operator.length(); ++i) {
            parsers.add(TERMS.token(Character.toString(operator.charAt(i))));
        }
        return TerminalParser.adjacent((Parser<List<Token>>)Parsers.list(parsers), Parsers.expect((String)operator));
    }

    public static Parser<?> term(String name) {
        if (name.equals(">>")) {
            return TerminalParser.adjacent(">>>").not().next(TerminalParser.adjacent(">>"));
        }
        if (name.equals("<<") || name.equals(">>>")) {
            return TerminalParser.adjacent(name);
        }
        return TERMS.token(name);
    }

    static Parser<?> oneOf(String ... names) {
        return TERMS.token(names);
    }

    static <T> T parse(Parser<T> parser, String source) {
        return (T)parser.from(TOKENIZER, Scanners.JAVA_DELIMITER).parse((CharSequence)source);
    }

    static <T> T parse(Parser<T> parser, Readable readable, String module) throws IOException {
        return (T)parser.from(TOKENIZER, Scanners.JAVA_DELIMITER).parse(readable, module);
    }

    public static Parser<?> phrase(String phrase) {
        return TERMS.phrase(phrase.split("\\s+"));
    }
}

