/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.calculator;

import java.util.function.BinaryOperator;
import java.util.function.UnaryOperator;
import org.jparsec.OperatorTable;
import org.jparsec.Parser;
import org.jparsec.Scanners;

public final class Calculator {
    static final Parser<Integer> NUMBER = Scanners.INTEGER.map(Integer::valueOf);
    static final BinaryOperator<Integer> PLUS = (a, b) -> a + b;
    static final BinaryOperator<Integer> MINUS = (a, b) -> a - b;
    static final BinaryOperator<Integer> MUL = (a, b) -> a * b;
    static final BinaryOperator<Integer> DIV = (a, b) -> a / b;
    static final BinaryOperator<Integer> MOD = (a, b) -> a % b;
    static final UnaryOperator<Integer> NEG = a -> -a.intValue();

    public static int evaluate(String source) {
        return (Integer)Calculator.parser().parse((CharSequence)source);
    }

    private static <T> Parser<T> op(char ch, T value) {
        return Scanners.isChar((char)ch).retn(value);
    }

    static Parser<Integer> parser() {
        Parser.Reference ref = Parser.newReference();
        Parser term = ref.lazy().between(Scanners.isChar((char)'('), Scanners.isChar((char)')')).or(NUMBER);
        Parser parser = new OperatorTable().prefix(Calculator.op('-', NEG), 100).infixl(Calculator.op('+', PLUS), 10).infixl(Calculator.op('-', MINUS), 10).infixl(Calculator.op('*', MUL), 20).infixl(Calculator.op('/', DIV), 20).infixl(Calculator.op('%', MOD), 20).build(term);
        ref.set((Object)parser);
        return parser;
    }
}

