/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.sql.parser;

import java.util.List;
import java.util.function.UnaryOperator;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.examples.sql.ast.AliasedRelation;
import org.jparsec.examples.sql.ast.CrossJoinRelation;
import org.jparsec.examples.sql.ast.Expression;
import org.jparsec.examples.sql.ast.GroupBy;
import org.jparsec.examples.sql.ast.JoinRelation;
import org.jparsec.examples.sql.ast.JoinType;
import org.jparsec.examples.sql.ast.OrderBy;
import org.jparsec.examples.sql.ast.Projection;
import org.jparsec.examples.sql.ast.Relation;
import org.jparsec.examples.sql.ast.Select;
import org.jparsec.examples.sql.ast.TableRelation;
import org.jparsec.examples.sql.ast.UnionRelation;
import org.jparsec.examples.sql.parser.ExpressionParser;
import org.jparsec.examples.sql.parser.TerminalParser;

public final class RelationParser {
    static final Parser<String> ALIAS = TerminalParser.term("as").optional().next(TerminalParser.NAME);
    static final Parser<JoinType> FULL_JOIN = RelationParser.joinType(JoinType.FULL, "full join", "full outer join");
    static final Parser<JoinType> RIGHT_JOIN = RelationParser.joinType(JoinType.RIGHT, "right join", "right outer join");
    static final Parser<JoinType> LEFT_JOIN = RelationParser.joinType(JoinType.LEFT, "left join", "left outer join");
    static final Parser<JoinType> INNER_JOIN = RelationParser.joinType(JoinType.INNER, "join", "inner join");
    static final Parser<Relation> TABLE = TerminalParser.QUALIFIED_NAME.map(TableRelation::new);
    static final Parser<Boolean> SELECT_CLAUSE = TerminalParser.term("select").next(TerminalParser.term("distinct").succeeds());

    static final Parser<Projection> projection(Parser<Expression> expr) {
        return Parsers.sequence(expr, (Parser)ALIAS.optional(), Projection::new);
    }

    static final Parser<Relation> alias(Parser<Relation> rel) {
        return Parsers.sequence(rel, ALIAS, AliasedRelation::new);
    }

    static final Parser<Relation> aliasable(Parser<Relation> rel) {
        return RelationParser.alias(rel).or(rel);
    }

    static final Parser<Boolean> selectClause() {
        return TerminalParser.term("select").next(TerminalParser.term("distinct").succeeds());
    }

    static Parser<List<Relation>> fromClause(Parser<Relation> rel) {
        return TerminalParser.term("from").next(RelationParser.aliasable(rel).sepBy1(TerminalParser.term(",")));
    }

    static Parser<Expression> whereClause(Parser<Expression> cond) {
        return TerminalParser.term("where").next(cond);
    }

    static Parser<GroupBy> groupByClause(Parser<Expression> expr, Parser<Expression> cond) {
        return Parsers.sequence((Parser)TerminalParser.phrase("group by").next(RelationParser.list(expr)), (Parser)TerminalParser.phrase("having").next(cond).optional(), GroupBy::new);
    }

    static Parser<Expression> havingClause(Parser<Expression> cond) {
        return TerminalParser.term("having").next(cond);
    }

    static Parser<OrderBy.Item> orderByItem(Parser<Expression> expr) {
        return Parsers.sequence(expr, (Parser)Parsers.or((Parser)TerminalParser.term("asc").retn((Object)true), (Parser)TerminalParser.term("desc").retn((Object)false)).optional((Object)true), OrderBy.Item::new);
    }

    static Parser<OrderBy> orderByClause(Parser<Expression> expr) {
        return TerminalParser.phrase("order by").next(RelationParser.list(RelationParser.orderByItem(expr))).map(OrderBy::new);
    }

    static Parser<Relation> join(Parser<Relation> rel, Parser<Expression> cond) {
        Parser.Reference ref = Parser.newReference();
        Parser lazy = ref.lazy();
        Parser<Relation> atom = RelationParser.aliasable((Parser<Relation>)ExpressionParser.paren(lazy).or(rel));
        Parser crossJoin = TerminalParser.phrase("cross join").next(atom).map(r -> l -> new CrossJoinRelation((Relation)l, (Relation)r));
        Parser parser = atom.postfix(Parsers.or(RelationParser.joinOn(INNER_JOIN, (Parser<Relation>)lazy, cond), RelationParser.joinOn(LEFT_JOIN, (Parser<Relation>)lazy, cond), RelationParser.joinOn(RIGHT_JOIN, (Parser<Relation>)lazy, cond), RelationParser.joinOn(FULL_JOIN, (Parser<Relation>)lazy, cond), (Parser)crossJoin));
        ref.set((Object)parser);
        return parser;
    }

    static Parser<Relation> select(Parser<Expression> expr, Parser<Expression> cond, Parser<Relation> rel) {
        return Parsers.sequence(SELECT_CLAUSE, RelationParser.list(RelationParser.projection(expr)), RelationParser.fromClause(RelationParser.join(rel, cond)), (Parser)RelationParser.whereClause(cond).optional(), (Parser)RelationParser.groupByClause(expr, cond).optional(), (Parser)RelationParser.orderByClause(expr).optional(), Select::new);
    }

    static Parser<Relation> union(Parser<Relation> rel) {
        Parser.Reference ref = Parser.newReference();
        Parser parser = ExpressionParser.paren(ref.lazy()).or(rel).infixl(TerminalParser.term("union").next(TerminalParser.term("all").succeeds()).label("relation").map(a -> (l, r) -> new UnionRelation((Relation)l, (boolean)a, (Relation)r)));
        ref.set((Object)parser);
        return parser;
    }

    static Parser<Relation> query(Parser<Expression> expr, Parser<Expression> cond, Parser<Relation> rel) {
        return RelationParser.union(RelationParser.select(expr, cond, rel));
    }

    public static Parser<Relation> query() {
        Parser.Reference relationRef = Parser.newReference();
        Parser subQuery = ExpressionParser.paren(relationRef.lazy());
        Parser.Reference conditionRef = Parser.newReference();
        Parser<Expression> expr = ExpressionParser.expression((Parser<Expression>)conditionRef.lazy());
        Parser<Expression> cond = ExpressionParser.condition(expr, subQuery);
        Parser<Relation> relation = RelationParser.query(expr, cond, (Parser<Relation>)subQuery.or(TABLE));
        conditionRef.set(cond);
        relationRef.set(relation);
        return relation;
    }

    private static Parser<JoinType> joinType(JoinType joinType, String phrase1, String phrase2) {
        return Parsers.or(TerminalParser.phrase(phrase1), TerminalParser.phrase(phrase2)).retn((Object)joinType);
    }

    private static Parser<UnaryOperator<Relation>> joinOn(Parser<JoinType> joinType, Parser<Relation> right, Parser<Expression> cond) {
        return Parsers.sequence(joinType, right, (Parser)TerminalParser.term("on").next(cond), (t, r, c) -> l -> new JoinRelation((Relation)l, (JoinType)((Object)t), (Relation)r, (Expression)c));
    }

    private static <T> Parser<List<T>> list(Parser<T> p) {
        return p.sepBy1(TerminalParser.term(","));
    }
}

