/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.java.ast.statement;

import java.util.List;
import org.jparsec.examples.common.ValueObject;
import org.jparsec.examples.java.ast.expression.Expression;
import org.jparsec.examples.java.ast.statement.Statement;
import org.jparsec.functors.Pair;

public final class IfStatement
extends ValueObject
implements Statement {
    public final Expression condition;
    public final Statement then;
    public final List<Pair<Expression, Statement>> elseifs;
    public final Statement otherwise;

    public IfStatement(Expression condition, Statement then, List<Pair<Expression, Statement>> elseifs, Statement otherwise) {
        this.condition = condition;
        this.then = then;
        this.elseifs = elseifs;
        this.otherwise = otherwise;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("if (").append(this.condition).append(") ").append(this.then);
        for (Pair<Expression, Statement> elseif : this.elseifs) {
            builder.append(" else if (").append(elseif.a).append(") ").append(elseif.b);
        }
        if (this.otherwise != null) {
            builder.append(" else ").append(this.otherwise);
        }
        return builder.toString();
    }
}

