/*
 * Decompiled with CFR 0.152.
 */
package org.jparsec.examples.bnf.parser;

import java.util.List;
import org.jparsec.Parser;
import org.jparsec.Parsers;
import org.jparsec.Terminals;
import org.jparsec.examples.bnf.ast.AltRule;
import org.jparsec.examples.bnf.ast.LiteralRule;
import org.jparsec.examples.bnf.ast.Rule;
import org.jparsec.examples.bnf.ast.RuleDef;
import org.jparsec.examples.bnf.ast.RuleReference;
import org.jparsec.examples.bnf.ast.SequentialRule;
import org.jparsec.examples.bnf.parser.TerminalParser;

public final class RuleParser {
    static final Parser<Rule> LITERAL = Terminals.StringLiteral.PARSER.map(LiteralRule::new);
    static final Parser<Rule> IDENT = Terminals.Identifier.PARSER.notFollowedBy(TerminalParser.term("::=")).map(RuleReference::new);
    static Parser<RuleDef> RULE_DEF = Parsers.sequence((Parser)Terminals.Identifier.PARSER, TerminalParser.term("::="), RuleParser.rule(), (name, __, r) -> new RuleDef((String)name, (Rule)r));
    public static Parser<List<RuleDef>> RULE_DEFS = RULE_DEF.many();

    static Parser<Rule> rule() {
        Parser.Reference ref = Parser.newReference();
        Parser atom = Parsers.or(LITERAL, IDENT, RuleParser.unit((Parser<Rule>)ref.lazy()));
        Parser<Rule> parser = RuleParser.alternative(RuleParser.sequential((Parser<Rule>)atom));
        ref.set(parser);
        return parser;
    }

    static Parser<Rule> unit(Parser<Rule> rule) {
        return Parsers.or((Parser)rule.between(TerminalParser.term("("), TerminalParser.term(")")), (Parser)rule.between(TerminalParser.INDENTATION.indent(), TerminalParser.INDENTATION.outdent()));
    }

    static Parser<Rule> sequential(Parser<Rule> rule) {
        return rule.many1().map(list -> list.size() == 1 ? (Rule)list.get(0) : new SequentialRule((List<Rule>)list));
    }

    static Parser<Rule> alternative(Parser<Rule> rule) {
        return rule.sepBy1(TerminalParser.term("|")).map(list -> list.size() == 1 ? (Rule)list.get(0) : new AltRule((List<Rule>)list));
    }
}

