/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.parser;

import java.util.ArrayList;
import org.codehaus.jparsec.Parser;
import org.codehaus.jparsec.Parsers;
import org.codehaus.jparsec.Terminals;
import org.codehaus.jparsec.examples.java.ast.expression.Expression;
import org.codehaus.jparsec.examples.java.ast.statement.Annotation;
import org.codehaus.jparsec.examples.java.ast.statement.AssertStatement;
import org.codehaus.jparsec.examples.java.ast.statement.BlockStatement;
import org.codehaus.jparsec.examples.java.ast.statement.BreakStatement;
import org.codehaus.jparsec.examples.java.ast.statement.ContinueStatement;
import org.codehaus.jparsec.examples.java.ast.statement.DoWhileStatement;
import org.codehaus.jparsec.examples.java.ast.statement.ExpressionListStatement;
import org.codehaus.jparsec.examples.java.ast.statement.ExpressionStatement;
import org.codehaus.jparsec.examples.java.ast.statement.ForStatement;
import org.codehaus.jparsec.examples.java.ast.statement.ForeachStatement;
import org.codehaus.jparsec.examples.java.ast.statement.IfStatement;
import org.codehaus.jparsec.examples.java.ast.statement.LabelStatement;
import org.codehaus.jparsec.examples.java.ast.statement.Modifier;
import org.codehaus.jparsec.examples.java.ast.statement.NopStatement;
import org.codehaus.jparsec.examples.java.ast.statement.ParameterDef;
import org.codehaus.jparsec.examples.java.ast.statement.ReturnStatement;
import org.codehaus.jparsec.examples.java.ast.statement.Statement;
import org.codehaus.jparsec.examples.java.ast.statement.SuperCallStatement;
import org.codehaus.jparsec.examples.java.ast.statement.SwitchStatement;
import org.codehaus.jparsec.examples.java.ast.statement.SynchronizedBlockStatement;
import org.codehaus.jparsec.examples.java.ast.statement.SystemModifier;
import org.codehaus.jparsec.examples.java.ast.statement.ThisCallStatement;
import org.codehaus.jparsec.examples.java.ast.statement.ThrowStatement;
import org.codehaus.jparsec.examples.java.ast.statement.TryStatement;
import org.codehaus.jparsec.examples.java.ast.statement.VarStatement;
import org.codehaus.jparsec.examples.java.ast.statement.WhileStatement;
import org.codehaus.jparsec.examples.java.parser.ExpressionParser;
import org.codehaus.jparsec.examples.java.parser.TerminalParser;
import org.codehaus.jparsec.examples.java.parser.TypeLiteralParser;
import org.codehaus.jparsec.functors.Unary;
import org.codehaus.jparsec.misc.Mapper;

public final class StatementParser {
    static final Parser<Modifier> SYSTEM_MODIFIER = StatementParser.systemModifier(SystemModifier.values());
    static final Parser<Statement> NOP = TerminalParser.term(";").retn((Object)NopStatement.instance);
    static final Parser<Unary<Statement>> LABEL = StatementParser.curry(LabelStatement.class, new Object[0]).prefix(new Parser[]{Terminals.Identifier.PARSER, TerminalParser.term(":")}).atomic();
    static final Parser<Statement> BREAK = StatementParser.curry(BreakStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("break"), Terminals.Identifier.PARSER.optional(), TerminalParser.term(";")});
    static final Parser<Statement> CONTINUE = StatementParser.curry(ContinueStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("continue"), Terminals.Identifier.PARSER.optional(), TerminalParser.term(";")});

    static Parser<Modifier> systemModifier(SystemModifier ... modifiers) {
        ArrayList<Parser> list = new ArrayList<Parser>(modifiers.length);
        for (SystemModifier modifier : modifiers) {
            list.add(TerminalParser.term(((Object)modifier).toString()).retn((Object)modifier));
        }
        return Parsers.or(list);
    }

    static Parser<Annotation> annotation(Parser<Expression> expr) {
        Parser element = Mapper.curry(Annotation.Element.class, (Object[])new Object[0]).sequence(new Parser[]{Terminals.Identifier.PARSER.followedBy(TerminalParser.term("=")).atomic().optional(), ExpressionParser.arrayInitializerOrRegularExpression(expr)});
        return Mapper.curry(Annotation.class, (Object[])new Object[0]).sequence(new Parser[]{TerminalParser.term("@"), TypeLiteralParser.ELEMENT_TYPE_LITERAL, ExpressionParser.paren(element.sepBy(TerminalParser.term(","))).optional()});
    }

    static Parser<Modifier> modifier(Parser<Expression> expr) {
        return Parsers.or(StatementParser.annotation(expr), SYSTEM_MODIFIER);
    }

    static Parser<Statement> returnStatement(Parser<Expression> expr) {
        return StatementParser.curry(ReturnStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("return"), expr.optional(), TerminalParser.term(";")});
    }

    static Parser<Statement> blockStatement(Parser<Statement> stmt) {
        return StatementParser.curry(BlockStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("{"), stmt.many(), TerminalParser.term("}")});
    }

    static Parser<Statement> whileStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return StatementParser.curry(WhileStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.phrase("while ("), expr, TerminalParser.term(")"), stmt});
    }

    static Parser<Statement> doWhileStatement(Parser<Statement> stmt, Parser<Expression> expr) {
        return StatementParser.curry(DoWhileStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("do"), stmt, TerminalParser.phrase("while ("), expr, TerminalParser.phrase(") ;")});
    }

    static Parser<Statement> ifStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return StatementParser.curry(IfStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.phrase("if ("), expr, TerminalParser.term(")"), stmt, Parsers.pair((Parser)Parsers.between(TerminalParser.phrase("else if ("), expr, TerminalParser.term(")")), stmt).many(), TerminalParser.term("else").next(stmt).optional()});
    }

    static Parser<Statement> switchStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return StatementParser.curry(SwitchStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.phrase("switch ("), expr, TerminalParser.phrase(") {"), Parsers.pair((Parser)Parsers.between(TerminalParser.term("case"), expr, TerminalParser.term(":")), (Parser)stmt.optional()).many(), TerminalParser.phrase("default :").next(stmt.optional()).optional(), TerminalParser.term("}")});
    }

    static Parser<Statement> foreachStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return StatementParser.curry(ForeachStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.phrase("for ("), TypeLiteralParser.TYPE_LITERAL, Terminals.Identifier.PARSER, TerminalParser.term(":"), expr, TerminalParser.term(")"), stmt});
    }

    static Parser<Statement> forStatement(Parser<Expression> expr, Parser<Statement> stmt) {
        return StatementParser.curry(ForStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.phrase("for ("), Parsers.or(StatementParser.varStatement(expr), StatementParser.expressionList(expr), NOP), expr.optional(), TerminalParser.term(";"), expr.sepBy(TerminalParser.term(",")), TerminalParser.term(")"), stmt});
    }

    static Parser<Statement> thisCall(Parser<Expression> expr) {
        return StatementParser.curry(ThisCallStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("this"), TerminalParser.term("("), expr.sepBy(TerminalParser.term(",")), TerminalParser.term(")"), TerminalParser.term(";")});
    }

    static Parser<Statement> superCall(Parser<Expression> expr) {
        return StatementParser.curry(SuperCallStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("super"), TerminalParser.term("("), expr.sepBy(TerminalParser.term(",")), TerminalParser.term(")"), TerminalParser.term(";")});
    }

    static Parser<Statement> varStatement(Parser<Expression> expr) {
        Parser initializer = TerminalParser.term("=").next(ExpressionParser.arrayInitializerOrRegularExpression(expr));
        Parser var = Mapper.curry(VarStatement.Var.class, (Object[])new Object[0]).sequence(new Parser[]{Terminals.Identifier.PARSER, initializer.optional()});
        return StatementParser.curry(VarStatement.class, new Object[0]).sequence(new Parser[]{StatementParser.modifier(expr).many(), TypeLiteralParser.TYPE_LITERAL, var.sepBy1(TerminalParser.term(",")), TerminalParser.term(";")});
    }

    static Parser<Statement> expressionList(Parser<Expression> expr) {
        return StatementParser.curry(ExpressionListStatement.class, new Object[0]).sequence(new Parser[]{expr.sepBy1(TerminalParser.term(",")), TerminalParser.term(";")});
    }

    static Parser<Statement> synchronizedBlock(Parser<Statement> stmt) {
        return StatementParser.curry(SynchronizedBlockStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("synchronized"), StatementParser.blockStatement(stmt)});
    }

    static Parser<Statement> assertStatement(Parser<Expression> expr) {
        return StatementParser.curry(AssertStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("assert"), expr, TerminalParser.term(":").next(expr).optional(), TerminalParser.term(";")});
    }

    static Parser<Statement> expression(Parser<Expression> expr) {
        return StatementParser.curry(ExpressionStatement.class, new Object[0]).sequence(new Parser[]{expr, TerminalParser.term(";")});
    }

    static Parser<ParameterDef> parameter(Parser<Modifier> mod) {
        return Mapper.curry(ParameterDef.class, (Object[])new Object[0]).sequence(new Parser[]{mod.many(), TypeLiteralParser.TYPE_LITERAL, TerminalParser.term("...").succeeds(), Terminals.Identifier.PARSER});
    }

    static Parser<Statement> tryStatement(Parser<Modifier> mod, Parser<Statement> stmt) {
        Parser<Statement> block = StatementParser.blockStatement(stmt);
        return StatementParser.curry(TryStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("try"), block, Mapper.curry(TryStatement.CatchBlock.class, (Object[])new Object[0]).sequence(new Parser[]{TerminalParser.term("catch"), TerminalParser.term("("), StatementParser.parameter(mod), TerminalParser.term(")"), block}).many(), TerminalParser.term("finally").next(block).optional()});
    }

    static Parser<Statement> throwStatement(Parser<Expression> thrown) {
        return StatementParser.curry(ThrowStatement.class, new Object[0]).sequence(new Parser[]{TerminalParser.term("throw"), thrown, TerminalParser.term(";")});
    }

    static Parser<Statement> statement(Parser<Expression> expr) {
        Parser.Reference ref = Parser.newReference();
        Parser lazy = ref.lazy();
        Parser parser = Parsers.or((Parser[])new Parser[]{StatementParser.returnStatement(expr), BREAK, CONTINUE, StatementParser.blockStatement((Parser<Statement>)lazy), StatementParser.foreachStatement(expr, (Parser<Statement>)lazy), StatementParser.forStatement(expr, (Parser<Statement>)lazy), StatementParser.whileStatement(expr, (Parser<Statement>)lazy), StatementParser.doWhileStatement((Parser<Statement>)lazy, expr), StatementParser.ifStatement(expr, (Parser<Statement>)lazy), StatementParser.switchStatement(expr, (Parser<Statement>)lazy), StatementParser.tryStatement(StatementParser.modifier(expr), (Parser<Statement>)lazy), StatementParser.throwStatement(expr), StatementParser.synchronizedBlock((Parser<Statement>)lazy), StatementParser.assertStatement(expr), StatementParser.varStatement(expr), StatementParser.thisCall(expr), StatementParser.superCall(expr), StatementParser.expression(expr), NOP}).prefix(LABEL).label("statement");
        ref.set((Object)parser);
        return parser;
    }

    private static Mapper<Statement> curry(Class<? extends Statement> clazz, Object ... curryArgs) {
        return Mapper.curry(clazz, (Object[])curryArgs);
    }
}

