/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.ast.statement;

import java.util.List;
import org.codehaus.jparsec.examples.common.Strings;
import org.codehaus.jparsec.examples.common.ValueObject;
import org.codehaus.jparsec.examples.java.ast.expression.Expression;
import org.codehaus.jparsec.examples.java.ast.statement.Statement;

public final class ForStatement
extends ValueObject
implements Statement {
    public final Statement initializer;
    public final Expression condition;
    public final List<Expression> incrementer;
    public final Statement statement;

    public ForStatement(Statement initializer, Expression condition, List<Expression> incrementer, Statement statement) {
        this.initializer = initializer;
        this.condition = condition;
        this.incrementer = incrementer;
        this.statement = statement;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("for (");
        builder.append(this.initializer);
        if (this.condition != null) {
            builder.append(this.condition);
        }
        builder.append(";");
        Strings.join(builder, ", ", this.incrementer);
        builder.append(") ").append(this.statement);
        return builder.toString();
    }
}

