/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jparsec.examples.java.ast.declaration;

import java.util.List;
import org.codehaus.jparsec.examples.common.Strings;
import org.codehaus.jparsec.examples.common.ValueObject;
import org.codehaus.jparsec.examples.java.ast.declaration.Member;
import org.codehaus.jparsec.examples.java.ast.declaration.TypeParameterDef;
import org.codehaus.jparsec.examples.java.ast.expression.Expression;
import org.codehaus.jparsec.examples.java.ast.statement.BlockStatement;
import org.codehaus.jparsec.examples.java.ast.statement.Modifier;
import org.codehaus.jparsec.examples.java.ast.statement.ParameterDef;
import org.codehaus.jparsec.examples.java.ast.type.TypeLiteral;

public final class MethodDef
extends ValueObject
implements Member {
    public final List<Modifier> modifiers;
    public final List<TypeParameterDef> typeParameters;
    public final TypeLiteral returnType;
    public final String name;
    public final List<ParameterDef> parameters;
    public final List<TypeLiteral> exceptions;
    public final Expression defaultValue;
    public final BlockStatement body;

    public MethodDef(List<Modifier> modifiers, List<TypeParameterDef> typeParameters, TypeLiteral returnType, String name, List<ParameterDef> parameters, List<TypeLiteral> exceptions, Expression defaultValue, BlockStatement body) {
        this.modifiers = modifiers;
        this.typeParameters = typeParameters;
        this.returnType = returnType;
        this.name = name;
        this.parameters = parameters;
        this.exceptions = exceptions;
        this.defaultValue = defaultValue;
        this.body = body;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Modifier modifier : this.modifiers) {
            builder.append(modifier).append(' ');
        }
        if (this.typeParameters != null) {
            builder.append('<');
            Strings.join(builder, ", ", this.typeParameters);
            builder.append("> ");
        }
        builder.append(this.returnType).append(' ').append(this.name).append('(');
        Strings.join(builder, ", ", this.parameters);
        builder.append(')');
        if (this.exceptions != null) {
            builder.append(" throws ");
            Strings.join(builder, ", ", this.exceptions);
        }
        if (this.defaultValue != null) {
            builder.append(" default ").append(this.defaultValue);
        }
        if (this.body == null) {
            builder.append(';');
        } else {
            builder.append(' ').append(this.body);
        }
        return builder.toString();
    }
}

