/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Stream;
import org.jooq.codegen.Generator;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.GeneratorStrategyWrapper;
import org.jooq.codegen.Language;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.jaxb.GeneratedAnnotationType;
import org.jooq.meta.jaxb.GeneratedSerialVersionUID;
import org.jooq.meta.jaxb.GeneratedTextBlocks;
import org.jooq.meta.jaxb.VisibilityModifier;
import org.jooq.tools.JooqLogger;

abstract class AbstractGenerator
implements Generator {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractGenerator.class);
    boolean generateDeprecated = true;
    boolean generateDeprecationOnUnknownTypes = true;
    boolean generateIndexes = true;
    boolean generateRelations = true;
    boolean generateUDTPaths = true;
    boolean generateImplicitJoinPathsToOne = true;
    boolean generateImplicitJoinPathsToMany = true;
    boolean generateImplicitJoinPathTableSubtypes = true;
    boolean generateImplicitJoinPathUnusedConstructors = true;
    boolean generateImplicitJoinPathsAsKotlinProperties = true;
    boolean generateInstanceFields = true;
    VisibilityModifier generateVisibilityModifier = VisibilityModifier.DEFAULT;
    boolean generateGeneratedAnnotation = false;
    GeneratedAnnotationType generatedGeneratedAnnotationType = GeneratedAnnotationType.DETECT_FROM_JDK;
    boolean generateGeneratedAnnotationDate = false;
    boolean generateGeneratedAnnotationJooqVersion = true;
    boolean generateNonnullAnnotation = false;
    String generatedNonnullAnnotationType = "javax.annotation.Nonnull";
    boolean generateNullableAnnotation = false;
    String generatedNullableAnnotationType = "javax.annotation.Nullable";
    boolean generateConstructorPropertiesAnnotation = false;
    Boolean generateConstructorPropertiesAnnotationOnPojos;
    Boolean generateConstructorPropertiesAnnotationOnRecords;
    boolean useSchemaVersionProvider = false;
    boolean useCatalogVersionProvider = false;
    boolean generateRoutines = true;
    boolean generateSequences = true;
    boolean generateSequenceFlags = true;
    boolean generateUDTs = true;
    boolean generateTables = true;
    boolean generateEmbeddables = true;
    boolean generateRecords = true;
    boolean generateRecordsImplementingRecordN = false;
    boolean generateEnumsAsScalaSealedTraits = false;
    boolean generatePojos = false;
    boolean generatePojosAsJavaRecordClasses = false;
    boolean generatePojosAsScalaCaseClasses = true;
    boolean generatePojosAsKotlinDataClasses = true;
    boolean generatePojosEqualsAndHashCode = true;
    boolean generatePojosToString = true;
    boolean generateImmutablePojos = false;
    boolean generateSerializablePojos = true;
    boolean generateInterfaces = false;
    boolean generateImmutableInterfaces = false;
    boolean generateSerializableInterfaces = true;
    boolean generateDaos = false;
    boolean generateJooqVersionReference = true;
    boolean generateJPAAnnotations = false;
    String generateJPAVersion = "";
    boolean generateValidationAnnotations = false;
    boolean generateSpringAnnotations = false;
    boolean generateSpringDao = false;
    boolean generateKotlinSetterJvmNameAnnotationsOnIsPrefix = true;
    boolean generateKotlinNotNullPojoAttributes = false;
    boolean generateKotlinNotNullRecordAttributes = false;
    boolean generateKotlinNotNullInterfaceAttributes = false;
    boolean generateKotlinDefaultedNullablePojoAttributes = true;
    boolean generateKotlinDefaultedNullableRecordAttributes = true;
    GeneratedSerialVersionUID generatedSerialVersionUID = GeneratedSerialVersionUID.CONSTANT;
    int maxMembersPerInitialiser = 500;
    boolean generateQueues = true;
    boolean generateLinks = true;
    boolean generateKeys = true;
    boolean generateGlobalObjectNames = true;
    boolean generateGlobalObjectReferences = true;
    boolean generateGlobalCatalogReferences = true;
    boolean generateGlobalSchemaReferences = true;
    boolean generateGlobalRoutineReferences = true;
    boolean generateGlobalSequenceReferences = true;
    boolean generateGlobalTableReferences = true;
    boolean generateGlobalDomainReferences = true;
    boolean generateGlobalUDTReferences = true;
    boolean generateGlobalQueueReferences = true;
    boolean generateGlobalLinkReferences = true;
    boolean generateGlobalKeyReferences = true;
    boolean generateGlobalIndexReferences = true;
    boolean generateDefaultCatalog = true;
    boolean generateDefaultSchema = true;
    boolean generateJavadoc = true;
    boolean generateComments = true;
    boolean generateCommentsOnAttributes = true;
    boolean generateCommentsOnCatalogs = true;
    boolean generateCommentsOnColumns = true;
    boolean generateCommentsOnKeys = true;
    boolean generateCommentsOnLinks = true;
    boolean generateCommentsOnPackages = true;
    boolean generateCommentsOnParameters = true;
    boolean generateCommentsOnQueues = true;
    boolean generateCommentsOnRoutines = true;
    boolean generateCommentsOnSchemas = true;
    boolean generateCommentsOnSequences = true;
    boolean generateCommentsOnTables = true;
    boolean generateCommentsOnUDTs = true;
    boolean generateCommentsOnEmbeddables = true;
    boolean generateSources = true;
    boolean generateSourcesOnViews = true;
    boolean generateFluentSetters = false;
    boolean generateJavaBeansGettersAndSetters = false;
    boolean generateUseTableNameForUnambiguousFKs = true;
    boolean generateVarargsSetters = true;
    String generateFullyQualifiedTypes = "";
    boolean generateJavaTimeTypes = true;
    boolean generateSpatialTypes = true;
    boolean generateXmlTypes = true;
    boolean generateJsonTypes = true;
    boolean generateIntervalTypes = true;
    boolean generateTableValuedFunctions = false;
    boolean generateEmptyCatalogs = false;
    boolean generateEmptySchemas = false;
    String generateNewline = "\n";
    String generateIndentation;
    int generatePrintMarginForBlockComment = 80;
    GeneratedTextBlocks generateTextBlocks = GeneratedTextBlocks.DETECT_FROM_JDK;
    boolean generateWhereMethodOverrides = true;
    boolean generateRenameMethodOverrides = true;
    boolean generateAsMethodOverrides = true;
    protected GeneratorStrategyWrapper strategy;
    protected String targetEncoding = "UTF-8";
    protected boolean targetClean = true;
    final Language languageConfigured;
    Language language;
    Database database;

    AbstractGenerator(Language language) {
        this.languageConfigured = this.language = language;
    }

    @Override
    public void generate(Database db) {
        this.database = db;
        this.database.setIncludeRelations(this.generateRelations());
        this.database.setTableValuedFunctions(this.generateTableValuedFunctions());
        this.generate0(db);
    }

    protected void generate0(Database db) {
    }

    void logDatabaseParameters(Database db) {
        String url = "";
        try {
            Connection connection = db.getConnection();
            if (connection != null) {
                url = connection.getMetaData().getURL();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        log.info((Object)"License parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  Thank you for using jOOQ and jOOQ's code generator");
        log.info((Object)"");
        log.info((Object)"Database parameters");
        log.info((Object)"----------------------------------------------------------");
        log.info((Object)"  dialect", (Object)db.getDialect());
        log.info((Object)"  URL", (Object)url);
        log.info((Object)"  target dir", (Object)this.getTargetDirectory());
        log.info((Object)"  target package", (Object)this.getTargetPackage());
        log.info((Object)"  includes", Arrays.asList(db.getIncludes()));
        log.info((Object)"  excludes", Arrays.asList(db.getExcludes()));
        log.info((Object)"  includeExcludeColumns", (Object)db.getIncludeExcludeColumns());
        log.info((Object)"----------------------------------------------------------");
    }

    void logGenerationRemarks(Database db) {
        log.info((Object)"Generation remarks");
        log.info((Object)"----------------------------------------------------------");
        if (this.contains(db.getIncludes(), ',') && db.getIncluded().isEmpty()) {
            log.info((Object)"  includes", (Object)"The <includes/> element takes a Java regular expression, not a comma-separated list. This might be why no objects were included.");
        }
        if (this.contains(db.getExcludes(), ',') && db.getExcluded().isEmpty()) {
            log.info((Object)"  excludes", (Object)"The <excludes/> element takes a Java regular expression, not a comma-separated list. This might be why no objects were excluded.");
        }
    }

    private boolean contains(String[] array, char c) {
        if (array == null) {
            return false;
        }
        return Stream.of(array).anyMatch(s -> s != null && s.indexOf(c) > -1);
    }

    @Override
    public void setStrategy(GeneratorStrategy strategy) {
        this.strategy = new GeneratorStrategyWrapper(this, strategy);
        this.strategy.setTargetLanguage(this.language);
    }

    @Override
    public GeneratorStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public boolean generateDeprecated() {
        return this.generateDeprecated;
    }

    @Override
    public void setGenerateDeprecated(boolean generateDeprecated) {
        this.generateDeprecated = generateDeprecated;
    }

    @Override
    public boolean generateDeprecationOnUnknownTypes() {
        return this.generateDeprecationOnUnknownTypes;
    }

    @Override
    public void setGenerateDeprecationOnUnknownTypes(boolean generateDeprecationOnUnknownTypes) {
        this.generateDeprecationOnUnknownTypes = generateDeprecationOnUnknownTypes;
    }

    @Override
    public boolean generateIndexes() {
        return this.generateIndexes;
    }

    @Override
    public void setGenerateIndexes(boolean generateIndexes) {
        this.generateIndexes = generateIndexes;
    }

    @Override
    public boolean generateRelations() {
        return this.generateRelations || this.generateTables || this.generateDaos;
    }

    @Override
    public void setGenerateRelations(boolean generateRelations) {
        this.generateRelations = generateRelations;
    }

    @Override
    public boolean generateUDTPaths() {
        return this.generateUDTPaths;
    }

    @Override
    public void setGenerateUDTPaths(boolean generateUDTPaths) {
        this.generateUDTPaths = generateUDTPaths;
    }

    @Override
    public boolean generateImplicitJoinPathsToOne() {
        return this.generateImplicitJoinPathsToOne && this.generateRelations();
    }

    @Override
    public void setGenerateImplicitJoinPathsToOne(boolean generateImplicitJoinPathsToOne) {
        this.generateImplicitJoinPathsToOne = generateImplicitJoinPathsToOne;
    }

    @Override
    public boolean generateImplicitJoinPathsToMany() {
        return this.generateImplicitJoinPathsToMany && this.generateRelations();
    }

    @Override
    public void setGenerateImplicitJoinPathsToMany(boolean generateImplicitJoinPathsToMany) {
        this.generateImplicitJoinPathsToMany = generateImplicitJoinPathsToMany;
    }

    @Override
    public boolean generateImplicitJoinPathTableSubtypes() {
        return this.generateImplicitJoinPathTableSubtypes && this.generateRelations();
    }

    @Override
    public void setGenerateImplicitJoinPathTableSubtypes(boolean generateImplicitJoinPathTableSubtypes) {
        this.generateImplicitJoinPathTableSubtypes = generateImplicitJoinPathTableSubtypes;
    }

    @Override
    public boolean generateImplicitJoinPathUnusedConstructors() {
        return this.generateImplicitJoinPathUnusedConstructors && this.generateRelations();
    }

    @Override
    public void setGenerateImplicitJoinPathUnusedConstructors(boolean generateImplicitJoinPathUnusedConstructors) {
        this.generateImplicitJoinPathUnusedConstructors = generateImplicitJoinPathUnusedConstructors;
    }

    @Override
    public boolean generateImplicitJoinPathsAsKotlinProperties() {
        return this.generateImplicitJoinPathsAsKotlinProperties && this.generateImplicitJoinPathsToOne();
    }

    @Override
    public void setGenerateImplicitJoinPathsAsKotlinProperties(boolean generateImplicitJoinPathsAsKotlinProperties) {
        this.generateImplicitJoinPathsAsKotlinProperties = generateImplicitJoinPathsAsKotlinProperties;
    }

    @Override
    public boolean generateTableValuedFunctions() {
        return this.generateTableValuedFunctions;
    }

    @Override
    public void setGenerateTableValuedFunctions(boolean generateTableValuedFunctions) {
        this.generateTableValuedFunctions = generateTableValuedFunctions;
    }

    @Override
    public boolean generateInstanceFields() {
        return this.generateInstanceFields;
    }

    @Override
    public void setGenerateInstanceFields(boolean generateInstanceFields) {
        this.generateInstanceFields = generateInstanceFields;
    }

    @Override
    public void setGenerateVisibilityModifier(VisibilityModifier generateVisibilityModifier) {
        if (generateVisibilityModifier == VisibilityModifier.PRIVATE) {
            log.warn((Object)"Visibility", (Object)"The private visibility modifier cannot be used globally, to be applied to classes. It can only be used on <forcedType/> configurations.");
        } else {
            this.generateVisibilityModifier = generateVisibilityModifier;
        }
    }

    @Override
    public VisibilityModifier generateVisibilityModifier() {
        return this.generateVisibilityModifier;
    }

    @Override
    public boolean generateGeneratedAnnotation() {
        return this.generateGeneratedAnnotation || this.useSchemaVersionProvider || this.useCatalogVersionProvider;
    }

    @Override
    public void setGenerateGeneratedAnnotation(boolean generateGeneratedAnnotation) {
        this.generateGeneratedAnnotation = generateGeneratedAnnotation;
    }

    @Override
    public GeneratedAnnotationType generateGeneratedAnnotationType() {
        return this.generatedGeneratedAnnotationType;
    }

    @Override
    public void setGenerateGeneratedAnnotationType(GeneratedAnnotationType generateGeneratedAnnotationType) {
        this.generatedGeneratedAnnotationType = generateGeneratedAnnotationType;
    }

    @Override
    public boolean generateGeneratedAnnotationDate() {
        return this.generateGeneratedAnnotationDate;
    }

    @Override
    public void setGenerateGeneratedAnnotationDate(boolean generateGeneratedAnnotationDate) {
        this.generateGeneratedAnnotationDate = generateGeneratedAnnotationDate;
    }

    @Override
    public boolean generateGeneratedAnnotationJooqVersion() {
        return this.generateGeneratedAnnotationJooqVersion;
    }

    @Override
    public void setGenerateGeneratedAnnotationJooqVersion(boolean generateGeneratedAnnotationJooqVersion) {
        this.generateGeneratedAnnotationJooqVersion = generateGeneratedAnnotationJooqVersion;
    }

    @Override
    public boolean generateNonnullAnnotation() {
        return this.generateNonnullAnnotation;
    }

    @Override
    public void setGenerateNonnullAnnotation(boolean generateNonnullAnnotation) {
        this.generateNonnullAnnotation = generateNonnullAnnotation;
    }

    @Override
    public String generatedNonnullAnnotationType() {
        return this.generatedNonnullAnnotationType;
    }

    @Override
    public void setGeneratedNonnullAnnotationType(String generatedNonnullAnnotationType) {
        this.generatedNonnullAnnotationType = generatedNonnullAnnotationType;
    }

    @Override
    public boolean generateNullableAnnotation() {
        return this.generateNullableAnnotation;
    }

    @Override
    public void setGenerateNullableAnnotation(boolean generateNullableAnnotation) {
        this.generateNullableAnnotation = generateNullableAnnotation;
    }

    @Override
    public String generatedNullableAnnotationType() {
        return this.generatedNullableAnnotationType;
    }

    @Override
    public void setGeneratedNullableAnnotationType(String generatedNullableAnnotationType) {
        this.generatedNullableAnnotationType = generatedNullableAnnotationType;
    }

    @Override
    public void setGenerateConstructorPropertiesAnnotation(boolean generateConstructorPropertiesAnnotation) {
        this.generateConstructorPropertiesAnnotation = generateConstructorPropertiesAnnotation;
    }

    @Override
    public boolean generateConstructorPropertiesAnnotation() {
        return this.generateConstructorPropertiesAnnotation;
    }

    @Override
    public void setGenerateConstructorPropertiesAnnotationOnPojos(boolean generateConstructorPropertiesAnnotationOnPojos) {
        this.generateConstructorPropertiesAnnotationOnPojos = generateConstructorPropertiesAnnotationOnPojos;
    }

    @Override
    public boolean generateConstructorPropertiesAnnotationOnPojos() {
        return Boolean.TRUE.equals(this.generateConstructorPropertiesAnnotationOnPojos) || this.generateConstructorPropertiesAnnotation() && this.generateConstructorPropertiesAnnotationOnPojos == null;
    }

    @Override
    public void setGenerateConstructorPropertiesAnnotationOnRecords(boolean generateConstructorPropertiesAnnotationOnRecords) {
        this.generateConstructorPropertiesAnnotationOnRecords = generateConstructorPropertiesAnnotationOnRecords;
    }

    @Override
    public boolean generateConstructorPropertiesAnnotationOnRecords() {
        return Boolean.TRUE.equals(this.generateConstructorPropertiesAnnotationOnPojos) || this.generateConstructorPropertiesAnnotation() && this.generateConstructorPropertiesAnnotationOnRecords == null;
    }

    @Override
    public boolean useSchemaVersionProvider() {
        return this.useSchemaVersionProvider;
    }

    @Override
    public void setUseSchemaVersionProvider(boolean useSchemaVersionProvider) {
        this.useSchemaVersionProvider = useSchemaVersionProvider;
    }

    @Override
    public boolean useCatalogVersionProvider() {
        return this.useCatalogVersionProvider;
    }

    @Override
    public void setUseCatalogVersionProvider(boolean useCatalogVersionProvider) {
        this.useCatalogVersionProvider = useCatalogVersionProvider;
    }

    @Override
    public boolean generateRoutines() {
        return this.generateRoutines;
    }

    @Override
    public void setGenerateRoutines(boolean generateRoutines) {
        this.generateRoutines = generateRoutines;
    }

    @Override
    public boolean generateSequences() {
        return this.generateSequences;
    }

    @Override
    public void setGenerateSequences(boolean generateSequences) {
        this.generateSequences = generateSequences;
    }

    @Override
    public boolean generateSequenceFlags() {
        return this.generateSequenceFlags;
    }

    @Override
    public void setGenerateSequenceFlags(boolean generateSequenceFlags) {
        this.generateSequenceFlags = generateSequenceFlags;
    }

    @Override
    public boolean generateUDTs() {
        return this.generateUDTs;
    }

    @Override
    public void setGenerateUDTs(boolean generateUDTs) {
        this.generateUDTs = generateUDTs;
    }

    @Override
    public boolean generateTables() {
        return this.generateTables || this.generateRecords || this.generateDaos || this.generateIndexes && this.database.getSchemata().stream().flatMap(s -> this.database.getIndexes(s).stream()).anyMatch(t -> true);
    }

    @Override
    public void setGenerateTables(boolean generateTables) {
        this.generateTables = generateTables;
    }

    @Override
    public boolean generateEmbeddables() {
        return this.generateEmbeddables;
    }

    @Override
    public void setGenerateEmbeddables(boolean generateEmbeddables) {
        this.generateEmbeddables = generateEmbeddables;
    }

    @Override
    public boolean generateRecords() {
        return this.generateRecords || this.generateDaos;
    }

    @Override
    public void setGenerateRecords(boolean generateRecords) {
        this.generateRecords = generateRecords;
    }

    @Override
    public boolean generateRecordsImplementingRecordN() {
        return this.generateRecords() && this.generateRecordsImplementingRecordN;
    }

    @Override
    public void setGenerateRecordsImplementingRecordN(boolean generateRecordsImplementingRecordN) {
        this.generateRecordsImplementingRecordN = generateRecordsImplementingRecordN;
    }

    @Override
    public boolean generateEnumsAsScalaSealedTraits() {
        return this.generateEnumsAsScalaSealedTraits;
    }

    @Override
    public void setGenerateEnumsAsScalaSealedTraits(boolean generateEnumsAsScalaSealedTraits) {
        this.generateEnumsAsScalaSealedTraits = generateEnumsAsScalaSealedTraits;
    }

    @Override
    public boolean generatePojos() {
        return this.generatePojos || this.generateImmutablePojos || this.generateDaos;
    }

    @Override
    public void setGeneratePojos(boolean generatePojos) {
        this.generatePojos = generatePojos;
    }

    @Override
    public boolean generatePojosAsJavaRecordClasses() {
        return this.generatePojosAsJavaRecordClasses;
    }

    @Override
    public void setGeneratePojosAsJavaRecordClasses(boolean pojosAsJavaRecordClasses) {
        this.generatePojosAsJavaRecordClasses = pojosAsJavaRecordClasses;
    }

    @Override
    public boolean generatePojosAsScalaCaseClasses() {
        return this.generatePojosAsScalaCaseClasses;
    }

    @Override
    public void setGeneratePojosAsScalaCaseClasses(boolean pojosAsScalaCaseClasses) {
        this.generatePojosAsScalaCaseClasses = pojosAsScalaCaseClasses;
    }

    @Override
    public boolean generatePojosAsKotlinDataClasses() {
        return this.generatePojosAsKotlinDataClasses;
    }

    @Override
    public void setGeneratePojosAsKotlinDataClasses(boolean pojosAsKotlinDataClasses) {
        this.generatePojosAsKotlinDataClasses = pojosAsKotlinDataClasses;
    }

    @Override
    public boolean generateImmutablePojos() {
        return this.generateImmutablePojos || this.generatePojosAsJavaRecordClasses();
    }

    @Override
    public void setGenerateImmutablePojos(boolean generateImmutablePojos) {
        this.generateImmutablePojos = generateImmutablePojos;
    }

    @Override
    public boolean generateSerializablePojos() {
        return this.generateSerializablePojos && this.generatePojos();
    }

    @Override
    public void setGenerateSerializablePojos(boolean generateSerializablePojos) {
        this.generateSerializablePojos = generateSerializablePojos;
    }

    @Override
    public boolean generateInterfaces() {
        return this.generateInterfaces || this.generateImmutableInterfaces;
    }

    @Override
    public void setGenerateInterfaces(boolean generateInterfaces) {
        this.generateInterfaces = generateInterfaces;
    }

    @Override
    public boolean generateImmutableInterfaces() {
        return this.generateImmutableInterfaces || this.generateInterfaces && (this.generateImmutablePojos || this.generatePojosAsJavaRecordClasses);
    }

    @Override
    public void setGenerateImmutableInterfaces(boolean generateImmutableInterfaces) {
        this.generateImmutableInterfaces = generateImmutableInterfaces;
    }

    @Override
    public boolean generateSerializableInterfaces() {
        return this.generateSerializableInterfaces && this.generateInterfaces();
    }

    @Override
    public void setGenerateSerializableInterfaces(boolean generateSerializableInterfaces) {
        this.generateSerializableInterfaces = generateSerializableInterfaces;
    }

    @Override
    public boolean generateDaos() {
        return this.generateDaos;
    }

    @Override
    public void setGenerateDaos(boolean generateDaos) {
        this.generateDaos = generateDaos;
    }

    @Override
    public boolean generateJooqVersionReference() {
        return this.generateJooqVersionReference;
    }

    @Override
    public void setGenerateJooqVersionReference(boolean generateJooqVersionReference) {
        this.generateJooqVersionReference = generateJooqVersionReference;
    }

    @Override
    public boolean generateJPAAnnotations() {
        return this.generateJPAAnnotations;
    }

    @Override
    public void setGenerateJPAAnnotations(boolean generateJPAAnnotations) {
        this.generateJPAAnnotations = generateJPAAnnotations;
    }

    @Override
    public String generateJPAVersion() {
        return this.generateJPAVersion;
    }

    @Override
    public void setGenerateJPAVersion(String generateJPAVersion) {
        this.generateJPAVersion = generateJPAVersion;
    }

    @Override
    public boolean generateValidationAnnotations() {
        return this.generateValidationAnnotations;
    }

    @Override
    public void setGenerateValidationAnnotations(boolean generateValidationAnnotations) {
        this.generateValidationAnnotations = generateValidationAnnotations;
    }

    @Override
    public boolean generateSpringAnnotations() {
        return this.generateSpringAnnotations;
    }

    @Override
    public void setGenerateSpringAnnotations(boolean generateSpringAnnotations) {
        this.generateSpringAnnotations = generateSpringAnnotations;
    }

    @Override
    public boolean generateSpringDao() {
        return this.generateSpringDao;
    }

    @Override
    public void setGenerateSpringDao(boolean generateSpringDao) {
        this.generateSpringDao = generateSpringDao;
    }

    @Override
    public boolean generateKotlinSetterJvmNameAnnotationsOnIsPrefix() {
        return this.generateKotlinSetterJvmNameAnnotationsOnIsPrefix;
    }

    @Override
    public void setGenerateKotlinSetterJvmNameAnnotationsOnIsPrefix(boolean generateKotlinSetterJvmNameAnnotationsOnIsPrefix) {
        this.generateKotlinSetterJvmNameAnnotationsOnIsPrefix = generateKotlinSetterJvmNameAnnotationsOnIsPrefix;
    }

    @Override
    public boolean generateKotlinNotNullPojoAttributes() {
        return this.generateKotlinNotNullPojoAttributes;
    }

    @Override
    public void setGenerateKotlinNotNullPojoAttributes(boolean generateKotlinNotNullPojoAttributes) {
        this.generateKotlinNotNullPojoAttributes = generateKotlinNotNullPojoAttributes;
    }

    @Override
    public boolean generateKotlinNotNullRecordAttributes() {
        return this.generateKotlinNotNullRecordAttributes;
    }

    @Override
    public void setGenerateKotlinNotNullRecordAttributes(boolean generateKotlinNotNullRecordAttributes) {
        this.generateKotlinNotNullRecordAttributes = generateKotlinNotNullRecordAttributes;
    }

    @Override
    public boolean generateKotlinNotNullInterfaceAttributes() {
        return this.generateKotlinNotNullInterfaceAttributes;
    }

    @Override
    public void setGenerateKotlinNotNullInterfaceAttributes(boolean generateKotlinNotNullInterfaceAttributes) {
        this.generateKotlinNotNullInterfaceAttributes = generateKotlinNotNullInterfaceAttributes;
    }

    @Override
    public boolean generateKotlinDefaultedNullablePojoAttributes() {
        return this.generateKotlinDefaultedNullablePojoAttributes;
    }

    @Override
    public void setGenerateKotlinDefaultedNullablePojoAttributes(boolean generateKotlinDefaultedNullablePojoAttributes) {
        this.generateKotlinDefaultedNullablePojoAttributes = generateKotlinDefaultedNullablePojoAttributes;
    }

    @Override
    public boolean generateKotlinDefaultedNullableRecordAttributes() {
        return this.generateKotlinDefaultedNullableRecordAttributes;
    }

    @Override
    public void setGenerateKotlinDefaultedNullableRecordAttributes(boolean generateKotlinDefaultedNullableRecordAttributes) {
        this.generateKotlinDefaultedNullableRecordAttributes = generateKotlinDefaultedNullableRecordAttributes;
    }

    @Override
    public GeneratedSerialVersionUID generatedSerialVersionUID() {
        return this.generatedSerialVersionUID;
    }

    @Override
    public void setGenerateGeneratedSerialVersionUID(GeneratedSerialVersionUID generatedSerialVersionUID) {
        this.generatedSerialVersionUID = generatedSerialVersionUID;
    }

    @Override
    public int maxMembersPerInitialiser() {
        return this.maxMembersPerInitialiser;
    }

    @Override
    public void setMaxMembersPerInitialiser(int maxMembersPerInitialiser) {
        this.maxMembersPerInitialiser = maxMembersPerInitialiser;
    }

    @Override
    public boolean generateGlobalObjectNames() {
        return this.generateGlobalObjectNames;
    }

    @Override
    public void setGenerateGlobalObjectNames(boolean generateGlobalObjectNames) {
        this.generateGlobalObjectNames = generateGlobalObjectNames;
    }

    @Override
    public boolean generateGlobalObjectReferences() {
        return this.generateGlobalObjectReferences;
    }

    @Override
    public void setGenerateGlobalObjectReferences(boolean generateGlobalObjectReferences) {
        this.generateGlobalObjectReferences = generateGlobalObjectReferences;
    }

    @Override
    public boolean generateGlobalCatalogReferences() {
        return this.generateGlobalObjectReferences() && this.generateGlobalCatalogReferences;
    }

    @Override
    public void setGenerateGlobalCatalogReferences(boolean globalCatalogReferences) {
        this.generateGlobalCatalogReferences = globalCatalogReferences;
    }

    @Override
    public boolean generateGlobalSchemaReferences() {
        return this.generateGlobalObjectReferences() && this.generateGlobalSchemaReferences;
    }

    @Override
    public void setGenerateGlobalSchemaReferences(boolean globalSchemaReferences) {
        this.generateGlobalSchemaReferences = globalSchemaReferences;
    }

    @Override
    public boolean generateGlobalRoutineReferences() {
        return this.generateRoutines() && this.generateGlobalObjectReferences() && this.generateGlobalRoutineReferences;
    }

    @Override
    public void setGenerateGlobalRoutineReferences(boolean generateGlobalRoutineReferences) {
        this.generateGlobalRoutineReferences = generateGlobalRoutineReferences;
    }

    @Override
    public boolean generateGlobalSequenceReferences() {
        return this.generateSequences() && this.generateGlobalObjectReferences() && this.generateGlobalSequenceReferences;
    }

    @Override
    public void setGenerateGlobalSequenceReferences(boolean generateGlobalSequenceReferences) {
        this.generateGlobalSequenceReferences = generateGlobalSequenceReferences;
    }

    @Override
    public boolean generateGlobalTableReferences() {
        return this.generateTables() && this.generateGlobalObjectReferences() && this.generateGlobalTableReferences;
    }

    @Override
    public void setGenerateGlobalTableReferences(boolean generateGlobalTableReferences) {
        this.generateGlobalTableReferences = generateGlobalTableReferences;
    }

    @Override
    public boolean generateGlobalDomainReferences() {
        return this.generateUDTs() && this.generateGlobalObjectReferences() && this.generateGlobalDomainReferences;
    }

    @Override
    public void setGenerateGlobalDomainReferences(boolean globalDomainReferences) {
        this.generateGlobalDomainReferences = globalDomainReferences;
    }

    @Override
    public boolean generateGlobalUDTReferences() {
        return this.generateUDTs() && this.generateGlobalObjectReferences() && this.generateGlobalUDTReferences;
    }

    @Override
    public void setGenerateGlobalUDTReferences(boolean generateGlobalUDTReferences) {
        this.generateGlobalUDTReferences = generateGlobalUDTReferences;
    }

    @Override
    public boolean generateGlobalQueueReferences() {
        return this.generateQueues() && this.generateGlobalObjectReferences() && this.generateGlobalQueueReferences;
    }

    @Override
    public void setGenerateGlobalQueueReferences(boolean globalQueueReferences) {
        this.generateGlobalQueueReferences = globalQueueReferences;
    }

    @Override
    public boolean generateGlobalLinkReferences() {
        return this.generateLinks() && this.generateGlobalObjectReferences() && this.generateGlobalLinkReferences;
    }

    @Override
    public void setGenerateGlobalLinkReferences(boolean globalLinkReferences) {
        this.generateGlobalLinkReferences = globalLinkReferences;
    }

    @Override
    public boolean generateGlobalKeyReferences() {
        return this.generateKeys() && this.generateGlobalObjectReferences() && this.generateGlobalKeyReferences;
    }

    @Override
    public void setGenerateGlobalKeyReferences(boolean globalKeyReferences) {
        this.generateGlobalKeyReferences = globalKeyReferences;
    }

    @Override
    public boolean generateGlobalIndexReferences() {
        return this.generateIndexes() && this.generateGlobalObjectReferences() && this.generateGlobalIndexReferences;
    }

    @Override
    public void setGenerateGlobalIndexReferences(boolean globalIndexReferences) {
        this.generateGlobalIndexReferences = globalIndexReferences;
    }

    @Override
    public boolean generateDefaultCatalog() {
        return this.generateDefaultCatalog;
    }

    boolean generateDefaultCatalog(CatalogDefinition catalog) {
        return this.generateDefaultCatalog() || !catalog.isDefaultCatalog();
    }

    @Override
    public void setGenerateDefaultCatalog(boolean defaultCatalog) {
        this.generateDefaultCatalog = defaultCatalog;
    }

    @Override
    public boolean generateDefaultSchema() {
        return this.generateDefaultSchema;
    }

    boolean generateDefaultSchema(SchemaDefinition schema) {
        return this.generateDefaultSchema() || !schema.isDefaultSchema();
    }

    @Override
    public void setGenerateDefaultSchema(boolean defaultSchema) {
        this.generateDefaultSchema = defaultSchema;
    }

    @Override
    public boolean generateQueues() {
        return this.generateQueues;
    }

    @Override
    public void setGenerateQueues(boolean queues) {
        this.generateQueues = queues;
    }

    @Override
    public boolean generateLinks() {
        return this.generateLinks;
    }

    @Override
    public void setGenerateLinks(boolean links) {
        this.generateLinks = links;
    }

    @Override
    public boolean generateKeys() {
        return this.generateKeys;
    }

    @Override
    public void setGenerateKeys(boolean keys) {
        this.generateKeys = keys;
    }

    @Override
    public boolean generateJavadoc() {
        return this.generateJavadoc;
    }

    @Override
    public void setGenerateJavadoc(boolean javadoc) {
        this.generateJavadoc = javadoc;
    }

    @Override
    public boolean generateComments() {
        return this.generateComments;
    }

    @Override
    public void setGenerateComments(boolean comments) {
        this.generateComments = comments;
    }

    @Override
    public boolean generateCommentsOnAttributes() {
        return this.generateComments() && this.generateCommentsOnAttributes;
    }

    @Override
    public void setGenerateCommentsOnAttributes(boolean commentsOnAttributes) {
        this.generateCommentsOnAttributes = commentsOnAttributes;
    }

    @Override
    public boolean generateCommentsOnCatalogs() {
        return this.generateComments() && this.generateCommentsOnCatalogs;
    }

    @Override
    public void setGenerateCommentsOnCatalogs(boolean commentsOnCatalogs) {
        this.generateCommentsOnCatalogs = commentsOnCatalogs;
    }

    @Override
    public boolean generateCommentsOnColumns() {
        return this.generateComments() && this.generateCommentsOnColumns;
    }

    @Override
    public void setGenerateCommentsOnColumns(boolean commentsOnColumns) {
        this.generateCommentsOnColumns = commentsOnColumns;
    }

    @Override
    public boolean generateCommentsOnKeys() {
        return this.generateComments() && this.generateCommentsOnKeys;
    }

    @Override
    public void setGenerateCommentsOnKeys(boolean commentsOnKeys) {
        this.generateCommentsOnKeys = commentsOnKeys;
    }

    @Override
    public boolean generateCommentsOnLinks() {
        return this.generateComments() && this.generateCommentsOnLinks;
    }

    @Override
    public void setGenerateCommentsOnLinks(boolean commentsOnLinks) {
        this.generateCommentsOnLinks = commentsOnLinks;
    }

    @Override
    public boolean generateCommentsOnPackages() {
        return this.generateComments() && this.generateCommentsOnPackages;
    }

    @Override
    public void setGenerateCommentsOnPackages(boolean commentsOnPackages) {
        this.generateCommentsOnPackages = commentsOnPackages;
    }

    @Override
    public boolean generateCommentsOnParameters() {
        return this.generateComments() && this.generateCommentsOnParameters;
    }

    @Override
    public void setGenerateCommentsOnParameters(boolean commentsOnParameters) {
        this.generateCommentsOnParameters = commentsOnParameters;
    }

    @Override
    public boolean generateCommentsOnQueues() {
        return this.generateComments() && this.generateCommentsOnQueues;
    }

    @Override
    public void setGenerateCommentsOnQueues(boolean commentsOnQueues) {
        this.generateCommentsOnQueues = commentsOnQueues;
    }

    @Override
    public boolean generateCommentsOnRoutines() {
        return this.generateComments() && this.generateCommentsOnRoutines;
    }

    @Override
    public void setGenerateCommentsOnRoutines(boolean commentsOnRoutines) {
        this.generateCommentsOnRoutines = commentsOnRoutines;
    }

    @Override
    public boolean generateCommentsOnSchemas() {
        return this.generateComments() && this.generateCommentsOnSchemas;
    }

    @Override
    public void setGenerateCommentsOnSchemas(boolean commentsOnSchemas) {
        this.generateCommentsOnSchemas = commentsOnSchemas;
    }

    @Override
    public boolean generateCommentsOnSequences() {
        return this.generateComments() && this.generateCommentsOnSequences;
    }

    @Override
    public void setGenerateCommentsOnSequences(boolean commentsOnSequences) {
        this.generateCommentsOnSequences = commentsOnSequences;
    }

    @Override
    public boolean generateCommentsOnTables() {
        return this.generateComments() && this.generateCommentsOnTables;
    }

    @Override
    public void setGenerateCommentsOnTables(boolean commentsOnTables) {
        this.generateCommentsOnTables = commentsOnTables;
    }

    @Override
    public boolean generateCommentsOnEmbeddables() {
        return this.generateComments() && this.generateCommentsOnEmbeddables;
    }

    @Override
    public void setGenerateCommentsOnEmbeddables(boolean generateCommentsOnEmbeddables) {
        this.generateCommentsOnEmbeddables = generateCommentsOnEmbeddables;
    }

    @Override
    public boolean generateCommentsOnUDTs() {
        return this.generateComments() && this.generateCommentsOnUDTs;
    }

    @Override
    public void setGenerateCommentsOnUDTs(boolean commentsOnUDTs) {
        this.generateCommentsOnUDTs = commentsOnUDTs;
    }

    @Override
    public boolean generateSources() {
        return this.generateSources;
    }

    @Override
    public void setGenerateSources(boolean sources) {
        this.generateSources = sources;
    }

    @Override
    public boolean generateSourcesOnViews() {
        return this.generateSources() && this.generateSourcesOnViews;
    }

    @Override
    public void setGenerateSourcesOnViews(boolean sourcesOnViews) {
        this.generateSourcesOnViews = sourcesOnViews;
    }

    @Override
    @Deprecated
    public boolean fluentSetters() {
        return this.generateFluentSetters();
    }

    @Override
    @Deprecated
    public void setFluentSetters(boolean fluentSetters) {
        this.setGenerateFluentSetters(fluentSetters);
    }

    @Override
    public boolean generateFluentSetters() {
        return this.generateFluentSetters;
    }

    @Override
    public void setGenerateFluentSetters(boolean fluentSetters) {
        this.generateFluentSetters = fluentSetters;
    }

    @Override
    public boolean generateJavaBeansGettersAndSetters() {
        return this.generateJavaBeansGettersAndSetters;
    }

    @Override
    public void setGenerateJavaBeansGettersAndSetters(boolean javaBeansGettersAndSetters) {
        this.generateJavaBeansGettersAndSetters = javaBeansGettersAndSetters;
    }

    @Override
    public boolean generateUseTableNameForUnambiguousFKs() {
        return this.generateUseTableNameForUnambiguousFKs;
    }

    @Override
    public void setGenerateUseTableNameForUnambiguousFKs(boolean useTableNameForUnambiguousFKs) {
        this.generateUseTableNameForUnambiguousFKs = useTableNameForUnambiguousFKs;
    }

    @Override
    public boolean generateVarargsSetters() {
        return this.generateVarargsSetters;
    }

    @Override
    public void setGenerateVarargsSetters(boolean varargsSetters) {
        this.generateVarargsSetters = varargsSetters;
    }

    @Override
    public boolean generatePojosEqualsAndHashCode() {
        return this.generatePojosEqualsAndHashCode;
    }

    @Override
    public void setGeneratePojosEqualsAndHashCode(boolean generatePojosEqualsAndHashCode) {
        this.generatePojosEqualsAndHashCode = generatePojosEqualsAndHashCode;
    }

    @Override
    public boolean generatePojosToString() {
        return this.generatePojosToString;
    }

    @Override
    public void setGeneratePojosToString(boolean generatePojosToString) {
        this.generatePojosToString = generatePojosToString;
    }

    @Override
    @Deprecated
    public String fullyQualifiedTypes() {
        return this.generateFullyQualifiedTypes();
    }

    @Override
    @Deprecated
    public void setFullyQualifiedTypes(String fullyQualifiedTypes) {
        this.setGenerateFullyQualifiedTypes(fullyQualifiedTypes);
    }

    @Override
    public String generateFullyQualifiedTypes() {
        return this.generateFullyQualifiedTypes;
    }

    @Override
    public void setGenerateFullyQualifiedTypes(String generateFullyQualifiedTypes) {
        this.generateFullyQualifiedTypes = generateFullyQualifiedTypes;
    }

    @Override
    public boolean generateJavaTimeTypes() {
        return this.generateJavaTimeTypes;
    }

    @Override
    public void setGenerateJavaTimeTypes(boolean generateJavaTimeTypes) {
        this.generateJavaTimeTypes = generateJavaTimeTypes;
    }

    @Override
    public boolean generateSpatialTypes() {
        return this.generateSpatialTypes;
    }

    @Override
    public void setGenerateSpatialTypes(boolean generateSpatialTypes) {
        this.generateSpatialTypes = generateSpatialTypes;
    }

    @Override
    public boolean generateXmlTypes() {
        return this.generateXmlTypes;
    }

    @Override
    public void setGenerateXmlTypes(boolean generateXmlTypes) {
        this.generateXmlTypes = generateXmlTypes;
    }

    @Override
    public boolean generateJsonTypes() {
        return this.generateJsonTypes;
    }

    @Override
    public void setGenerateJsonTypes(boolean generateJsonTypes) {
        this.generateJsonTypes = generateJsonTypes;
    }

    @Override
    public boolean generateIntervalTypes() {
        return this.generateIntervalTypes;
    }

    @Override
    public void setGenerateIntervalTypes(boolean generateIntervalTypes) {
        this.generateIntervalTypes = generateIntervalTypes;
    }

    @Override
    public boolean generateEmptyCatalogs() {
        return this.generateEmptyCatalogs;
    }

    @Override
    public void setGenerateEmptyCatalogs(boolean generateEmptyCatalogs) {
        this.generateEmptyCatalogs = generateEmptyCatalogs;
    }

    @Override
    public boolean generateEmptySchemas() {
        return this.generateEmptySchemas;
    }

    @Override
    public void setGenerateEmptySchemas(boolean generateEmptySchemas) {
        this.generateEmptySchemas = generateEmptySchemas;
    }

    @Override
    public String generateNewline() {
        return this.generateNewline;
    }

    @Override
    public void setGenerateNewline(String newline) {
        this.generateNewline = newline == null ? newline : newline.replace("\\r", "\r").replace("\\n", "\n");
    }

    @Override
    public String generateIndentation() {
        return this.generateIndentation;
    }

    @Override
    public void setGenerateIndentation(String indentation) {
        this.generateIndentation = indentation;
    }

    @Override
    public int generatePrintMarginForBlockComment() {
        return this.generatePrintMarginForBlockComment;
    }

    @Override
    public void setGeneratePrintMarginForBlockComment(int printMarginForBlockComment) {
        this.generatePrintMarginForBlockComment = printMarginForBlockComment;
    }

    @Override
    public GeneratedTextBlocks generateTextBlocks() {
        return this.generateTextBlocks;
    }

    @Override
    public void setGenerateTextBlocks(GeneratedTextBlocks textBlocks) {
        this.generateTextBlocks = textBlocks;
    }

    @Override
    public boolean generateWhereMethodOverrides() {
        return this.generateWhereMethodOverrides;
    }

    @Override
    public void setGenerateWhereMethodOverrides(boolean whereMethodOverrides) {
        this.generateWhereMethodOverrides = whereMethodOverrides;
    }

    @Override
    public boolean generateRenameMethodOverrides() {
        return this.generateRenameMethodOverrides;
    }

    @Override
    public void setGenerateRenameMethodOverrides(boolean renameMethodOverrides) {
        this.generateRenameMethodOverrides = renameMethodOverrides;
    }

    @Override
    public boolean generateAsMethodOverrides() {
        return this.generateAsMethodOverrides;
    }

    @Override
    public void setGenerateAsMethodOverrides(boolean asMethodOverrides) {
        this.generateAsMethodOverrides = asMethodOverrides;
    }

    @Override
    public void setTargetDirectory(String directory) {
        this.strategy.setTargetDirectory(directory);
    }

    @Override
    public String getTargetDirectory() {
        return this.strategy.getTargetDirectory();
    }

    @Override
    public void setTargetPackage(String packageName) {
        this.strategy.setTargetPackage(packageName);
    }

    @Override
    public String getTargetPackage() {
        return this.strategy.getTargetPackage();
    }

    @Override
    public String getTargetEncoding() {
        return this.targetEncoding;
    }

    @Override
    public void setTargetEncoding(String encoding) {
        this.targetEncoding = encoding;
    }

    @Override
    public Locale getTargetLocale() {
        return this.strategy.getTargetLocale();
    }

    @Override
    public void setTargetLocale(Locale targetLocale) {
        this.strategy.setTargetLocale(targetLocale);
    }

    @Override
    public boolean getTargetClean() {
        return this.targetClean;
    }

    @Override
    public void setTargetClean(boolean clean) {
        this.targetClean = clean;
    }

    protected void empty(File file, String suffix) {
        this.empty(file, suffix, Collections.emptySet(), Collections.emptySet());
    }

    protected void empty(File file, String suffix, Set<File> keep, Set<File> ignore) {
        if (!this.targetClean) {
            return;
        }
        if (file != null) {
            if (file.getParentFile() == null) {
                log.warn((Object)"WARNING: Root directory configured for code generation. Not deleting anything from previous generations!");
                return;
            }
            for (File file2 : ignore) {
                if (!file.getAbsolutePath().startsWith(file2.getAbsolutePath())) continue;
                return;
            }
            if (file.isDirectory()) {
                File[] fileArray;
                File[] children = file.listFiles();
                if (children != null) {
                    for (File child : children) {
                        this.empty(child, suffix, keep, ignore);
                    }
                }
                if ((fileArray = file.listFiles()) != null && fileArray.length == 0) {
                    file.delete();
                }
            } else if (file.getName().endsWith(suffix) && !keep.contains(file)) {
                file.delete();
            }
        }
    }
}

