/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jooq.codegen.Files;
import org.jooq.codegen.GenerationUtil;
import org.jooq.codegen.GeneratorStrategy;
import org.jooq.codegen.GeneratorWriter;
import org.jooq.meta.Definition;
import org.jooq.meta.jaxb.GeneratedSerialVersionUID;
import org.jooq.tools.StringUtils;

public class JavaWriter
extends GeneratorWriter<JavaWriter> {
    private static final String SERIAL_STATEMENT = "__SERIAL_STATEMENT__";
    private static final String IMPORT_STATEMENT = "__IMPORT_STATEMENT__";
    private final Pattern fullyQualifiedTypes;
    private final boolean javadoc;
    private final Set<String> refConflicts;
    private final Set<String> qualifiedTypes = new TreeSet<String>(this.qualifiedTypeComparator());
    private final Map<String, String> unqualifiedTypes = new TreeMap<String, String>();
    private final String className;
    private String packageName;
    private final boolean isJava;
    private final boolean isScala;
    private final boolean isKotlin;
    private final GeneratedSerialVersionUID generatedSerialVersionUID;
    private final GeneratorStrategy.Mode mode;
    private boolean ignoreImports;
    private static final Pattern KOTLIN_ARRAY_PATTERN = Pattern.compile("kotlin.Array<(.*)\\?>");

    public JavaWriter(File file, String fullyQualifiedTypes) {
        this(file, fullyQualifiedTypes, (String)null);
    }

    public JavaWriter(File file, String fullyQualifiedTypes, String encoding) {
        this(file, fullyQualifiedTypes, encoding, true);
    }

    public JavaWriter(File file, String fullyQualifiedTypes, String encoding, boolean javadoc) {
        this(file, fullyQualifiedTypes, encoding, javadoc, null);
    }

    public JavaWriter(File file, String fullyQualifiedTypes, String encoding, boolean javadoc, Files files) {
        this(file, fullyQualifiedTypes, encoding, javadoc, files, GeneratedSerialVersionUID.CONSTANT);
    }

    public JavaWriter(File file, String fullyQualifiedTypes, String encoding, boolean javadoc, Files files, GeneratedSerialVersionUID generatedSerialVersionUID) {
        this(file, fullyQualifiedTypes, encoding, javadoc, files, generatedSerialVersionUID, null);
    }

    public JavaWriter(File file, String fullyQualifiedTypes, String encoding, boolean javadoc, Files files, GeneratedSerialVersionUID generatedSerialVersionUID, GeneratorStrategy.Mode mode) {
        super(file, encoding, files);
        this.className = file.getName().replaceAll("\\.(java|scala|kt)$", "");
        this.isJava = file.getName().endsWith(".java");
        this.isScala = file.getName().endsWith(".scala");
        this.isKotlin = file.getName().endsWith(".kt");
        this.refConflicts = new HashSet<String>();
        this.fullyQualifiedTypes = fullyQualifiedTypes == null ? null : Pattern.compile(fullyQualifiedTypes);
        this.javadoc = javadoc;
        this.generatedSerialVersionUID = generatedSerialVersionUID;
        this.mode = mode;
        if (this.isJava || this.isKotlin) {
            this.tabString("    ");
        } else if (this.isScala) {
            this.tabString("  ");
        }
    }

    public JavaWriter print(Class<?> clazz) {
        this.printClass(clazz.getCanonicalName());
        return this;
    }

    public JavaWriter printClass(String clazz) {
        this.print(this.ref(clazz));
        return this;
    }

    public JavaWriter javadocAndAnnotations(Definition definition, String string, Object ... args) {
        this.javadoc(string, args);
        this.annotations(definition);
        return this;
    }

    public JavaWriter annotations(Definition definition) {
        return this;
    }

    public JavaWriter javadoc(String string, Object ... args) {
        this.println();
        if (this.javadoc) {
            String escaped = JavaWriter.escapeJavadoc(string);
            Object[] escapedArgs = Arrays.copyOf(args, args.length);
            for (int i = 0; i < escapedArgs.length; ++i) {
                escapedArgs[i] = JavaWriter.escapeJavadoc(escapedArgs[i]);
            }
            this.println("/**");
            this.println(escaped, escapedArgs);
            this.println(" */");
        }
        return this;
    }

    static Object escapeJavadoc(Object object) {
        if (object instanceof String) {
            return JavaWriter.escapeJavadoc((String)object);
        }
        if (object instanceof List) {
            return ((List)object).stream().map(JavaWriter::escapeJavadoc).collect(Collectors.toList());
        }
        return object;
    }

    static String escapeJavadoc(String string) {
        return string.replace("/*", "/ *").replace("*/", "* /").replace("\\u002a/", "\\u002a /").replace("*\\u002f", "* \\u002f").replace("\\u002a\\u002f", "\\u002a \\u002f");
    }

    public GeneratorStrategy.Mode mode() {
        return this.mode;
    }

    public JavaWriter header(String header, Object ... args) {
        this.println();
        this.println("// -------------------------------------------------------------------------");
        this.println("// " + header, args);
        this.println("// -------------------------------------------------------------------------");
        return this;
    }

    public JavaWriter override() {
        this.println("@%s", Override.class);
        return this;
    }

    public JavaWriter overrideIf(boolean override) {
        if (override) {
            this.println("@%s", Override.class);
        }
        return this;
    }

    public JavaWriter overrideInherit() {
        this.println();
        this.override();
        return this;
    }

    public JavaWriter overrideInheritIf(boolean override) {
        this.println();
        if (override) {
            this.override();
        }
        return this;
    }

    public void printSerial() {
        if (this.isJava && this.generatedSerialVersionUID != GeneratedSerialVersionUID.OFF) {
            this.println();
            this.println("private static final long serialVersionUID = %s;", SERIAL_STATEMENT);
        }
    }

    public void printPackageSpecification(String packageName) {
        this.packageName = packageName;
        if (this.isScala || this.isKotlin) {
            this.println("package %s", packageName);
        } else {
            this.println("package %s;", packageName);
        }
    }

    public void printImports() {
        this.println(IMPORT_STATEMENT);
    }

    protected Comparator<String> qualifiedTypeComparator() {
        return null;
    }

    @Override
    protected String beforeClose(String string) {
        string = super.beforeClose(string);
        StringBuilder importString = new StringBuilder();
        Pattern samePackagePattern = Pattern.compile(this.packageName + "\\.[^.]+");
        String dotClassName = "." + this.className;
        String previous = "";
        for (String imp : this.qualifiedTypes) {
            if ((this.isJava || this.isKotlin) && imp.startsWith("java.lang.") || this.isKotlin && imp.startsWith("kotlin.") && !imp.substring("kotlin.".length()).contains(".") || imp.endsWith(dotClassName) || this.packageName != null && this.packageName.length() > 0 && samePackagePattern.matcher(imp).matches()) continue;
            String topLevelPackage = imp.split("\\.")[0];
            if (!topLevelPackage.equals(previous)) {
                importString.append(this.newlineString());
            }
            importString.append("import ").append(imp).append(this.isScala || this.isKotlin ? "" : ";").append(this.newlineString());
            previous = topLevelPackage;
        }
        string = string.replaceAll(IMPORT_STATEMENT, Matcher.quoteReplacement(importString.toString()));
        if (this.isJava) {
            switch ((GeneratedSerialVersionUID)StringUtils.defaultIfNull((Object)this.generatedSerialVersionUID, (Object)GeneratedSerialVersionUID.CONSTANT)) {
                case HASH: {
                    string = string.replaceAll(SERIAL_STATEMENT, Matcher.quoteReplacement(String.valueOf(string.hashCode())));
                    break;
                }
                case OFF: {
                    break;
                }
                default: {
                    string = string.replaceAll(SERIAL_STATEMENT, Matcher.quoteReplacement("1L"));
                }
            }
        }
        return string;
    }

    public JavaWriter refConflicts(List<String> conflicts) {
        this.refConflicts.addAll(conflicts);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected List<String> ref(List<String> clazz, int keepSegments) {
        if (this.ignoreImports) {
            return super.ref(clazz, keepSegments);
        }
        ArrayList<String> result = new ArrayList<String>(clazz == null ? 0 : clazz.size());
        if (clazz != null) {
            for (String string : clazz) {
                void var5_5;
                if (string.contains(".")) {
                    Matcher m;
                    String string2 = this.patchKotlinClasses(string);
                    if ((this.fullyQualifiedTypes == null || !this.fullyQualifiedTypes.matcher(string2).matches()) && (m = GenerationUtil.TYPE_REFERENCE_PATTERN.matcher(string2)).find()) {
                        List<String> split = Arrays.asList(m.group(1).split("\\."));
                        String qualifiedType = StringUtils.join((Object[])split.subList(0, split.size() - keepSegments + 1).toArray(), (String)".");
                        String unqualifiedType = split.get(split.size() - keepSegments);
                        String remainder = StringUtils.join((Object[])split.subList(split.size() - keepSegments, split.size()).toArray(), (String)".");
                        if (!(this.className.equals(unqualifiedType) && (this.packageName == null || !qualifiedType.equals(this.packageName + "." + this.className)) || this.unqualifiedTypes.containsKey(unqualifiedType) && !qualifiedType.equals(this.unqualifiedTypes.get(unqualifiedType)) || this.refConflicts.contains(unqualifiedType))) {
                            this.unqualifiedTypes.put(unqualifiedType, qualifiedType);
                            this.qualifiedTypes.add(qualifiedType);
                            String generic = m.group(2);
                            String string3 = remainder + (String)(GenerationUtil.PLAIN_GENERIC_TYPE_PATTERN.matcher(generic).matches() ? generic.substring(0, 1) + this.ref(generic.substring(1, generic.length() - 1)) + generic.substring(generic.length() - 1) : generic);
                        }
                    }
                }
                result.add((String)var5_5);
            }
        }
        return result;
    }

    private String patchKotlinClasses(String c) {
        if (this.isKotlin) {
            if (((String)c).endsWith("[]")) {
                c = "kotlin.Array<" + this.patchKotlinClasses(((String)c).substring(0, ((String)c).length() - 2)) + "?>";
            } else if (Byte.class.getName().equals(c)) {
                c = "kotlin.Byte";
            } else if (Short.class.getName().equals(c)) {
                c = "kotlin.Short";
            } else if (Integer.class.getName().equals(c)) {
                c = "kotlin.Int";
            } else if (Long.class.getName().equals(c)) {
                c = "kotlin.Long";
            } else if (Float.class.getName().equals(c)) {
                c = "kotlin.Float";
            } else if (Double.class.getName().equals(c)) {
                c = "kotlin.Double";
            } else if (Boolean.class.getName().equals(c)) {
                c = "kotlin.Boolean";
            } else if (Character.class.getName().equals(c)) {
                c = "kotlin.Char";
            } else if (String.class.getName().equals(c)) {
                c = "kotlin.String";
            } else if (Object.class.getName().equals(c)) {
                c = "kotlin.Any";
            } else {
                Matcher m = KOTLIN_ARRAY_PATTERN.matcher((CharSequence)c);
                if (m.matches()) {
                    c = m.replaceAll("kotlin.Array<" + this.ref(this.patchKotlinClasses(m.group(1))) + "?>");
                }
            }
        }
        return c;
    }

    public void ignoreImports(boolean ignoreImports) {
        this.ignoreImports = ignoreImports;
    }
}

