/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jolokia.client.EscapeUtil;
import org.jolokia.client.JolokiaOperation;
import org.jolokia.client.JolokiaTargetConfig;
import org.jolokia.client.request.JolokiaMBeanRequest;
import org.jolokia.client.response.JolokiaReadResponse;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;

public class JolokiaReadRequest
extends JolokiaMBeanRequest {
    private final List<String> attributes;
    private String path;

    public JolokiaReadRequest(ObjectName pObjectName, String ... pAttribute) {
        this(null, pObjectName, pAttribute);
    }

    public JolokiaReadRequest(JolokiaTargetConfig pTargetConfig, ObjectName pObjectName, String ... pAttribute) {
        super(JolokiaOperation.READ, pObjectName, pTargetConfig);
        this.attributes = Arrays.asList(pAttribute);
    }

    public JolokiaReadRequest(String pObjectName, String ... pAttribute) throws MalformedObjectNameException {
        this((JolokiaTargetConfig)null, pObjectName, pAttribute);
    }

    public JolokiaReadRequest(JolokiaTargetConfig pTargetConfig, String pObjectName, String ... pAttribute) throws MalformedObjectNameException {
        this(pTargetConfig, new ObjectName(pObjectName), pAttribute);
    }

    public Collection<String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute() {
        if (!this.hasSingleAttribute()) {
            throw new IllegalStateException("More than one attribute given for this request");
        }
        return this.attributes.get(0);
    }

    @Override
    public List<String> getRequestParts() {
        if (this.hasSingleAttribute()) {
            List<String> ret = super.getRequestParts();
            ret.add(this.getAttribute());
            ret.addAll(EscapeUtil.splitPath(this.path));
            return ret;
        }
        if (this.hasAllAttributes() && this.path == null) {
            return super.getRequestParts();
        }
        return null;
    }

    @Override
    public JSONObject toJson() {
        JSONObject ret = super.toJson();
        if (this.hasSingleAttribute()) {
            ret.put((Object)"attribute", (Object)this.attributes.get(0));
        } else if (!this.hasAllAttributes()) {
            JSONArray attrs = new JSONArray(this.attributes.size());
            attrs.addAll(this.attributes);
            ret.put((Object)"attribute", (Object)attrs);
        }
        if (this.path != null) {
            ret.put((Object)"path", (Object)this.path);
        }
        return ret;
    }

    public JolokiaReadResponse createResponse(JSONObject pResponse) {
        return new JolokiaReadResponse(this, pResponse);
    }

    public boolean hasSingleAttribute() {
        return this.attributes.size() == 1;
    }

    public boolean hasAllAttributes() {
        return this.attributes.isEmpty() || this.attributes.contains(null) || this.attributes.contains("*");
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String pPath) {
        this.path = pPath;
    }
}

