/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.httpclient5;

import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionRequestTimeoutException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.jolokia.client.EscapeUtil;
import org.jolokia.client.HttpUtil;
import org.jolokia.client.JolokiaClientBuilder;
import org.jolokia.client.JolokiaQueryParameter;
import org.jolokia.client.JolokiaTargetConfig;
import org.jolokia.client.exception.JolokiaConnectException;
import org.jolokia.client.exception.JolokiaException;
import org.jolokia.client.exception.JolokiaRemoteException;
import org.jolokia.client.exception.JolokiaTimeoutException;
import org.jolokia.client.request.HttpMethod;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.client.response.JolokiaResponse;
import org.jolokia.client.spi.HttpClientSpi;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.json.JSONStructure;
import org.jolokia.json.parser.ParseException;

public class Http5Client
implements HttpClientSpi<HttpClient> {
    private final CloseableHttpClient client;
    private final JolokiaClientBuilder.Configuration config;
    private final URI jolokiaAgentUrl;
    private final HttpHost jolokiaHost;
    private final BasicCredentialsProvider credentialsProvider;
    private final AuthScope targetAuthScope;

    public Http5Client(CloseableHttpClient client, JolokiaClientBuilder.Configuration configuration, BasicCredentialsProvider credentialsProvider) {
        this.client = client;
        this.config = configuration;
        this.jolokiaAgentUrl = this.config.url();
        this.jolokiaHost = new HttpHost(this.jolokiaAgentUrl.getHost(), this.jolokiaAgentUrl.getPort());
        this.targetAuthScope = new AuthScope(this.jolokiaAgentUrl.getHost(), this.jolokiaAgentUrl.getPort());
        this.credentialsProvider = credentialsProvider;
    }

    public HttpClient getClient(Class<HttpClient> clientClass) {
        if (clientClass.isAssignableFrom(this.client.getClass())) {
            return clientClass.cast(this.client);
        }
        return null;
    }

    public <REQ extends JolokiaRequest, RES extends JolokiaResponse<REQ>> JSONStructure execute(REQ pRequest, HttpMethod method, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig targetConfig) throws IOException, JolokiaException {
        HttpUriRequest httpRequest = this.prepareRequest(pRequest, method, parameters, targetConfig);
        return this.execute(httpRequest, pRequest, pRequest.getType().getValue());
    }

    public <REQ extends JolokiaRequest, RES extends JolokiaResponse<REQ>> JSONStructure execute(List<REQ> pRequests, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig targetConfig) throws IOException, JolokiaException {
        HttpUriRequest httpRequest = this.prepareRequests(pRequests, parameters, targetConfig);
        return this.execute(httpRequest, null, "bulk");
    }

    public void close() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    private <REQ extends JolokiaRequest> HttpUriRequest prepareRequest(REQ pRequest, HttpMethod method, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig pTargetConfig) {
        JolokiaTargetConfig targetConfig = HttpUtil.determineTargetConfig(pRequest, (JolokiaTargetConfig)pTargetConfig);
        HttpMethod selectedMethod = HttpUtil.determineHttpMethod(pRequest, (HttpMethod)method, (JolokiaTargetConfig)targetConfig);
        String queryParams = HttpUtil.toQueryString(parameters);
        Charset charset = this.config.contentCharset() == null ? StandardCharsets.UTF_8 : this.config.contentCharset();
        HttpPost request = null;
        if (selectedMethod.equals((Object)HttpMethod.GET)) {
            if (targetConfig != null) {
                throw new IllegalArgumentException("Proxy requests should be sent using POST method");
            }
            List parts = pRequest.getRequestParts();
            if (parts != null) {
                String base = HttpUtil.prepareBaseUrl((URI)this.jolokiaAgentUrl);
                StringBuilder requestPath = new StringBuilder(base);
                requestPath.append(pRequest.getType().getValue());
                for (String p : parts) {
                    requestPath.append("/");
                    requestPath.append(EscapeUtil.escape((String)p));
                }
                URI uri = HttpUtil.prepareFullUrl((URI)this.jolokiaAgentUrl, (String)requestPath.toString(), (String)queryParams);
                request = new HttpGet(uri);
            }
        }
        if (request == null) {
            HttpPost postRequest = new HttpPost(HttpUtil.prepareFullUrl((URI)this.jolokiaAgentUrl, (String)this.jolokiaAgentUrl.getPath(), (String)queryParams));
            JSONObject requestContent = HttpUtil.getJsonRequestContent(pRequest, (JolokiaTargetConfig)targetConfig);
            postRequest.setEntity((HttpEntity)new StringEntity(requestContent.toJSONString(), StandardCharsets.UTF_8));
            postRequest.addHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.getMimeType());
            request = postRequest;
        }
        return request;
    }

    private <REQ extends JolokiaRequest> HttpUriRequest prepareRequests(List<REQ> pRequests, Map<JolokiaQueryParameter, String> parameters, JolokiaTargetConfig pTargetConfig) {
        String queryParams = HttpUtil.toQueryString(parameters);
        Charset charset = this.config.contentCharset() == null ? StandardCharsets.UTF_8 : this.config.contentCharset();
        JSONArray bulkRequest = new JSONArray(pRequests.size());
        for (JolokiaRequest request : pRequests) {
            JSONObject requestContent = HttpUtil.getJsonRequestContent((JolokiaRequest)request, (JolokiaTargetConfig)HttpUtil.determineTargetConfig((JolokiaRequest)request, (JolokiaTargetConfig)pTargetConfig));
            bulkRequest.add((Object)requestContent);
        }
        HttpPost request = new HttpPost(HttpUtil.prepareFullUrl((URI)this.jolokiaAgentUrl, (String)this.jolokiaAgentUrl.getPath(), (String)queryParams));
        request.setEntity((HttpEntity)new StringEntity(bulkRequest.toJSONString(), StandardCharsets.UTF_8));
        request.addHeader("Content-Type", (Object)ContentType.APPLICATION_JSON.getMimeType());
        return request;
    }

    private JSONStructure execute(HttpUriRequest httpRequest, JolokiaRequest jolokiaRequest, String requestType) throws IOException, JolokiaException {
        HttpClientContext httpContext = null;
        Credentials credentials = this.credentialsProvider.getCredentials(this.targetAuthScope, null);
        if (credentials instanceof UsernamePasswordCredentials) {
            UsernamePasswordCredentials basicAuth = (UsernamePasswordCredentials)credentials;
            httpContext = ContextBuilder.create().useCredentialsProvider((CredentialsProvider)this.credentialsProvider).preemptiveBasicAuth(this.jolokiaHost, basicAuth).build();
        }
        HttpClientResponseHandler<ProcessedResponse> responseHandler = new HttpClientResponseHandler<ProcessedResponse>(){

            public ProcessedResponse handleResponse(ClassicHttpResponse response) {
                HttpEntity entity = response.getEntity();
                try {
                    String contentEncoding = entity.getContentEncoding();
                    Charset encoding = contentEncoding == null ? (Http5Client.this.config.contentCharset() == null ? StandardCharsets.ISO_8859_1 : Http5Client.this.config.contentCharset()) : Charset.forName(contentEncoding);
                    JSONStructure json = HttpUtil.parseJsonResponse((InputStream)entity.getContent(), (Charset)encoding);
                    return new ProcessedResponse(response, json, null, response.getCode());
                }
                catch (IOException | ParseException e) {
                    return new ProcessedResponse(response, null, (Exception)e, response.getCode());
                }
            }
        };
        try {
            ProcessedResponse response = (ProcessedResponse)this.client.execute((ClassicHttpRequest)httpRequest, httpContext, (HttpClientResponseHandler)responseHandler);
            int errorCode = response.code();
            if (errorCode != 200) {
                throw new JolokiaRemoteException(jolokiaRequest, "HTTP error " + errorCode + " sending " + requestType + " Jolokia request", null, errorCode, null, null);
            }
            Exception e = response.exception();
            if (e != null) {
                String errorType = e.getClass().getName();
                String message = "Error processing " + requestType + " response: " + e.getMessage();
                throw new JolokiaRemoteException(jolokiaRequest, message, errorType, errorCode, null, null);
            }
            return response.json();
        }
        catch (ConnectException e) {
            String msg = "Cannot connect to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
            throw new JolokiaConnectException(msg, e);
        }
        catch (ConnectTimeoutException e) {
            String msg = "Connection timeout when sending " + requestType + " request to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
            throw new JolokiaTimeoutException(msg, (IOException)((Object)e));
        }
        catch (ConnectionRequestTimeoutException e) {
            String msg = "Timeout getting pooled connection when sending " + requestType + " request to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
            throw new JolokiaTimeoutException(msg, (IOException)((Object)e));
        }
        catch (IOException e) {
            String msg = "IO exception when processing " + requestType + " request to " + String.valueOf(this.jolokiaAgentUrl) + ": " + e.getMessage();
            throw new JolokiaTimeoutException(msg, e);
        }
    }

    private record ProcessedResponse(ClassicHttpResponse response, JSONStructure json, Exception exception, int code) {
    }
}

