/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.httpclient4;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.impl.conn.DefaultHttpResponseParserFactory;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.VersionInfo;
import org.jolokia.client.JolokiaClientBuilder;
import org.jolokia.client.httpclient4.Http4Client;
import org.jolokia.client.spi.HttpClientBuilder;
import org.jolokia.client.spi.HttpClientSpi;

public class Http4ClientBuilder
implements HttpClientBuilder<HttpClient> {
    public HttpClientSpi<HttpClient> buildHttpClient(JolokiaClientBuilder.Configuration jcb) {
        String user = jcb.user();
        String password = jcb.password();
        org.apache.http.impl.client.HttpClientBuilder builder = HttpClients.custom().setUserAgent("Jolokia JMX-Client (using Apache-HttpClient/" + Http4ClientBuilder.getVersionInfo() + ")").setDefaultCookieStore((CookieStore)new BasicCookieStore()).setDefaultRequestConfig(this.createRequestConfig(jcb));
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        registryBuilder.register("http", (Object)PlainConnectionSocketFactory.INSTANCE);
        if (jcb.tlsConfig() != null && jcb.tlsConfig().protocolVersion() != null) {
            try {
                LayeredConnectionSocketFactory sslSocketFactory = this.createSSLSocketFactory(jcb);
                builder.setSSLSocketFactory(sslSocketFactory);
                registryBuilder.register("https", (Object)sslSocketFactory);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Problem with TLS configuration: " + e.getMessage(), e);
            }
        }
        Registry registry = registryBuilder.build();
        PoolingHttpClientConnectionManager connManager = jcb.poolConfig().usePool() ? this.createPoolingConnectionManager(jcb, (Registry<ConnectionSocketFactory>)registry) : this.createBasicConnectionManager(jcb, (Registry<ConnectionSocketFactory>)registry);
        builder.setConnectionManager((HttpClientConnectionManager)connManager);
        Collection defaultHttpHeaders = jcb.defaultHttpHeaders();
        if (defaultHttpHeaders != null && !defaultHttpHeaders.isEmpty()) {
            List<BasicHeader> headers = defaultHttpHeaders.stream().map(h -> new BasicHeader(h.name(), h.value())).toList();
            builder.setDefaultHeaders(headers);
        }
        if (user != null && !user.isEmpty()) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(user, password));
            builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor((AuthScheme)new BasicScheme()));
        }
        this.setupProxyIfNeeded(jcb.proxy(), builder);
        if (jcb.customizer() != null) {
            Class builderClass = jcb.clientBuilderClass();
            if (!builderClass.isAssignableFrom(builder.getClass())) {
                throw new IllegalArgumentException("Unsupported class for HttpClient4 builder associated with the customizer: " + builderClass.getName());
            }
            jcb.customizer().accept(builder);
        }
        return new Http4Client((HttpClient)builder.build(), jcb);
    }

    private static String getVersionInfo() {
        VersionInfo vi = VersionInfo.loadVersionInfo((String)"org.apache.http.client", (ClassLoader)Http4ClientBuilder.class.getClassLoader());
        return vi != null ? vi.getRelease() : "UNAVAILABLE";
    }

    private void setupProxyIfNeeded(JolokiaClientBuilder.Proxy httpProxy, org.apache.http.impl.client.HttpClientBuilder builder) {
        if (httpProxy != null) {
            builder.setProxy(new HttpHost(httpProxy.getHost(), httpProxy.getPort()));
            if (httpProxy.getUser() != null) {
                AuthScope proxyAuthScope = new AuthScope(httpProxy.getHost(), httpProxy.getPort());
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(httpProxy.getUser(), httpProxy.getPass());
                BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
                credentialsProvider.setCredentials(proxyAuthScope, (Credentials)proxyCredentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            }
        }
    }

    private RequestConfig createRequestConfig(JolokiaClientBuilder.Configuration jcb) {
        RequestConfig.Builder builder = RequestConfig.custom();
        builder.setNormalizeUri(false);
        builder.setExpectContinueEnabled(jcb.expectContinue());
        if (jcb.connectionConfig().socketTimeout() > -1) {
            builder.setSocketTimeout(jcb.connectionConfig().socketTimeout());
        }
        if (jcb.connectionConfig().connectionTimeout() > -1) {
            builder.setConnectTimeout(jcb.connectionConfig().connectionTimeout());
        }
        if (jcb.poolConfig().usePool() && jcb.poolConfig().connectionPoolTimeout() > -1) {
            builder.setConnectionRequestTimeout(jcb.poolConfig().connectionPoolTimeout());
        }
        return builder.build();
    }

    private BasicHttpClientConnectionManager createBasicConnectionManager(JolokiaClientBuilder.Configuration jcb, Registry<ConnectionSocketFactory> registry) {
        BasicHttpClientConnectionManager connManager = new BasicHttpClientConnectionManager(registry, this.getConnectionFactory());
        connManager.setSocketConfig(this.createSocketConfig(jcb));
        connManager.setConnectionConfig(this.createConnectionConfig(jcb));
        return connManager;
    }

    private PoolingHttpClientConnectionManager createPoolingConnectionManager(JolokiaClientBuilder.Configuration jcb, Registry<ConnectionSocketFactory> registry) {
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(registry, this.getConnectionFactory());
        connManager.setDefaultSocketConfig(this.createSocketConfig(jcb));
        connManager.setDefaultConnectionConfig(this.createConnectionConfig(jcb));
        if (jcb.poolConfig().maxConnections() != 0) {
            connManager.setMaxTotal(jcb.poolConfig().maxConnections());
            connManager.setMaxPerRoute(new HttpRoute(new HttpHost(jcb.url().getHost(), jcb.url().getPort())), jcb.poolConfig().maxConnections());
        }
        return connManager;
    }

    private LayeredConnectionSocketFactory createSSLSocketFactory(JolokiaClientBuilder.Configuration jcb) throws Exception {
        JolokiaClientBuilder.TlsConfiguration tlsConfiguration = jcb.tlsConfig();
        KeyStore ks = null;
        if (tlsConfiguration.keystore() != null) {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            ks = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fis = new FileInputStream(tlsConfiguration.keystore().toFile());){
                ks.load(fis, tlsConfiguration.keystorePassword() == null ? new char[]{} : tlsConfiguration.keystorePassword().toCharArray());
            }
        }
        KeyStore ts = null;
        if (tlsConfiguration.truststore() != null) {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ts = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fis = new FileInputStream(tlsConfiguration.truststore().toFile());){
                ts.load(fis, tlsConfiguration.truststorePassword() == null ? new char[]{} : tlsConfiguration.truststorePassword().toCharArray());
                tmf.init(ts);
            }
        }
        SSLContext sslcontext = SSLContexts.custom().setProtocol(tlsConfiguration.protocolVersion()).loadKeyMaterial(ks, tlsConfiguration.keyPassword() == null ? new char[]{} : tlsConfiguration.keyPassword().toCharArray()).loadTrustMaterial(ts, null).build();
        return new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)new DefaultHostnameVerifier());
    }

    private ConnectionConfig createConnectionConfig(JolokiaClientBuilder.Configuration jcb) {
        return ConnectionConfig.custom().setBufferSize(jcb.connectionConfig().socketBufferSize()).setCharset(jcb.contentCharset()).build();
    }

    private SocketConfig createSocketConfig(JolokiaClientBuilder.Configuration jcb) {
        SocketConfig.Builder socketConfigB = SocketConfig.custom();
        if (jcb.connectionConfig().socketTimeout() >= 0) {
            socketConfigB.setSoTimeout(jcb.connectionConfig().socketTimeout());
        }
        socketConfigB.setTcpNoDelay(jcb.connectionConfig().tcpNoDelay());
        return socketConfigB.build();
    }

    private HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> getConnectionFactory() {
        return new ManagedHttpClientConnectionFactory((HttpMessageWriterFactory)new DefaultHttpRequestWriterFactory(), (HttpMessageParserFactory)new DefaultHttpResponseParserFactory());
    }

    static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private final AuthScheme authScheme;

        PreemptiveAuthInterceptor(AuthScheme pScheme) {
            this.authScheme = pScheme;
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException {
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            if (authState.getAuthScheme() == null) {
                HttpHost targetHost;
                CredentialsProvider credentialsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
                Credentials credentials = credentialsProvider.getCredentials(new AuthScope((targetHost = (HttpHost)context.getAttribute("http.target_host")).getHostName(), targetHost.getPort()));
                if (credentials == null) {
                    throw new HttpException("No credentials given for preemptive authentication");
                }
                authState.update(this.authScheme, credentials);
            }
        }
    }
}

